/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse.expression.common;

import org.encog.ml.ea.exception.EACompileError;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.expvalue.ExpressionValue;
import org.encog.ml.prg.extension.BasicTemplate;
import org.encog.ml.prg.extension.NodeType;
import org.encog.ml.prg.extension.ProgramExtensionTemplate;
import org.encog.ml.prg.extension.StandardExtensions;
import org.encog.util.SimpleParser;
import org.encog.util.datastruct.StackObject;

public class ParseCommonExpression {
    private final EncogProgram holder;
    private SimpleParser parser;
    private ProgramNode rootNode;
    private boolean unary;
    private ProgramExtensionTemplate LEFT_PAREN = new BasicTemplate(100, "(", NodeType.None, false, 0){

        @Override
        public ExpressionValue evaluate(ProgramNode actual) {
            return null;
        }
    };
    private StackObject<ProgramExtensionTemplate> functionStack = new StackObject(100);
    private StackObject<ProgramNode> outputStack = new StackObject(100);

    public ParseCommonExpression(EncogProgram theHolder) {
        this.holder = theHolder;
    }

    private void outputQueue(ProgramNode leaf) {
        this.outputStack.push(leaf);
    }

    private void outputQueue(ProgramExtensionTemplate opp) {
        if (opp == this.LEFT_PAREN) {
            throw new EACompileError("Unmatched parentheses");
        }
        ProgramNode[] args = new ProgramNode[opp.getChildNodeCount()];
        for (int i = args.length - 1; i >= 0; --i) {
            if (this.outputStack.isEmpty()) {
                throw new EACompileError("Not enough arguments");
            }
            args[i] = this.outputStack.pop();
        }
        this.rootNode = this.holder.getFunctions().factorProgramNode(opp, this.holder, args);
        this.outputStack.push(this.rootNode);
    }

    private void functionQueue(ProgramExtensionTemplate f) {
        while (!this.functionStack.isEmpty() && this.functionStack.peek().getNodeType() != NodeType.None && (f.getNodeType() == NodeType.OperatorLeft && f.getPrecedence() >= this.functionStack.peek().getPrecedence() || f.getPrecedence() > this.functionStack.peek().getPrecedence())) {
            this.outputQueue(this.functionStack.pop());
        }
        this.functionStack.push(f);
    }

    private void handleNumeric() {
        int sign = 43;
        boolean isFloat = false;
        boolean neg = false;
        double value = 0.0;
        double exponent = 0.0;
        if (!this.functionStack.isEmpty() && this.functionStack.peek() == StandardExtensions.EXTENSION_NEG) {
            this.functionStack.pop();
            neg = true;
        }
        while (Character.isDigit(this.parser.peek())) {
            value = 10.0 * value + (double)(this.parser.readChar() - 48);
        }
        if (this.parser.peek() == '.') {
            isFloat = true;
            this.parser.advance();
            int i = 1;
            while (Character.isDigit(this.parser.peek())) {
                double f = this.parser.readChar() - 48;
                value += (f /= Math.pow(10.0, i));
                ++i;
            }
        }
        if (Character.toUpperCase(this.parser.peek()) == 'E') {
            this.parser.advance();
            if (this.parser.peek() == '+' || this.parser.peek() == '-') {
                sign = this.parser.readChar();
            }
            while (Character.isDigit(this.parser.peek())) {
                exponent = (int)(10.0 * exponent) + (this.parser.readChar() - 48);
            }
            if (sign == 45) {
                isFloat = true;
                exponent = -exponent;
            }
            value *= Math.pow(10.0, exponent);
        }
        if (neg) {
            value = -value;
        }
        ProgramNode v = this.holder.getFunctions().factorProgramNode("#const", this.holder, new ProgramNode[0]);
        v.getData()[0] = isFloat ? new ExpressionValue(value) : new ExpressionValue((int)value);
        this.outputQueue(v);
    }

    private void handleAlpha(boolean neg) {
        StringBuilder varName = new StringBuilder();
        while (Character.isLetterOrDigit(this.parser.peek())) {
            varName.append(this.parser.readChar());
        }
        this.parser.eatWhiteSpace();
        if (varName.toString().equals("true")) {
            if (neg) {
                throw new EACompileError("Invalid negative sign.");
            }
            ProgramNode v = this.holder.getFunctions().factorProgramNode("#const", this.holder, new ProgramNode[0]);
            v.getData()[0] = new ExpressionValue(true);
            this.outputQueue(v);
        } else if (varName.toString().equals("false")) {
            if (neg) {
                throw new EACompileError("Invalid negative sign.");
            }
            ProgramNode v = this.holder.getFunctions().factorProgramNode("#const", this.holder, new ProgramNode[0]);
            v.getData()[0] = new ExpressionValue(false);
            this.outputQueue(v);
        } else if (this.parser.peek() != '(') {
            ProgramNode v;
            if (this.holder.getFunctions().isDefined(varName.toString(), 0)) {
                v = this.holder.getFunctions().factorProgramNode(varName.toString(), this.holder, new ProgramNode[0]);
            } else {
                this.holder.getVariables().setVariable(varName.toString(), new ExpressionValue(0L));
                v = this.holder.getFunctions().factorProgramNode("#var", this.holder, new ProgramNode[0]);
                v.getData()[0] = new ExpressionValue(this.holder.getVariables().getVariableIndex(varName.toString()));
            }
            if (neg) {
                v = this.holder.getFunctions().factorProgramNode("-", this.holder, new ProgramNode[]{v});
            }
            this.outputQueue(v);
        } else {
            ProgramExtensionTemplate temp = this.holder.getFunctions().findFunction(varName.toString());
            if (temp == null) {
                throw new EACompileError("Undefined function: " + varName.toString());
            }
            this.functionQueue(temp);
        }
    }

    private void handleSymbol() {
        ProgramExtensionTemplate temp;
        char ch1 = this.parser.readChar();
        if (this.unary) {
            if (ch1 == '+') {
                return;
            }
            if (ch1 == '-') {
                this.functionStack.push(StandardExtensions.EXTENSION_NEG);
                return;
            }
        }
        char ch2 = '\u0000';
        if (!this.parser.eol()) {
            ch2 = this.parser.peek();
        }
        if ((temp = this.holder.getFunctions().findOperator(ch1, ch2)) != null) {
            if (temp.getName().length() > 1) {
                this.parser.advance();
            }
        } else {
            throw new EACompileError("Unknown symbol: " + ch1);
        }
        this.functionQueue(temp);
    }

    private void handleString() {
        char ch;
        StringBuilder str = new StringBuilder();
        if (this.parser.peek() == '\"') {
            this.parser.advance();
        }
        do {
            if ((ch = this.parser.readChar()) == '\"') {
                if (this.parser.peek() != '\"') continue;
                this.parser.advance();
                str.append(ch);
                ch = this.parser.readChar();
                continue;
            }
            str.append(ch);
        } while (ch != '\"' && ch > '\u0000');
        if (ch != '\"') {
            throw new EACompileError("Unterminated string");
        }
        ProgramNode v = this.holder.getFunctions().factorProgramNode("#const", this.holder, new ProgramNode[0]);
        v.getData()[0] = new ExpressionValue(str.toString());
        this.outputQueue(v);
    }

    private void handleRightParen() {
        this.parser.advance();
        while (this.functionStack.peek() != this.LEFT_PAREN) {
            this.outputQueue(this.functionStack.pop());
        }
        this.functionStack.pop();
        if (!this.functionStack.isEmpty() && this.functionStack.peek().getNodeType() == NodeType.Function) {
            this.outputQueue(this.functionStack.pop());
        }
    }

    private void handleFunctionSeparator() {
        this.parser.advance();
        while (this.functionStack.peek() != this.LEFT_PAREN) {
            this.outputQueue(this.functionStack.pop());
        }
    }

    public ProgramNode parse(String expression) {
        this.parser = new SimpleParser(expression);
        this.unary = true;
        while (!this.parser.eol()) {
            this.parser.eatWhiteSpace();
            char ch = this.parser.peek();
            if (ch == '.' || Character.isDigit(ch)) {
                this.handleNumeric();
                this.unary = false;
                continue;
            }
            if (Character.isLetter(ch)) {
                this.handleAlpha(false);
                this.unary = false;
                continue;
            }
            if (ch == '(') {
                this.parser.advance();
                this.functionStack.push(this.LEFT_PAREN);
                this.unary = true;
                continue;
            }
            if (ch == ')') {
                this.handleRightParen();
                this.unary = false;
                continue;
            }
            if ("<>^*/+-=&|".indexOf(ch) != -1) {
                this.handleSymbol();
                this.unary = true;
                continue;
            }
            if (ch == '\"') {
                this.handleString();
                this.unary = false;
                continue;
            }
            if (ch == ',') {
                this.handleFunctionSeparator();
                this.unary = true;
                continue;
            }
            throw new EACompileError("Unparsable character: " + ch);
        }
        while (!this.functionStack.isEmpty()) {
            ProgramExtensionTemplate f = this.functionStack.pop();
            this.outputQueue(f);
        }
        if (this.rootNode == null) {
            this.rootNode = this.outputStack.pop();
        }
        return this.rootNode;
    }
}

