/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.thermal;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.encog.neural.thermal.HopfieldNetwork;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;

public class PersistHopfield
implements EncogPersistor {
    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public String getPersistClassString() {
        return HopfieldNetwork.class.getSimpleName();
    }

    @Override
    public Object read(InputStream is) {
        EncogFileSection section;
        HopfieldNetwork result = new HopfieldNetwork();
        EncogReadHelper in = new EncogReadHelper(is);
        while ((section = in.readNextSection()) != null) {
            Map<String, String> params;
            if (section.getSectionName().equals("HOPFIELD") && section.getSubSectionName().equals("PARAMS")) {
                params = section.parseParams();
                result.getProperties().putAll(params);
            }
            if (!section.getSectionName().equals("HOPFIELD") || !section.getSubSectionName().equals("NETWORK")) continue;
            params = section.parseParams();
            result.setWeights(section.parseDoubleArray(params, "weights"));
            result.setCurrentState(section.parseDoubleArray(params, "output"));
            result.setNeuronCount(EncogFileSection.parseInt(params, "neurons"));
        }
        return result;
    }

    @Override
    public void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        HopfieldNetwork hopfield = (HopfieldNetwork)obj;
        out.addSection("HOPFIELD");
        out.addSubSection("PARAMS");
        out.addProperties(hopfield.getProperties());
        out.addSubSection("NETWORK");
        out.writeProperty("weights", hopfield.getWeights());
        out.writeProperty("output", hopfield.getCurrentState().getData());
        out.writeProperty("neurons", hopfield.getNeuronCount());
        out.flush();
    }
}

