/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.MLMethod;
import org.encog.neural.bam.BAM;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;

public class BAMPattern
implements NeuralNetworkPattern {
    private int f1Neurons;
    private int f2Neurons;

    @Override
    public void addHiddenLayer(int count) {
        throw new PatternError("A BAM network has no hidden layers.");
    }

    @Override
    public void clear() {
        this.f1Neurons = 0;
        this.f2Neurons = 0;
    }

    @Override
    public MLMethod generate() {
        BAM bam = new BAM(this.f1Neurons, this.f2Neurons);
        return bam;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        throw new PatternError("A BAM network can't specify a custom activation function.");
    }

    public void setF1Neurons(int count) {
        this.f1Neurons = count;
    }

    public void setF2Neurons(int count) {
        this.f2Neurons = count;
    }

    @Override
    public void setInputNeurons(int count) {
        throw new PatternError("A BAM network has no input layer, consider setting F1 layer.");
    }

    @Override
    public void setOutputNeurons(int count) {
        throw new PatternError("A BAM network has no output layer, consider setting F2 layer.");
    }
}

