/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.nm;

import org.encog.ml.MLMethod;
import org.encog.ml.TrainingImplementationType;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.BasicTraining;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.structure.NetworkCODEC;
import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.util.EngineArray;

public class NelderMeadTraining
extends BasicTraining {
    private final BasicNetwork network;
    private double ynewlo;
    private boolean converged = false;
    private final double ccoeff = 0.5;
    private double del;
    private final double ecoeff = 2.0;
    private final double eps = 0.001;
    private int ihi;
    private int ilo;
    private int jcount;
    private int l;
    private final int nn;
    private final double[] p;
    private final double[] p2star;
    private final double[] pbar;
    private final double[] pstar;
    private final double rcoeff = 1.0;
    private final double rq;
    private final double[] y;
    private double y2star;
    private double ylo;
    private double ystar;
    private double z;
    private final double[] start;
    private final double[] trainedWeights;
    private final double[] step;
    private int konvge;

    public NelderMeadTraining(BasicNetwork network, MLDataSet training) {
        this(network, training, 100.0);
    }

    public NelderMeadTraining(BasicNetwork network, MLDataSet training, double stepValue) {
        super(TrainingImplementationType.OnePass);
        this.network = network;
        this.setTraining(training);
        this.start = NetworkCODEC.networkToArray(network);
        this.trainedWeights = NetworkCODEC.networkToArray(network);
        int n = this.start.length;
        this.p = new double[n * (n + 1)];
        this.pstar = new double[n];
        this.p2star = new double[n];
        this.pbar = new double[n];
        this.y = new double[n + 1];
        this.nn = n + 1;
        this.del = 1.0;
        this.rq = 1.0E-13 * (double)n;
        this.step = new double[NetworkCODEC.networkSize(network)];
        this.konvge = 500;
        this.jcount = 500;
        EngineArray.fill(this.step, stepValue);
    }

    @Override
    public boolean canContinue() {
        return false;
    }

    public double fn(double[] weights) {
        NetworkCODEC.arrayToNetwork(weights, this.network);
        return this.network.calculateError(this.getTraining());
    }

    @Override
    public MLMethod getMethod() {
        return this.network;
    }

    @Override
    public boolean isTrainingDone() {
        if (this.converged) {
            return true;
        }
        return super.isTrainingDone();
    }

    @Override
    public void iteration() {
        int j;
        int i;
        if (this.converged) {
            return;
        }
        int n = this.start.length;
        for (i = 0; i < n; ++i) {
            this.p[i + n * n] = this.start[i];
        }
        this.y[n] = this.fn(this.start);
        for (j = 0; j < n; ++j) {
            double x = this.start[j];
            this.start[j] = this.start[j] + this.step[j] * this.del;
            for (int i2 = 0; i2 < n; ++i2) {
                this.p[i2 + j * n] = this.start[i2];
            }
            this.y[j] = this.fn(this.start);
            this.start[j] = x;
        }
        this.ylo = this.y[0];
        this.ilo = 0;
        for (i = 1; i < this.nn; ++i) {
            if (!(this.y[i] < this.ylo)) continue;
            this.ylo = this.y[i];
            this.ilo = i;
        }
        block4: while (true) {
            this.ynewlo = this.y[0];
            this.ihi = 0;
            for (i = 1; i < this.nn; ++i) {
                if (!(this.ynewlo < this.y[i])) continue;
                this.ynewlo = this.y[i];
                this.ihi = i;
            }
            for (i = 0; i < n; ++i) {
                this.z = 0.0;
                for (int j2 = 0; j2 < this.nn; ++j2) {
                    this.z += this.p[i + j2 * n];
                }
                this.z -= this.p[i + this.ihi * n];
                this.pbar[i] = this.z / (double)n;
            }
            for (i = 0; i < n; ++i) {
                this.pstar[i] = this.pbar[i] + this.rcoeff * (this.pbar[i] - this.p[i + this.ihi * n]);
            }
            this.ystar = this.fn(this.pstar);
            if (this.ystar < this.ylo) {
                for (i = 0; i < n; ++i) {
                    this.p2star[i] = this.pbar[i] + this.ecoeff * (this.pstar[i] - this.pbar[i]);
                }
                this.y2star = this.fn(this.p2star);
                if (this.ystar < this.y2star) {
                    for (i = 0; i < n; ++i) {
                        this.p[i + this.ihi * n] = this.pstar[i];
                    }
                    this.y[this.ihi] = this.ystar;
                } else {
                    for (i = 0; i < n; ++i) {
                        this.p[i + this.ihi * n] = this.p2star[i];
                    }
                    this.y[this.ihi] = this.y2star;
                }
            } else {
                this.l = 0;
                for (i = 0; i < this.nn; ++i) {
                    if (!(this.ystar < this.y[i])) continue;
                    ++this.l;
                }
                if (1 < this.l) {
                    for (i = 0; i < n; ++i) {
                        this.p[i + this.ihi * n] = this.pstar[i];
                    }
                    this.y[this.ihi] = this.ystar;
                } else if (this.l == 0) {
                    for (i = 0; i < n; ++i) {
                        this.p2star[i] = this.pbar[i] + this.ccoeff * (this.p[i + this.ihi * n] - this.pbar[i]);
                    }
                    this.y2star = this.fn(this.p2star);
                    if (this.y[this.ihi] < this.y2star) {
                        for (j = 0; j < this.nn; ++j) {
                            for (int i3 = 0; i3 < n; ++i3) {
                                this.p[i3 + j * n] = (this.p[i3 + j * n] + this.p[i3 + this.ilo * n]) * 0.5;
                                this.trainedWeights[i3] = this.p[i3 + j * n];
                            }
                            this.y[j] = this.fn(this.trainedWeights);
                        }
                        this.ylo = this.y[0];
                        this.ilo = 0;
                        i = 1;
                        while (true) {
                            if (i >= this.nn) continue block4;
                            if (this.y[i] < this.ylo) {
                                this.ylo = this.y[i];
                                this.ilo = i;
                            }
                            ++i;
                        }
                    }
                    for (i = 0; i < n; ++i) {
                        this.p[i + this.ihi * n] = this.p2star[i];
                    }
                    this.y[this.ihi] = this.y2star;
                } else if (this.l == 1) {
                    for (i = 0; i < n; ++i) {
                        this.p2star[i] = this.pbar[i] + this.ccoeff * (this.pstar[i] - this.pbar[i]);
                    }
                    this.y2star = this.fn(this.p2star);
                    if (this.y2star <= this.ystar) {
                        for (i = 0; i < n; ++i) {
                            this.p[i + this.ihi * n] = this.p2star[i];
                        }
                        this.y[this.ihi] = this.y2star;
                    } else {
                        for (i = 0; i < n; ++i) {
                            this.p[i + this.ihi * n] = this.pstar[i];
                        }
                        this.y[this.ihi] = this.ystar;
                    }
                }
            }
            if (this.y[this.ihi] < this.ylo) {
                this.ylo = this.y[this.ihi];
                this.ilo = this.ihi;
            }
            --this.jcount;
            if (0 < this.jcount) continue;
            this.jcount = this.konvge;
            this.z = 0.0;
            for (i = 0; i < this.nn; ++i) {
                this.z += this.y[i];
            }
            double x = this.z / (double)this.nn;
            this.z = 0.0;
            for (int i4 = 0; i4 < this.nn; ++i4) {
                this.z += Math.pow(this.y[i4] - x, 2.0);
            }
            if (this.z <= this.rq) break;
        }
        for (int i5 = 0; i5 < n; ++i5) {
            this.trainedWeights[i5] = this.p[i5 + this.ilo * n];
        }
        this.ynewlo = this.y[this.ilo];
        boolean fault = false;
        int i6 = 0;
        while (i6 < n) {
            this.del = this.step[i6] * this.eps;
            int n2 = i6;
            this.trainedWeights[n2] = this.trainedWeights[n2] + this.del;
            this.z = this.fn(this.trainedWeights);
            if (this.z < this.ynewlo) {
                fault = true;
                break;
            }
            this.trainedWeights[i6] = this.trainedWeights[i6] - this.del - this.del;
            this.z = this.fn(this.trainedWeights);
            if (this.z < this.ynewlo) {
                fault = true;
                break;
            }
            int n3 = i6++;
            this.trainedWeights[n3] = this.trainedWeights[n3] + this.del;
        }
        if (!fault) {
            this.converged = true;
        } else {
            for (i6 = 0; i6 < n; ++i6) {
                this.start[i6] = this.trainedWeights[i6];
            }
            this.del = this.eps;
        }
        this.setError(this.ynewlo);
        NetworkCODEC.arrayToNetwork(this.trainedWeights, this.network);
    }

    @Override
    public TrainingContinuation pause() {
        return null;
    }

    @Override
    public void resume(TrainingContinuation state) {
    }
}

