/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.structure;

import java.util.Arrays;
import org.encog.ml.MLEncodable;
import org.encog.ml.MLMethod;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.BasicNetwork;

public final class NetworkCODEC {
    private static final String ERROR = "This machine learning method cannot be encoded:";

    public static void arrayToNetwork(double[] array, MLMethod network) {
        if (network instanceof MLEncodable) {
            ((MLEncodable)network).decodeFromArray(array);
            return;
        }
        throw new NeuralNetworkError(ERROR + network.getClass().getName());
    }

    public static boolean equals(BasicNetwork network1, BasicNetwork network2) {
        double[] array2;
        double[] array1 = NetworkCODEC.networkToArray(network1);
        if (array1.length != (array2 = NetworkCODEC.networkToArray(network2)).length) {
            return false;
        }
        return Arrays.equals(array1, array2);
    }

    public static boolean equals(BasicNetwork network1, BasicNetwork network2, int precision) {
        double[] array2;
        double[] array1 = NetworkCODEC.networkToArray(network1);
        if (array1.length != (array2 = NetworkCODEC.networkToArray(network2)).length) {
            return false;
        }
        double test = Math.pow(10.0, precision);
        if (Double.isInfinite(test) || test > 9.223372036854776E18) {
            throw new NeuralNetworkError("Precision of " + precision + " decimal places is not supported.");
        }
        for (int i = 0; i < array1.length; ++i) {
            long l1 = (long)(array1[i] * test);
            long l2 = (long)(array2[i] * test);
            if (l1 == l2) continue;
            return false;
        }
        return true;
    }

    public static int networkSize(MLMethod network) {
        if (network instanceof MLEncodable) {
            return ((MLEncodable)network).encodedArrayLength();
        }
        throw new NeuralNetworkError(ERROR + network.getClass().getName());
    }

    public static double[] networkToArray(MLMethod network) {
        int size = NetworkCODEC.networkSize(network);
        if (network instanceof MLEncodable) {
            double[] encoded = new double[size];
            ((MLEncodable)network).encodeToArray(encoded);
            return encoded;
        }
        throw new NeuralNetworkError(ERROR + network.getClass().getName());
    }

    private NetworkCODEC() {
    }
}

