/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.encog.ml.MLError;
import org.encog.ml.MLRegression;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.ea.exception.EACompileError;
import org.encog.ml.ea.exception.EARuntimeError;
import org.encog.ml.ea.genome.BasicGenome;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.prg.EncogProgramContext;
import org.encog.ml.prg.EncogProgramVariables;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.VariableMapping;
import org.encog.ml.prg.expvalue.ExpressionValue;
import org.encog.ml.prg.expvalue.ValueType;
import org.encog.ml.prg.extension.FunctionFactory;
import org.encog.ml.prg.extension.StandardExtensions;
import org.encog.ml.prg.train.PrgPopulation;
import org.encog.ml.tree.traverse.tasks.TaskGetNodeIndex;
import org.encog.ml.tree.traverse.tasks.TaskReplaceNode;
import org.encog.parse.expression.common.ParseCommonExpression;
import org.encog.parse.expression.common.RenderCommonExpression;
import org.encog.parse.expression.epl.ParseEPL;
import org.encog.parse.expression.epl.RenderEPL;
import org.encog.parse.expression.rpn.RenderRPN;
import org.encog.util.simple.EncogUtility;

public class EncogProgram
extends BasicGenome
implements MLRegression,
MLError {
    private static final long serialVersionUID = 1L;
    private EncogProgramVariables variables = new EncogProgramVariables();
    private EncogProgramContext context = new EncogProgramContext();
    private ProgramNode rootNode;
    private Map<String, Object> extraData = new HashMap<String, Object>();

    public static boolean parseBoolean(String str) {
        EncogProgram holder = new EncogProgram(str);
        return holder.evaluate().toBooleanValue();
    }

    public static ExpressionValue parseExpression(String str) {
        EncogProgram holder = new EncogProgram(str);
        return holder.evaluate();
    }

    public static double parseFloat(String str) {
        EncogProgram holder = new EncogProgram(str);
        return holder.evaluate().toFloatValue();
    }

    public static String parseString(String str) {
        EncogProgram holder = new EncogProgram(str);
        return holder.evaluate().toStringValue();
    }

    public EncogProgram() {
        this(new EncogProgramContext(), new EncogProgramVariables());
        StandardExtensions.createAll(this.context);
    }

    public EncogProgram(EncogProgramContext theContext) {
        this(theContext, new EncogProgramVariables());
    }

    public EncogProgram(EncogProgramContext theContext, EncogProgramVariables theVariables) {
        this.context = theContext;
        this.variables = theVariables;
        for (VariableMapping v : this.context.getDefinedVariables()) {
            this.variables.defineVariable(v);
        }
    }

    public EncogProgram(String expression) {
        this();
        this.compileExpression(expression);
    }

    @Override
    public double calculateError(MLDataSet data) {
        return EncogUtility.calculateRegressionError(this, data);
    }

    public ProgramNode compileEPL(String code) {
        ParseEPL parser = new ParseEPL(this);
        this.rootNode = parser.parse(code);
        return this.rootNode;
    }

    public ProgramNode compileExpression(String expression) {
        ParseCommonExpression parser = new ParseCommonExpression(this);
        this.rootNode = parser.parse(expression);
        return this.rootNode;
    }

    @Override
    public MLData compute(MLData input) {
        if (input.size() != this.getInputCount()) {
            throw new EACompileError("Invalid input count.");
        }
        for (int i = 0; i < input.size(); ++i) {
            this.variables.setVariable(i, input.getData(i));
        }
        ExpressionValue v = this.rootNode.evaluate();
        VariableMapping resultMapping = this.getResultType();
        BasicMLData result = new BasicMLData(1);
        boolean success = false;
        switch (resultMapping.getVariableType()) {
            case floatingType: {
                if (!v.isNumeric()) break;
                result.setData(0, v.toFloatValue());
                success = true;
                break;
            }
            case stringType: {
                result.setData(0, v.toFloatValue());
                success = true;
                break;
            }
            case booleanType: {
                if (!v.isBoolean()) break;
                result.setData(0, v.toBooleanValue() ? 1.0 : 0.0);
                success = true;
                break;
            }
            case intType: {
                if (!v.isNumeric()) break;
                result.setData(0, v.toIntValue());
                success = true;
                break;
            }
            case enumType: {
                if (!v.isEnum()) break;
                result.setData(0, v.toIntValue());
                success = true;
            }
        }
        if (!success) {
            throw new EARuntimeError("EncogProgram produced " + v.getExpressionType().toString() + " but " + resultMapping.getVariableType().toString() + " was expected.");
        }
        return result;
    }

    @Override
    public void copy(Genome source) {
    }

    public String dumpAsCommonExpression() {
        RenderCommonExpression render = new RenderCommonExpression();
        return render.render(this);
    }

    public ExpressionValue evaluate() {
        return this.rootNode.evaluate();
    }

    public ProgramNode findNode(int index) {
        return (ProgramNode)TaskGetNodeIndex.process(index, this.rootNode);
    }

    public String generateEPL() {
        RenderEPL render = new RenderEPL();
        return render.render(this);
    }

    public EncogProgramContext getContext() {
        return this.context;
    }

    public FunctionFactory getFunctions() {
        return this.context.getFunctions();
    }

    @Override
    public int getInputCount() {
        return this.variables.size();
    }

    @Override
    public int getOutputCount() {
        return 1;
    }

    private VariableMapping getResultType() {
        return ((PrgPopulation)this.getPopulation()).getContext().getResult();
    }

    public ValueType getReturnType() {
        return this.context.getResult().getVariableType();
    }

    public ProgramNode getRootNode() {
        return this.rootNode;
    }

    public EncogProgramVariables getVariables() {
        return this.variables;
    }

    public void replaceNode(ProgramNode replaceThisNode, ProgramNode replaceWith) {
        if (replaceThisNode == this.rootNode) {
            this.rootNode = replaceWith;
        } else {
            TaskReplaceNode.process(this.rootNode, replaceThisNode, replaceWith);
        }
    }

    public int selectRandomVariable(Random rnd, List<ValueType> desiredTypes) {
        List<VariableMapping> selectionSet = this.context.findVariablesByTypes(desiredTypes);
        if (selectionSet.size() == 0 && desiredTypes.contains((Object)ValueType.intType)) {
            ArrayList<ValueType> floatList = new ArrayList<ValueType>();
            floatList.add(ValueType.floatingType);
            selectionSet = this.context.findVariablesByTypes(floatList);
        }
        if (selectionSet.size() == 0) {
            return -1;
        }
        VariableMapping selected = selectionSet.get(rnd.nextInt(selectionSet.size()));
        return this.getContext().getDefinedVariables().indexOf(selected);
    }

    public void setRootNode(ProgramNode theRootNode) {
        this.rootNode = theRootNode;
    }

    @Override
    public int size() {
        return this.rootNode.size();
    }

    @Override
    public String toString() {
        RenderRPN render = new RenderRPN();
        String code = render.render(this);
        StringBuilder result = new StringBuilder();
        result.append("[EncogProgram: size=");
        result.append(this.size());
        result.append(", score=");
        result.append(this.getScore());
        result.append(",code=");
        result.append(code);
        result.append("]");
        return result.toString();
    }

    public Object getExtraData(String name) {
        return this.extraData.get(name);
    }

    public void setExtraData(String name, Object value) {
        this.extraData.put(name, value);
    }
}

