/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.genetic.crossover;

import java.util.Random;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.opp.EvolutionaryOperator;
import org.encog.ml.ea.train.EvolutionaryAlgorithm;
import org.encog.ml.genetic.genome.ArrayGenome;

public class Splice
implements EvolutionaryOperator {
    private final int cutLength;
    private EvolutionaryAlgorithm owner;

    public Splice(int theCutLength) {
        this.cutLength = theCutLength;
    }

    @Override
    public void performOperation(Random rnd, Genome[] parents, int parentIndex, Genome[] offspring, int offspringIndex) {
        int i;
        ArrayGenome mother = (ArrayGenome)parents[parentIndex];
        ArrayGenome father = (ArrayGenome)parents[parentIndex + 1];
        ArrayGenome offspring1 = (ArrayGenome)this.owner.getPopulation().getGenomeFactory().factor();
        ArrayGenome offspring2 = (ArrayGenome)this.owner.getPopulation().getGenomeFactory().factor();
        offspring[offspringIndex] = offspring1;
        offspring[offspringIndex + 1] = offspring2;
        int geneLength = mother.size();
        int cutpoint1 = rnd.nextInt(geneLength - this.cutLength);
        int cutpoint2 = cutpoint1 + this.cutLength;
        for (i = 0; i < geneLength; ++i) {
            if (i < cutpoint1 || i > cutpoint2) continue;
            offspring1.copy(father, i, i);
            offspring2.copy(mother, i, i);
        }
        for (i = 0; i < geneLength; ++i) {
            if (i >= cutpoint1 && i <= cutpoint2) continue;
            offspring1.copy(mother, i, i);
            offspring2.copy(father, i, i);
        }
    }

    @Override
    public int offspringProduced() {
        return 2;
    }

    @Override
    public int parentsNeeded() {
        return 2;
    }

    @Override
    public void init(EvolutionaryAlgorithm theOwner) {
        this.owner = theOwner;
    }
}

