/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.encog.ml.MLMethod;
import org.encog.ml.MLProperties;
import org.encog.util.csv.CSVFormat;

public abstract class BasicML
implements MLMethod,
MLProperties,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> properties = new HashMap<String, String>();

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public double getPropertyDouble(String name) {
        return Double.parseDouble(this.properties.get(name));
    }

    @Override
    public long getPropertyLong(String name) {
        return Long.parseLong(this.properties.get(name));
    }

    @Override
    public String getPropertyString(String name) {
        return this.properties.get(name);
    }

    @Override
    public void setProperty(String name, double d) {
        this.properties.put(name, "" + CSVFormat.EG_FORMAT.format(d, 10));
        this.updateProperties();
    }

    @Override
    public void setProperty(String name, long l) {
        this.properties.put(name, "" + l);
        this.updateProperties();
    }

    @Override
    public void setProperty(String name, String value) {
        this.properties.put(name, value);
        this.updateProperties();
    }

    @Override
    public abstract void updateProperties();
}

