/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.rbf;

import org.encog.mathutil.rbf.BasicRBF;

public class MexicanHatFunction
extends BasicRBF {
    private static final long serialVersionUID = 1L;

    public MexicanHatFunction(double center, double peak, double width) {
        this.setCenters(new double[1]);
        this.getCenters()[0] = center;
        this.setPeak(peak);
        this.setWidth(width);
    }

    public MexicanHatFunction(double peak, double[] center, double width) {
        this.setCenters(center);
        this.setPeak(peak);
        this.setWidth(width);
    }

    public MexicanHatFunction(int dimensions) {
        this.setCenters(new double[dimensions]);
        this.setPeak(1.0);
        this.setWidth(1.0);
    }

    @Override
    public final double calculate(double[] x) {
        double[] center = this.getCenters();
        double norm = 0.0;
        for (int i = 0; i < center.length; ++i) {
            norm += Math.pow(x[i] - center[i], 2.0);
        }
        return this.getPeak() * (1.0 - norm) * Math.exp(-norm / 2.0);
    }
}

