/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.mathutil.BoundMath;
import org.encog.util.obj.ActivationUtil;

public class ActivationLOG
implements ActivationFunction {
    private static final long serialVersionUID = 7134233791725797522L;
    private final double[] params = new double[0];

    @Override
    public final void activationFunction(double[] x, int start, int size) {
        for (int i = start; i < start + size; ++i) {
            x[i] = x[i] >= 0.0 ? BoundMath.log(1.0 + x[i]) : -BoundMath.log(1.0 - x[i]);
        }
    }

    @Override
    public final ActivationFunction clone() {
        return new ActivationLOG();
    }

    @Override
    public final double derivativeFunction(double b, double a) {
        if (b >= 0.0) {
            return 1.0 / (1.0 + b);
        }
        return 1.0 / (1.0 - b);
    }

    @Override
    public final String[] getParamNames() {
        String[] result = new String[]{};
        return result;
    }

    @Override
    public final double[] getParams() {
        return this.params;
    }

    @Override
    public final boolean hasDerivative() {
        return true;
    }

    @Override
    public final void setParam(int index, double value) {
        this.params[index] = value;
    }

    @Override
    public String getFactoryCode() {
        return ActivationUtil.generateActivationFactory("log", this);
    }
}

