/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.tokenAttributes;

import java.util.ArrayList;
import java.util.List;
import net.java.sen.dictionary.Morpheme;
import org.apache.lucene.analysis.ja.ToStringUtil;
import org.apache.lucene.analysis.ja.tokenAttributes.PartOfSpeechAttribute;
import org.apache.lucene.analysis.ja.tokenAttributes.ReadingsAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadingsAttributeImpl
extends AttributeImpl
implements ReadingsAttribute,
Cloneable {
    private Morpheme morpheme;

    @Override
    public List<String> getReadings() {
        return this.morpheme == null ? null : this.morpheme.getReadings();
    }

    @Override
    public void setMorpheme(Morpheme morpheme) {
        this.morpheme = morpheme;
    }

    public void clear() {
        this.morpheme = null;
    }

    public void copyTo(AttributeImpl target) {
        ReadingsAttribute t = (ReadingsAttribute)target;
        t.setMorpheme(this.morpheme);
    }

    public void reflectWith(AttributeReflector reflector) {
        List<String> readings = this.getReadings();
        ArrayList<String> enReadings = null;
        if (readings != null) {
            enReadings = new ArrayList<String>(readings.size());
            for (String kana : readings) {
                enReadings.add(ToStringUtil.getRomanization(kana));
            }
        }
        reflector.reflect(PartOfSpeechAttribute.class, "readings", readings);
        reflector.reflect(PartOfSpeechAttribute.class, "readings (en)", enReadings);
    }
}

