/***********************************************************************
 * FXRuby -- the Ruby language bindings for the FOX GUI toolkit.
 * Copyright (c) 2001-2009 by Lyle Johnson. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information please contact the author by e-mail
 * at "lyle@lylejohnson.name".
 ***********************************************************************/

%define DO_CLASS_SETUP(klass)
%exception klass::klass {
  $action FXRbRegisterRubyObj(self, result);
  if(rb_block_given_p()){
    rb_yield(self);
  }
}
%freefunc klass "FXRbObject::freefunc"; // some classes override this in freefuncs.i
%enddef

DO_CLASS_SETUP(FX4Splitter)
DO_CLASS_SETUP(FX7Segment)
DO_CLASS_SETUP(FXAccelTable)
DO_CLASS_SETUP(FXApp)
DO_CLASS_SETUP(FXArrowButton)
DO_CLASS_SETUP(FXBMPIcon)
DO_CLASS_SETUP(FXBMPImage)
DO_CLASS_SETUP(FXBitmap)
DO_CLASS_SETUP(FXBitmapFrame)
DO_CLASS_SETUP(FXBitmapView)
DO_CLASS_SETUP(FXButton)
DO_CLASS_SETUP(FXCURCursor)
DO_CLASS_SETUP(FXCanvas)
DO_CLASS_SETUP(FXCheckButton)
DO_CLASS_SETUP(FXChoiceBox)
DO_CLASS_SETUP(FXColorBar)
DO_CLASS_SETUP(FXColorDialog)
DO_CLASS_SETUP(FXColorItem)
DO_CLASS_SETUP(FXColorList)
DO_CLASS_SETUP(FXColorRing)
DO_CLASS_SETUP(FXColorSelector)
DO_CLASS_SETUP(FXColorWell)
DO_CLASS_SETUP(FXColorWheel)
DO_CLASS_SETUP(FXComboBox)
DO_CLASS_SETUP(FXComposite)
DO_CLASS_SETUP(FXCursor)
DO_CLASS_SETUP(FXDC)
DO_CLASS_SETUP(FXDCPrint)
DO_CLASS_SETUP(FXDataTarget)
DO_CLASS_SETUP(FXDebugTarget)
DO_CLASS_SETUP(FXDelegator)
DO_CLASS_SETUP(FXDial)
DO_CLASS_SETUP(FXDialogBox)
DO_CLASS_SETUP(FXDict)
DO_CLASS_SETUP(FXDirBox)
DO_CLASS_SETUP(FXDirDialog)
DO_CLASS_SETUP(FXDirItem)
DO_CLASS_SETUP(FXDirList)
DO_CLASS_SETUP(FXDirSelector)
DO_CLASS_SETUP(FXDocument)
DO_CLASS_SETUP(FXDockBar)
DO_CLASS_SETUP(FXDockHandler)
DO_CLASS_SETUP(FXDockSite)
DO_CLASS_SETUP(FXDockTitle)
DO_CLASS_SETUP(FXDragCorner)
DO_CLASS_SETUP(FXDrawable)
DO_CLASS_SETUP(FXDriveBox)
DO_CLASS_SETUP(FXFileDialog)
DO_CLASS_SETUP(FXIconDict)
DO_CLASS_SETUP(FXFileDict)
DO_CLASS_SETUP(FXFileItem)
DO_CLASS_SETUP(FXFileList)
DO_CLASS_SETUP(FXFileSelector)
DO_CLASS_SETUP(FXFoldingItem)
DO_CLASS_SETUP(FXFoldingList)
DO_CLASS_SETUP(FXFont)
DO_CLASS_SETUP(FXFontDialog)
DO_CLASS_SETUP(FXFontSelector)
DO_CLASS_SETUP(FXFrame)
DO_CLASS_SETUP(FXGIFCursor)
DO_CLASS_SETUP(FXGIFIcon)
DO_CLASS_SETUP(FXGIFImage)
DO_CLASS_SETUP(FXGLCanvas)
DO_CLASS_SETUP(FXGLContext)
DO_CLASS_SETUP(FXGLObject)
DO_CLASS_SETUP(FXGLShape)
DO_CLASS_SETUP(FXGLViewer)
DO_CLASS_SETUP(FXGLVisual)
DO_CLASS_SETUP(FXGradientBar)
DO_CLASS_SETUP(FXGroupBox)
DO_CLASS_SETUP(FXHeaderItem)
DO_CLASS_SETUP(FXHeader)
DO_CLASS_SETUP(FXHorizontalFrame)
DO_CLASS_SETUP(FXICOIcon)
DO_CLASS_SETUP(FXICOImage)
DO_CLASS_SETUP(FXIcon)
DO_CLASS_SETUP(FXIconItem)
DO_CLASS_SETUP(FXIconList)
DO_CLASS_SETUP(FXIconSource)
DO_CLASS_SETUP(FXId)
DO_CLASS_SETUP(FXImage)
DO_CLASS_SETUP(FXImageFrame)
DO_CLASS_SETUP(FXImageView)
DO_CLASS_SETUP(FXInputDialog)
DO_CLASS_SETUP(FXJPGIcon)
DO_CLASS_SETUP(FXJPGImage)
DO_CLASS_SETUP(FXKnob)
DO_CLASS_SETUP(FXLabel)
DO_CLASS_SETUP(FXListItem)
DO_CLASS_SETUP(FXList)
DO_CLASS_SETUP(FXListBox)
DO_CLASS_SETUP(FXMDIDeleteButton)
DO_CLASS_SETUP(FXMDIRestoreButton)
DO_CLASS_SETUP(FXMDIMaximizeButton)
DO_CLASS_SETUP(FXMDIMinimizeButton)
DO_CLASS_SETUP(FXMDIWindowButton)
DO_CLASS_SETUP(FXMDIMenu)
DO_CLASS_SETUP(FXMDIChild)
DO_CLASS_SETUP(FXMDIClient)
DO_CLASS_SETUP(FXMainWindow)
DO_CLASS_SETUP(FXMat3d)
DO_CLASS_SETUP(FXMat3f)
DO_CLASS_SETUP(FXMat4d)
DO_CLASS_SETUP(FXMat4f)
DO_CLASS_SETUP(FXMatrix)
DO_CLASS_SETUP(FXMenuButton)
DO_CLASS_SETUP(FXMenuCaption)
DO_CLASS_SETUP(FXMenuCascade)
DO_CLASS_SETUP(FXMenuCheck)
DO_CLASS_SETUP(FXMenuCommand)
DO_CLASS_SETUP(FXMenuPane)
DO_CLASS_SETUP(FXMenuRadio)
DO_CLASS_SETUP(FXMenuSeparator)
DO_CLASS_SETUP(FXMenuTitle)
DO_CLASS_SETUP(FXMenuBar)
DO_CLASS_SETUP(FXMessageBox)
DO_CLASS_SETUP(FXObject)
DO_CLASS_SETUP(FXOption)
DO_CLASS_SETUP(FXOptionMenu)
DO_CLASS_SETUP(FXPCXIcon)
DO_CLASS_SETUP(FXPCXImage)
DO_CLASS_SETUP(FXPNGIcon)
DO_CLASS_SETUP(FXPNGImage)
DO_CLASS_SETUP(FXPPMIcon)
DO_CLASS_SETUP(FXPPMImage)
DO_CLASS_SETUP(FXPacker)
DO_CLASS_SETUP(FXPicker)
DO_CLASS_SETUP(FXPoint)
DO_CLASS_SETUP(FXPopup)
DO_CLASS_SETUP(FXPrintDialog)
DO_CLASS_SETUP(FXProgressBar)
DO_CLASS_SETUP(FXProgressDialog)
DO_CLASS_SETUP(FXQuatd)
DO_CLASS_SETUP(FXQuatf)
DO_CLASS_SETUP(FXRGBIcon)
DO_CLASS_SETUP(FXRGBImage)
DO_CLASS_SETUP(FXRadioButton)
DO_CLASS_SETUP(FXRanged)
DO_CLASS_SETUP(FXRangef)
DO_CLASS_SETUP(FXRealSlider)
DO_CLASS_SETUP(FXRealSpinner)
DO_CLASS_SETUP(FXRecentFiles)
DO_CLASS_SETUP(FXRectangle)
DO_CLASS_SETUP(FXRegion)
DO_CLASS_SETUP(FXRegistry)
DO_CLASS_SETUP(FXReplaceDialog)
DO_CLASS_SETUP(FXRootWindow)
DO_CLASS_SETUP(FXRuler)
DO_CLASS_SETUP(FXRulerView)
DO_CLASS_SETUP(FXScintilla)
DO_CLASS_SETUP(FXScrollArea)
DO_CLASS_SETUP(FXScrollCorner)
DO_CLASS_SETUP(FXScrollWindow)
DO_CLASS_SETUP(FXScrollBar)
DO_CLASS_SETUP(FXScrollPane)
DO_CLASS_SETUP(FXSearchDialog)
DO_CLASS_SETUP(FXHorizontalSeparator)
DO_CLASS_SETUP(FXVerticalSeparator)
DO_CLASS_SETUP(FXSeparator)
DO_CLASS_SETUP(FXSettings)
DO_CLASS_SETUP(FXShell)
DO_CLASS_SETUP(FXShutterItem)
DO_CLASS_SETUP(FXShutter)
DO_CLASS_SETUP(FXSize)
DO_CLASS_SETUP(FXSlider)
DO_CLASS_SETUP(FXSpinner)
DO_CLASS_SETUP(FXSplashWindow)
DO_CLASS_SETUP(FXSplitter)
DO_CLASS_SETUP(FXSpring)
DO_CLASS_SETUP(FXStatusBar)
DO_CLASS_SETUP(FXStatusLine)
DO_CLASS_SETUP(FXStream)
DO_CLASS_SETUP(FXFileStream)
DO_CLASS_SETUP(FXMemoryStream)
DO_CLASS_SETUP(FXStringDict)
DO_CLASS_SETUP(FXSwitcher)
DO_CLASS_SETUP(FXTGAIcon)
DO_CLASS_SETUP(FXTGAImage)
DO_CLASS_SETUP(FXTIFIcon)
DO_CLASS_SETUP(FXTIFImage)
DO_CLASS_SETUP(FXTabItem)
DO_CLASS_SETUP(FXTabBar)
DO_CLASS_SETUP(FXTabBook)
DO_CLASS_SETUP(FXTabBar)
DO_CLASS_SETUP(FXTabBook)
DO_CLASS_SETUP(FXTabItem)
DO_CLASS_SETUP(FXTableItem)
DO_CLASS_SETUP(FXTable)
DO_CLASS_SETUP(FXText)
DO_CLASS_SETUP(FXTextField)
DO_CLASS_SETUP(FXToggleButton)
DO_CLASS_SETUP(FXToolBar)
DO_CLASS_SETUP(FXToolBarGrip)
DO_CLASS_SETUP(FXToolBarShell)
DO_CLASS_SETUP(FXToolBarTab)
DO_CLASS_SETUP(FXToolTip)
DO_CLASS_SETUP(FXTopWindow)
DO_CLASS_SETUP(FXTranslator)
DO_CLASS_SETUP(FXTreeItem)
DO_CLASS_SETUP(FXTreeList)
DO_CLASS_SETUP(FXTreeListBox)
DO_CLASS_SETUP(FXTriStateButton)
DO_CLASS_SETUP(FXVec2d)
DO_CLASS_SETUP(FXVec2f)
DO_CLASS_SETUP(FXVec3d)
DO_CLASS_SETUP(FXVec3f)
DO_CLASS_SETUP(FXVec4d)
DO_CLASS_SETUP(FXVec4f)
DO_CLASS_SETUP(FXVerticalFrame)
DO_CLASS_SETUP(FXVisual)
DO_CLASS_SETUP(FXWindow)
DO_CLASS_SETUP(FXWizard)
DO_CLASS_SETUP(FXXBMIcon)
DO_CLASS_SETUP(FXXBMImage)
DO_CLASS_SETUP(FXXPMIcon)
DO_CLASS_SETUP(FXXPMImage)

