/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.swing;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jd.gui.util.exception.ExceptionUtil;

public class SwingUtil {
    public static void installGtkPopupBugWorkaround() {
        block3: {
            LookAndFeel laf = UIManager.getLookAndFeel();
            Class<?> lafClass = laf.getClass();
            if (!lafClass.getName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) {
                return;
            }
            try {
                Field field = lafClass.getDeclaredField("styleFactory");
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                Object styleFactory = field.get(laf);
                field.setAccessible(accessible);
                Object style = SwingUtil.getGtkStyle(styleFactory, new JPopupMenu(), "POPUP_MENU");
                SwingUtil.fixGtkThickness(style, "yThickness");
                SwingUtil.fixGtkThickness(style, "xThickness");
                style = SwingUtil.getGtkStyle(styleFactory, new JSeparator(), "POPUP_MENU_SEPARATOR");
                SwingUtil.fixGtkThickness(style, "yThickness");
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block3;
                throw new AssertionError();
            }
        }
    }

    private static void fixGtkThickness(Object style, String fieldName) throws Exception {
        Field field = style.getClass().getDeclaredField(fieldName);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        field.setInt(style, Math.max(1, field.getInt(style)));
        field.setAccessible(accessible);
    }

    private static Object getGtkStyle(Object styleFactory, JComponent component, String regionName) throws Exception {
        Class<?> regionClass = Class.forName("javax.swing.plaf.synth.Region");
        Field field = regionClass.getField(regionName);
        Object region = field.get(regionClass);
        Class<?> styleFactoryClass = styleFactory.getClass();
        Method method = styleFactoryClass.getMethod("getStyle", JComponent.class, regionClass);
        boolean accessible = method.isAccessible();
        method.setAccessible(true);
        Object style = method.invoke(styleFactory, component, region);
        method.setAccessible(accessible);
        return style;
    }

    public static void invokeLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static Image getImage(String iconPath) {
        return Toolkit.getDefaultToolkit().getImage(SwingUtil.class.getResource(iconPath));
    }

    public static ImageIcon newImageIcon(String iconPath) {
        return new ImageIcon(SwingUtil.getImage(iconPath));
    }

    public static Action newAction(String name, boolean enable, final ActionListener listener) {
        AbstractAction action = new AbstractAction(name){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                listener.actionPerformed(actionEvent);
            }
        };
        action.setEnabled(enable);
        return action;
    }

    public static Action newAction(String name, ImageIcon icon, boolean enable, ActionListener listener) {
        Action action = SwingUtil.newAction(name, enable, listener);
        action.putValue("SmallIcon", icon);
        return action;
    }

    public static Action newAction(ImageIcon icon, boolean enable, ActionListener listener) {
        Action action = SwingUtil.newAction(null, icon, enable, listener);
        action.putValue("SmallIcon", icon);
        return action;
    }

    public static Action newAction(String name, ImageIcon icon, boolean enable, String shortDescription, ActionListener listener) {
        Action action = SwingUtil.newAction(name, icon, enable, listener);
        action.putValue("ShortDescription", shortDescription);
        return action;
    }

    public static Action newAction(String name, boolean enable, String shortDescription, ActionListener listener) {
        Action action = SwingUtil.newAction(name, enable, listener);
        action.putValue("ShortDescription", shortDescription);
        return action;
    }
}

