//   XUL Webmail, a web based mailclient
//
//   Copyright (C) 2004 Wouter van Wijk (wvw a@t dds.nl)
//   Copyright (C) 2004-05 Achim J. Latz (xwm a@t latz.org)
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

var priv = "UniversalXPConnect";

netscape.security.PrivilegeManager.enablePrivilege(priv);

var CommonDlg = new Object();
CommonDlg.filePicker = Components.interfaces.nsIFilePicker;
CommonDlg.fileConstructor = new
Components.Constructor("@mozilla.org/file/local;1",                              
       "nsILocalFile",
                        "initWithPath");
var OPEN_DLG = CommonDlg.filePicker.modeOpen;
var SAVE_DLG = CommonDlg.filePicker.modeSave;
var GETFOLDER_DLG = CommonDlg.filePicker.modeGetFolder;
CommonDlg.filters = new Array();    // Array holding the used filters.

/*
Method:       nsIFile
showDlg(String,[String],[String],[String],[String],[Int],[Bool])
Description:  shows the defined dialog to let the user pick a file
Parameters:
     String aDlgMode                    -
     (String aTitle)     - Optional. Defines the title for the openFile
dialog.
                           If not defined, a default string will be used
     (String aDir)       - Optional. Defines the directory to show. This
can also
                           be a keyword as defined for the Directory object.
                           eg. "pictureDir" or "idaDir". If not defined, the
                           applications root directory will be shown.
     (String aDefaultFile) - Optional. The name of the default file
     (String aFilter)    - Optional. Defines the filters used in the dialog.
                           This can be a list of filters or a constant as
                           defined in idalang.properties (ie:
"fileFilter.ida")
                           A filter consists of two elements separated
with ","
                           where the first element defines the text
shown and
                           the second element defines the file
extensions for
                           that filter. ie: "Bitmap (*.bmp),*.bmp"
                           The function will automatically add an "All
files"
                           filter. If no filter is defined, just the
                           "All files" filter is used.
     (Int aFilterIndex)  - Optional. Defines the defaultFilter to use (0
based).
                           If not defined the first filter will be used.
     (Bool aIncludeFilterAll - Optional. Defines, if the "All Files" filter
                           should be included. Default is true.
Returns:
     nsIFile   - returns the choosen file as a nsIFile object.
                 If no file was choosen the method will return null.
*/
CommonDlg.showDlg = function
showDlg(aDlgMode,aTitle,aDir,aDefaultFile,aFilter,aFilterIndex,aIncludeFilterAll)
{
     try {

            var priv = "UniversalXPConnect";
            netscape.security.PrivilegeManager.enablePrivilege(priv);

       var fp =
Components.classes["@mozilla.org/filepicker;1"].createInstance(this.filePicker);

       // holds a list of all used filters
       this.filters = new Array();
       var lFilterArray;
       var lFilter = "";

       function appendFilter(aFilter) {
         if (!aFilter) return false;

         lFilterArray = aFilter.split(",");
         for (var i=0;i<lFilterArray.length;i+=2) {
           fp.appendFilter(lFilterArray[i],lFilterArray[i+1]);
           CommonDlg.filters[CommonDlg.filters.length] = new
Array(lFilterArray[i],lFilterArray[i+1]);
         }
       }

       fp.init(window, aTitle || "Choose", aDlgMode);

       if (aFilter)
        appendFilter(aFilter);

       if (aDlgMode == fp.modeOpen && (aIncludeFilterAll || typeof
aIncludeFilterAll == "undefined"))
         appendFilter("All Files (*.*),*.*");

       if (!aDir)
         aDir = "c:\\";

       fp.displayDirectory = this.nsIFile(aDir);
       if (aDlgMode != fp.modeGetFolder) {
         fp.defaultString = aDefaultFile;
         fp.filterIndex = aFilterIndex || 0;
         fp.defaultExtension =
this.getExtensionFromFilterIndex(fp.filterIndex);
       }
       var res=fp.show();
       if (res==fp.returnOK || res==fp.returnReplace) {
         var lFilePath = fp.file.path;

         if (aDlgMode == fp.modeSave) {
           // check if an extension was chosen. If not, add the current
           if (lFilePath.indexOf(".") == -1) {
             lFilePath += this.getExtensionFromFilterIndex(fp.filterIndex);
             return nsIFile(lFilePath);
           }
         }
         return fp.file;
       }
       else return null;
     }
     catch(e) {
       alert(e);
     }
   };

CommonDlg.nsIFile = function(path) {
     return new this.fileConstructor(path);
   };

CommonDlg.getExtensionFromFilterIndex = function
getExtensionFromFilterIndex(aIndex) {
   if (!aIndex) return "*";
     var lExtension = CommonDlg.filters[aIndex][1].substring(1);

     // use the first defined index if more than one is present
     var lPos = lExtension.indexOf(";");
     if (lPos > -1)
       lExtension = lExtension.substring(0,lPos);

     // clear wildcard characters that might be in the filter index.
     lExtension = lExtension.replace(/\?|\*|\./g,"");
     return lExtension;
   };
   

function submitMessage() {
//    alert ('y');
  /*var httpRequest = new XMLHttpRequest();
  httpRequest.open("POST", "sendmessage.php", false, null, null);
  httpRequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
  httpRequest.send("test=8");
  var response = httpRequest.responseText;
  if (response == '') {
    window.close();
  } else {
    alert (response);
  }*/
  var subject = document.getElementById('subject');
  var to = document.getElementById('to');
  var cc = document.getElementById('cc');
  var bcc = document.getElementById('bcc');
  var message = document.getElementById('message');
  var attachment = document.getElementById('attachment');

  var htsub = document.getElementById('htsubject');
  var htto = document.getElementById('htto');
  var htcc = document.getElementById('htcc');
  var htbcc = document.getElementById('htbcc');
  var htmessage = document.getElementById('htmessage');
  var htattachment = document.getElementById('htattachment');

  htsub.value = subject.value;
  htto.value = to.value;
  htcc.value = cc.value;
  htbcc.value = bcc.value;
  htmessage.value = message.value;

  var htform = document.getElementById('htform');
  var res = htform.submit();
  if ( res ) {
     window.close();
  } else {
  }
}

function refreshMailboxes() {
	// caching of RDF resources can apparently not be disabled in Firefox,
	// solution is to dynamically adapt the source URL for the RDF by adding a random argument
	// see also http://groups.google.nl/group/netscape.public.dev.xul/browse_thread/thread/b30b4eb640f5e1c/90353d37f081dc47?q=rdf+refresh+periodically&rnum=3&hl=nl#90353d37f081dc47
	var url = 'mailboxlist.rdf.php?ran=' + Math.random()*10000;

	var tree=document.getElementById("MailBoxTree");
	tree.setAttribute('datasources', '');
	tree.builder.rebuild();
	tree.setAttribute('datasources', url);
	tree.builder.rebuild();
	tree.builder.refresh();

	var menu=document.getElementById("movemenu");
	menu.setAttribute('datasources', '');
	menu.builder.rebuild();
	menu.setAttribute('datasources', url);
	menu.builder.rebuild();
	menu.builder.refresh();

	var menu=document.getElementById("copymenu");
	menu.setAttribute('datasources', '');
	menu.builder.rebuild();
	menu.setAttribute('datasources', url);
	menu.builder.rebuild();
	menu.builder.refresh();
}

function refreshMessages() {
/*
	xml = '@mozilla.org/rdf/datasource;1?name=xml-datasource';
	datasource = Components.classes[xml].
             createInstance(Components.interfaces.nsIRDFRemoteDataSource);
	datasource.Init('messagelist.rdf.php'+ Math.random()*10000);
	datasource.Refresh(false);
*/

	var msglist = document.getElementById('msgTree');
	msglist.setAttribute('datasources', '');
	selectMailbox();
}

function selectMailbox() {
	var mailbox=getCurrentMailbox();
	var msglist = document.getElementById('msgTree');

	// caching of RDF resources can apparently not be disabled in Firefox,
	// solution is to dynamically adapt the source URL for the RDF by adding a random argument
	// see also http://groups.google.nl/group/netscape.public.dev.xul/browse_thread/thread/b30b4eb640f5e1c/90353d37f081dc47?q=rdf+refresh+periodically&rnum=3&hl=nl#90353d37f081dc47
	msglist.setAttribute('datasources', 'messagelist.rdf.php?mailbox=' + escape(mailbox) + '&ran=' + Math.random()*10000);
	msglist.builder.rebuild();
	msglist.builder.refresh();
}

function selectMessage() {
	var id=getCurrentMessageId();
	var mailbox=getCurrentMailbox();
	var contentFrame = document.getElementById('contentFrame');
	if(id != null) {
		contentFrame.setAttribute('src', "mailsplash.php?id=" + escape(id) + "&mailbox=" + escape(mailbox));
	}
}

function showAbout() {
	window.open("about.xul.php",'about','width=400, height=200, location=no, menubar=no, status=no, toolbar=no, scrollbars=no, resizable=no');
}

function getCurrentMessageIds() {
	var tree = document.getElementById('msgTree');
	try {
 
		var start = new Object();
		var end = new Object();
		var id_array = new Array();
		var id = 0;
		var n = 0;
	
		var numRanges = tree.view.selection.getRangeCount();

		for (var t=0; t<numRanges; t++){
			tree.view.selection.getRangeAt(t,start,end);
			for (var v=start.value; v<=end.value; v++){
				id = tree.view.getCellValue(v, "subject");
				// alert("Item "+id+" is selected.");
				id_array[n]=id;
				n++;
			}
		}
     } catch (e) {
    	    var id_array = null;
     }
     return(id_array);
}

function getCurrentMessageId() {
	var tree = document.getElementById('msgTree');
	try {
		var id = tree.view.getCellValue(tree.currentIndex,"subject");
	} catch (e) {
		var id = null;
     }
     return(id);
}

function getCurrentMailbox() {
	var tree=document.getElementById("MailBoxTree");
	try {
    		var id = tree.view.getCellValue(tree.currentIndex,"mailboxName");
	} catch (e) {
        	var id = null;
     	}
	return(id);
}

function getCurrentMailboxOrAlert() {
	var id = getCurrentMailbox();
	if (id == null) {
		alert('Please select a mailbox!');
	}
	return(id);
}

function sendMessage(action) {
	var openoptions = 'width=750, height=500, location=no, menubar=no, status=no, toolbar=no, scrollbars=no, resizable=yes';
	var mailbox= getCurrentMailbox();

	//new message
	if (action == 0) {
		window.open('composemail.xul.php', '', openoptions);
	} else {
		var id = getCurrentMessageIdOrAlert();
	}

	if (id != null) {
		switch (action) {
		//reply
		case 1: {
			window.open('composemail.xul.php?action=reply&mailbox=' + escape(mailbox) + '&id=' + escape(id), '', openoptions);
		} break;
		//replyall
		case 2: {
			window.open('composemail.xul.php?action=replyall&mailbox=' + escape(mailbox) + '&id=' + escape(id), '', openoptions);
		} break;
		//forward
		case 3: {
		window.open('composemail.xul.php?action=forward&mailbox=' + escape(mailbox) + '&id=' + escape(id), '', openoptions);
		}
		}
	}
}

function closeSession() {
	// alert('closeSession() called');
	var req = new XMLHttpRequest();
	if (req) {  
		argument = 'logout.php';
		req.open('GET', argument, true); 
		req.send(null);
	}
	this.location='logout.php';
	this.close();
}

function printMessage() {
//   obviously not done yet
//  var msgframe = frames[0];
//  var message = frames['ifr'].document.getElementById('message');
//	var contentFrame = document.getElementById('contentFrame');
	var id = getCurrentMessageIdOrAlert();
	if (id != null) {
		parent.contentFrame.print();
	}
}

function viewSource() {
	var mailbox= getCurrentMailbox();
	var id = getCurrentMessageIdOrAlert();
	if (id != null) {
		window.open("viewsource.xul.php?mailbox="  + escape(mailbox) + '&id=' + escape(id) ,'','width=600, height=400, location=no, menubar=no, status=yes, toolbar=no, scrollbars=no, resizable=no');
	}
}

function getCurrentMessageIdOrAlert() {
	var id = getCurrentMessageId();
	if (id == null) {
		alert('Please select a message!');
	}
	return(id);
}

function initMain($statusmessage) {

	var tree = document.getElementById("MailBoxTree");
	var ds = tree.getAttribute('datasources');
	if (ds == '') {
		refreshMailboxes();
	}
	
	window.defaultStatus = $statusmessage;
	//remove the onload handler, workaround for a bug in Moz
	mailwindow = document.getElementById("mailwindow");
	mailwindow.setAttribute('onload', null);

	// Refresh messages every 60 seconds
	interval = 60 * 1000;
	
	intervalID = this.setInterval(refreshMessages, interval);
	// alert('intervalID is '+ intervalID );

	// select the first mailbox (hopefully "INBOX") by default
	tree.view.selection.select(0);
}

/*
 * BUGBUG it appears for now that none of the three approaches 
 * to modify the tree (on the UI side only, thus removing the need
 * for re-loading RDF every time) works:
 *
 * treebuilder.getResourceAtIndex (dynamic RDF)
 * view.getItemAtIndex (normal RDF)
 * 
 *  var tree=document.getElementById('treeset');
  var items=tree.selectedItems;
  if (items.length==0) alert("No items are selected.");
  else {
    txt="You have selected:\n\n";
    for (t=0;t<items.length;t++){
      txt+=items[t].firstChild.firstChild.getAttribute('value')+'\n';
    }
    alert(txt);
  }
  * 
  */

function deleteMessage_new() {
	var mailbox= getCurrentMailbox();

	// assure that at least one message is selected
	var id = getCurrentMessageIdOrAlert();
	
	// applyAction('delete', mailbox, null);
	var tree = document.getElementById('msgTree');

	alert('deleteMessage(): ' + tree.view);

	try {
		var start = new Object();
		var end = new Object();
	
		var numRanges = tree.view.selection.getRangeCount();

		for (var t=0; t<numRanges; t++){
    		tree.view.selection.getRangeAt(t,start,end);
        	for (var v=start.value; v<=end.value; v++){
 				alert('removing ' + v);
				id = tree.view.getCellValue(v, "subject");
				// var selected = tree.treebuilder.getResourceAtIndex(v);
				// var id = selected.getAttribute("subject");
                var parent = selected.parentNode;
                parent.removeChild(selected);
				alert('removed ' + id);
			}
		}

/*		
		for (var t=0; t<numRanges; t++){
			msglist.view.selection.getRangeAt(t,start,end);
			for (var v=start.value; v<=end.value; v++){
				// id = msglist.view.getCellValue(v, "subject");
                var selected = msglist.view.getItemAtIndex(v);
                var parent = selected.parentNode;
                parent.removeChild(selected);
				alert('removed ' + selected);
                // Selected row, value of column "name"
                var name = msglist.view.getCellText(v, "subject")
				// alert("Item "+id+" is selected.");
			}
		}
*/				
     } catch (e) {
				alert('Exception ' + e);
     }

	// refreshMessages();
}

function deleteMessage() {
	var mailbox= getCurrentMailbox();

	// assure that at least one message is selected
	var id = getCurrentMessageIdOrAlert();
	
	applyAction('delete', mailbox, null);
}

// apply a specified action (delete, move, copy) to the currently selected message or messages 
function applyAction(action, sourcemailbox, targetmailbox) {

	// get *all* selected messages and treat them correspondingly
	var id_array = getCurrentMessageIds();

	var contentFrame = document.getElementById('contentFrame');
	
	var argument = '';

	for (var i=0; i <= id_array.length-1;i++){
			if (id_array[i] != null) {
				// start a async request for every delete action				
				var req = new XMLHttpRequest(); 
				if (req) {  
					argument = 'managemail.php?action=' + action + '&sourcemailbox=' + escape(sourcemailbox) + '&targetmailbox=' + escape(targetmailbox) + '&id=' + escape(id_array[i]) + '&submit=1';
			 		req.open('GET', argument, true); 
			 		req.send(null);
			 	}
			}
	}
	// finally, set the content frame to show the message, and update
	contentFrame.setAttribute('src',argument);
	refreshMessages();
}

function copymoveMessage(targetmailbox, action) {
	var sourcemailbox= getCurrentMailbox();

	// assure that at least one message is selected
	var id = getCurrentMessageIdOrAlert();
	
	// test whether source and target are identical
	if (sourcemailbox == targetmailbox) {
		alert('Cannot '+action+' the messsage: The destination folder is the same as the source folder: ' + targetmailbox);
		return;
	}

	// now get *all* selected messages and treat them correspondingly
	applyAction(action, sourcemailbox, targetmailbox);
}

function deleteMailbox() {
	var mailbox= getCurrentMailboxOrAlert();
	if (mailbox != null) {
//		alert(id);
		if(confirm('Delete this mailbox: ' + mailbox + '?')) {
			var contentFrame = document.getElementById('contentFrame');
			contentFrame.setAttribute('src','managefolders.php?action=delete&mailbox=' + escape(mailbox) + '&submit=1');
		}
		refreshMailboxes();
	}
}

function renameMailbox() {
	var mailbox= getCurrentMailboxOrAlert();
	if (mailbox != null) {
		var name = prompt('Please type the new name for the mailbox:', mailbox);
		if( (name != '') && (name != ' ') && (name != null) ) {
			var contentFrame = document.getElementById('contentFrame');
			contentFrame.setAttribute('src','managefolders.php?action=rename&oldname=' + escape(mailbox) + '&newname=' + name + '&submit=1');
		}
		refreshMailboxes();
	}
}

function createMailbox() {
	var mailbox= getCurrentMailboxOrAlert();
	if (mailbox != null) {
		var name = prompt('Please type the new name for the mailbox:', 'New Folder');
		if( (name != '') && (name != ' ') && (name != null) ) {
			var contentFrame = document.getElementById('contentFrame');
			contentFrame.setAttribute('src','managefolders.php?action=create&inmailbox=' + escape(mailbox) + '&name=' + name + '&submit=1');
		}
		refreshMailboxes();
	}
}

function emptyTrash() {
	if(confirm('Empty the trash?')) {
		var contentFrame = document.getElementById('contentFrame');
		contentFrame.setAttribute('src','managefolders.php?action=emptytrash&submit=1');
		refreshMessages();
	}
}

	function attachToMessage() {
		var file = CommonDlg.showDlg(OPEN_DLG,"Please choose a file to attach")
		
		var priv = "UniversalXPConnect";
		netscape.security.PrivilegeManager.enablePrivilege(priv);

		var serverURL = "uploadattachment.php";

		if(file) {
		const FILESIZE = file.fileSize;
		const FILENAME = file.leafName;
		
		const BOUNDARY="111222111"; //ce qui va nous servir de dlimiteur
		
		 const MULTI="@mozilla.org/io/multiplex-input-stream;1";
		 const FINPUT = "@mozilla.org/network/file-input-stream;1";
		 const STRINGIS="@mozilla.org/io/string-input-stream;1";
		 const BUFFERED="@mozilla.org/network/buffered-input-stream;1";
		
		 const nsIMultiplexInputStream=Components.interfaces.nsIMultiplexInputStream;
		 const nsIFileInputStream=Components.interfaces.nsIFileInputStream;
		 const nsIStringInputStream=Components.interfaces.nsIStringInputStream;
		 const nsIBufferedInputStream = Components.interfaces.nsIBufferedInputStream;

		 // 1
		 var mis=Components.classes[MULTI].createInstance(nsIMultiplexInputStream);
		
		 //2
		 var fin=Components.classes[FINPUT].createInstance(nsIFileInputStream);
		 fin.init(file,0x01,0444,null); //file est un objet de type filehier
		 var buf=Components.classes[BUFFERED].createInstance(nsIBufferedInputStream);
		 buf.init(fin,4096);
		
		 //3
		 var hsis=Components.classes[STRINGIS].createInstance(nsIStringInputStream);
		 var sheader=new String();
		 sheader+="\r\n";
		 sheader+="--"+BOUNDARY+"\r\nContent-disposition: form-data;name=\"addfile\"\r\n\r\n1";
		 sheader+="\r\n"+"--"+BOUNDARY+"\r\n";
		 sheader+="Content-disposition: form-data;name=\"filename\";filename=\""+FILENAME+"\"\r\n";
		 sheader+="Content-Type: application/octet-stream\r\n";
		 sheader+="Content-Length: "+FILESIZE+"\r\n\r\n";
		 hsis.setData(sheader,sheader.length);
		
		 //4
		 var endsis=Components.classes[STRINGIS].createInstance(nsIStringInputStream);
		 var bs=new String("\r\n--"+BOUNDARY+"--\r\n");
		 endsis.setData(bs,bs.length);
		
		 //5
		 mis.appendStream(hsis);
		 mis.appendStream(buf);
		 mis.appendStream(endsis);
		
		 //6
		 var xmlr = new XMLHttpRequest();
		 
		 // async POST request to serverURL
		 xmlr.open("POST",serverURL,true);
		 
		 // this function will be called for every change of status
		 xmlr.onreadystatechange = function() {
		    stateChangeCallback(xmlr, FILESIZE, FILENAME);
	}
 
	xmlr.setRequestHeader("Content-Length",(mis.available()-2));
	 //Je ne sais pas pouquoi -2, je doit faire une erreur quelque part
	 xmlr.setRequestHeader("Content-Type","multipart/form-data; boundary="+BOUNDARY);
	 //7 :)
	 //8
	 xmlr.send(mis);
	}
	}
	
	function finishedUpload(request, filename) {
	
		responseText = request.responseText;
		status = request.status;
		
		if (200 != status) {
			error = "An error has occurred during the upload of " + filename + ": " + status +': '+ responseText;
			alert(error);
			document.getElementById('statusbar').setAttribute('label',error);
		} else {
			document.getElementById('statusbar').setAttribute('label',"Attachment " + filename + " successfully uploaded.");
			
			// activate list of attachments and add the element
			document.getElementById('attachments-box').setAttribute('hidden',"false");
			document.getElementById('attachmentbucket-sizer').setAttribute('hidden',"false");
			document.getElementById('attachmentBucket').appendItem(filename,filename);
			
			// add filename to list of attachments in document, split by ' (tick)
			current = document.getElementById('htattachment').getAttribute('value');
			if (null == current) {
				// first attachment to be added
				document.getElementById('htattachment').setAttribute('value', filename+"'");
			} else {
				// at least one other attachment existed already
				document.getElementById('htattachment').setAttribute('value', current+filename+"'");
			}
		}
	}

 
// Called whenever readyState changes
function stateChangeCallback(xmlhttp, filesize, filename) {
	// alert('stateChangeCallback() with xmlhttp.readyState=' + xmlhttp.readyState);
	var meter = document.getElementById('uploadprogress');
    switch ( xmlhttp.readyState ) {

        case 1:
			// disable SEND and ATTACH options while upload is in progess
			document.getElementById('cmd_send').setAttribute('disabled','true');
			document.getElementById('cmd_attach').setAttribute('disabled','true');

			meter.setAttribute('mode', 'undetermined');
			document.getElementById('statusbar').label="Uploading attachment "+filename+". Please wait...";
        break;

        case 2:
			//document.getElementById('statusbar').label="LOADED send() has been called, headers and status are available.";

        break;

        case 3:
            //processUpload(xmlhttp.responseText,filesize);

        break;

        case 4:
			// enable the attachment UI again.
			document.getElementById('cmd_send').setAttribute('disabled','false');
			document.getElementById('cmd_attach').setAttribute('disabled','false');

			meter.setAttribute('mode', 'determined');
			meter.setAttribute('value', '100%');			

			finishedUpload(xmlhttp, filename);
        break;
    }
    return true;
}

// NOT USED FOR NOW: User progress handler 
// Unfortunately, onprogress does not seem to work -- no exact tracking 
// upload progress (current/total) possible
/*
function processUpload (responseText, contentLength, fileName) {
		document.getElementById('statusbar').label="INTERACTIVE Downloading, responseText holds the partial data.";
        // Note that responseText is everything we've got so far
        // (not the incremental change)
        alert("Got "+responseText+" of "+contentLength);
        document.getElementById('uploadprogress').hidden=false;
        document.getElementById('uploadprogress').value=responseText/contentLength;
    }

    function onProgress(xmlhttp, filesize) {
    	processUpload(xmlhttp.responseText, filesize);
   	}
   	*/
   	
function deleteAttachment() {
	// get all the required elements from the page
	var htattachment = document.getElementById('htattachment')
	var oldlist = htattachment.getAttribute('value');
	var list = document.getElementById('attachmentBucket');
	var count = list.selectedCount;
	var filename = '';
   
   //alert ('delete() Before: ' + oldlist);
  // 1. delete the selected attachment(s) from the list
  // 2. delete the attachment(s) on the server
  while (count--){
    // Step 1
    var item = list.selectedItems[0];
    filename = item.value;
    list.removeItemAt(list.getIndexOfItem(item));
    // Step 2
    // need to create a new request every time, otherwise
    // race conditions occur
	var req = new XMLHttpRequest(); 
	if (req) {  
 		req.open('POST', 'deleteattachment.php', true); 
 		req.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded'); 
 		req.send('attachment='+filename);
 	}
  }
 		

  // 3. re-create the htattachment string that contains all attachments
  count = list.getRowCount();  
  var remaining = '';
  var i = 0;
  while (i<count) {
   remaining = remaining + list.getItemAtIndex(i).value + "'";
   i++;
   }
   
   htattachment.setAttribute('value', remaining);
   var newlist = htattachment.getAttribute('value');
   // alert ('delete() after: ' + newlist);
   
   // 4. check whether this was the last attachment left
   // and hide attachmentBucket in that case
   if (0 == count) {
			// de-activate list of attachments and add the element
			document.getElementById('attachments-box').setAttribute('hidden',"true");
			document.getElementById('attachmentbucket-sizer').setAttribute('hidden',"true");
	}
   
   // 5. Set the status bar accordingly.
   document.getElementById('statusbar').setAttribute('label',"Attachment " + filename + " deleted.");
}