/***********************************************************************
*                               Tracing
*                             (trace.js)
***********************************************************************/
/*
* Description:
* ============
*
* Contributors
* ============
* Franklin de Graaf (original author)
*
* API
* ===
* Constants and Variables (that need to be defined externally)
* -----------------------
* const TRACE_LOADING	(settings.js)
* const TRACE_INITIALIZING(settings.js)
* const NAMESPACE		(settings.js)
* var   outputFrame	(xulmaker.js)
*
* Issues (bugs/problems)
* ======
*     
* Notes
* =====
*
* Change Log (for Version 0.40) 
* ==========
*
* Resolved Issues
* ---------------
*
* Enhancements
* ------------
*
* TODO
* ====
* minor
* -----
* 
* major
* -----
*
***********************************************************************/
if(TRACE_LOADING){ alert("Start loading: trace.js"); }

//======================================================================
//  Tracing
//======================================================================


//------------------------
// Constants
//------------------------


// The following must be defined (could have different definitions)
// in a javascript file that is loaded before this one, e.g. "global.js"
//const VERSION = "0.38";
//const NAMESPACE = "xm:";

//------------------------
// Variables
//------------------------

var traceFunction = new Array();


//----------------------------------------------------------------------
//  setDevelopmentMode(show)
//----------------------------------------------------------------------
function setDevelopmentMode(show) {
		// Show the trace menu (Its set as hidden for non-developement mode)
		menuNode = document.getElementById(NAMESPACE + "trace");
		if (show) {
			menuNode.setAttribute("hidden", "false");
		} else {
			menuNode.setAttribute("hidden", "true");
		}

		// Show the debug menu (Its set as hidden for non-development mode)
		menuNode = document.getElementById(NAMESPACE + "debug");
		if (show) {
			menuNode.setAttribute("hidden", "false");
		} else {
			menuNode.setAttribute("hidden", "true");
		}

		// Show the Project Documentation (Its set as hidden for non-development mode)
		menuNode = document.getElementById(NAMESPACE + "project-documentation");
		if (show) {
			menuNode.setAttribute("hidden", "false");
		} else {
			menuNode.setAttribute("hidden", "true");
		}
		// Show the the broken stuff (Its set as hidden for non-development mode)
		menuNode = document.getElementById(NAMESPACE + "xulplanet");
		if (show) {
			menuNode.setAttribute("hidden", "false");
		} else {
			menuNode.setAttribute("hidden", "true");
		}
}

//----------------------------------------------------------------------
//  traceInit()
//----------------------------------------------------------------------
function traceInit() {
	if(TRACE_INITIALIZING){ alert("Start Initializing 'traceInit()'"); }
	if (debugMode) {
		// Show the trace menu (Its set as hidden for non-debug mode)
		setDevelopmentMode(false);

		// find output frame
		//outputFrame = document.getElementById(NAMESPACE + "output-view");
		outputFrame = window.frames[NAMESPACE + "output-view"];
		if (outputFrame == null) { alert("There is no output frame to output trace messages."); }
		outputFrame.document.open();

		// Build trace table from current trace menu settings
		menuNode = document.getElementById(NAMESPACE + "trace");
		menuNode = menuNode.childNodes.item(0); //go to <popupmenu>
		var menuitemNode;
		for (var i=0; i < menuNode.childNodes.length; i++) {
			menuitemNode = menuNode.childNodes.item(i);
			setTraceFunction(menuitemNode);
		}
			
		// Override trace table entries for initialization
		if(TRACE_INITIALIZING){
	                //<<<<< =============== modify this list =========== >>>>>>>>>>>>
			traceFunction["Init"] = true;
			traceFunction["XMLSchema::openFile"] = true;
			traceFunction["xulmaker"] = true;
			traceFunction["DesignDocument::DesignDocument"] = true;
			traceFunction["ElementExplorer::ElementExplorer"] = true;
			traceFunction["AttributeInspector::AttributeInspector"] = true;
		}

	}
	if(TRACE_INITIALIZING){ alert("Finished Initializing 'traceInit()'"); }
}
 
//----------------------------------------------------------------------
//  setTraceFunction()
//----------------------------------------------------------------------
function setTraceFunction(menuitemNode) {
	if (menuitemNode.tagName == "menuitem") {
		if (menuitemNode.getAttribute("type") == "checkbox") {
			fn = menuitemNode.getAttribute("label");
			fn = fn.substring(0,fn.length-2); // strip off "()"
			if ( menuitemNode.hasAttribute("checked") && (menuitemNode.getAttribute("checked")=="true" ) ) {
				traceFunction[ fn ] = true;
			} else {
				traceFunction[ fn ] = false;
			}
			//alert("traceFunction[" + fn + "] = " + traceFunction[fn]);
		}     
	}
}

//----------------------------------------------------------------------
//  onChangeTraceCheckbox()
//----------------------------------------------------------------------
function onChangeTraceCheckbox(event) {
	// changing the checkbox on any of the trace menuitems changes the trace table entry
	setTraceFunction(event.target);
}

//----------------------------------------------------------------------
//  trace()
//----------------------------------------------------------------------
function trace(traceFunctionName, traceType, traceMessage )
{
    if ( debugMode && traceFunction[traceFunctionName] ) {
        var traceTypeLabel;
        switch (traceType) {
            case "BEGIN": { traceTypeLabel = "BEGIN"; }
            case "END": { traceTypeLabel = "END"; }
            case "INFO": { traceTypeLabel = "INFO"; }
            case "ERROR": { traceTypeLabel = "ERROR"; }
            case "WARNING": { traceTypeLabel = "WARNING"; }
            case "MSG": { traceTypeLabel = "MSG"; }
            default: { traceTypeLabel = traceType; }
        }
        alertMessage("TRACE", traceFunctionName + ": " + traceTypeLabel
        + (traceMessage?"\n----------------------------------------\n" + traceMessage:"") );
        outputMessage(traceFunctionName, traceTypeLabel, traceMessage );
    }
        
}

//----------------------------------------------------------------------
//  outputMessage()
//----------------------------------------------------------------------
function outputMessage(aFunctionName, aTraceTypeLabel, aMessage ) {
        outputFrame.document.write("<b>" + aFunctionName + "</b>" + ": " + aTraceTypeLabel + "<br/>");
        if (aMessage) {
            outputFrame.document.write( "&nbsp;&nbsp;&nbsp;&nbsp;" + aMessage + "<br/>");
        }
}

//----------------------------------------------------------------------
//  alertMessage()
//----------------------------------------------------------------------
function alertMessage( aMessageType, aMessage ) {
    alert(
        aMessageType + "\n"
    +   "========================================\n"
    +   aMessage + "\n"
    +   "========================================\n"
    );
}

//======================================================================
//  dump()
//======================================================================
function dump(msg) {
	alert("DUMP:\n" + msg);
      outputFrame.document.write(msg);
      outputFrame.document.write("<br/>");
}

/*
	if (browserMode) {
		//setSecurity();
		setPreferences();
	}
	window.dump.enabled;
	debug(" **********************************");
	debug("   xulmaker v"+version+" loaded\n");
*/

//======================================================================
//  debug()
//======================================================================
function debug(msg) {
	//window.dump(msg+"\n");
	alert("TRACE:\n" + msg);
}

//======================================================================
//  listProperties()
//======================================================================
function listProperties(obj,name) {
	var str = "";
	var objName = name?name:obj.nodeName;
	for (var property in obj) {
try {
		//str += obj.nodeName + "." + property + " = " + obj[property] + "\n";
		str += objName + "." + property + " = " + obj[property] + "\n";
} catch (e) {
	alert("listProperties: ERROR: " + e);
}
	}
	return ("Properties:\n" + str);
}

//======================================================================
//  displayProperties()
//======================================================================
function displayProperties(str,name) {
	
	popupWindow = window.openDialog('about:', '_blank', 'chrome,all,dialog');
	var re = /\n/g;
	str = str.replace(re,"</br>"); // replace linefeed with html break element
	popupWindow.title = (name?name+" ":"") + "Properties";
	popupWindow.moveTo=(400,200);//doesn't work
	popupWindow.resizeTo(400,600);
	popupWindow.document.write(str);
}

/***********************************************************************
if(TRACE_LOADING){ alert("Continuing loading: trace.js"); }
***********************************************************************/
if(TRACE_LOADING){ alert("Finish loading: trace.js"); }
