//  **** BEGIN LICENSE BLOCK ****
//  Copyright(c) 2002-2003 Daniel Savard.
//
//  LiveHTTPHeaders: this programs have two purpose
//  - Add a tab in PageInfo to show http headers sent and received
//  - Add a tool that display http headers in real time while loading pages
//
//  This program is free software; you can redistribute it and/or modify it under
//  the terms of the GNU General Public License as published by the Free
//  Software Foundation; either version 2 of the License, or (at your option)
//  any later version.
//
//  This program is distributed in the hope that it will be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
//  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
//  more details.
//
//  You should have received a copy of the GNU General Public License along with
//  this program; if not, write to the Free Software Foundation, Inc., 59 Temple
//  Place, Suite 330, Boston, MA 02111-1307 USA
//  **** END LICENSE BLOCK ****

var oHeaderInfoLive;
function startHeaderInfoLive() {
  oHeaderInfoLive = new HeaderInfoLive();
  oHeaderInfoLive.start();
  addToListener(oHeaderInfoLive)
}
function stopHeaderInfoLive() {
  removeFromListener(oHeaderInfoLive)
  oHeaderInfoLive.stop();
  delete oHeaderInfoLive;
  oHeaderInfoLive = null;
}

function addToListener(obj)
{
  // Register new request and response listener
  if ('nsINetModuleMgr' in Components.interfaces) {
    // Should be an old version of Mozilla/Phoenix (before september 15, 2003)
    var netModuleMgr = Components.classes["@mozilla.org/network/net-extern-mod;1"].getService(Components.interfaces.nsINetModuleMgr);
    netModuleMgr.registerModule("@mozilla.org/network/moduleMgr/http/request;1", obj);
    netModuleMgr.registerModule("@mozilla.org/network/moduleMgr/http/response;1", obj)
  } else {
    // Should be a new version of  Mozilla/Phoenix (after september 15, 2003)
    var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
    observerService.addObserver(obj, "http-on-modify-request", false);
    observerService.addObserver(obj, "http-on-examine-response", false);
  }
}
function removeFromListener(obj)
{
  // Unregistering listener
  if ('nsINetModuleMgr' in Components.interfaces) {
    // Should be an old version of Mozilla/Phoenix (before september 15, 2003)
    var netModuleMgr = Components.classes["@mozilla.org/network/net-extern-mod;1"].getService(Components.interfaces.nsINetModuleMgr);
    netModuleMgr.unregisterModule("@mozilla.org/network/moduleMgr/http/request;1", obj);
    netModuleMgr.unregisterModule("@mozilla.org/network/moduleMgr/http/response;1", obj);
  } else {
    // Should be a new version of  Mozilla/Phoenix (after september 15, 2003)
    var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
    observerService.removeObserver(obj, "http-on-modify-request");
    observerService.removeObserver(obj, "http-on-examine-response");
  }
}

function HeaderInfoLive()
{
  this.test = new Array(); //Test
  this.data = new Array(); //Data for each row
  this.type = new Array(); //Type of data (request, post, response, url, etc)
  this.style= new Array(); //Style of data (request, post, response, url, etc)
  this.check= new Array(); //This is an array of url to check (modify headers)
  this.names= new Array(); //Names for tree's images
  this.atoms= new Array(); //Atoms for tree's styles
   
}
HeaderInfoLive.prototype =
{
  test : null, 
  oDump: null,
  isCapturing: true,

  // Tree interface
  rows: 0,
  tree: null,

  // Horizontal scrolling
  hScrollBar: null,
  hScrollPos: 0,
  hScrollMax: 0,
  datapresent: "datapresent",

  
  
  // Initialisation and termination functions
  start : function()
  {
  },


  stop : function()
  {
  },

  // This is the observerService's observe listener.
  observe: function(aSubject, aTopic, aData) {
    if (aTopic == 'http-on-modify-request') {
      aSubject.QueryInterface(Components.interfaces.nsIHttpChannel);
      this.onModifyRequest(aSubject);
    } else if (aTopic == 'http-on-examine-response') {
      aSubject.QueryInterface(Components.interfaces.nsIHttpChannel);
      this.onExamineResponse(aSubject);
    }
  },

  // Header Info Lives functions
  capture : function(flag)
  {
    this.isCapturing = flag;
  },

  observeURL : function(name, request, response, postData)
  {
    
    //filter out images, javascript files and css files
    //var extRE = /.gif$|.jpg$|.ico$|.png$|.css$|.js$|.css$|.xml$|.rss|.rdf$/i
    if ( this.isCapturing ) {
      var getdata = name;
      var flag = false;
      var encoding = request['Accept-Charset']
      encoding = encoding.substring(0, encoding.indexOf(','))
      var postdata = ''
      if (postData) {
        this.t = postData.seekablestream;	//DSMT: REPLAY
        //this.c = request["CACHE"];
        var size, mode;
        this.mode=1
        switch (this.mode) {
          case 0: mode=0; size=0; break;	//Don't get any content
          case 1: mode=1; size=-1; break;	//Get content the fast way
          case 2: mode=2; size=-1; break;	//Get content the accurate way
          case 3: mode=2; size=1024; break;	//Only get 1024 bytes of content
        }
        postData.setMode(mode);
        var postdata = postData.getPostBody(size).match(/^.*(\r\n|\r|\n)?/mg); // "\r\n"
        
      }
      
      //Now test if this is actually the needlesearch post (and not some rss feed refreshing in
      //	the background)
		var nsRE = /needlesearch/ig
		if ( nsRE.test(String(getdata)) || nsRE.test(String(postdata)) ) {
			flag = false;
			stopHeaderInfoLive()
			NeedleSearch.finishAutoAdd(String(getdata), String(postdata), String(encoding))
		}
    }
  },

  onModifyRequest : function (oHttp)
  {
    //dump("onModifyRequest\n");
    //dumpall("Request", oHttp,2);
    //dump("MODIFY: '" + oHttp.URI.asciiSpec +"'\n");

    //this.onExamineResponse(oHttp);
    //alert("REquest: " + oHttp)
    //this.test[oHttp.URI.asciiSpec] = 1

    if (oHttp.URI.asciiSpec in this.check) {
      //dumpall("Request", oHttp,1);
      // This observer is designed to delete all observed headers
      function emptyObserver(oHttp) {
        this.oHttp = oHttp;
        this.request = new Array();
      }
      emptyObserver.prototype = {
        visitHeader : function (name, value)
        {
          this.request[name.toLowerCase()]=value;
        },
        emptyHeaders: function ()
        {
          oHttp.visitRequestHeaders(this);
          for (var i in this.request) {
            this.oHttp.setRequestHeader(i,null,false);
          }
        }
      }
      var empty = new emptyObserver(oHttp);
      empty.emptyHeaders();

      //Get the URI and request array
      //dump("BINGO: " + uri);
      var uri = oHttp.URI.asciiSpec;
      var req = this.check[uri];
      delete this.check[uri];

      //Set the new headers
      for (var i in req) {
        try {
          //dump("Try: " + i + " = " + req[i] + "\n");
          if (i == 'Content-Type' || i == 'Content-Length') {
            oHttp.setRequestHeader(i, null, false);
          } else {
            oHttp.setRequestHeader(i, req[i], false);
          }
        } catch (ex) {
          //dump("onModifyRequest: exception: " + ex +"\n");
        }
      }
      //oHttp.requestMethod = "Get";
      //oHttp.QueryInterface(Components.interfaces.nsICachingChannel);
      //oHttp.cacheToken = null;
      //oHttp.cacheKey = null;
      //oHttp.loadFlags = oHttp.LOAD_NORMAL;
      //oHttp.loadFlags = oHttp.LOAD_BYPASS_CACHE;
      //oHttp.loadFlags = oHttp.VALIDATE_ALWAYS;
    }
  },

  onExamineResponse : function (oHttp)
  {
    var name = oHttp.URI.asciiSpec;
    var visitor = new HeaderInfoVisitor(oHttp);
    //dumpall("oHttp",oHttp,2);
    //alert("REsponse: " + oHttp)
    //alert(this.test[oHttp])
    //if (name in this.test) {
    //    dump("URL FOUND: " + name +"\n");
    //    delete this.test[name];
    //}
    //for (i in this.test) {
    //    dump("URL: " + i + "\n");
    //}
 
    // Get the request headers
    var request = visitor.visitRequest();
    // and extract Post Data if present
    var postData = request["POSTDATA"];
    delete request["POSTDATA"];
    //DSMT
    //this.request[name]["CACHE"] = oHttp.cacheToken;
 
    // Get the response headers
    var response = visitor.visitResponse();
    //dumpall("oHttp",oHttp,5);
    //dumpall("oHttp.loadGroup",oHttp.loadGroup,2);
    //dumpall("oHttp.loadGroup.groupObserver",oHttp.loadGroup.groupObserver,2);
    //dumpall("oHttp.loadGroup.groupObserver.DOMWindow",oHttp.loadGroup.groupObserver.DOMWindow,2);
    //dumpall("oHttp.loadGroup.groupObserver.container",oHttp.loadGroup.groupObserver.container,2);
    //dumpall("oHttp.loadGroup",oHttp.loadGroup,2);
    //dumpall("oHttp.loadGroup.groupObserver",oHttp.loadGroup.groupObserver,2);
    //dumpall("oHttp.loadGroup.notificationCallbacks",oHttp.loadGroup.notificationCallbacks,2);

    this.observeURL(name, request, response, postData);

    //dumpall("Request",this.request[oHttp.name],1);
    //dumpall("Response",this.response[oHttp.name],1);
  },

  QueryInterface: function(iid) {
    if (!iid.equals(Components.interfaces.nsISupports) &&
        !iid.equals(Components.interfaces.nsIHttpNotify) &&
        //!iid.equals(Components.interfaces.nsIClassInfo) &&
        //!iid.equals(Components.interfaces.nsISecurityCheckedComponent) &&
        //!iid.equals(Components.interfaces.nsIWeakReference) &&
        !iid.equals(Components.interfaces.nsIHttpNotify) &&
        !iid.equals(Components.interfaces.nsIObserver)) {
          //dump("LiveHTTPHeaders: QI unknown iid: " + iid + "\n");
          throw Components.results.NS_ERROR_NO_INTERFACE;
      }
      return this;
    }
}

function HeaderInfoVisitor (oHttp)
{
  //dump("HeaderInfoVisitor\n");
  this.oHttp = oHttp;
  this.headers = new Array();
}
HeaderInfoVisitor.prototype = 
{
  oHttp : null,
  headers : null,
  getHttpRequestVersion: function (httpProxy)
  {
    var version = "1.0"; // Default value for direct HTTP and proxy HTTP
    try {
      // This code is based on netwerk/protocol/http/src/nsHttpHandler.cpp (PrefsChanged)
      var pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
      pref = pref.getBranch("");
      // Now, get the value of the HTTP version fields
      if (httpProxy) {
        var tmp = pref.getCharPref("network.http.proxy.version");
        if (tmp == "1.1") version = tmp;
      } else {
        var tmp = pref.getCharPref("network.http.version");
        if (tmp == "1.1" || tmp == "0.9") version = tmp;
      }
    } catch (ex) {}
    return version;
  },
  useHttpProxy : function (uri)
  {
    // This code is based on netwerk/base/src/nsProtocolProxyService.cpp (ExamineForProxy)
    try {
      var pps = Components.classes["@mozilla.org/network/protocol-proxy-service;1"].getService().QueryInterface(Components.interfaces.nsIProtocolProxyService);
      
      // If a proxy is used for this url, we need to keep the host part
      if (pps.proxyEnabled && (pps.examineForProxy(uri)!=null)) {
        // Proxies are enabled.  Now, check if it is an HTTP proxy.
        var pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
        pref = pref.getBranch("");
        // Now, get the value of the HTTP proxy fields
        var http_host = pref.getCharPref("network.proxy.http");
        var http_port = pref.getIntPref("network.proxy.http_port");
        // network.proxy.http_port network.proxy.http
        if (http_host && http_port>0) {
          return true; // HTTP Proxy
        } 
      } 
      return false; // No proxy or not HTTP Proxy
    } catch (ex) {
      return null; // Error
    }
  },
  getPostData : function(oHttp) {
    function postData(stream) {
      // Scriptable Stream Constants
      const JS_SCRIPTABLEINPUTSTREAM_CID = "@mozilla.org/scriptableinputstream;1";
      const JS_SCRIPTABLEINPUTSTREAM     = "nsIScriptableInputStream";
      const JS_ScriptableInputStream = new Components.Constructor
           ( JS_SCRIPTABLEINPUTSTREAM_CID, JS_SCRIPTABLEINPUTSTREAM );
      // Create a scriptable stream
      this.seekablestream = stream;
      this.stream = new JS_ScriptableInputStream();
      this.stream.init(this.seekablestream);
      this.mode = this.FAST;

      // Check if the stream has headers
      try { 
        this.seekablestream.QueryInterface(Components.interfaces.nsIMIMEInputStream);
        this.hasheaders = true;
        this.body = -1; // Must read header to find body
      } catch (ex) {
        this.hasheaders = false;
        this.body = 0;  // Body at the start of the stream
      }
    }
    postData.prototype = {
      NONE: 0,
      FAST: 1,
      SLOW: 2,
      rewind: function() {
        this.seekablestream.seek(0,0);
      },
      tell: function() {
        return this.seekablestream.tell();
      },
      readLine: function() {
        var line = "";
        var size = this.stream.available();
        for (var i=0; i<size; i++) {
          var c = this.stream.read(1);
          if (c == '\r') {
          } else if (c == '\n') {
            break;
          } else {
            line += c;
          }
        }
        return line;
      },
      setMode: function(mode) {
        if (mode < this.NONE && mode > this.SLOW) {
          throw "postData: unsupported mode: " + this.mode;
        }
        this.mode = mode;
      },
      visitPostHeaders: function(visitor) {
        this.rewind();
        if (!this.hasheaders) { return; }
        var line = this.readLine();
        while(line) {
          if (visitor) {
            var tmp = line.split(/:\s?/);
            visitor.visitHeader(tmp[0],tmp[1]);
          }
          line = this.readLine();
        }
        body = this.tell();
      },
      getPostBody: function(max) {
        // Position the stream to the start of the body
        if (this.body < 0 || this.seekablestream.tell() != this.body) {
          this.visitPostHeaders(null);
        }

        var size = this.stream.available();
        if (max && max >= 0 && max<size) size = max;

        var postString = "";
        try {
          switch (this.mode) {
            case this.NONE:
              //Don't get any content
              break;
            case this.FAST:
              //Get the content in one shot
              postString = this.stream.read(size);
              break;
            case this.SLOW:
              //Must read octet by octet because of a bug in nsIMultiplexStream.cpp
              //This is to avoid 'NS_BASE_STREAM_CLOSED' exception that may occurs
              //See bug #188328.
              for (var i=0; i<size; i++) {
                var c=this.stream.read(1);
                c ? postString+=c : postString+='\0';
              }
              break;
          }
        } catch (ex) {
          //dump("Exception while getting POST CONTENT with mode "+this.mode+": "+ex+"\n");
          return ""+ex;
        } finally {
          // Need to close the stream after use
          this.seekablestream.close();
          this.stream.close();
        }
	return postString;
      }
    }
   
    // Get the postData stream from the Http Object 
    try {
      // Must change HttpChannel to UploadChannel to be able to access post data
      oHttp.QueryInterface(Components.interfaces.nsIUploadChannel);
      // Get the post data stream
      if (oHttp.uploadStream) {
        // Must change to SeekableStream to be able to rewind
        oHttp.uploadStream.QueryInterface(Components.interfaces.nsISeekableStream);
        // And return a postData object
        return new postData(oHttp.uploadStream);
      } 
    } catch (e) {
      //dump("POSTDATAEXCEPTION:"+e+"\n");
    }
  return null;
  },
  visitHeader : function (name, value)
  {
    this.headers[name] = value;
  },
  visitRequest : function ()
  {
    this.headers = new Array();
    var uri, note, ver;
    try {
      
      // Get the URL and get parts
      // Should I use  this.oHttp.URI.prePath and this.oHttp.URI.path to make
      // the URL ?  I still need to remove the '#' sign if present in 'path'
      var url = String(this.oHttp.URI.asciiSpec);

      // If an http proxy is used for this url, we need to keep the host part
      if (this.useHttpProxy(this.oHttp.URI)==true) {
        uri = url.match(/^(.*?\/\/[^\/]+\/[^#]*)/)[1];
        ver = this.getHttpRequestVersion(true);
      } else {
        uri = url.match(/^.*?\/\/[^\/]+(\/[^#]*)/)[1];
        ver = this.getHttpRequestVersion(false);
      }
    } catch (ex) {
      //dump("PPS: cas5: " + ex + "\n");
      uri = String(this.oHttp.URI.asciiSpec);
      note = "Unsure about the precedent REQUEST uri";
    }
    this.headers["REQUEST"] = this.oHttp.requestMethod + " " 
                            + uri + " HTTP/" + ver;
    if (note) this.headers["NOTE"] = note;
    this.oHttp.visitRequestHeaders(this);

    // There may be post data in the request
    var postData = this.getPostData(this.oHttp);
    if (postData) {
      postData.visitPostHeaders(this);
      this.visitHeader("POSTDATA",postData);
    } else {
      this.visitHeader("POSTDATA",null);
    }

    return this.headers;
  },
  visitResponse : function ()
  {
    this.headers = new Array();
    this.headers["RESPONSE"] = "HTTP/1.x " + this.oHttp.responseStatus 
                    + " " + this.oHttp.responseStatusText;
    //this.headers["loadGroup"] = this.oHttp.loadGroup
    //this.headers["owner"] = this.oHttp.owner
    //this.headers["notificationCallbacks"] = this.oHttp.notificationCallbacks
    //if (this.oHttp.loadGroup) this.headers["loadGroup.ncb"] = this.oHttp.loadGroup.notificationCallbacks
    this.oHttp.visitResponseHeaders(this);
    return this.headers;
  }
}
