const gMultiZillaPanel =
{
  _init: false,
  _timer: null,
  _previewImage: null,

  init: function()
  {
    this._previewImage = document.getElementById("prefPreview");
    this._previewImage.style.opacity = 0;
    this._timer = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
    this._timer.initWithCallback(this, 100, Components.interfaces.nsITimer.TYPE_REPEATING_SLACK);
  },

  notify: function()
  {
    var newOpacity = parseFloat(window.getComputedStyle(this._previewImage, "").opacity) + 0.15;

    if (newOpacity < 1.0)
      this._previewImage.style.opacity = newOpacity;
    else {
      this._timer.cancel();
      this._previewImage.style.opacity = 1.0;
    }
  },

  openPreferenceManager: function()
  {
    const pmPath = "chrome://multiviews/content/preference-manager/";
    var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
                                  .getService(Components.interfaces.nsIWindowMediator);
    var pmWindow = windowManager.getMostRecentWindow("multizilla:preferences");

    if (pmWindow)
      pmWindow.focus();
    else {
      var dialogOption = /Mac/.test(navigator.platform) ? "=no": "";
      var winFeatures = "chrome, toolbar, dialog" + dialogOption + ", all"

      // The Preference Manager should be modal on Windows!
      if (/Win/.test(navigator.platform))
        winFeatures += ", dependent, modal";

      var prefBranch = Components.classes["@mozilla.org/preferences-service;1"]
                                 .getService(Components.interfaces.nsIPrefService)
                                 .getBranch("multizilla.windows.");

      var platformExtras = new Object();
      platformExtras.isClassicStyle = prefBranch.getBoolPref("classic-style");
      platformExtras.isMac = /Mac/.test(navigator.platform) || 
                             prefBranch.getBoolPref("mac-style");
      platformExtras.isMac = /Linux/.test(navigator.platform) || 
                             prefBranch.getBoolPref("linux-style");

      window.openDialog(pmPath + "preferenceManager.xul", "", winFeatures, 
                        "", "", "", platformExtras);
    }
  },

  shutdown: function()
  {
    if (this._timer) {
      this._timer.cancel();
      this._timer = null;
    }
  }
};

if (!gMultiZillaPanel._init) {
  function _inner() {
    gMultiZillaPanel.init();
  }
  window.setTimeout(_inner, 20);
}