function spoofReferrer(url, referrer)
{
  var spoofURL = "http://ref.spoof.org/refspoof.cgi"; // default fake referrer
  var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                            .getService(Components.interfaces.nsIIOService);
  var spoofing = gMultiZilla.prefs.readInteger("multizilla.refspoof.spoofing", 1);

  switch (spoofing) {
    case 1: // send original referrer
      referrer = getDocumentReferrer(document);
      break;
    case 2: // send url as referrer
      spoofURL = url;
      try {
        referrer = spoofURL ? ioService.newURI(spoofURL, null, null) : null;
      } catch(ex) {
      }
      break;
    default: // send fake referrer
      try {
        /* spoofURL = pref.getComplexValue("multizilla.refspoof.spoofurl",
                                        Components.interfaces.nsIPrefLocalizedString).data; */
        spoofURL = gMultiZilla.prefs.readString("multizilla.refspoof.spoofurl", spoofURL);
      } catch (ex) {
        dump("\nError: " + ex);
      }
      referrer = ioService.newURI(spoofURL, null, null);
  }
  return(referrer);
}

function getDocumentReferrer(doc)
{
  if (!doc)
    return null;

  if (doc == document) // compatibility
    doc = getContentFrameDocument(document.commandDispatcher.focusedWindow);

  // return makeURI(doc.location.href, doc.characterSet);
  var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                            .getService(Components.interfaces.nsIIOService);
  
  try {
    return ioService.newURI(doc.location.href, doc.characterSet, null);
  } catch (ex) {
    return null;
  }
}

function mzIsBlockedXPInstall(aURL, aBrowser)
{
  var browser = (aBrowser == undefined) ? gBrowser.mCurrentBrowser : aBrowser;
  browser.lastBlockedXPInstallURL = null;
  /***
    * Prevent callers from loadURI to throw a JS error when they pass in a
    * typeof object instead of a typeof string (just like the GoogleBox did)
    * see also: http://bugzilla.mozdev.org/show_bug.cgi?id=10xxx
    */
  if (typeof(aURL) != 'string')
    aURL = String(aURL);
  var checkURL = aURL.replace(/\?(.*)/, ""); // remove crufty parameters!

  if (checkURL.indexOf(".xpi")) { //  || aURL.indexOf(".jar")) {
    // var isJarFile = (checkURL.substring(checkURL.length-4, checkURL.length) == ".jar");
    var isXPIFile = (checkURL.substring(checkURL.length-4, checkURL.length) == ".xpi");

    if (isXPIFile) { // || isJarFile) {
      if (!mzCheckXPInstallPermission(checkURL, browser)) {
        var observerService = Components.classes["@mozilla.org/observer-service;1"]
                                        .getService(Components.interfaces.nsIObserverService);
        observerService.notifyObservers(browser.docShell, "xpinstall-install-blocked", null);
        gBrowser.updateCurrentBrowser();
        return true;
      }
    }
  }
  return false;
}

function mzCheckXPInstallPermission(aURL, aBrowser)
{
  var browser = (aBrowser == undefined) ? gBrowser.mCurrentBrowser
                                        : aBrowser;
  var pm = Components.classes["@mozilla.org/permissionmanager;1"]
                     .getService(Components.interfaces.nsIPermissionManager);
  var nsIIOService = Components.classes["@mozilla.org/network/io-service;1"]
                               .getService(Components.interfaces.nsIIOService);
  var uri = nsIIOService.newURI(aURL, null, null);
  var permission = pm.testPermission(uri, "install");

  if (gMultiZilla.prefs.readBoolean(gMultiZilla._observer_XPInstall._XPInstallWhiteListPrefString, true)) {
    if (permission == pm.ALLOW_ACTION)
      return true;
  }
  else if (permission != pm.DENY_ACTION) {
    return true;
  }
  browser.lastBlockedXPInstallURL = aURL;
  return false;
}

/* function mzCheckForUnicodeHost(aBrowser, aURL, aForcedDisplayFlag)
{
  return false;
  if (gMultiZilla.prefs.readBoolean("network.enableIDN", false) == false)
    return false;
  else if (!aForcedDisplayFlag && gMultiZilla.prefs.readBoolean("multizilla.check.idn", true) == false)
    return;

  var nsIIOService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
  var uri;
  var scheme = "";

  try {
    uri = nsIIOService.newURI(aURL, null, null);
    scheme = uri.scheme;  
  } catch(ex) {
    // dump("\nerror getting scheme");
  }
  if (scheme && scheme.match(/^http/i) == null) {
    // dump("\nwrong scheme ["+scheme+"], bail out!");
    return false;
  }
  var start = (scheme == "") ? 0 : scheme.length + 3;
  var url = aURL.replace(/^\s*([-\w]*:\/+)?/, "");
  var end = url.indexOf("/");

  if (end < start)
    end = aURL.length;

  var host = aURL.substring(start, (start + end));
  var encodedURL = encodeURIComponent(host);
  var rawhost = encodedURL.replace(/\%3A/g, ":").replace(/\%2F/g, "/").replace(/\%2E/g, ".");
  // dump("\nhost: " + host + "\nrawhost: " + rawhost);

  if (rawhost != host)
    return mzDisplayIDNWarning(aBrowser, aURL, rawhost, host);
  return false;
}
*/

function mzDisplaySSLPrompt(aBrowser, aHostArray, aIsNewHostFlag, aIsIDNFlag, aCertificate)
{
  aBrowser = (aBrowser == undefined) ? gBrowser.mCurrentBrowser : aBrowser;

  var bundle = gMultiZilla.utility.getStringBundle();
  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                .getService(Components.interfaces.nsIPromptService);
  var titleID = aIsNewHostFlag ? "newSSLTitle" : "otherSSLTitle";
  var textID = aIsNewHostFlag ? "newSSLText" : "otherSSLText";
  var host = aHostArray[0];

  if (aIsIDNFlag) {
    textID += "IDN";
    titleID += "IDN";
    aHostArray = [host];
  }
  var dialogTitle = bundle.GetStringFromName(titleID);
  var notPartOfCertificate = bundle.GetStringFromName("notPartOfCertificate");
  aHostArray.push(aCertificate.commonName ? aCertificate.commonName
                                          : notPartOfCertificate);
  aHostArray.push(aCertificate.organization ? aCertificate.organization
                                            : notPartOfCertificate);
  aHostArray.push(aCertificate.issuerCommonName ? aCertificate.issuerCommonName
                                                : notPartOfCertificate);
  aHostArray.push(aCertificate.issuerOrganization ? aCertificate.issuerOrganization
                                                  : notPartOfCertificate);
  /* dump("\ncommonName: " + aCertificate.commonName);
  dump("\norganization: " + aCertificate.organization);
  dump("\nissuerCommonName: " + aCertificate.issuerCommonName);
  dump("\nissuerOrganization: " + aCertificate.issuerOrganization); */
  var dialogText = bundle.formatStringFromName(textID, aHostArray, aHostArray.length);
  var checkbox = {value:0};
  var checkboxText = null;
  // checkboxText = bundle.formatStringFromName(textID, aHostArray, aHostArray.length);
  var updateIDNHistory = false;
  var retValue = promptService.confirmEx(window, dialogTitle, dialogText, 
                                         (promptService.BUTTON_POS_0 * promptService.BUTTON_TITLE_YES) + 
                                         (promptService.BUTTON_POS_1 * promptService.BUTTON_TITLE_NO),
                                         null, null, null, checkboxText, checkbox);
  if (!retValue) {
    if (aIsNewHostFlag)
      updateIDNHistory = true;
  }
  if (updateIDNHistory) {
    mzIDNHistory(host, true, true);
  }
  aBrowser.lastSSLHost = host;
}

function mzDisplayIDNWarning(aBrowser, aURL, aRawhost, aHost)
{
  var isNewHost = mzIDNHistory(aRawhost, false, false);

  if (isNewHost == -1)
    return true;
  else if (isNewHost) {
    var aEvent = window.document.createEvent('Events');
    aEvent.initEvent("DOMWillOpenModalDialog", false, false);
    aBrowser = (aBrowser == undefined) ? gBrowser.mCurrentBrowser : aBrowser;
    aBrowser.contentDocument.defaultView.dispatchEvent(aEvent);

    var bundle = gMultiZilla.utility.getStringBundle();
    var confirmationTitle = bundle.GetStringFromName("mzWizard");
    var confirmationText = bundle.formatStringFromName("idnHost", [aRawhost, aHost], 2);
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                  .getService(Components.interfaces.nsIPromptService);
    var checkbox = {value:0};

    if (promptService.confirmEx(window, confirmationTitle, confirmationText, 
                                (promptService.BUTTON_POS_0 * promptService.BUTTON_TITLE_YES) + 
                                (promptService.BUTTON_POS_1 * promptService.BUTTON_TITLE_NO),
                                null, null, null, null, checkbox)) {

      var tab = gBrowser.getTabForBrowser(aBrowser);
      var firstPage = tab.getAttribute("firstPage");

      if (firstPage == aURL)
        tab.setAttribute("removeAfterLoad", "true");
      return true;
    }
    aEvent = window.document.createEvent('Events');
    aEvent.initEvent("DOMModalDialogClosed", false, false);
    aBrowser.contentDocument.defaultView.dispatchEvent(aEvent);
    mzIDNHistory(aRawhost, true, true);
  }
  return false;
}
var mzIDNStore = null;

function mzIDNHistory(aHost, aUpdateFlag, aSkipCheckFlag, aPurgeFlag)
{
  if (!mzIDNStore)
    mzIDNStore = mzGetNewOrCurrentDSByFilename("idn-history.rdf", false, null, false);

  var entries = mzRDFCUtils.MakeSeq(mzIDNStore, RDF.GetResource("urn:idn-hash-keys"));

  if (!entries)
    return -1;
  if (!entries.GetElements())
    return -1;

  var keys = entries.GetCount();

  if (aHost == null && aUpdateFlag == undefined && aSkipCheckFlag == undefined && aPurgeFlag == undefined)
    return keys;

  var index = 0;
  var newHost = true;
  var retValue = false;
  var sDecoderRing = Components.classes["@mozilla.org/security/sdr;1"]
                               .getService(Components.interfaces.nsISecretDecoderRing);

  if (!aHost && aPurgeFlag) { // do we need to purge IDN history?
    // dump("\nTrigger Master Password Prompt");
    var dummy = sDecoderRing.encryptString("abc"); // force master password prompt to be displayed!
    // dump("\nPurge IDN History ");
    index = keys;
    // dump(index + " entries to be removed");
    for (index; index > 0; index--) {
      entries.RemoveElementAt(index, true);
      // dump("\nremoving entry: " + index);
    }
    newHost = false;
  }
  else if (!aSkipCheckFlag) { // do we have to skip the check?
    dump("\nLookup: " + aHost);
    var idnHistory = entries.GetElements();

    while (idnHistory.hasMoreElements()) {
      var entry = idnHistory.getNext();
      // dump("\nindex: " + index);
      if (entry) {
        try {
          entry = entry.QueryInterface(Components.interfaces.nsIRDFLiteral);
          index++;
        } catch(ex) {
          continue;
        }
        var host = sDecoderRing.decryptString(entry.Value);
        dump("\nhost("+index+"): " + host);
        if (host == aHost) {
          if (aPurgeFlag) { // do we need to purge a specified host entry?
            entries.RemoveElementAt(index, true);
            // dump("\naPurge host from IDN history: " + aPurgeFlag);
          }
          newHost = false;
          break;
        }
      }
    }
  }
  if (newHost) { // is this a new host?
    // dump("\nnewHost: " + newHost);
    if (aUpdateFlag) { // do we need to add the new host?
      // dump("\naUpdateFlag: " + aUpdateFlag);
      var hash = sDecoderRing.encryptString(aHost);
      entries.InsertElementAt(RDF.GetLiteral(hash), 1, true);
    }
    retValue = true;
  }
  mzIDNStore.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
  return retValue;
}

function mzRemoveHostFromIDNHistory(aHost)
{
  if (!aHost)
    return
  mzIDNHistory(aHost, false, false, true);
}

function mzPurgeIDNHistory()
{
  mzIDNHistory("", false, false, true);
}

function mzAddHostToIDNHistory(aHost)
{
  if (!aHost)
    return
  mzIDNHistory(aHost, true, true, false);
}
