/* 
   - The contents of this file are subject to the Mozilla Public
   - License Version 1.1 (the "License"); you may not use this file
   - except in compliance with the License. You may obtain a copy of
   - the License at http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS
   - IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
   - implied. See the License for the specific language governing
   - rights and limitations under the License.
   -
   - The Original Code is this file as it was released on
   - September 24, 2002.
   -
   - The Initial Developer of the Original Code is HJ van Rantwijk.
   - Portions created by HJ van Rantwijk are Copyright (C) 2002-2008
   - HJ van Rantwijk.  All Rights Reserved.
   -
   - Contributor(s):
   -	Michael Vincent van Rantwijk <mv_van_rantwijk@yahoo.com>
   - 
*/

////////////////////////////////////////////////////////////////////////////////
// this extends mozilla's default Mail context menu
////////////////////////////////////////////////////////////////////////////////
var multiviewsContextMenu =
{
  initMailWindowSelectorMenu: function() 
  {
    var item = document.getElementById("MailWindowSelectorSeparator");
    var windowManagerDS = Components.classes['@mozilla.org/rdf/datasource;1?name=window-mediator']
                                    .getService(nsIWindowDataSource);
  
    while ((item = item.nextSibling)) {
      var win = windowManagerDS.getWindowForResource(item.getAttribute('id'));
  
      if (win) {
        if (win == window ||
            win.document.documentElement.getAttribute("windowtype") != "navigator:browser")
          item.setAttribute("hidden", "true");
      }
    }
  },

  initItems: function() 
  {
    var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
    var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
    var browserWindow = windowManagerInterface.getMostRecentWindow("navigator:browser");

    if (!browserWindow)
      gContextMenu.showItem("context-maillinkintab", false);
    else {
      gContextMenu.showItem("context-maillinkintab", gContextMenu.onSaveableLink || 
                            (gContextMenu.inDirList && gContextMenu.onLink));
      var menuItem = document.getElementById("context-maillinkintab");

      if (multiviewsContextMenu.openInNewTab())
        menuItem.setAttribute("label", multiviewsContextMenu.getTextFromBundle("openLinkInNewTab"));
      else
        menuItem.setAttribute("label", multiviewsContextMenu.getTextFromBundle("openLinkInTab"));
    }
  },

  openInNewTab: function() 
  {
    var pref = gContextMenu.getService('@mozilla.org/preferences-service;1', 'nsIPrefBranch');
    var inNewTab = false;
    try {
      inNewTab = pref.getBoolPref("multizilla.newtabfor.mailnews");
    } catch(ex) {
    }
    return inNewTab;
  },

  openMailLinkInTab: function(aID, aURL) 
  {
    if (aID == null)
      window.open(aURL);
    else 
      this.loadURLInSelectedWindowAsTab(aID, gContextMenu.linkURL(), multiviewsContextMenu.openInNewTab());
  },

  openMailLinkInFirstWindow: function() 
  {
    var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
    var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
    var browserWindow = windowManagerInterface.getMostRecentWindow("navigator:browser");
  
    if (!browserWindow)
      window.open(aURL)
    else { 
      var windowManagerDS = Components.classes['@mozilla.org/rdf/datasource;1?name=window-mediator']
                                      .getService(nsIWindowDataSource);
   
      for (i = 0; i < 500; i++) {
        var win = windowManagerDS.getWindowForResource("window-"+i);
  
        if (win) {
          if (win.document.documentElement.getAttribute("windowtype") == "navigator:browser") {
            if (multiviewsContextMenu.openInNewTab()) {
              var loadInBackground = pref.getBoolPref("browser.tabs.loadInBackground");
              win.gBrowser.addTab(aURL, null, null, !loadInBackground);
            }
            else
              win.loadURI(aURL);
            break;
          }
        }
      }
    }
  },

  loadURLInSelectedWindowAsTab: function(aID, aURL, aNewTab)
  {
    /* this function opens aURL (link) in the selected aID (window) and respects 
       the 'New Tab For Messenger' and 'Load In BackGround' pref settings */
    var item = document.getElementById("MailWindowSelectorSeparator");
    var windowManagerDS = Components.classes['@mozilla.org/rdf/datasource;1?name=window-mediator']
                                    .getService(nsIWindowDataSource);
  
    while ((item = item.nextSibling)) {
      var id = item.getAttribute('id');
  
      if (id == aID) {
        var win = windowManagerDS.getWindowForResource(id);
  
        if (aNewTab) {
          var loadInBackground = pref.getBoolPref("browser.tabs.loadInBackground");
          win.gBrowser.addTab(aURL, null, null, !loadInBackground);
        }
        else
          win.loadURI(aURL);
      }
    }
  },

  getTextFromBundle: function(aString)
  {
    var bundle = Components.classes["@mozilla.org/intl/stringbundle;1"]
                            .getService(Components.interfaces.nsIStringBundleService)
                            .createBundle("chrome://multiviews/locale/multizilla.properties");
    return bundle.GetStringFromName(aString) || "> Error <";
  },

  _addEventListener: function (aEvent) 
  {
    var contextMenuPopup = document.getElementById("messagePaneContext");

    if (contextMenuPopup)
      contextMenuPopup.addEventListener("popupshowing", multiviewsContextMenu.initItems, false);
  },

  _removeEventListener: function(aString)
  {
    var contextMenuPopup = document.getElementById("messagePaneContext");

    if (contextMenuPopup)
      contextMenuPopup.removeEventListener("popupshowing", multiviewsContextMenu.initItems, false);
  }
};

window.addEventListener("load", multiviewsContextMenu._addEventListener, false);
window.addEventListener("unload", multiviewsContextMenu._removeEventListener, false);
