/*
 * Decompiled with CFR 0.152.
 */
package org.mozdev.MacroTracker.toolkit;

import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.mozdev.MacroTracker.toolkit.event.EventManager;
import org.mozdev.MacroTracker.toolkit.event.iPropertyChangeEvent;

public class MPropertiesTable
extends JPanel {
    private ArrayList<String> mPropertyNames;
    private ArrayList<String> mCellData;
    private ArrayList<Boolean> mEditable = new ArrayList();
    private JTable mTable;
    public EventManager<iPropertyChangeEvent> propertyChangeListener;

    public MPropertiesTable(String[] initialProperties) {
        this.mCellData = new ArrayList();
        this.mPropertyNames = new ArrayList();
        for (int i = 0; i < initialProperties.length; ++i) {
            this.mEditable.add(new Boolean(true));
            this.mCellData.add("");
            this.mPropertyNames.add(initialProperties[i]);
        }
        this.initialize();
    }

    public MPropertiesTable(String[] initialProperties, boolean[] editable) {
        this.mCellData = new ArrayList();
        this.mPropertyNames = new ArrayList();
        for (int i = 0; i < initialProperties.length; ++i) {
            this.mEditable.add(new Boolean(editable[i]));
            this.mCellData.add("");
            this.mPropertyNames.add(initialProperties[i]);
        }
        this.initialize();
    }

    private void initialize() {
        this.mTable = new JTable(new PropertiesTableModel());
        this.propertyChangeListener = new EventManager("propertyChanged");
        this.setLayout(new GridLayout(1, 1));
        this.add(new JScrollPane(this.mTable));
    }

    public void setProperty(String property, String newValue) {
        int low = 0;
        int high = this.mPropertyNames.size() - 1;
        int location = -1;
        while (low <= high) {
            int mid = low + high >> 1;
            String midVal = this.mPropertyNames.get(mid);
            if (midVal.compareTo(property) == 0) {
                location = mid;
                break;
            }
            if (midVal.compareTo(property) < 0) {
                low = mid + 1;
                continue;
            }
            if (midVal.compareTo(property) <= 0) continue;
            high = mid - 1;
        }
        if (location == -1) {
            return;
        }
        this.mTable.setValueAt(newValue, location, 1);
    }

    private class PropertiesTableModel
    extends AbstractTableModel {
        private PropertiesTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return MPropertiesTable.this.mPropertyNames.size();
        }

        public String getColumnName(int col) {
            return "";
        }

        public Object getValueAt(int row, int col) {
            if (col != 0) {
                return MPropertiesTable.this.mCellData.get(row);
            }
            return MPropertiesTable.this.mPropertyNames.get(row);
        }

        public Class getColumnClass(int c) {
            return ((String)MPropertiesTable.this.mPropertyNames.get(0)).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col >= 1 && (Boolean)MPropertiesTable.this.mEditable.get(row) != false;
        }

        public void setValueAt(Object value, int row, int col) {
            MPropertiesTable.this.mCellData.set(row, (String)value);
            Iterator<iPropertyChangeEvent> i = MPropertiesTable.this.propertyChangeListener.iterator();
            while (i.hasNext()) {
                i.next().propertyChanged((String)MPropertiesTable.this.mPropertyNames.get(row), (String)value);
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

