/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace LocaleInpector
{

internal sealed class PlaceholderExpressionsTest : PhraseTest
{

private static Regex m_regexDigits = new Regex(@"#\d+");
private static Regex m_regex2 = new Regex(@"%[\w_\.]+%");
private static Regex m_regexVar = new Regex(@"\$\w+\$");

public override string Compare(Dictionary<string, string>.Enumerator originalEntry, string translated)
{
    string original = originalEntry.Current.Value;

    if (m_extension == "properties") {
        // has it %S style? ==> there is no placeholder
        if (CStyleFormatTest.IsCFormat(original)) {
            return null;
        }
    }

    string hexEntity = @"&\#[\d]+;";
    // replace entities before, avoiding &#039;
    original = Regex.Replace(original, hexEntity, " ");
    translated = Regex.Replace(translated, hexEntity, " ");

    // test #222
    if (MatchRegex(m_regexDigits, original, translated, new string[0]) == false) {
        m_stat.Errors++;
        return "test #1 failed";
    }

    // LOCALIZED: %zoom%% (Normal)
    // test %nonono%
    // avoid escaped "%": "%S%% or 80%%" ==> "70% or 80%"
    if (MatchRegex(m_regex2, original, translated, new string[0]) == false) {
        m_stat.Errors++;
        return "test %var% failed";
    }

    // test $ProductName$
    if (MatchRegex(m_regexVar, original, translated, new string[0]) == false) {
        m_stat.Errors++;
        return "test $Var$ failed";
    }

    return null;
}

}//class
}//ns

