#ifndef XLOGMASTER_H
#define XLOGMASTER_H

/* 
   Include file for Xlogmaster 
*/

/*{{{  Variables  */
// This flag is used for enabling / disabling the logs...
int display_logs;                  // Display of logs file (ENABLED/DISABLED)

Log **syslog;
int syslogs;                   // Amount of "Log" objects
int active;                     // currently active "Log" object
char* read_buffer;        // Pointer to I/O-buffer for file operations
long maxtext;               // Number of bytes to be cached
struct stat status;         // stat-buffer for files

// These are only used at startup & reconfiguration:
int *mode;                  // mode for opening the file / whatever it is
char **filename;          // where to find it
char **help;                 // helptext to display when holding mouse over button
char **buttontext;       // text of button itself
int *interval;              // interval to display things... only used for executing/catting stuff
char ***commandline;  // commandline parameters for executable
char ***filter;                // strings to filter for
char ***filter_exec;       // command to execute (if EXECUTE set, otherwise NULL)
int **filter_mode;          // and the mode to use
int fillups;                   // amount of logs to be created...

int request_active;      // which one should be activated...
int xpos,ypos;
int width, height;
int wordwrap;
int terse;                    // should there be a "are you sure" question for
// critical things ?
int lockmem;               // should I try to lock the Xlogmasters pages in memory ?
int small_icon;          // big or small icon to be displayed ?
int notice_follows_mouse; // should the notice window follow the mouse around ?
gint configuration_changed; // did the configuration change ?

/*}}}*/

/*{{{  GTK variables  */
/* GtkWidget is the storage type for widgets */
GtkWidget *window;            // Main window
static GtkWidget *box;                  // Main Box
static GtkWidget *buttonbox;       // Box for Buttons
GtkWidget *textwindow;    // Text window
GtkTooltips *tooltips;         // for the help messages
static GtkWidget *scrolled_window;
static GtkWidget *textscrollbar;

/* GTK-Widgets for dial boxes */
static GtkWidget *file_error_dialog; 
static GtkWidget *file_error_ok;
static GtkWidget *file_error_label;

/* GTK-Widgets for "really quit" dialog... */
static GtkWidget *really_quit_dialog; 
static GtkWidget *really_quit_ok;
static GtkWidget *really_quit_cancel;
static GtkWidget *really_quit_label;

/* GTK-Widgets for "about Xlogmaster" */
static GtkWidget *about_dialog;
GtkWidget *small_logo_xpm;

/* Standard style */
GtkStyle* stdstyle;

/* GDK variables: */
GdkColormap* cmap; // xlogmasters overall colormap
GdkColor alert;              // Alert color to start at
GdkColor base;              // Colors to fade to
GdkColor prelight;         // (prelight to fade to)
double c_alert[3] = {0,0,0};

/*}}}*/

/*{{{  commandline options  */
static struct option options[] =
{
  {"activate", 1, 0, 0},
  {"alertcolor", 1, 0, 0},
  {"audio", 1, 0, 0},
  {"audio-alert", 1, 0, 0},
  {"audio-notice", 1, 0, 0},
  {"audio-uniconify", 1, 0, 0},
  {"buffer", 1, 0, 0},
  {"config", 1 , 0, 0},
  {"fadeseconds", 1, 0, 0},
  {"fadesteps", 1, 0, 0},
  {"geometry", 1, 0, 0},
  {"gtkrc", 1, 0, 0},
  {"help", 0, 0, 0},
#if HAVE_MLOCKALL
  {"mlockall", 0, 0, 0},
#endif /* HAVE_MLOCKALL */
  {"notice-follows-mouse", 2, 0, 0},
  {"silent", 0, 0, 0},
  {"smallicon", 2, 0, 0},
  {"terse", 0, 0, 0},
  {"version", 0, 0, 0},
  {"wordwrap", 2, 0, 0},
  {0, 0, 0, 0}
};
/*}}}*/

/*{{{  GTK subroutines  */
gint delete_event(GtkWidget *, GdkEvent *, gpointer);
void quit (GtkWidget*, gpointer*);
void really_quit_button_pressed();
void color_init();
void create_textwidget();
void destroy_textwidget();
void create_buttons();
void button_pressed (GtkWidget*, gpointer*);
void request_about();
void about_ready(GtkWidget *, gpointer *);
/*}}}*/

/*{{{  Data management  */
void setup_logs();
void unsetup_logs();
void free_memory();
void disable();
void enable();
gint determine_filter_class(gint);
void sort_filters(Filter**);
/*}}}*/

/*{{{  Initial preparations  */
void usage();
void help_message();
void version_message();
static void eval_colorstring(char*);
long get_value(char*, int*);
void init(int, char**);

/*}}}*/

/*{{{  Text output subroutines  */
void output_text (GtkWidget*, char*, long);
int does_match(char*, char*, long, long);




/*}}}*/

/*{{{  Error procedures  */
void file_error(gchar*);
void fork_error();


/*}}}*/

/*{{{  About Xlogmaster  */
void create_about();
/*}}}*/

#endif /* XLOGMASTER_H */
