#! @AWK@ -f

#######################################################################
#
#   Gtk wrapper creation script (struct declarations)
#
########################################################################


#######################################################################
#
# Copyright 2001, 2003 Free Software Foundation, Inc.
# Written by Paolo Bonzini and Dragomir Milivojevic
#
# This file is part of the GNU Smalltalk class library.
#
# The GNU Smalltalk class library is free software; you can redistribute it
# and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1, or (at
# your option) any later version.
# 
# The GNU Smalltalk class library is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
# General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with the GNU Smalltalk class library; see the file COPYING.LESSER.
# If not, write to the Free Software Foundation, 59 Temple Place - Suite
# 330, Boston, MA 02111-1307, USA.  
#
########################################################################

BEGIN {
  print "\"Automatically generated, do not edit!\""
  type["void"] = "void"
  type["int"]	= "int"
  type["char"] = "string"
  type["double"] = "double"

  type["gint8"] = "byte"
  type["guint8"] = "ubyte"
  type["gint16"] = "short"
  type["guint16"] = "ushort"
  type["gint32"] = "int"
  type["guint32"] = "uint"

  type["gshort"] = "short"
  type["gushort"] = "ushort"
  type["glong"] = "long"
  type["gulong"] = "ulong"
  type["gint"] = "int"
  type["guint"] = "uint"
  type["gboolean"] = "int"
  type["gfloat"] = "float"
  type["gdouble"] = "double"

  classNames["GValue"] = ""
  classNames["GtkObject"] = ""
}

{
  gsub(/[_;]/, "", $0)
  is_typedef = ($1 == "typedef")
  is_struct = $(1+is_typedef) ~ /^(struct|union)$/
  if (is_typedef)
    {
      src = $(1+is_typedef+is_struct)
      dest = $(3+is_struct)

      is_vtable_decl = src ~ /(Class|Iface)$/
      is_g_name = src ~ /^(G|Pango|Atk)/
      is_pointer = dest ~ /\*/
    }
  else if (is_struct)
    name = $2
}

is_typedef && is_struct && is_g_name && src == dest {
  if (!is_vtable_decl)
    classNames[src] = ""
  next
}

is_typedef && is_g_name && !is_pointer {
  # Take into account typedefs from a struct named differently.
  # We emit all these at the end, because they're often forward
  # references.
  found_synonym(src, dest)
  next
}

is_struct && (name in classNames) {
  delete classNames[name]

  while ($0 !~ /{/)
    read_next_line()

  read_next_line()

  parent = ($1 ~ /^(G|Pango|Atk)/) && ($2 !~ /^\*/) && ($1 in emitted) ? $1 : "CObject" 
  parse_struct(parent, name)
}

END {
  for (i in classNames)
    emit_struct("CObject", i)
}

# strips garbage from string
function strip( var )
{
  gsub( /[()\\,;*]/, "", var )
  return var
}

function smalltalkize( res )
{
  first = substr (res, 1, 1)
  res = tolower( substr (res, 2) )

  while (i = index (res, "_")) {
    first = first substr(res, 1, i - 1) toupper( substr (res, i + 1, 1))
    res = substr (res, i + 2)
  }

  return first res
}

function read_next_line ()
{
  getline
  gsub (/\/\*[^*]*\*\//, "", $0)
  if ($1 == "/*") {
    while ($0 !~ /\*\//)
      getline
    getline
  }
}

# save and i are local variables
function emit_struct (parent, name, save, i)
{
  if (name ~ /^\*/)
    return

  emitted[name] = ""
  printf "%s subclass: #%s\n", parent, name
  print "\tinstanceVariableNames: ''"
  print "\tclassVariableNames: ''"
  print "\tpoolDictionaries: ''"
  print "\tcategory: 'Gtk'!\n"

  save = $0
  $0 = synonyms[name]
  delete synonyms[name]
  for (i = 1; i <= NF; i++)
    emit_struct(name, $i)
  $0 = save
}

function parse_struct (parent, name)
{
  emit_struct(parent, name)

  while ($1 != "};")
    read_next_line()
}


function found_synonym(src, dest)
{
  if (i in emitted)
    emit_struct(src, dest)
  else
    synonyms[src] = synonyms[src] " " dest
}
