/* set.c		-*- mode: c; buffer-read-only: t -*-

   Generated by q2c from ../../src/set.q on Sat Aug 25 19:50:48 2007.
   Do not modify!
 */
#line 1 "../../src/set.q"
/* PSPP - computes sample statistics.
   Copyright (C) 1997-9, 2000 Free Software Foundation, Inc.
   Written by Ben Pfaff <blp@gnu.org>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 3 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA. */

/*
   Categories of SET subcommands:

   data input: BLANKS, DECIMAL, FORMAT, EPOCH.
   
   program input: ENDCMD, NULLINE.
   
   interaction: CPROMPT, DPROMPT, ERRORBREAK, MXERRS, MXWARNS, PROMPT.
   
   program execution: MEXPAND, MITERATE, MNEST, MPRINT,
   MXLOOPS, SEED, UNDEFINED.

   data output: CCA...CCE, DECIMAL, FORMAT, RESULTS-p.

   output routing: ECHO, ERRORS, INCLUDE, MESSAGES, PRINTBACK, ERRORS,
   RESULTS-rw.

   output activation: LISTING (on/off), SCREEN, PRINTER.

   output driver options: HEADERS, MORE, PAGER, VIEWLENGTH, VIEWWIDTH,
   LISTING (filename).

   logging: LOG, JOURNAL.

   system files: COMP/COMPRESSION, SCOMP/SCOMPRESSION.

   security: SAFER.
*/

/*
   FIXME

   These subcommands remain to be implemented:
     ECHO, PRINTBACK, INCLUDE
     MORE, PAGER, VIEWLENGTH, VIEWWIDTH, HEADERS

   These subcommands are not complete:
     MESSAGES, ERRORS, RESULTS
     LISTING/DISK, LOG/JOURNAL
*/     
   
#include <config.h>
#include "settings.h"
#include "error.h"
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <time.h>
#include "alloc.h"
#include "command.h"
#include "lexer.h"
#include "error.h"
#include "magic.h"
#include "log.h"
#include "output.h"
#include "var.h"
#include "format.h"
#include "copyleft.h"

#include "signal.h"

#if HAVE_LIBTERMCAP
#if HAVE_TERMCAP_H
#include <termcap.h>
#else /* !HAVE_TERMCAP_H */
int tgetent (char *, const char *);
int tgetnum (const char *);
#endif /* !HAVE_TERMCAP_H */
#endif /* !HAVE_LIBTERMCAP */

#include "gettext.h"
#define _(msgid) gettext (msgid)

static int set_errors;
static int set_messages;
static int set_results;

static double set_blanks=SYSMIS;

static int set_epoch = -1;

static struct fmt_spec set_format={FMT_F,8,2};

static struct set_cust_currency set_cc[5];
  
static char *set_journal;
static int set_journaling;

static int set_listing=1;

#if !USE_INTERNAL_PAGER
static char *set_pager=0;
#endif /* !USE_INTERNAL_PAGER */

static gsl_rng *rng;

static int long_view=0;
int set_testing_mode=0;
static int set_viewlength;
static int set_viewwidth;

void aux_show_warranty(void);
void aux_show_copying(void);

static const char *route_to_string(int routing);
static void set_routing (int q, int *setting);

static int set_ccx (const char *cc_string, struct set_cust_currency * cc,
		    int cc_name);
static void set_rng (unsigned long);
static unsigned long random_seed (void);

#line 139 "set.c"
#line 205 "../../src/set.q"

#line 142 "set.c"
/* Settings for subcommand specifiers. */
enum
  {
    STC_ON = 1000,
    STC_OFF,
    STC_UPPER,
    STC_UPLOW,
    STC_DOT,
    STC_COMMA,
    STC_TERMINAL,
    STC_LISTING,
    STC_BOTH,
    STC_NONE,
    STC_NO,
    STC_YES,
    STC_BLANK,
    STC_AUTO,
    STC_STANDARD,
    STC_EXTENDED,
    STC_MANUAL,
    STC_WARN,
    STC_NOWARN
  };

#define MAXLISTS 10
/* SET structure. */
struct cmd_set
  {
    /* AUTOMENU subcommand. */
    int sbc_automenu;
    long automenu;
    
    /* BEEP subcommand. */
    int sbc_beep;
    long beep;
    
    /* BLANKS subcommand. */
    int sbc_blanks;
    
    /* BLOCK subcommand. */
    int sbc_block;
    char *s_block;
    
    /* BOXSTRING subcommand. */
    int sbc_boxstring;
    char *s_boxstring;
    
    /* CASE subcommand. */
    int sbc_case;
    long size;
    
    /* CCA subcommand. */
    int sbc_cca;
    char *s_cca;
    
    /* CCB subcommand. */
    int sbc_ccb;
    char *s_ccb;
    
    /* CCC subcommand. */
    int sbc_ccc;
    char *s_ccc;
    
    /* CCD subcommand. */
    int sbc_ccd;
    char *s_ccd;
    
    /* CCE subcommand. */
    int sbc_cce;
    char *s_cce;
    
    /* COLOR subcommand. */
    int sbc_color;
    
    /* COMPRESSION subcommand. */
    int sbc_compression;
    long compress;
    
    /* CPI subcommand. */
    int sbc_cpi;
    long n_cpi[MAXLISTS];
    
    /* CPROMPT subcommand. */
    int sbc_cprompt;
    char *s_cprompt;
    
    /* DECIMAL subcommand. */
    int sbc_decimal;
    long dec;
    
    /* DISK subcommand. */
    int sbc_disk;
    
    /* DPROMPT subcommand. */
    int sbc_dprompt;
    char *s_dprompt;
    
    /* ECHO subcommand. */
    int sbc_echo;
    long echo;
    
    /* EJECT subcommand. */
    int sbc_eject;
    long eject;
    
    /* ENDCMD subcommand. */
    int sbc_endcmd;
    char *s_endcmd;
    
    /* EPOCH subcommand. */
    int sbc_epoch;
    
    /* ERRORBREAK subcommand. */
    int sbc_errorbreak;
    long errbrk;
    
    /* ERRORS subcommand. */
    int sbc_errors;
    long errors;
    
    /* FORMAT subcommand. */
    int sbc_format;
    
    /* HEADERS subcommand. */
    int sbc_headers;
    long headers;
    
    /* HELPWINDOWS subcommand. */
    int sbc_helpwindows;
    long helpwin;
    
    /* HIGHRES subcommand. */
    int sbc_highres;
    long hires;
    
    /* HISTOGRAM subcommand. */
    int sbc_histogram;
    char *s_histogram;
    
    /* INCLUDE subcommand. */
    int sbc_include;
    long inc;
    
    /* JOURNAL subcommand. */
    int sbc_journal;
    
    /* LENGTH subcommand. */
    int sbc_length;
    
    /* LISTING subcommand. */
    int sbc_listing;
    
    /* LOG subcommand. */
    int sbc_log;
    
    /* LOWRES subcommand. */
    int sbc_lowres;
    long lores;
    
    /* LPI subcommand. */
    int sbc_lpi;
    long n_lpi[MAXLISTS];
    
    /* MENUS subcommand. */
    int sbc_menus;
    long menus;
    
    /* MESSAGES subcommand. */
    int sbc_messages;
    long messages;
    
    /* MEXPAND subcommand. */
    int sbc_mexpand;
    long mexp;
    
    /* MITERATE subcommand. */
    int sbc_miterate;
    long n_miterate[MAXLISTS];
    
    /* MNEST subcommand. */
    int sbc_mnest;
    long n_mnest[MAXLISTS];
    
    /* MORE subcommand. */
    int sbc_more;
    long more;
    
    /* MPRINT subcommand. */
    int sbc_mprint;
    long mprint;
    
    /* MXERRS subcommand. */
    int sbc_mxerrs;
    long n_mxerrs[MAXLISTS];
    
    /* MXLOOPS subcommand. */
    int sbc_mxloops;
    long n_mxloops[MAXLISTS];
    
    /* MXMEMORY subcommand. */
    int sbc_mxmemory;
    long n_mxmemory[MAXLISTS];
    
    /* MXWARNS subcommand. */
    int sbc_mxwarns;
    long n_mxwarns[MAXLISTS];
    
    /* NULLINE subcommand. */
    int sbc_nulline;
    long null;
    
    /* PAGER subcommand. */
    int sbc_pager;
    
    /* PRINTBACK subcommand. */
    int sbc_printback;
    long prtbck;
    
    /* PRINTER subcommand. */
    int sbc_printer;
    long prtr;
    
    /* PROMPT subcommand. */
    int sbc_prompt;
    char *s_prompt;
    
    /* PTRANSLATE subcommand. */
    int sbc_ptranslate;
    long ptrans;
    
    /* RCOLOR subcommand. */
    int sbc_rcolor;
    
    /* RESULTS subcommand. */
    int sbc_results;
    
    /* RUNREVIEW subcommand. */
    int sbc_runreview;
    long runrev;
    
    /* SAFER subcommand. */
    int sbc_safer;
    long safe;
    
    /* SCOMPRESSION subcommand. */
    int sbc_scompression;
    long scompress;
    
    /* SCREEN subcommand. */
    int sbc_screen;
    long scrn;
    
    /* SCRIPTTAB subcommand. */
    int sbc_scripttab;
    char *s_scripttab;
    
    /* SEED subcommand. */
    int sbc_seed;
    
    /* TB1 subcommand. */
    int sbc_tb1;
    char *s_tb1;
    
    /* TBFONTS subcommand. */
    int sbc_tbfonts;
    char *s_tbfonts;
    
    /* UNDEFINED subcommand. */
    int sbc_undefined;
    long undef;
    
    /* VIEWLENGTH subcommand. */
    int sbc_viewlength;
    
    /* VIEWWIDTH subcommand. */
    int sbc_viewwidth;
    
    /* WIDTH subcommand. */
    int sbc_width;
    
    /* WORKDEV subcommand. */
    int sbc_workdev;
    
    /* WORKSPACE subcommand. */
    int sbc_workspace;
    long n_workspace[MAXLISTS];
    
    /* XSORT subcommand. */
    int sbc_xsort;
    long xsort;
  };

/* Prototype for custom subcommands of SET. */
static int stc_custom_blanks (struct cmd_set *);
static int stc_custom_color (struct cmd_set *);
static int stc_custom_disk (struct cmd_set *);
static int stc_custom_epoch (struct cmd_set *);
static int stc_custom_format (struct cmd_set *);
static int stc_custom_journal (struct cmd_set *);
static int stc_custom_length (struct cmd_set *);
static int stc_custom_listing (struct cmd_set *);
static int stc_custom_log (struct cmd_set *);
static int stc_custom_pager (struct cmd_set *);
static int stc_custom_rcolor (struct cmd_set *);
static int stc_custom_results (struct cmd_set *);
static int stc_custom_seed (struct cmd_set *);
static int stc_custom_viewlength (struct cmd_set *);
static int stc_custom_viewwidth (struct cmd_set *);
static int stc_custom_width (struct cmd_set *);
static int stc_custom_workdev (struct cmd_set *);

/* Command parsing functions. */
static int parse_set (struct cmd_set *);
static void free_set (struct cmd_set *);

#line 207 "../../src/set.q"

#line 460 "set.c"
static int
parse_set (struct cmd_set *p)
{
  p->sbc_automenu = 0;
  p->sbc_beep = 0;
  p->sbc_blanks = 0;
  p->sbc_block = 0;
  p->sbc_boxstring = 0;
  p->sbc_case = 0;
  p->sbc_cca = 0;
  p->sbc_ccb = 0;
  p->sbc_ccc = 0;
  p->sbc_ccd = 0;
  p->sbc_cce = 0;
  p->sbc_color = 0;
  p->sbc_compression = 0;
  p->sbc_cpi = 0;
  p->sbc_cprompt = 0;
  p->sbc_decimal = 0;
  p->sbc_disk = 0;
  p->sbc_dprompt = 0;
  p->sbc_echo = 0;
  p->sbc_eject = 0;
  p->sbc_endcmd = 0;
  p->sbc_epoch = 0;
  p->sbc_errorbreak = 0;
  p->sbc_errors = 0;
  p->sbc_format = 0;
  p->sbc_headers = 0;
  p->sbc_helpwindows = 0;
  p->sbc_highres = 0;
  p->sbc_histogram = 0;
  p->sbc_include = 0;
  p->sbc_journal = 0;
  p->sbc_length = 0;
  p->sbc_listing = 0;
  p->sbc_log = 0;
  p->sbc_lowres = 0;
  p->sbc_lpi = 0;
  p->sbc_menus = 0;
  p->sbc_messages = 0;
  p->sbc_mexpand = 0;
  p->sbc_miterate = 0;
  p->sbc_mnest = 0;
  p->sbc_more = 0;
  p->sbc_mprint = 0;
  p->sbc_mxerrs = 0;
  p->sbc_mxloops = 0;
  p->sbc_mxmemory = 0;
  p->sbc_mxwarns = 0;
  p->sbc_nulline = 0;
  p->sbc_pager = 0;
  p->sbc_printback = 0;
  p->sbc_printer = 0;
  p->sbc_prompt = 0;
  p->sbc_ptranslate = 0;
  p->sbc_rcolor = 0;
  p->sbc_results = 0;
  p->sbc_runreview = 0;
  p->sbc_safer = 0;
  p->sbc_scompression = 0;
  p->sbc_screen = 0;
  p->sbc_scripttab = 0;
  p->sbc_seed = 0;
  p->sbc_tb1 = 0;
  p->sbc_tbfonts = 0;
  p->sbc_undefined = 0;
  p->sbc_viewlength = 0;
  p->sbc_viewwidth = 0;
  p->sbc_width = 0;
  p->sbc_workdev = 0;
  p->sbc_workspace = 0;
  p->sbc_xsort = 0;
  for (;;)
    {
      if (lex_match_id ("AUTOMENU"))
        {
          lex_match ('=');
          p->sbc_automenu++;
          while (token != '/' && token != '.')
            {
              if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                p->automenu = STC_ON;
              else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                p->automenu = STC_OFF;
              else
                {
                  lex_error (NULL);
                  goto lossage;
                }
              lex_match (',');
            }
        }
      else if (lex_match_id ("BEEP"))
        {
          lex_match ('=');
          p->sbc_beep++;
          while (token != '/' && token != '.')
            {
              if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                p->beep = STC_ON;
              else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                p->beep = STC_OFF;
              else
                {
                  lex_error (NULL);
                  goto lossage;
                }
              lex_match (',');
            }
        }
      else if (lex_match_id ("BLANKS"))
        {
          lex_match ('=');
          p->sbc_blanks++;
          switch (stc_custom_blanks (p))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (NULL);
              goto lossage;
            default:
              assert (0);
            }
        }
      else if (lex_match_id ("BLOCK"))
        {
          lex_match ('=');
          p->sbc_block++;
          {
            int x;
            if (!lex_force_string ())
              return 0;
            x = ds_length (&tokstr);
            if (!(x==1))
              {
                msg (SE, _("String for BLOCK must be one character long."));
                goto lossage;
              }
            free(p->s_block);
            p->s_block = xstrdup (ds_c_str (&tokstr));
            lex_get ();
          }
        }
      else if (lex_match_id ("BOXSTRING"))
        {
          lex_match ('=');
          p->sbc_boxstring++;
          {
            int x;
            if (!lex_force_string ())
              return 0;
            x = ds_length (&tokstr);
            if (!(x==3 || x==11))
              {
                msg (SE, _("String for BOXSTRING must be 3 or 11 characters long."));
                goto lossage;
              }
            free(p->s_boxstring);
            p->s_boxstring = xstrdup (ds_c_str (&tokstr));
            lex_get ();
          }
        }
      else if (lex_match_id ("CASE"))
        {
          lex_match ('=');
          p->sbc_case++;
          while (token != '/' && token != '.')
            {
              if (lex_match_id ("UPPER"))
                p->size = STC_UPPER;
              else if (lex_match_id ("UPLOW"))
                p->size = STC_UPLOW;
              else
                {
                  lex_error (NULL);
                  goto lossage;
                }
              lex_match (',');
            }
        }
      else if (lex_match_id ("CCA"))
        {
          lex_match ('=');
          p->sbc_cca++;
          if (!lex_force_string ())
            return 0;
          free(p->s_cca);
          p->s_cca = xstrdup (ds_c_str (&tokstr));
          lex_get ();
        }
      else if (lex_match_id ("CCB"))
        {
          lex_match ('=');
          p->sbc_ccb++;
          if (!lex_force_string ())
            return 0;
          free(p->s_ccb);
          p->s_ccb = xstrdup (ds_c_str (&tokstr));
          lex_get ();
        }
      else if (lex_match_id ("CCC"))
        {
          lex_match ('=');
          p->sbc_ccc++;
          if (!lex_force_string ())
            return 0;
          free(p->s_ccc);
          p->s_ccc = xstrdup (ds_c_str (&tokstr));
          lex_get ();
        }
      else if (lex_match_id ("CCD"))
        {
          lex_match ('=');
          p->sbc_ccd++;
          if (!lex_force_string ())
            return 0;
          free(p->s_ccd);
          p->s_ccd = xstrdup (ds_c_str (&tokstr));
          lex_get ();
        }
      else if (lex_match_id ("CCE"))
        {
          lex_match ('=');
          p->sbc_cce++;
          if (!lex_force_string ())
            return 0;
          free(p->s_cce);
          p->s_cce = xstrdup (ds_c_str (&tokstr));
          lex_get ();
        }
      else if (lex_match_id ("COLOR"))
        {
          lex_match ('=');
          p->sbc_color++;
          switch (stc_custom_color (p))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (NULL);
              goto lossage;
            default:
              assert (0);
            }
        }
      else if (lex_match_id ("COMPRESSION"))
        {
          lex_match ('=');
          p->sbc_compression++;
          while (token != '/' && token != '.')
            {
              if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                p->compress = STC_ON;
              else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                p->compress = STC_OFF;
              else
                {
                  lex_error (NULL);
                  goto lossage;
                }
              lex_match (',');
            }
        }
      else if (lex_match_id ("CPI"))
        {
          lex_match ('=');
          p->sbc_cpi++;
          {
            int x;
            if (!lex_force_int ())
              goto lossage;
            x = lex_integer ();
            lex_get();
            if (!(x>0))
              {
                msg (SE, "CPI must be greater than 0");
                goto lossage;
              }
              p->n_cpi[p->sbc_cpi - 1] = x;
            }
          }
        else if (lex_match_id ("CPROMPT"))
          {
            lex_match ('=');
            p->sbc_cprompt++;
            if (!lex_force_string ())
              return 0;
            free(p->s_cprompt);
            p->s_cprompt = xstrdup (ds_c_str (&tokstr));
            lex_get ();
          }
        else if (lex_match_id ("DECIMAL"))
          {
            lex_match ('=');
            p->sbc_decimal++;
            while (token != '/' && token != '.')
              {
                if (lex_match_id ("DOT"))
                  p->dec = STC_DOT;
                else if (lex_match_id ("COMMA"))
                  p->dec = STC_COMMA;
                else
                  {
                    lex_error (NULL);
                    goto lossage;
                  }
                lex_match (',');
              }
          }
        else if (lex_match_id ("DISK"))
          {
            lex_match ('=');
            p->sbc_disk++;
            switch (stc_custom_disk (p))
              {
              case 0:
                goto lossage;
              case 1:
                break;
              case 2:
                lex_error (NULL);
                goto lossage;
              default:
                assert (0);
              }
          }
        else if (lex_match_id ("DPROMPT"))
          {
            lex_match ('=');
            p->sbc_dprompt++;
            if (!lex_force_string ())
              return 0;
            free(p->s_dprompt);
            p->s_dprompt = xstrdup (ds_c_str (&tokstr));
            lex_get ();
          }
        else if (lex_match_id ("ECHO"))
          {
            lex_match ('=');
            p->sbc_echo++;
            while (token != '/' && token != '.')
              {
                if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                  p->echo = STC_ON;
                else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                  p->echo = STC_OFF;
                else
                  {
                    lex_error (NULL);
                    goto lossage;
                  }
                lex_match (',');
              }
          }
        else if (lex_match_id ("EJECT"))
          {
            lex_match ('=');
            p->sbc_eject++;
            while (token != '/' && token != '.')
              {
                if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                  p->eject = STC_ON;
                else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                  p->eject = STC_OFF;
                else
                  {
                    lex_error (NULL);
                    goto lossage;
                  }
                lex_match (',');
              }
          }
        else if (lex_match_id ("ENDCMD"))
          {
            lex_match ('=');
            p->sbc_endcmd++;
            {
              int x;
              if (!lex_force_string ())
                return 0;
              x = ds_length (&tokstr);
              if (!(x==1))
                {
                  msg (SE, _("String for ENDCMD must be one character long."));
                  goto lossage;
                }
              free(p->s_endcmd);
              p->s_endcmd = xstrdup (ds_c_str (&tokstr));
              lex_get ();
            }
          }
        else if (lex_match_id ("EPOCH"))
          {
            lex_match ('=');
            p->sbc_epoch++;
            switch (stc_custom_epoch (p))
              {
              case 0:
                goto lossage;
              case 1:
                break;
              case 2:
                lex_error (NULL);
                goto lossage;
              default:
                assert (0);
              }
          }
        else if (lex_match_id ("ERRORBREAK"))
          {
            lex_match ('=');
            p->sbc_errorbreak++;
            while (token != '/' && token != '.')
              {
                if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                  p->errbrk = STC_ON;
                else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                  p->errbrk = STC_OFF;
                else
                  {
                    lex_error (NULL);
                    goto lossage;
                  }
                lex_match (',');
              }
          }
        else if (lex_match_id ("ERRORS"))
          {
            lex_match ('=');
            p->sbc_errors++;
            while (token != '/' && token != '.')
              {
                if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                  p->errors = STC_ON;
                else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                  p->errors = STC_OFF;
                else if (lex_match_id ("TERMINAL"))
                  p->errors = STC_TERMINAL;
                else if (lex_match_id ("LISTING"))
                  p->errors = STC_LISTING;
                else if (lex_match_id ("BOTH"))
                  p->errors = STC_BOTH;
                else if (lex_match_id ("NONE"))
                  p->errors = STC_NONE;
                else
                  {
                    lex_error (NULL);
                    goto lossage;
                  }
                lex_match (',');
              }
          }
        else if (lex_match_id ("FORMAT"))
          {
            lex_match ('=');
            p->sbc_format++;
            switch (stc_custom_format (p))
              {
              case 0:
                goto lossage;
              case 1:
                break;
              case 2:
                lex_error (NULL);
                goto lossage;
              default:
                assert (0);
              }
          }
        else if (lex_match_id ("HEADERS"))
          {
            lex_match ('=');
            p->sbc_headers++;
            while (token != '/' && token != '.')
              {
                if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                  p->headers = STC_NO;
                else if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                  p->headers = STC_YES;
                else if (lex_match_id ("BLANK"))
                  p->headers = STC_BLANK;
                else
                  {
                    lex_error (NULL);
                    goto lossage;
                  }
                lex_match (',');
              }
          }
        else if (lex_match_id ("HELPWINDOWS"))
          {
            lex_match ('=');
            p->sbc_helpwindows++;
            while (token != '/' && token != '.')
              {
                if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                  p->helpwin = STC_ON;
                else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                  p->helpwin = STC_OFF;
                else
                  {
                    lex_error (NULL);
                    goto lossage;
                  }
                lex_match (',');
              }
          }
        else if (lex_match_id ("HIGHRES"))
          {
            lex_match ('=');
            p->sbc_highres++;
            while (token != '/' && token != '.')
              {
                if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                  p->hires = STC_ON;
                else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                  p->hires = STC_OFF;
                else
                  {
                    lex_error (NULL);
                    goto lossage;
                  }
                lex_match (',');
              }
          }
        else if (lex_match_id ("HISTOGRAM"))
          {
            lex_match ('=');
            p->sbc_histogram++;
            {
              int x;
              if (!lex_force_string ())
                return 0;
              x = ds_length (&tokstr);
              if (!(x==1))
                {
                  msg (SE, _("String for HISTOGRAM must be one character long."));
                  goto lossage;
                }
              free(p->s_histogram);
              p->s_histogram = xstrdup (ds_c_str (&tokstr));
              lex_get ();
            }
          }
        else if (lex_match_id ("INCLUDE"))
          {
            lex_match ('=');
            p->sbc_include++;
            while (token != '/' && token != '.')
              {
                if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                  p->inc = STC_ON;
                else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                  p->inc = STC_OFF;
                else
                  {
                    lex_error (NULL);
                    goto lossage;
                  }
                lex_match (',');
              }
          }
        else if (lex_match_id ("JOURNAL"))
          {
            lex_match ('=');
            p->sbc_journal++;
            switch (stc_custom_journal (p))
              {
              case 0:
                goto lossage;
              case 1:
                break;
              case 2:
                lex_error (NULL);
                goto lossage;
              default:
                assert (0);
              }
          }
        else if (lex_match_id ("LENGTH"))
          {
            lex_match ('=');
            p->sbc_length++;
            switch (stc_custom_length (p))
              {
              case 0:
                goto lossage;
              case 1:
                break;
              case 2:
                lex_error (NULL);
                goto lossage;
              default:
                assert (0);
              }
          }
        else if (lex_match_id ("LISTING"))
          {
            lex_match ('=');
            p->sbc_listing++;
            switch (stc_custom_listing (p))
              {
              case 0:
                goto lossage;
              case 1:
                break;
              case 2:
                lex_error (NULL);
                goto lossage;
              default:
                assert (0);
              }
          }
        else if (lex_match_id ("LOG"))
          {
            lex_match ('=');
            p->sbc_log++;
            switch (stc_custom_log (p))
              {
              case 0:
                goto lossage;
              case 1:
                break;
              case 2:
                lex_error (NULL);
                goto lossage;
              default:
                assert (0);
              }
          }
        else if (lex_match_id ("LOWRES"))
          {
            lex_match ('=');
            p->sbc_lowres++;
            while (token != '/' && token != '.')
              {
                if (lex_match_id ("AUTO"))
                  p->lores = STC_AUTO;
                else if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                  p->lores = STC_ON;
                else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                  p->lores = STC_OFF;
                else
                  {
                    lex_error (NULL);
                    goto lossage;
                  }
                lex_match (',');
              }
          }
        else if (lex_match_id ("LPI"))
          {
            lex_match ('=');
            p->sbc_lpi++;
            {
              int x;
              if (!lex_force_int ())
                goto lossage;
              x = lex_integer ();
              lex_get();
              if (!(x>0))
                {
                  msg (SE, "LPI must be greater than 0");
                  goto lossage;
                }
                p->n_lpi[p->sbc_lpi - 1] = x;
              }
            }
          else if (lex_match_id ("MENUS"))
            {
              lex_match ('=');
              p->sbc_menus++;
              while (token != '/' && token != '.')
                {
                  if (lex_match_id ("STANDARD"))
                    p->menus = STC_STANDARD;
                  else if (lex_match_id ("EXTENDED"))
                    p->menus = STC_EXTENDED;
                  else
                    {
                      lex_error (NULL);
                      goto lossage;
                    }
                  lex_match (',');
                }
            }
          else if (lex_match_id ("MESSAGES"))
            {
              lex_match ('=');
              p->sbc_messages++;
              while (token != '/' && token != '.')
                {
                  if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                    p->messages = STC_ON;
                  else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                    p->messages = STC_OFF;
                  else if (lex_match_id ("TERMINAL"))
                    p->messages = STC_TERMINAL;
                  else if (lex_match_id ("LISTING"))
                    p->messages = STC_LISTING;
                  else if (lex_match_id ("BOTH"))
                    p->messages = STC_BOTH;
                  else if (lex_match_id ("NONE"))
                    p->messages = STC_NONE;
                  else
                    {
                      lex_error (NULL);
                      goto lossage;
                    }
                  lex_match (',');
                }
            }
          else if (lex_match_id ("MEXPAND"))
            {
              lex_match ('=');
              p->sbc_mexpand++;
              while (token != '/' && token != '.')
                {
                  if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                    p->mexp = STC_ON;
                  else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                    p->mexp = STC_OFF;
                  else
                    {
                      lex_error (NULL);
                      goto lossage;
                    }
                  lex_match (',');
                }
            }
          else if (lex_match_id ("MITERATE"))
            {
              lex_match ('=');
              p->sbc_miterate++;
              {
                int x;
                if (!lex_force_int ())
                  goto lossage;
                x = lex_integer ();
                lex_get();
                if (!(x>0))
                  {
                    msg (SE, "MITERATE must be greater than 0");
                    goto lossage;
                  }
                  p->n_miterate[p->sbc_miterate - 1] = x;
                }
              }
            else if (lex_match_id ("MNEST"))
              {
                lex_match ('=');
                p->sbc_mnest++;
                {
                  int x;
                  if (!lex_force_int ())
                    goto lossage;
                  x = lex_integer ();
                  lex_get();
                  if (!(x>0))
                    {
                      msg (SE, "MNEST must be greater than 0");
                      goto lossage;
                    }
                    p->n_mnest[p->sbc_mnest - 1] = x;
                  }
                }
              else if (lex_match_id ("MORE"))
                {
                  lex_match ('=');
                  p->sbc_more++;
                  while (token != '/' && token != '.')
                    {
                      if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                        p->more = STC_ON;
                      else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                        p->more = STC_OFF;
                      else
                        {
                          lex_error (NULL);
                          goto lossage;
                        }
                      lex_match (',');
                    }
                }
              else if (lex_match_id ("MPRINT"))
                {
                  lex_match ('=');
                  p->sbc_mprint++;
                  while (token != '/' && token != '.')
                    {
                      if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                        p->mprint = STC_ON;
                      else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                        p->mprint = STC_OFF;
                      else
                        {
                          lex_error (NULL);
                          goto lossage;
                        }
                      lex_match (',');
                    }
                }
              else if (lex_match_id ("MXERRS"))
                {
                  lex_match ('=');
                  p->sbc_mxerrs++;
                  {
                    int x;
                    if (!lex_force_int ())
                      goto lossage;
                    x = lex_integer ();
                    lex_get();
                    if (!(x >= 1))
                      {
                        msg (SE, "MXERRS must be at least 1");
                        goto lossage;
                      }
                      p->n_mxerrs[p->sbc_mxerrs - 1] = x;
                    }
                  }
                else if (lex_match_id ("MXLOOPS"))
                  {
                    lex_match ('=');
                    p->sbc_mxloops++;
                    {
                      int x;
                      if (!lex_force_int ())
                        goto lossage;
                      x = lex_integer ();
                      lex_get();
                      if (!(x >=1))
                        {
                          msg (SE, "MXLOOPS must be at least 1");
                          goto lossage;
                        }
                        p->n_mxloops[p->sbc_mxloops - 1] = x;
                      }
                    }
                  else if (lex_match_id ("MXMEMORY"))
                    {
                      lex_match ('=');
                      p->sbc_mxmemory++;
                      {
                        int x;
                        if (!lex_force_int ())
                          goto lossage;
                        x = lex_integer ();
                        lex_get();
                        p->n_mxmemory[p->sbc_mxmemory - 1] = x;
                      }
                    }
                  else if (lex_match_id ("MXWARNS"))
                    {
                      lex_match ('=');
                      p->sbc_mxwarns++;
                      {
                        int x;
                        if (!lex_force_int ())
                          goto lossage;
                        x = lex_integer ();
                        lex_get();
                        p->n_mxwarns[p->sbc_mxwarns - 1] = x;
                      }
                    }
                  else if (lex_match_id ("NULLINE"))
                    {
                      lex_match ('=');
                      p->sbc_nulline++;
                      while (token != '/' && token != '.')
                        {
                          if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                            p->null = STC_ON;
                          else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                            p->null = STC_OFF;
                          else
                            {
                              lex_error (NULL);
                              goto lossage;
                            }
                          lex_match (',');
                        }
                    }
                  else if (lex_match_id ("PAGER"))
                    {
                      lex_match ('=');
                      p->sbc_pager++;
                      switch (stc_custom_pager (p))
                        {
                        case 0:
                          goto lossage;
                        case 1:
                          break;
                        case 2:
                          lex_error (NULL);
                          goto lossage;
                        default:
                          assert (0);
                        }
                    }
                  else if (lex_match_id ("PRINTBACK"))
                    {
                      lex_match ('=');
                      p->sbc_printback++;
                      while (token != '/' && token != '.')
                        {
                          if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                            p->prtbck = STC_ON;
                          else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                            p->prtbck = STC_OFF;
                          else
                            {
                              lex_error (NULL);
                              goto lossage;
                            }
                          lex_match (',');
                        }
                    }
                  else if (lex_match_id ("PRINTER"))
                    {
                      lex_match ('=');
                      p->sbc_printer++;
                      while (token != '/' && token != '.')
                        {
                          if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                            p->prtr = STC_ON;
                          else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                            p->prtr = STC_OFF;
                          else
                            {
                              lex_error (NULL);
                              goto lossage;
                            }
                          lex_match (',');
                        }
                    }
                  else if (lex_match_id ("PROMPT"))
                    {
                      lex_match ('=');
                      p->sbc_prompt++;
                      if (!lex_force_string ())
                        return 0;
                      free(p->s_prompt);
                      p->s_prompt = xstrdup (ds_c_str (&tokstr));
                      lex_get ();
                    }
                  else if (lex_match_id ("PTRANSLATE"))
                    {
                      lex_match ('=');
                      p->sbc_ptranslate++;
                      while (token != '/' && token != '.')
                        {
                          if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                            p->ptrans = STC_ON;
                          else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                            p->ptrans = STC_OFF;
                          else
                            {
                              lex_error (NULL);
                              goto lossage;
                            }
                          lex_match (',');
                        }
                    }
                  else if (lex_match_id ("RCOLOR"))
                    {
                      lex_match ('=');
                      p->sbc_rcolor++;
                      switch (stc_custom_rcolor (p))
                        {
                        case 0:
                          goto lossage;
                        case 1:
                          break;
                        case 2:
                          lex_error (NULL);
                          goto lossage;
                        default:
                          assert (0);
                        }
                    }
                  else if (lex_match_id ("RESULTS"))
                    {
                      lex_match ('=');
                      p->sbc_results++;
                      switch (stc_custom_results (p))
                        {
                        case 0:
                          goto lossage;
                        case 1:
                          break;
                        case 2:
                          lex_error (NULL);
                          goto lossage;
                        default:
                          assert (0);
                        }
                    }
                  else if (lex_match_id ("RUNREVIEW"))
                    {
                      lex_match ('=');
                      p->sbc_runreview++;
                      while (token != '/' && token != '.')
                        {
                          if (lex_match_id ("AUTO"))
                            p->runrev = STC_AUTO;
                          else if (lex_match_id ("MANUAL"))
                            p->runrev = STC_MANUAL;
                          else
                            {
                              lex_error (NULL);
                              goto lossage;
                            }
                          lex_match (',');
                        }
                    }
                  else if (lex_match_id ("SAFER"))
                    {
                      lex_match ('=');
                      p->sbc_safer++;
                      while (token != '/' && token != '.')
                        {
                          if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                            p->safe = STC_ON;
                          else
                            {
                              lex_error (NULL);
                              goto lossage;
                            }
                          lex_match (',');
                        }
                    }
                  else if (lex_match_id ("SCOMPRESSION"))
                    {
                      lex_match ('=');
                      p->sbc_scompression++;
                      while (token != '/' && token != '.')
                        {
                          if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                            p->scompress = STC_ON;
                          else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                            p->scompress = STC_OFF;
                          else
                            {
                              lex_error (NULL);
                              goto lossage;
                            }
                          lex_match (',');
                        }
                    }
                  else if (lex_match_id ("SCREEN"))
                    {
                      lex_match ('=');
                      p->sbc_screen++;
                      while (token != '/' && token != '.')
                        {
                          if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                            p->scrn = STC_ON;
                          else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                            p->scrn = STC_OFF;
                          else
                            {
                              lex_error (NULL);
                              goto lossage;
                            }
                          lex_match (',');
                        }
                    }
                  else if (lex_match_id ("SCRIPTTAB"))
                    {
                      lex_match ('=');
                      p->sbc_scripttab++;
                      {
                        int x;
                        if (!lex_force_string ())
                          return 0;
                        x = ds_length (&tokstr);
                        if (!(x==1))
                          {
                            msg (SE, _("String for SCRIPTTAB must be one character long."));
                            goto lossage;
                          }
                        free(p->s_scripttab);
                        p->s_scripttab = xstrdup (ds_c_str (&tokstr));
                        lex_get ();
                      }
                    }
                  else if (lex_match_id ("SEED"))
                    {
                      lex_match ('=');
                      p->sbc_seed++;
                      switch (stc_custom_seed (p))
                        {
                        case 0:
                          goto lossage;
                        case 1:
                          break;
                        case 2:
                          lex_error (NULL);
                          goto lossage;
                        default:
                          assert (0);
                        }
                    }
                  else if (lex_match_id ("TB1"))
                    {
                      lex_match ('=');
                      p->sbc_tb1++;
                      {
                        int x;
                        if (!lex_force_string ())
                          return 0;
                        x = ds_length (&tokstr);
                        if (!(x==3 || x==11))
                          {
                            msg (SE, _("String for TB1 must be 3 or 11 characters long."));
                            goto lossage;
                          }
                        free(p->s_tb1);
                        p->s_tb1 = xstrdup (ds_c_str (&tokstr));
                        lex_get ();
                      }
                    }
                  else if (lex_match_id ("TBFONTS"))
                    {
                      lex_match ('=');
                      p->sbc_tbfonts++;
                      if (!lex_force_string ())
                        return 0;
                      free(p->s_tbfonts);
                      p->s_tbfonts = xstrdup (ds_c_str (&tokstr));
                      lex_get ();
                    }
                  else if (lex_match_id ("UNDEFINED"))
                    {
                      lex_match ('=');
                      p->sbc_undefined++;
                      while (token != '/' && token != '.')
                        {
                          if (lex_match_id ("WARN"))
                            p->undef = STC_WARN;
                          else if (lex_match_id ("NOWARN"))
                            p->undef = STC_NOWARN;
                          else
                            {
                              lex_error (NULL);
                              goto lossage;
                            }
                          lex_match (',');
                        }
                    }
                  else if (lex_match_id ("VIEWLENGTH"))
                    {
                      lex_match ('=');
                      p->sbc_viewlength++;
                      switch (stc_custom_viewlength (p))
                        {
                        case 0:
                          goto lossage;
                        case 1:
                          break;
                        case 2:
                          lex_error (NULL);
                          goto lossage;
                        default:
                          assert (0);
                        }
                    }
                  else if (lex_match_id ("VIEWWIDTH"))
                    {
                      lex_match ('=');
                      p->sbc_viewwidth++;
                      switch (stc_custom_viewwidth (p))
                        {
                        case 0:
                          goto lossage;
                        case 1:
                          break;
                        case 2:
                          lex_error (NULL);
                          goto lossage;
                        default:
                          assert (0);
                        }
                    }
                  else if (lex_match_id ("WIDTH"))
                    {
                      lex_match ('=');
                      p->sbc_width++;
                      switch (stc_custom_width (p))
                        {
                        case 0:
                          goto lossage;
                        case 1:
                          break;
                        case 2:
                          lex_error (NULL);
                          goto lossage;
                        default:
                          assert (0);
                        }
                    }
                  else if (lex_match_id ("WORKDEV"))
                    {
                      lex_match ('=');
                      p->sbc_workdev++;
                      switch (stc_custom_workdev (p))
                        {
                        case 0:
                          goto lossage;
                        case 1:
                          break;
                        case 2:
                          lex_error (NULL);
                          goto lossage;
                        default:
                          assert (0);
                        }
                    }
                  else if (lex_match_id ("WORKSPACE"))
                    {
                      lex_match ('=');
                      p->sbc_workspace++;
                      {
                        int x;
                        if (!lex_force_int ())
                          goto lossage;
                        x = lex_integer ();
                        lex_get();
                        if (!(x>=1024))
                          {
                            msg (SE, "WORKSPACE must be at least 1 MB");
                            goto lossage;
                          }
                          p->n_workspace[p->sbc_workspace - 1] = x;
                        }
                      }
                    else if (lex_match_id ("XSORT"))
                      {
                        lex_match ('=');
                        p->sbc_xsort++;
                        while (token != '/' && token != '.')
                          {
                            if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                              p->xsort = STC_YES;
                            else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                              p->xsort = STC_NO;
                            else
                              {
                                lex_error (NULL);
                                goto lossage;
                              }
                            lex_match (',');
                          }
                      }
                    else if ( get_syntax() != COMPATIBLE && lex_match_id("ALGORITHM"))
                      {
                        lex_match ('=');
                        if (lex_match_id("COMPATIBLE"))
                          set_cmd_algorithm(COMPATIBLE);
                        else if (lex_match_id("ENHANCED"))
                          set_cmd_algorithm(ENHANCED);
                        }
                      if (!lex_match ('/'))
                        break;
                    }
                  
                  if (token != '.')
                    {
                      lex_error (_("expecting end of command"));
                      goto lossage;
                    }
                    
                return 1;
                
              lossage:
                free_set (p);
                return 0;
              }
              
static void
free_set (struct cmd_set *p UNUSED)
{
}
#line 209 "../../src/set.q"

static int
aux_stc_custom_blanks(struct cmd_set *cmd UNUSED)
{
  if ( set_blanks == SYSMIS ) 
    msg(MM, "SYSMIS");
  else
    msg(MM, "%g", set_blanks);
  return 0;
}


static int
aux_stc_custom_color(struct cmd_set *cmd UNUSED)
{
  msg (MW, _("%s is obsolete."),"COLOR");
  return 0;
}

static int
aux_stc_custom_listing(struct cmd_set *cmd UNUSED)
{
  if ( set_listing ) 
    msg(MM, _("LISTING is ON"));
  else
    msg(MM, _("LISTING is OFF"));

  return 0;
}

static int
aux_stc_custom_disk(struct cmd_set *cmd UNUSED)
{
  return aux_stc_custom_listing(cmd);
}

static int
aux_stc_custom_epoch(struct cmd_set *cmd UNUSED) 
{
  msg (MM, _("EPOCH is %d"), get_epoch ());
  return 0;
}

static int
aux_stc_custom_format(struct cmd_set *cmd UNUSED)
{
  msg(MM, fmt_to_string(&set_format));
  return 0;
}



static int
aux_stc_custom_journal(struct cmd_set *cmd UNUSED)
{
  if (set_journaling) 
    msg(MM, set_journal);
  else
    msg(MM, _("Journalling is off") );
	
  return 0;
}

static int
aux_stc_custom_length(struct cmd_set *cmd UNUSED)
{
  msg(MM, "%d", set_viewlength);
  return 0;
}

static int
aux_stc_custom_log(struct cmd_set *cmd )
{
  return aux_stc_custom_journal (cmd);
}

static int
aux_stc_custom_pager(struct cmd_set *cmd UNUSED)
{
#if !USE_INTERNAL_PAGER 
  if ( set_pager ) 
    msg(MM, set_pager);
  else
    msg(MM, "No pager");
#else /* USE_INTERNAL_PAGER */
  msg (MM, "Internal pager.");
#endif /* USE_INTERNAL_PAGER */

  return 0;
}

static int
aux_stc_custom_rcolor(struct cmd_set *cmd UNUSED)
{
  msg (SW, _("%s is obsolete."),"RCOLOR");
  return 0;
}

static int
aux_stc_custom_results(struct cmd_set *cmd UNUSED)
{
  
  msg(MM, route_to_string(set_results) );

  return 0;
}

static int
aux_stc_custom_seed(struct cmd_set *cmd UNUSED)
{
  return 0;
}

static int
aux_stc_custom_viewlength(struct cmd_set *cmd UNUSED)
{
  msg(MM, "%d", set_viewlength);
  return 0;
}

static int
aux_stc_custom_viewwidth(struct cmd_set *cmd UNUSED)
{
  msg(MM, "%d", set_viewwidth);
  return 0;
}

static int
aux_stc_custom_width(struct cmd_set *cmd UNUSED)
{
  msg(MM, "%d", set_viewwidth);
  return 0;
}

static int
aux_stc_custom_workdev(struct cmd_set *cmd UNUSED)
{
  msg (SW, _("%s is obsolete."),"WORKDEV");
  return 0;
}



#line 1894 "set.c"
/* Strings for subcommand specifiers. */
static const char *settings[]=
  {
    "ON",
    "OFF",
    "UPPER",
    "UPLOW",
    "DOT",
    "COMMA",
    "TERMINAL",
    "LISTING",
    "BOTH",
    "NONE",
    "NO",
    "YES",
    "BLANK",
    "AUTO",
    "STANDARD",
    "EXTENDED",
    "MANUAL",
    "WARN",
    "NOWARN"
  };

static int
aux_parse_set (struct cmd_set *p)
{
  for (;;)
    {
      if (lex_match_id ("AUTOMENU"))
        {
          msg(MM,"AUTOMENU is %s",
          (p->automenu < 1000)?"not set":settings[p->automenu - 1000]
          );
        }
      else if (lex_match_id ("BEEP"))
        {
          msg(MM,"BEEP is %s",
          (p->beep < 1000)?"not set":settings[p->beep - 1000]
          );
        }
      else if (lex_match_id ("BLANKS"))
        {
          aux_stc_custom_blanks(p);
        }
      else if (lex_match_id ("BLOCK"))
        {
          msg(MM,"BLOCK is \"%s\"",p->s_block);
        }
      else if (lex_match_id ("BOXSTRING"))
        {
          msg(MM,"BOXSTRING is \"%s\"",p->s_boxstring);
        }
      else if (lex_match_id ("CASE"))
        {
          msg(MM,"CASE is %s",
          (p->size < 1000)?"not set":settings[p->size - 1000]
          );
        }
      else if (lex_match_id ("CCA"))
        {
          msg(MM,"CCA is \"%s\"",p->s_cca);
        }
      else if (lex_match_id ("CCB"))
        {
          msg(MM,"CCB is \"%s\"",p->s_ccb);
        }
      else if (lex_match_id ("CCC"))
        {
          msg(MM,"CCC is \"%s\"",p->s_ccc);
        }
      else if (lex_match_id ("CCD"))
        {
          msg(MM,"CCD is \"%s\"",p->s_ccd);
        }
      else if (lex_match_id ("CCE"))
        {
          msg(MM,"CCE is \"%s\"",p->s_cce);
        }
      else if (lex_match_id ("COLOR"))
        {
          aux_stc_custom_color(p);
        }
      else if (lex_match_id ("COMPRESSION"))
        {
          msg(MM,"COMPRESSION is %s",
          (p->compress < 1000)?"not set":settings[p->compress - 1000]
          );
        }
      else if (lex_match_id ("CPI"))
        {
          {
            int i;
            for (i = 0; i < MAXLISTS; ++i)
              msg(MM,"CPI is %ld",p->n_cpi[i]);
          }
        }
      else if (lex_match_id ("CPROMPT"))
        {
          msg(MM,"CPROMPT is \"%s\"",p->s_cprompt);
        }
      else if (lex_match_id ("DECIMAL"))
        {
          msg(MM,"DECIMAL is %s",
          (p->dec < 1000)?"not set":settings[p->dec - 1000]
          );
        }
      else if (lex_match_id ("DISK"))
        {
          aux_stc_custom_disk(p);
        }
      else if (lex_match_id ("DPROMPT"))
        {
          msg(MM,"DPROMPT is \"%s\"",p->s_dprompt);
        }
      else if (lex_match_id ("ECHO"))
        {
          msg(MM,"ECHO is %s",
          (p->echo < 1000)?"not set":settings[p->echo - 1000]
          );
        }
      else if (lex_match_id ("EJECT"))
        {
          msg(MM,"EJECT is %s",
          (p->eject < 1000)?"not set":settings[p->eject - 1000]
          );
        }
      else if (lex_match_id ("ENDCMD"))
        {
          msg(MM,"ENDCMD is \"%s\"",p->s_endcmd);
        }
      else if (lex_match_id ("EPOCH"))
        {
          aux_stc_custom_epoch(p);
        }
      else if (lex_match_id ("ERRORBREAK"))
        {
          msg(MM,"ERRORBREAK is %s",
          (p->errbrk < 1000)?"not set":settings[p->errbrk - 1000]
          );
        }
      else if (lex_match_id ("ERRORS"))
        {
          msg(MM,"ERRORS is %s",
          (p->errors < 1000)?"not set":settings[p->errors - 1000]
          );
        }
      else if (lex_match_id ("FORMAT"))
        {
          aux_stc_custom_format(p);
        }
      else if (lex_match_id ("HEADERS"))
        {
          msg(MM,"HEADERS is %s",
          (p->headers < 1000)?"not set":settings[p->headers - 1000]
          );
        }
      else if (lex_match_id ("HELPWINDOWS"))
        {
          msg(MM,"HELPWINDOWS is %s",
          (p->helpwin < 1000)?"not set":settings[p->helpwin - 1000]
          );
        }
      else if (lex_match_id ("HIGHRES"))
        {
          msg(MM,"HIGHRES is %s",
          (p->hires < 1000)?"not set":settings[p->hires - 1000]
          );
        }
      else if (lex_match_id ("HISTOGRAM"))
        {
          msg(MM,"HISTOGRAM is \"%s\"",p->s_histogram);
        }
      else if (lex_match_id ("INCLUDE"))
        {
          msg(MM,"INCLUDE is %s",
          (p->inc < 1000)?"not set":settings[p->inc - 1000]
          );
        }
      else if (lex_match_id ("JOURNAL"))
        {
          aux_stc_custom_journal(p);
        }
      else if (lex_match_id ("LENGTH"))
        {
          aux_stc_custom_length(p);
        }
      else if (lex_match_id ("LISTING"))
        {
          aux_stc_custom_listing(p);
        }
      else if (lex_match_id ("LOG"))
        {
          aux_stc_custom_log(p);
        }
      else if (lex_match_id ("LOWRES"))
        {
          msg(MM,"LOWRES is %s",
          (p->lores < 1000)?"not set":settings[p->lores - 1000]
          );
        }
      else if (lex_match_id ("LPI"))
        {
          {
            int i;
            for (i = 0; i < MAXLISTS; ++i)
              msg(MM,"LPI is %ld",p->n_lpi[i]);
          }
        }
      else if (lex_match_id ("MENUS"))
        {
          msg(MM,"MENUS is %s",
          (p->menus < 1000)?"not set":settings[p->menus - 1000]
          );
        }
      else if (lex_match_id ("MESSAGES"))
        {
          msg(MM,"MESSAGES is %s",
          (p->messages < 1000)?"not set":settings[p->messages - 1000]
          );
        }
      else if (lex_match_id ("MEXPAND"))
        {
          msg(MM,"MEXPAND is %s",
          (p->mexp < 1000)?"not set":settings[p->mexp - 1000]
          );
        }
      else if (lex_match_id ("MITERATE"))
        {
          {
            int i;
            for (i = 0; i < MAXLISTS; ++i)
              msg(MM,"MITERATE is %ld",p->n_miterate[i]);
          }
        }
      else if (lex_match_id ("MNEST"))
        {
          {
            int i;
            for (i = 0; i < MAXLISTS; ++i)
              msg(MM,"MNEST is %ld",p->n_mnest[i]);
          }
        }
      else if (lex_match_id ("MORE"))
        {
          msg(MM,"MORE is %s",
          (p->more < 1000)?"not set":settings[p->more - 1000]
          );
        }
      else if (lex_match_id ("MPRINT"))
        {
          msg(MM,"MPRINT is %s",
          (p->mprint < 1000)?"not set":settings[p->mprint - 1000]
          );
        }
      else if (lex_match_id ("MXERRS"))
        {
          {
            int i;
            for (i = 0; i < MAXLISTS; ++i)
              msg(MM,"MXERRS is %ld",p->n_mxerrs[i]);
          }
        }
      else if (lex_match_id ("MXLOOPS"))
        {
          {
            int i;
            for (i = 0; i < MAXLISTS; ++i)
              msg(MM,"MXLOOPS is %ld",p->n_mxloops[i]);
          }
        }
      else if (lex_match_id ("MXMEMORY"))
        {
          {
            int i;
            for (i = 0; i < MAXLISTS; ++i)
              msg(MM,"MXMEMORY is %ld",p->n_mxmemory[i]);
          }
        }
      else if (lex_match_id ("MXWARNS"))
        {
          {
            int i;
            for (i = 0; i < MAXLISTS; ++i)
              msg(MM,"MXWARNS is %ld",p->n_mxwarns[i]);
          }
        }
      else if (lex_match_id ("NULLINE"))
        {
          msg(MM,"NULLINE is %s",
          (p->null < 1000)?"not set":settings[p->null - 1000]
          );
        }
      else if (lex_match_id ("PAGER"))
        {
          aux_stc_custom_pager(p);
        }
      else if (lex_match_id ("PRINTBACK"))
        {
          msg(MM,"PRINTBACK is %s",
          (p->prtbck < 1000)?"not set":settings[p->prtbck - 1000]
          );
        }
      else if (lex_match_id ("PRINTER"))
        {
          msg(MM,"PRINTER is %s",
          (p->prtr < 1000)?"not set":settings[p->prtr - 1000]
          );
        }
      else if (lex_match_id ("PROMPT"))
        {
          msg(MM,"PROMPT is \"%s\"",p->s_prompt);
        }
      else if (lex_match_id ("PTRANSLATE"))
        {
          msg(MM,"PTRANSLATE is %s",
          (p->ptrans < 1000)?"not set":settings[p->ptrans - 1000]
          );
        }
      else if (lex_match_id ("RCOLOR"))
        {
          aux_stc_custom_rcolor(p);
        }
      else if (lex_match_id ("RESULTS"))
        {
          aux_stc_custom_results(p);
        }
      else if (lex_match_id ("RUNREVIEW"))
        {
          msg(MM,"RUNREVIEW is %s",
          (p->runrev < 1000)?"not set":settings[p->runrev - 1000]
          );
        }
      else if (lex_match_id ("SAFER"))
        {
          msg(MM,"SAFER is %s",
          (p->safe < 1000)?"not set":settings[p->safe - 1000]
          );
        }
      else if (lex_match_id ("SCOMPRESSION"))
        {
          msg(MM,"SCOMPRESSION is %s",
          (p->scompress < 1000)?"not set":settings[p->scompress - 1000]
          );
        }
      else if (lex_match_id ("SCREEN"))
        {
          msg(MM,"SCREEN is %s",
          (p->scrn < 1000)?"not set":settings[p->scrn - 1000]
          );
        }
      else if (lex_match_id ("SCRIPTTAB"))
        {
          msg(MM,"SCRIPTTAB is \"%s\"",p->s_scripttab);
        }
      else if (lex_match_id ("SEED"))
        {
          aux_stc_custom_seed(p);
        }
      else if (lex_match_id ("TB1"))
        {
          msg(MM,"TB1 is \"%s\"",p->s_tb1);
        }
      else if (lex_match_id ("TBFONTS"))
        {
          msg(MM,"TBFONTS is \"%s\"",p->s_tbfonts);
        }
      else if (lex_match_id ("UNDEFINED"))
        {
          msg(MM,"UNDEFINED is %s",
          (p->undef < 1000)?"not set":settings[p->undef - 1000]
          );
        }
      else if (lex_match_id ("VIEWLENGTH"))
        {
          aux_stc_custom_viewlength(p);
        }
      else if (lex_match_id ("VIEWWIDTH"))
        {
          aux_stc_custom_viewwidth(p);
        }
      else if (lex_match_id ("WIDTH"))
        {
          aux_stc_custom_width(p);
        }
      else if (lex_match_id ("WORKDEV"))
        {
          aux_stc_custom_workdev(p);
        }
      else if (lex_match_id ("WORKSPACE"))
        {
          {
            int i;
            for (i = 0; i < MAXLISTS; ++i)
              msg(MM,"WORKSPACE is %ld",p->n_workspace[i]);
          }
        }
      else if (lex_match_id ("XSORT"))
        {
          msg(MM,"XSORT is %s",
          (p->xsort < 1000)?"not set":settings[p->xsort - 1000]
          );
        }
      else if (lex_match_id ("COPYING"))
        {
          aux_show_copying();
        }
      else if (lex_match_id ("WARRANTY"))
        {
          aux_show_warranty();
        }
      if (!lex_match ('/'))
        break;
    }
  
  if (token != '.')
    {
      lex_error (_("expecting end of command"));
      goto lossage;
    }
    
  return 1;
  
lossage:
  free_set (p);
  return 0;
} /* aux_parse_set (struct cmd_set *p) */

#line 356 "../../src/set.q"


static struct cmd_set cmd;

int
cmd_show (void)
{
  lex_match_id ("SHOW");

  if (!aux_parse_set (&cmd))
    return CMD_FAILURE;

  return CMD_SUCCESS;
}

int
cmd_set (void)
{

  if (!parse_set (&cmd))
    return CMD_FAILURE;

  if (cmd.sbc_cca)
    set_ccx (cmd.s_cca, &set_cc[0], 'A');
  if (cmd.sbc_ccb)
    set_ccx (cmd.s_ccb, &set_cc[1], 'B');
  if (cmd.sbc_ccc)
    set_ccx (cmd.s_ccc, &set_cc[2], 'C');
  if (cmd.sbc_ccd)
    set_ccx (cmd.s_ccd, &set_cc[3], 'D');
  if (cmd.sbc_cce)
    set_ccx (cmd.s_cce, &set_cc[4], 'E');

  if (cmd.sbc_errors)
    set_routing (cmd.errors, &set_errors);
  if (cmd.sbc_messages)
    set_routing (cmd.messages, &set_messages);

  /* PC+ compatible syntax. */
  if (cmd.sbc_screen)
    outp_enable_device (cmd.scrn == STC_OFF ? 0 : 1, OUTP_DEV_SCREEN);
  if (cmd.sbc_printer)
    outp_enable_device (cmd.prtr == STC_OFF ? 0 : 1, OUTP_DEV_PRINTER);

  if (cmd.sbc_automenu )
    msg (SW, _("%s is obsolete."),"AUTOMENU");
  if (cmd.sbc_beep )
    msg (SW, _("%s is obsolete."),"BEEP");
  if (cmd.sbc_block)
    msg (SW, _("%s is obsolete."),"BLOCK");
  if (cmd.sbc_boxstring)
    msg (SW, _("%s is obsolete."),"BOXSTRING");
  if (cmd.sbc_eject )
    msg (SW, _("%s is obsolete."),"EJECT");
  if (cmd.sbc_helpwindows )
    msg (SW, _("%s is obsolete."),"HELPWINDOWS");
  if (cmd.sbc_histogram)
    msg (MW, _("%s is obsolete."),"HISTOGRAM");
  if (cmd.sbc_menus )
    msg (MW, _("%s is obsolete."),"MENUS");
  if (cmd.sbc_ptranslate )
    msg (SW, _("%s is obsolete."),"PTRANSLATE");
  if (cmd.sbc_runreview )
    msg (SW, _("%s is obsolete."),"RUNREVIEW");
  if (cmd.sbc_xsort )
    msg (SW, _("%s is obsolete."),"XSORT");
  if (cmd.sbc_mxmemory )
    msg (SE, _("%s is obsolete."),"MXMEMORY");
  if (cmd.sbc_scripttab)
    msg (SE, _("%s is obsolete."),"SCRIPTTAB");

  if (cmd.sbc_tbfonts)
    msg (SW, _("%s is not yet implemented."),"TBFONTS");
  if (cmd.sbc_tb1 && cmd.s_tb1)
    msg (SW, _("%s is not yet implemented."),"TB1");

  /* Windows compatible syntax. */
  if (cmd.sbc_case)
    msg (SW, _("CASE is not implemented and probably won't be.  "
	"If you care, complain about it."));

  if (cmd.sbc_compression)
    {
      msg (MW, _("Active file compression is not yet implemented "
		 "(and probably won't be)."));
    }

  return CMD_SUCCESS;
}

/* Sets custom currency specifier CC having name CC_NAME ('A' through
   'E') to correspond to the settings in CC_STRING. */
static int
set_ccx (const char *cc_string, struct set_cust_currency * cc, int cc_name)
{
  if (strlen (cc_string) > 16)
    {
      msg (SE, _("CC%c: Length of custom currency string `%s' (%d) "
		 "exceeds maximum length of 16."),
	   cc_name, cc_string, strlen (cc_string));
      return 0;
    }

  /* Determine separators. */
  {
    const char *sp;
    int n_commas, n_periods;
  
    /* Count the number of commas and periods.  There must be exactly
       three of one or the other. */
    n_commas = n_periods = 0;
    for (sp = cc_string; *sp; sp++)
      if (*sp == ',')
	n_commas++;
      else if (*sp == '.')
	n_periods++;
  
    if (!((n_commas == 3) ^ (n_periods == 3)))
      {
	msg (SE, _("CC%c: Custom currency string `%s' does not contain "
		   "exactly three periods or commas (not both)."),
	     cc_name, cc_string);
	return 0;
      }
    else if (n_commas == 3)
      {
	cc->decimal = '.';
	cc->grouping = ',';
      }
    else
      {
	cc->decimal = ',';
	cc->grouping = '.';
      }
  }
  
  /* Copy cc_string to cc, changing separators to nulls. */
  {
    char *cp;
    
    strcpy (cc->buf, cc_string);
    cp = cc->neg_prefix = cc->buf;

    while (*cp++ != cc->grouping)
      ;
    cp[-1] = '\0';
    cc->prefix = cp;

    while (*cp++ != cc->grouping)
      ;
    cp[-1] = '\0';
    cc->suffix = cp;

    while (*cp++ != cc->grouping)
      ;
    cp[-1] = '\0';
    cc->neg_suffix = cp;
  }
  
  return 1;
}


const char *
route_to_string(int routing)
{
  static char s[255];
  
  s[0]='\0';

  if ( routing == 0 )
    {
      strcpy(s, _("None"));
      return s;
    }

  if (routing & SET_ROUTE_DISABLE ) 
    {
    strcpy(s, _("Disabled") );
    return s;
    }

  if (routing & SET_ROUTE_SCREEN)
    strcat(s, _("Screen") );
  
  if (routing & SET_ROUTE_LISTING)
    {
      if(s[0] != '\0') 
	strcat(s,", ");
	
      strcat(s, _("Listing") );
    }

  if (routing & SET_ROUTE_OTHER)
    {
      if(s[0] != '\0') 
	strcat(s,", ");
      strcat(s, _("Other") );
    }
 
    
  return s;
  
    
}

/* Sets *SETTING, which is a combination of SET_ROUTE_* bits that
   indicates what to do with some sort of output, to the value
   indicated by Q, which is a value provided by the input parser. */
static void
set_routing (int q, int *setting)
{
  switch (q)
    {
    case STC_OFF:
      *setting |= SET_ROUTE_DISABLE;
      break;
    case STC_ON:
      *setting &= ~SET_ROUTE_DISABLE;
      break;
    case STC_TERMINAL:
      *setting &= ~(SET_ROUTE_LISTING | SET_ROUTE_OTHER);
      *setting |= SET_ROUTE_SCREEN;
      break;
    case STC_LISTING:
      *setting &= ~SET_ROUTE_SCREEN;
      *setting |= SET_ROUTE_LISTING | SET_ROUTE_OTHER;
      break;
    case STC_BOTH:
      *setting |= SET_ROUTE_SCREEN | SET_ROUTE_LISTING | SET_ROUTE_OTHER;
      break;
    case STC_NONE:
      *setting &= ~(SET_ROUTE_SCREEN | SET_ROUTE_LISTING | SET_ROUTE_OTHER);
      break;
    default:
      assert (0);
    }
}

static int
stc_custom_pager (struct cmd_set *cmd UNUSED)
{
  lex_match ('=');
#if !USE_INTERNAL_PAGER
  if (lex_match_id ("OFF"))
    {
      if (set_pager)
	free (set_pager);
      set_pager = NULL;
    }
  else
    {
      if (!lex_force_string ())
	return 0;
      if (set_pager)
	free (set_pager);
      set_pager = xstrdup (ds_c_str (&tokstr));
      lex_get ();
    }
  return 1;
#else /* USE_INTERNAL_PAGER */
  if (lex_match_id ("OFF"))
    return 1;
  msg (SW, "External pagers not supported.");
  return 0;
#endif /* USE_INTERNAL_PAGER */
}

/* Parses the BLANKS subcommand, which controls the value that
   completely blank fields in numeric data imply.  X, Wnd: Syntax is
   SYSMIS or a numeric value; PC+: Syntax is '.', which is equivalent
   to SYSMIS, or a numeric value. */
static int
stc_custom_blanks (struct cmd_set *cmd UNUSED)
{
  lex_match ('=');
  if ((token == T_ID && lex_id_match ("SYSMIS", tokid))
      || (token == T_STRING && !strcmp (tokid, ".")))
    {
      lex_get ();
      set_blanks = SYSMIS;
    }
  else
    {
      if (!lex_force_num ())
	return 0;
      set_blanks = tokval;
      lex_get ();
    }
  return 1;
}

/* Parses the EPOCH subcommand, which controls the epoch used for
   parsing 2-digit years. */
static int
stc_custom_epoch (struct cmd_set *cmd UNUSED) 
{
  lex_match ('=');
  if (lex_match_id ("AUTOMATIC"))
    set_epoch = -1;
  else if (lex_is_integer ()) 
    {
      int new_epoch = lex_integer ();
      lex_get ();
      if (new_epoch < 1500) 
        {
          msg (SE, _("EPOCH must be 1500 or later."));
          return 0;
        }
      set_epoch = new_epoch;
    }
  else 
    {
      lex_error (_("expecting AUTOMATIC or year"));
      return 0;
    }

  return 1;
}

static int
stc_custom_length (struct cmd_set *cmd UNUSED)
{
  int page_length;

  lex_match ('=');
  if (lex_match_id ("NONE"))
    page_length = -1;
  else
    {
      if (!lex_force_int ())
	return 0;
      if (lex_integer () < 1)
	{
	  msg (SE, _("LENGTH must be at least 1."));
	  return 0;
	}
      page_length = lex_integer ();
      lex_get ();
    }

  if ( page_length != -1 ) 
    set_viewlength = page_length;

  return 1;
}

static int
stc_custom_results (struct cmd_set *cmd UNUSED)
{
  struct tuple
    {	
      const char *s;	
      int v;
    };

  static struct tuple tab[] =
    {
      {"ON", STC_ON},
      {"OFF", STC_OFF},
      {"TERMINAL", STC_TERMINAL},
      {"LISTING", STC_LISTING},
      {"BOTH", STC_BOTH},
      {"NONE", STC_NONE},
      {NULL, 0},
    };

  struct tuple *t;

  lex_match ('=');

  if (token != T_ID)
    {
      msg (SE, _("Missing identifier in RESULTS subcommand."));
      return 0;
    }
  
  for (t = tab; t->s; t++)
    if (lex_id_match (t->s, tokid))
      {
	lex_get ();
	set_routing (t->v, &set_results);
	return 1;
      }
  msg (SE, _("Unrecognized identifier in RESULTS subcommand."));
  return 0;
}

static int
stc_custom_seed (struct cmd_set *cmd UNUSED)
{
  lex_match ('=');
  if (lex_match_id ("RANDOM"))
    set_rng (random_seed ());
  else
    {
      if (!lex_force_num ())
	return 0;
      set_rng (tokval);
      lex_get ();
    }

  return 1;
}

static int
stc_custom_width (struct cmd_set *cmd UNUSED)
{
  int page_width;

  lex_match ('=');
  if (lex_match_id ("NARROW"))
    page_width = 79;
  else if (lex_match_id ("WIDE"))
    page_width = 131;
  else
    {
      if (!lex_force_int ())
	return 0;
      if (lex_integer () < 1)
	{
	  msg (SE, _("WIDTH must be at least 1."));
	  return 0;
	}
      page_width = lex_integer ();
      lex_get ();
    }

  set_viewwidth = page_width;
  return 1;
}

/* Parses FORMAT subcommand, which consists of a numeric format
   specifier. */
static int
stc_custom_format (struct cmd_set *cmd UNUSED)
{
  struct fmt_spec fmt;

  lex_match ('=');
  if (!parse_format_specifier (&fmt, 0))
    return 0;
  if ((formats[fmt.type].cat & FCAT_STRING) != 0)
    {
      msg (SE, _("FORMAT requires numeric output format as an argument.  "
		 "Specified format %s is of type string."),
	   fmt_to_string (&fmt));
      return 0;
    }

  set_format = fmt;
  return 1;
}

static int
stc_custom_journal (struct cmd_set *cmd UNUSED)
{
  lex_match ('=');
  if (lex_match_id ("ON"))
    set_journaling = 1;
  else if (lex_match_id ("OFF"))
    set_journaling = 0;
  if (token == T_STRING)
    {
      set_journal = xstrdup (ds_c_str (&tokstr));
      lex_get ();
    }
  return 1;
}

/* Parses COLOR subcommand.  PC+: either ON or OFF or two or three
   comma-delimited numbers inside parentheses. */
static int
stc_custom_color (struct cmd_set *cmd UNUSED)
{
  msg (MW, _("%s is obsolete."),"COLOR");

  lex_match ('=');
  if (!lex_match_id ("ON") && !lex_match_id ("YES") && !lex_match_id ("OFF") && !lex_match_id ("NO"))
    {
      if (!lex_force_match ('('))
	return 0;
      if (!lex_match ('*'))
	{
	  if (!lex_force_int ())
	    return 0;
	  if (lex_integer () < 0 || lex_integer () > 15)
	    {
	      msg (SE, _("Text color must be in range 0-15."));
	      return 0;
	    }
	  lex_get ();
	}
      if (!lex_force_match (','))
	return 0;
      if (!lex_match ('*'))
	{
	  if (!lex_force_int ())
	    return 0;
	  if (lex_integer () < 0 || lex_integer () > 7)
	    {
	      msg (SE, _("Background color must be in range 0-7."));
	      return 0;
	    }
	  lex_get ();
	}
      if (lex_match (',') && !lex_match ('*'))
	{
	  if (!lex_force_int ())
	    return 0;
	  if (lex_integer () < 0 || lex_integer () > 7)
	    {
	      msg (SE, _("Border color must be in range 0-7."));
	      return 0;
	    }
	  lex_get ();
	}
      if (!lex_force_match (')'))
	return 0;
    }
  return 1;
}

static int
stc_custom_listing (struct cmd_set *cmd UNUSED)
{
  lex_match ('=');
  if (lex_match_id ("ON") || lex_match_id ("YES"))
    set_listing = 1;
  else if (lex_match_id ("OFF") || lex_match_id ("NO"))
    set_listing = 0;
  else
    {
      /* FIXME */
      return 0;
    }
  outp_enable_device (set_listing, OUTP_DEV_LISTING);

  return 1;
}

static int
stc_custom_disk (struct cmd_set *cmd UNUSED)
{
  return stc_custom_listing (cmd);
}

static int
stc_custom_log (struct cmd_set *cmd UNUSED)
{ 
  return stc_custom_journal (cmd);
}

static int
stc_custom_rcolor (struct cmd_set *cmd UNUSED)
{
  msg (SW, _("%s is obsolete."),"RCOLOR");

  lex_match ('=');
  if (!lex_force_match ('('))
    return 0;

  if (!lex_match ('*'))
    {
      if (!lex_force_int ())
	return 0;
      if (lex_integer () < 0 || lex_integer () > 6)
	{
	  msg (SE, _("Lower window color must be between 0 and 6."));
	  return 0;
	}
      lex_get ();
    }
  if (!lex_force_match (','))
    return 0;

  if (!lex_match ('*'))
    {
      if (!lex_force_int ())
	return 0;
      if (lex_integer () < 0 || lex_integer () > 6)
	{
	  msg (SE, _("Upper window color must be between 0 and 6."));
	  return 0;
	}
      lex_get ();
    }

  if (lex_match (',') && !lex_match ('*'))
    {
      if (!lex_force_int ())
	return 0;
      if (lex_integer () < 0 || lex_integer () > 6)
	{
	  msg (SE, _("Frame color must be between 0 and 6."));
	  return 0;
	}
      lex_get ();
    }
  return 1;
}

static int
stc_custom_viewwidth (struct cmd_set *cmd UNUSED)
{
  lex_match ('=');

  if ( !lex_force_int() ) 
    return 0;

  set_viewwidth = lex_integer();
  lex_get();
  
  return 1;
}

static int
stc_custom_viewlength (struct cmd_set *cmd UNUSED)
{
  if (lex_match_id ("MINIMUM"))
    set_viewlength = 25;
  else if (lex_match_id ("MEDIAN"))
    set_viewlength = 43;	/* This is not correct for VGA displays. */
  else if (lex_match_id ("MAXIMUM"))
    set_viewlength = 43;
  else
    {
      if (!lex_force_int ())
	return 0;
#ifdef __MSDOS__
      if (lex_integer () >= (43 + 25) / 2)
	set_viewlength = 43;
      else
	set_viewlength = 25;
#else /* not dos */
      set_viewlength = lex_integer ();
#endif /* not dos */
      lex_get ();
    }

#ifdef __MSDOS__
  msg (SW, _("%s is not yet implemented."),"VIEWLENGTH");
#endif /* dos */
  return 1;
}

static int
stc_custom_workdev (struct cmd_set *cmd UNUSED)
{
  char c[2];

  msg (SW, _("%s is obsolete."),"WORKDEV");

  c[1] = 0;
  for (*c = 'A'; *c <= 'Z'; (*c)++)
    if (token == T_ID && lex_id_match (c, tokid))
      {
	lex_get ();
	return 1;
      }
  msg (SE, _("Drive letter expected in WORKDEV subcommand."));
  return 0;
}



static void 
set_viewport(int sig_num UNUSED)
{
#if HAVE_LIBTERMCAP
  static char term_buffer[16384];
#endif

  set_viewwidth = -1;
  set_viewlength = -1;

#if __DJGPP__ || __BORLANDC__
  {
    struct text_info ti;

    gettextinfo (&ti);
    set_viewlength = max (ti.screenheight, 25);
    set_viewwidth = max (ti.screenwidth, 79);
  }
#elif HAVE_LIBTERMCAP
  {
    char *termtype;
    int success;

    /* This code stolen from termcap.info, though modified. */
    termtype = getenv ("TERM");
    if (!termtype)
      msg (FE, _("Specify a terminal type with the TERM environment variable."));

    success = tgetent (term_buffer, termtype);
    if (success <= 0)
      {
	if (success < 0)
	  msg (IE, _("Could not access the termcap data base."));
	else
	  msg (IE, _("Terminal type `%s' is not defined."), termtype);
      }
    else
      {
	/* NOTE: Do not rely upon tgetnum returning -1 if the value is 
	   not available. It's supposed to do it, but not all platforms 
	   do (eg Cygwin) .
	*/
        if ( -1 != tgetnum("li")) 
	  set_viewlength = tgetnum ("li");

        if ( -1 != tgetnum("co")) 
	  set_viewwidth = tgetnum ("co") - 1;
      }
  }
#endif /* HAVE_LIBTERMCAP */

  /* Try the environment variables */
  if ( -1 ==  set_viewwidth ) 
    { 
      char *s = getenv("COLUMNS");
      if ( s )  set_viewwidth = atoi(s);
    }

  if ( -1 ==  set_viewwidth ) 
    {
      char *s = getenv("LINES");
      if ( s )  set_viewlength = atoi(s);
    }


  /* Last resort.  Use hard coded values */
  if ( 0  >  set_viewwidth ) set_viewwidth = 79;
  if ( 0  >  set_viewlength ) set_viewlength = 24;

}

/* Public functions */

void
done_settings(void)
{
  if ( rng ) 
    gsl_rng_free (rng);
  free (set_pager);
  free (set_journal);

  free (cmd.s_endcmd);
  free (cmd.s_prompt);
  free (cmd.s_cprompt);
  free (cmd.s_dprompt);
}



void
init_settings(void)
{
  cmd.s_dprompt = xstrdup (_("data> "));
  cmd.s_cprompt = xstrdup ("    > ");  
  cmd.s_prompt = xstrdup ("PSPP> ");
  cmd.s_endcmd = xstrdup (".");

  assert(cmd.safe == 0 );
  cmd.safe = STC_OFF;

  cmd.dec = STC_DOT;
  cmd.n_cpi[0] = 6;
  cmd.n_lpi[0] = 10;
  cmd.echo = STC_OFF;
  cmd.more = STC_ON;
  cmd.headers = STC_YES;
  cmd.errbrk = STC_OFF;

  cmd.scompress = STC_OFF;
  cmd.undef = STC_WARN;
  cmd.mprint = STC_ON ;
  cmd.prtbck = STC_ON ;
  cmd.null = STC_ON ;
  cmd.inc = STC_ON ;

  set_journal = xstrdup ("pspp.jnl");
  set_journaling = 1;

  cmd.n_mxwarns[0] = 100;
  cmd.n_mxerrs[0] = 100;
  cmd.n_mxloops[0] = 1;
  cmd.n_workspace[0] = 4L * 1024 * 1024;


#if !USE_INTERNAL_PAGER
  {
    const char *pager = getenv ("STAT_PAGER");

    if (!pager) 
      {
	const char *p = getenv ("PAGER");
	
	if ( p != NULL ) 
	  set_pager = xstrdup (p);
	else
	  set_pager = 0;
      }
    

    if (pager)  
      set_pager = xstrdup (pager);
#if DEFAULT_PAGER
    else
      set_pager = xstrdup (DEFAULT_PAGER);
#endif /* DEFAULT_PAGER */
  }
#endif /* !USE_INTERNAL_PAGER */


  {
    int i;
    
    for (i = 0; i < 5; i++)
      {
	struct set_cust_currency *cc = &set_cc[i];
	strcpy (cc->buf, "-");
	cc->neg_prefix = cc->buf;
	cc->prefix = &cc->buf[1];
	cc->suffix = &cc->buf[1];
	cc->neg_suffix = &cc->buf[1];
	cc->decimal = '.';
	cc->grouping = ',';
      }
  }

  if ( ! long_view )
    {
      set_viewport (0);
      signal (SIGWINCH, set_viewport);
    }

}

void
force_long_view(void)
{
  long_view = 1;
  set_viewwidth=9999;
}

int 
safer_mode(void)
{
  return !(cmd.safe != STC_ON) ;
}


/* Set safer mode */
void
make_safe(void)
{
  cmd.safe = STC_ON;
}


char 
get_decimal(void)
{
  return (cmd.dec == STC_DOT ? '.' : ',');
}

int
get_epoch (void) 
{
  if (set_epoch < 0) 
    {
      time_t t = time (0);
      struct tm *tm = localtime (&t);
      if (tm != NULL) 
        set_epoch = (tm->tm_year + 1900) - 69;
      else
        set_epoch = 2000 - 69;
    }

  return set_epoch;
}

char
get_grouping(void)
{
  return (cmd.dec == STC_DOT ? ',' : '.');
}
 

char * 
get_prompt(void)
{
  return cmd.s_prompt;
}

char * 
get_dprompt(void)
{
  return cmd.s_dprompt;
}

char * 
get_cprompt(void)
{
  return cmd.s_cprompt;
}


int
get_echo(void)
{
    return (cmd.echo != STC_OFF );
}


int 
get_errorbreak(void)
{
  return (cmd.errbrk != STC_OFF);
}


int 
get_scompression(void)
{
  return (cmd.scompress != STC_OFF );
}

int
get_undefined(void)
{
  return (cmd.undef != STC_NOWARN);
}

int
get_mxwarns(void)
{  
  return cmd.n_mxwarns[0];
}

int
get_mxerrs(void)
{
  return cmd.n_mxerrs[0];
}

int
get_mprint(void)
{
  return ( cmd.mprint != STC_OFF );
}

int
get_printback(void)
{
  return (cmd.prtbck != STC_OFF );
}

int
get_mxloops(void)
{
  return cmd.n_mxloops[0];
}

int
get_nullline(void)
{
  return (cmd.null != STC_OFF );
}

int
get_include(void)
{
 return (cmd.inc != STC_OFF );
}

unsigned char
get_endcmd(void)
{
  return cmd.s_endcmd[0];
}


size_t
get_max_workspace(void)
{
  return cmd.n_workspace[0];
}

double
get_blanks(void)
{
  return set_blanks;
}

struct fmt_spec 
get_format(void)
{ 
  return set_format;
}

/* CCA through CCE. */
const struct set_cust_currency *
get_cc(int i)
{
  return &set_cc[i];
}

void
aux_show_warranty(void)
{
  msg(MM,lack_of_warranty);
}

void
aux_show_copying(void)
{
  msg(MM,copyleft);
}


int
get_viewlength(void)
{
  return set_viewlength;
}

int
get_viewwidth(void)
{
  return set_viewwidth;
}

const char *
get_pager(void)
{
  return set_pager;
}

gsl_rng *
get_rng (void)
{
  if (rng == NULL)
    set_rng (random_seed ());
  return rng;
}

static void
set_rng (unsigned long seed) 
{
  rng = gsl_rng_alloc (gsl_rng_mt19937);
  if (rng == NULL)
    out_of_memory ();
  gsl_rng_set (rng, seed);
}

static unsigned long
random_seed (void) 
{
  return time (0);
}

static int global_algorithm = ENHANCED;
static int cmd_algorithm = ENHANCED;
static int *algorithm = &global_algorithm;

static int syntax = ENHANCED;

/* Set the algorithm option globally */
void 
set_algorithm(int x)
{
  global_algorithm = x;
}

/* Set the algorithm option for this command only */
void 
set_cmd_algorithm(int x)
{
  cmd_algorithm = x; 
  algorithm = &cmd_algorithm;
}

/* Unset the algorithm option for this command */
void
unset_cmd_algorithm(void)
{
  algorithm = &global_algorithm;
}

/* Return the current algorithm setting */
int
get_algorithm(void)
{
  return *algorithm;
}

/* Set the syntax option */
void 
set_syntax(int x)
{
  syntax = x;
}

/* Get the current syntax setting */
int
get_syntax(void)
{
  return syntax;
}


/*
   Local Variables:
   mode: c
   End:
*/
