/*  Motti -- a strategy game
    Copyright (C) 1999 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#ifndef XINIT_H

#define XINIT_H 1

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>

#ifdef HAVE_LIBPTHREAD
#include <pthread.h>
#endif

#include "map.h"

enum misc_colors {
  capital_col, cross_col,
  fg_col, bg_col,
  map_bg_col,
  but_fg, but_bg,
  cross_left, turn_win_border,
  end_font_col, end_bg_col, end_bor_col,
  last_col_num
};

enum mouse_action {
  mark, sel, act, last_place, attack, defend, guerilla, reset, smart,
  halfsmart, no_act
};

struct db_vals {
  char *geom_str;
  short but_width, but_height;
  short turnwin_width, turnwin_height;
  char *cross_left_font;
  short map_square_size;
  short x_margin, y_margin;
  enum mouse_action mouse[5];
  short sel_width;
  char *end_msg, *end_font;
};

/* This struct has all variables for different X connections.  */
struct x_info_struct {
  /* Sequence number for this connection.  */
  int conn_num;
  /* Coordinates for each symbol in the turn window.  */
  Coord turnwin_num_base[CROSS_MAX+2];
  /* Width and height of the main window, used to determine the place of the
     end game message.  */
  int main_win_width, main_win_height;

  Display *display;
  /* This one is used by other connections to send events.  */
  Display *common_display;
  int screen_num;
  Colormap colormap;
  int depth;
  XrmDatabase DB;

  /* This one is true, if using an own colormap.  */
  char own_colormap;
  XColor *player_col;
  XColor *occupied_col;
  XColor misc_col[last_col_num];

  Window main_win;
  Window but_win[3];	/* Attack, defend, guerilla.  */
  Window turn_win;
  Window map_win;

  Window endgame_win;
  char *endgame_msg;
  int endmsg_len, endmsg_y;

  GC mapgc, capitalgc, crossgc, turngc, endgamegc, tempgc;
  Pixmap att_pix[CROSS_MAX], def_pix, gue_pix, d_def_pix, d_gue_pix;
#ifdef HAVE_LIBPTHREAD
  Pixmap d_att_pix[CROSS_MAX+1];
  /* This lock is released once x is fully initalized.  */
  pthread_mutex_t init_lock;
  int active;		/* True if this connection is active.  */
#else
  Pixmap d_att_pix[1];
#endif
  int last_sel;		/* Last selected action.  */

  struct db_vals db_tab;
};

struct hint_struct {
  XWMHints *wm_hints;
  XClassHint *class_hints;
  XTextProperty window_name_prop, icon_name_prop;
  XSizeHints *size_hints;
};

extern void create_DB (struct x_info_struct *);
extern int alloc_colors (struct x_info_struct *);
extern void open_windows (struct x_info_struct *);
#if 0
extern void create_cursors (void);
extern void kill_x (void);
#endif

#endif /* xinit.h  */
