/*  GNU Moe - My Own Editor
    Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011
    Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace RC {

struct Options
  {
  int indent_step, keep_lines, max_windows;
  bool auto_unmark, backup, /*beep,*/ exit_ask, ignore_case;
  bool orphan_extra, rectangle_mode, search_wrap, show_code, smart_home;

  Options() throw()
    : indent_step( 2 ), keep_lines( -1 ), max_windows( 0 ),
    auto_unmark( false ), backup( true ), /*beep( false ),*/ exit_ask( false ),
    ignore_case( false ), orphan_extra( false ), rectangle_mode( false ),
    search_wrap( false ), show_code( false ), smart_home( true ) {}

  void reset() throw() { *this = Options(); }
  };


Options & editor_options() throw();		// Global editor options
const Buffer::Options & default_buffer_options() throw();

void apply_regex_options( Buffer & buffer ) throw();

bool parse_int( const std::string & s, int & result ) throw();

    // Returns 0 for success, 1 for file not found, 2 for syntax error.
int process_rcfile( const std::string & name );

    // Returns 0 if success, 1 if invalid option, 2 if a file can't be read.
int process_options();

int read_options( const int argc, const char * const argv[] );

void reset() throw();

    // Defined in main.cc
const std::string & home_directory() throw();
void show_error( const char * const msg, const int errcode = 0,
                 const bool help = false ) throw();

} // end namespace RC
