// hlib/domterm-version.js.  Generated from domterm-version.js.in by configure.
DomTerm.versionString = "2.1.0";
DomTerm.copyrightYear = 2020;
DomTerm.inAtomFlag = false;
DomTerm.useXtermJs = 0;

DomTerm.versions = {};
DomTerm.versions.domterm = DomTerm.versionString;

if (typeof process !== 'undefined' && process.versions
    && process.versions.electron)
    DomTerm.versions = Object.assign(DomTerm.versions, process.versions.electron);
if (typeof navigator !== 'undefined' && navigator.userAgent) {
    let m;
    if ((m = navigator.userAgent.match(/QtWebEngine[/]([^ ]+)/)))
        DomTerm.versions.qtwebengine = m[1];
    if ((m = navigator.userAgent.match(/Electron[/]([^ ]+)/)))
        DomTerm.versions.electron = m[1];
    if ((m = navigator.userAgent.match(/Chrome[/]([^ ]+)/)))
        DomTerm.versions.chrome = m[1];
    if ((m = navigator.userAgent.match(/Firefox[/]([^ ]+)/)))
        DomTerm.versions.firefox = m[1];
    if ((m = navigator.userAgent.match(/Atom[/]([^ ]+)/)))
        DomTerm.versions.atom = m[1];
    if ((m = navigator.userAgent.match(/JavaFX[/]([^ ]+)/)))
        DomTerm.versions.javaFX = m[1];
    if ((m = navigator.userAgent.match(/AppleWebKit[/]([^ ]+)/))
       && ! DomTerm.versions.chrome)
        DomTerm.versions.appleWebKit = m[1];
    DomTerm.versions.userAgent = navigator.userAgent;
}

DomTerm.isElectron = function() {
    return DomTerm.versions.electron;
}

DomTerm.isAtom = function() { return DomTerm.inAtomFlag; }

DomTerm.versionInfo = "version="+DomTerm.versionString;

DomTerm.isMac = typeof navigator != "undefined" ? /Mac/.test(navigator.platform)
    : typeof os != "undefined" ? os.platform() == "darwin" : false;
