;;; hyperbole-autoloads.el --- automatically extracted autoloads
;;
;;; Code:


;;;### (autoloads nil "hact" "hact.el" (0 0 0 0))
;;; Generated autoloads from hact.el

(autoload 'htype:symbol "hact" "\
Return possibly new Hyperbole type symbol composed from TYPE and TYPE-CATEGORY.
TYPE and TYPE-CATEGORY are both symbols.  TYPE-CATEGORY must be one of
`actypes' or `ibtypes'; if not, return nil.

\(fn TYPE TYPE-CATEGORY)" nil nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hact" '("act" "defact" "hact" "hrule:action" "htype:create" "sym")))

;;;***

;;;### (autoloads nil "hactypes" "hactypes.el" (0 0 0 0))
;;; Generated autoloads from hactypes.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hactypes" '("annot-bib" "completion" "display-" "eval-elisp" "exec-" "hyp-" "link-to-" "man-show" "rfc-toc" "text-toc")))

;;;***

;;;### (autoloads nil "hargs" "hargs.el" (0 0 0 0))
;;; Generated autoloads from hargs.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hargs" '("hargs:")))

;;;***

;;;### (autoloads nil "hbdata" "hbdata.el" (0 0 0 0))
;;; Generated autoloads from hbdata.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hbdata" '("hbdata:")))

;;;***

;;;### (autoloads nil "hbmap" "hbmap.el" (0 0 0 0))
;;; Generated autoloads from hbmap.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hbmap" '("hbmap:")))

;;;***

;;;### (autoloads nil "hbut" "hbut.el" (0 0 0 0))
;;; Generated autoloads from hbut.el

(autoload 'hbut:modify-syntax "hbut" "\
Make <> and {} behave as syntactic character pairs in major syntax tables.
Modify `hbut:syntax-table' and `help-mode-syntax-table' to include <> and {}.
Modify `text-mode-syntax-table' and `fundamental-mode's syntax table
to include {} only.  For use with implicit button activations." nil nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hbut" '("defal" "defi" "ebut:" "hattr:summarize" "hbut:" "ibtype:" "ibut:" "map-")))

;;;***

;;;### (autoloads nil "hgnus" "hgnus.el" (0 0 0 0))
;;; Generated autoloads from hgnus.el

(autoload 'Gnus-init "hgnus" "\
Initialize Hyperbole support for Gnus Usenet news reading." t nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hgnus" '("lnews:to" "rnews:")))

;;;***

;;;### (autoloads nil "hhist" "hhist.el" (0 0 0 0))
;;; Generated autoloads from hhist.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hhist" '("*hhist*" "hhist:")))

;;;***

;;;### (autoloads nil "hib-debbugs" "hib-debbugs.el" (0 0 0 0))
;;; Generated autoloads from hib-debbugs.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hib-debbugs" '("debbugs-" "smart-debbugs-gnu")))

;;;***

;;;### (autoloads nil "hib-doc-id" "hib-doc-id.el" (0 0 0 0))
;;; Generated autoloads from hib-doc-id.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hib-doc-id" '("doc-id" "link-to-doc")))

;;;***

;;;### (autoloads nil "hib-kbd" "hib-kbd.el" (0 0 0 0))
;;; Generated autoloads from hib-kbd.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hib-kbd" '("kbd-key")))

;;;***

;;;### (autoloads nil "hib-social" "hib-social.el" (0 0 0 0))
;;; Generated autoloads from hib-social.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hib-social" '("git" "hibtypes-" "social-reference")))

;;;***

;;;### (autoloads nil "hibtypes" "hibtypes.el" (0 0 0 0))
;;; Generated autoloads from hibtypes.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hibtypes" '("Info-node" "action" "annot-bib" "completion" "cscope" "ctags" "debugger-source" "dir-summary" "eli" "etags" "glink" "gnus-push-button" "grep-msg" "hib-python-traceback" "hlink" "id-cflow" "ilink" "ipython-stack-frame" "mail-address" "man-apropos" "markdown-" "org-" "pat" "python-tb-previous-line" "rfc" "ripgrep-msg" "tex")))

;;;***

;;;### (autoloads nil "hinit" "hinit.el" (0 0 0 0))
;;; Generated autoloads from hinit.el

(autoload 'hyperb:init-menubar "hinit" "\
Add a pulldown menu for Hyperbole after Emacs is initialized." t nil)

(autoload 'hui-menu-remove "hinit" "\
Remove MENU-SYM from menubars generated by optional KEYMAP or the `global-map'.

\(fn MENU-SYM &optional KEYMAP)" nil t)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hinit" '("hyperb:check-dir-user")))

;;;***

;;;### (autoloads nil "hload-path" "hload-path.el" (0 0 0 0))
;;; Generated autoloads from hload-path.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hload-path" '("hload-path--" "hyperb:")))

;;;***

;;;### (autoloads nil "hmail" "hmail.el" (0 0 0 0))
;;; Generated autoloads from hmail.el

(autoload 'hmail:compose "hmail" "\
Compose mail with ADDRESS and evaluation of EXPR.
Optional SUBJECT and HELP message may also be given.

\(fn ADDRESS EXPR &optional SUBJECT HELP)" t nil)

(autoload 'hmail:msg-narrow "hmail" "\
Narrows buffer to displayable part of current message.
Its displayable part begins at optional MSG-START and ends at or before
MSG-END.

\(fn &optional MSG-START MSG-END)" nil nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hmail" '("hmail:" "hnews:" "rmail:")))

;;;***

;;;### (autoloads nil "hmh" "hmh.el" (0 0 0 0))
;;; Generated autoloads from hmh.el

(autoload 'Mh-init "hmh" "\
Initialize Hyperbole support for Mh mail reading." t nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hmh" '("Mh-" "hmh--")))

;;;***

;;;### (autoloads nil "hmoccur" "hmoccur.el" (0 0 0 0))
;;; Generated autoloads from hmoccur.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hmoccur" '("moccur")))

;;;***

;;;### (autoloads nil "hmouse-drv" "hmouse-drv.el" (0 0 0 0))
;;; Generated autoloads from hmouse-drv.el

(autoload 'hkey-ace-window-setup "hmouse-drv" "\
Bind optional keyboard KEY and setup display of items specified by short ids.

The ace-window package, (see \"https://elpa.gnu.org/packages/ace-window.html\"),
assigns short ids to each Emacs window and lets you jump to or
operate upon a specific window by giving its letter.  Hyperbole
can insert an operation into ace-window that allows you to
display items such as Dired or buffer menu items in a specific
window.

To enable this feature, in your Emacs initialization file after
Hyperbole is initialized, if you already have a key bound for
ace-window, then call:

 (hkey-ace-window-setup)

otherwise, choose a binding like {\\`M-o'} and send it to the same
function to bind it:

 (hkey-ace-window-setup \"\357\")

Then whenever point is on an item you want displayed in another
window, use {\\`M-o' i <id-of-window-to-display-item-in>} and watch the
magic happen.

\(fn &optional KEY)" nil nil)

(autoload 'hkey-drag "hmouse-drv" "\
Emulate Smart Mouse Key drag from the selected window to RELEASE-WINDOW.
When called interactively the RELEASE-WINDOW is chosen via
ace-window.  The drag action determines the final selected
window.

Optional prefix arg non-nil means emulate Assist Key rather than the
Action Key.

Works only when running under a window system, not from a dumb terminal.

\(fn RELEASE-WINDOW)" t nil)

(autoload 'hkey-drag-stay "hmouse-drv" "\
Emulate Smart Mouse Key drag from selected window to RELEASE-WINDOW.
When called interactively the RELEASE-WINDOW is chosen via
ace-window.  After the drag, the selected window remains the same
as it was before the drag.

Works only when running under a window system, not from a dumb terminal.

\(fn RELEASE-WINDOW)" nil nil)

(autoload 'hkey-drag-item "hmouse-drv" "\
Emulate Smart Mouse Key drag from item in a selected window to RELEASE-WINDOW.
When called interactively the RELEASE-WINDOW is chosen via
ace-window.  RELEASE-WINDOW is left selected unless point is not
on an item, in which case, an error is signalled.

Optional prefix arg non-nil means emulate Assist Key rather than the
Action Key.

Works only when running under a window system, not from a dumb terminal.

\(fn RELEASE-WINDOW)" t nil)

(autoload 'hkey-drag-to "hmouse-drv" "\
Emulate Smart Mouse Key drag from a selected window to RELEASE-WINDOW.
When called interactively the RELEASE-WINDOW is chosen via
ace-window.  If an item is dragged to RELEASE-WINDOW, then
RELEASE-WINDOW is selected; otherwise, the drag action determines
the selected window.  If no drag has taken place, then the
selected window's buffer is displayed in RELEASE-WINDOW and that
becomes the selected window.

Optional prefix arg non-nil means emulate Assist Key rather than the
Action Key.

Works only when running under a window system, not from a dumb terminal.

\(fn RELEASE-WINDOW)" t nil)

(autoload 'hkey-link "hmouse-drv" "\
Return a list of the selected window (where depressed) and the RELEASE-WINDOW.

\(fn RELEASE-WINDOW)" nil nil)

(autoload 'hkey-replace "hmouse-drv" "\
Grab the buffer from RELEASE-WINDOW and place it into the current window.
When called interactively the RELEASE-WINDOW is chosen via
ace-window.  The selected window does not change.

\(fn RELEASE-WINDOW)" t nil)

(autoload 'hkey-swap "hmouse-drv" "\
Swap the buffer from the selected window with that of TO-WINDOW.
When called interactively the TO-WINDOW is chosen via ace-window.  Leave
TO-WINDOW as the selected window.

\(fn TO-WINDOW)" t nil)

(autoload 'hkey-throw "hmouse-drv" "\
Throw a thing to display in RELEASE-WINDOW.
Throw one of:
 - the active (highlighted) region,
 - a displayable item at point or
 - the current buffer.
With optional prefix arg THROW-REGION-FLAG, throw the current region
even if not active.
The selected window does not change.

\(fn RELEASE-WINDOW &optional THROW-REGION-FLAG)" t nil)

(autoload 'hkey-window-link "hmouse-drv" "\
Create a but in the selected window, linked to point in RELEASE-WINDOW.
RELEASE-WINDOW is interactively selected via the `ace-window' command.
The selected window does not change.

With no prefix argument, create an unnamed implicit button.
With a single \\`C-u' \\='(4) prefix argument, create an explicit button.
With any other prefix argument, like M-1, create an named implicit button.

\(fn RELEASE-WINDOW)" t nil)

(autoload 'hkey-buffer-to "hmouse-drv" "\
Display buffer from FROM-WINDOW in TO-WINDOW.
When interactive use ace-window to choose FROM-WINDOW and
TO-WINDOW.  The selected window does not change.

\(fn FROM-WINDOW TO-WINDOW)" t nil)

(autoload 'hkey-swap-buffers "hmouse-drv" "\
Swap buffer from FROM-WINDOW with buffer of TO-WINDOW.
When interactive use ace-window to choose FROM-WINDOW and
TO-WINDOW.  Leave TO-WINDOW as the selected window.

\(fn FROM-WINDOW TO-WINDOW)" t nil)

(autoload 'hmouse-click-to-drag "hmouse-drv" "\
Mouse click on start and end windows for use with `hkey-drag'.
Emulate Smart Mouse Key drag from start window to end window.
The drag action determines the final selected window." t nil)

(autoload 'hmouse-click-to-drag-stay "hmouse-drv" "\
Mouse click on start and end windows for use with `hkey-drag-stay'.
Emulate Smart Mouse Key drag from start window to end window.
The selected window does not change." t nil)

(autoload 'hmouse-click-to-drag-item "hmouse-drv" "\
Mouse click on start and end windows for use with `hkey-drag-item'.
Emulate {\\`M-o' i} from start window to end window.
After the drag, the end window is the selected window." t nil)

(autoload 'hmouse-click-to-drag-to "hmouse-drv" "\
Mouse click on start and end windows for use with `hkey-drag-to'.
Emulate Smart Mouse Key drag from start window to end window.
After the drag, the end window is the selected window." t nil)

(autoload 'hmouse-click-to-replace "hmouse-drv" "\
Mouse click on start and end windows for use with `hkey-replace'.
Replace the buffer in start window with the buffer in end window.
The selected window does not change." t nil)

(autoload 'hmouse-click-to-swap "hmouse-drv" "\
Mouse click on start and end windows for use with `hkey-swap'.
Swap the buffer in start window with the buffer in end window.
Leave the end window selected." t nil)

(autoload 'hmouse-click-to-throw "hmouse-drv" "\
Mouse click on start and end windows for use with `hkey-throw'.
Throw either a displayable item at start window's point or its current
buffer to the end window.  The selected window does not change." t nil)

(autoload 'hkey-buffer-move-left "hmouse-drv" "\
Swap the current buffer with the one on its left, if any; otherwise, do nothing." t nil)

(autoload 'hkey-buffer-move-right "hmouse-drv" "\
Swap the current buffer with the one on its right, if any; otherwise do nothing." t nil)

(autoload 'hkey-buffer-move-down "hmouse-drv" "\
Swap the current buffer with the one below it, if any; otherwise, do nothing." t nil)

(autoload 'hkey-buffer-move-up "hmouse-drv" "\
Swap the current buffer with the one on above it, if any; otherwise, do nothing." t nil)

(autoload 'hkey-help-hide "hmouse-drv" "\
Optionally KILL current buffer (default is bury) and quit WINDOW.
Restore frame to configuration prior to help buffer display.
Point must be in a help buffer.  See `hkey-quit-window' for additional
details.

\(fn &optional KILL WINDOW)" t nil)

(autoload 'hkey-help-show "hmouse-drv" "\
Save prior window configuration if BUFFER displays help.  Display BUFFER.

With optional second arg CURRENT-WINDOW non-nil, force display of buffer within
the current window.  By default, it is displayed according to the setting of
`hpath:display-where'.

\(fn &optional BUFFER CURRENT-WINDOW)" nil nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hmouse-drv" '("action-" "assist-" "hkey-" "hmouse-" "mouse-drag-mode-line" "quit-window" "smart-scroll-")))

;;;***

;;;### (autoloads nil "hmouse-info" "hmouse-info.el" (0 0 0 0))
;;; Generated autoloads from hmouse-info.el

(autoload 'Info-read-index-item-name "hmouse-info" "\
Read an Info index item name with completion, prompting with PROMPT.
An index item name can have the form \"itemname\", referring to an index
item in the current Info file, or \"(filename)itemname\", referring to
an item in filename.  \"(filename)\" is a short format to go to
the Top node in filename.  Signal an error if a filename without an
index is given.

\(fn PROMPT)" nil nil)

(autoload 'smart-info "hmouse-info" "\
Walks through Info documentation networks using one key or mouse key.

If key is pressed within:
 (1) the first line of an Info Menu Entry or Cross Reference, the desired node
       is found;
 (2) the Up, Next, or Previous entries of a Node Header (first line),
       the desired node is found;
 (3) the File entry of a Node Header (first line),
       the `Top' node within that file is found;
 (4) at the end of the current node, the Next node is found (this will
       descend subtrees if the function `Info-global-next' is bound);
 (5) anywhere else (e.g. at the end of a line), the current node entry is
       scrolled up one windowful.

Returns t if key is pressed within an Info Node Header, Cross Reference,
or a Menu; otherwise returns nil." t nil)

(autoload 'smart-info-assist "hmouse-info" "\
Walk through Info documentation using one assist-key or mouse assist-key.

If assist-key is pressed within:
 (1) the first line of an Info Menu Entry or Cross Reference, the desired node
       is found;
 (2) the Up, Next, or Previous entries of a Node Header (first line),
       the last node in the history list is found;
 (3) the File entry of a Node Header (first line),
       the `DIR' root-level node is found;
 (4) at the end of the current node, the Previous node is found (this will
       return from subtrees if the function `Info-global-prev' is bound);
 (5) anywhere else (e.g. at the end of a line), the current node entry is
       scrolled down one windowful.

Returns t if assist-key is pressed within an Info Node Header, Cross Reference,
or a Menu; otherwise returns nil." t nil)

(autoload 'Info-handle-in-note "hmouse-info" "\
Follows an Info cross-reference.
If point is within the first line of an Info note (cross-reference), follows
cross-reference and returns t; otherwise returns nil." nil nil)

(autoload 'Info-current-filename-sans-extension "hmouse-info" "\
Return the filename for the current Info node, if any.
Filename is returned without directory or file extension.
This works regardless of the current buffer." nil nil)

(autoload 'Info-menu-item-at-p "hmouse-info" "\
Return the name of the Info menu item at point, or nil if none." nil nil)

(autoload 'Info-note-at-p "hmouse-info" "\
Return the name of the Info cross-reference note at point, or nil if none." nil nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hmouse-info" '("Info-")))

;;;***

;;;### (autoloads nil "hmouse-key" "hmouse-key.el" (0 0 0 0))
;;; Generated autoloads from hmouse-key.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hmouse-key" '("hmouse-")))

;;;***

;;;### (autoloads nil "hmouse-mod" "hmouse-mod.el" (0 0 0 0))
;;; Generated autoloads from hmouse-mod.el

(defvar hmouse-mod-mode nil "\
Non-nil if Hmouse-Mod mode is enabled.
See the `hmouse-mod-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `hmouse-mod-mode'.")

(custom-autoload 'hmouse-mod-mode "hmouse-mod" nil)

(autoload 'hmouse-mod-mode "hmouse-mod" "\
Toggle use of Smart Keys as Control- and Meta- modifiers (Hmouse Modifier mode).
With a prefix argument ARG, enable Hmouse Mod mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

If the Action Key is held down while alpha characters are typed,
they are translated into Control keys instead.  The Assist Key
translates them into Meta keys.  When both Smart Keys are depressed,
Control-Meta keys are produced.  The commands bound to the
characters produced are then run.

Hmouse Modifier mode is a global minor mode.  It does not affect
unmodified keys.  Normal Smart Key operations work with this
mode, if no other key is pressed while a Smart Key is depressed.

\(fn &optional ARG)" t nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hmouse-mod" '("hmouse-mod-")))

;;;***

;;;### (autoloads nil "hmouse-sh" "hmouse-sh.el" (0 0 0 0))
;;; Generated autoloads from hmouse-sh.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hmouse-sh" '("hmouse-")))

;;;***

;;;### (autoloads nil "hmouse-tag" "hmouse-tag.el" (0 0 0 0))
;;; Generated autoloads from hmouse-tag.el

(autoload 'smart-asm-at-tag-p "hmouse-tag" "\
Return assembly tag name that point is within, else nil.
When optional NO-FLASH, do not flash.

\(fn &optional NO-FLASH)" nil nil)

(autoload 'smart-c++ "hmouse-tag" "\
Jump to the definition of optional C++ IDENTIFIER or the one at point.
Optional second arg NEXT means jump to next matching C++ tag.

It assumes that its caller has already checked that the key was pressed in an
appropriate buffer and has moved the cursor to the selected buffer.

See the documentation for `c++-to-definition' for the behavior of this
function when the OO-Browser has been loaded.
Otherwise:
 (1) on a `#include' statement, the include file is displayed;
     Look for include file in directory lists `smart-c-cpp-include-path'
     and `smart-c-include-path';
 (2) on a C++ identifier, the identifier definition is displayed,
     assuming the identifier is found within an `etags' generated tag file
     in the current directory or any of its ancestor directories;
 (3) if `smart-c-use-lib-man' is non-nil, the C++ identifier is
     recognized as a library symbol, and a man page is found for the
     identifier, then the man page is displayed.

\(fn &optional IDENTIFIER NEXT)" t nil)

(autoload 'smart-c++-tag "hmouse-tag" "\
Jump to the definition of optional C++ IDENTIFIER or the one at point.
Optional second arg NEXT means jump to next matching C++ tag.

\(fn &optional IDENTIFIER NEXT)" nil nil)

(autoload 'smart-c-at-tag-p "hmouse-tag" "\
Return C tag name that point is within, else nil.
When optional NO-FLASH, do not flash.

\(fn &optional NO-FLASH)" nil nil)

(autoload 'smart-cc-mode-initialize "hmouse-tag" "\
Load and initialize cc-mode if possible and always return nil." nil nil)

(autoload 'smart-fortran-at-tag-p "hmouse-tag" "\
Return Fortran tag name that point is within, else nil.
When optional NO-FLASH, do not flash.

\(fn &optional NO-FLASH)" nil nil)

(autoload 'smart-java "hmouse-tag" "\
Jump to the definition of optional Java IDENTIFIER or the one at point.
Optional second arg NEXT means jump to next matching Java tag.

It assumes that its caller has already checked that the key was pressed in an
appropriate buffer and has moved the cursor to the selected buffer.

See the documentation for `smart-java-oo-browser' for the behavior of this
function when the OO-Browser has been loaded.
Otherwise:
 (1) within a commented @see cross-reference, the referent is displayed;
 (2) on a `package' or `import' statement, the referent is displayed;
     Look for referent files in the directory list `smart-java-package-path';
 (3) on a Java identifier, the identifier definition is displayed,
     assuming the identifier is found within an `etags' generated tag file
     in the current directory or any of its ancestor directories.

\(fn &optional IDENTIFIER NEXT)" t nil)

(autoload 'smart-java-tag "hmouse-tag" "\
Jump to the definition of optional Java IDENTIFIER or the one at point.
Optional second arg NEXT means jump to next matching Java tag.

\(fn &optional IDENTIFIER NEXT)" nil nil)

(autoload 'smart-java-at-tag-p "hmouse-tag" "\
Return Java tag name that point is within, else nil.
When optional NO-FLASH, do not flash.

\(fn &optional NO-FLASH)" nil nil)

(autoload 'smart-javascript "hmouse-tag" "\
Jump to the definition of optional JavaScript IDENTIFIER or the one at point.
Optional second arg NEXT means jump to next matching JavaScript tag.

It assumes that its caller has already checked that the key was pressed in an
appropriate buffer and has moved the cursor to the selected buffer.

If on a JavaScript identifier, the identifier definition is displayed,
assuming the identifier is found within an `etags' generated tag file
in the current directory or any of its ancestor directories.

\(fn &optional IDENTIFIER NEXT)" t nil)

(autoload 'smart-javascript-at-tag-p "hmouse-tag" "\
Return JavaScript tag name that point is within, else nil.
When optional NO-FLASH, do not flash.

\(fn &optional NO-FLASH)" nil nil)

(defconst smart-lisp-identifier-first-char-regexp "[-<>*a-zA-Z]" "\
Regexp matching the first character of a Lisp identifier.")

(defconst smart-lisp-identifier-chars "-_:/*+=%$&?!<>a-zA-Z0-9~^@" "\
Regexp matching a valid char in a Lisp identifier except the first char.
Excludes character matching square brackets, so may be used with
skip-characters-forward/backward.")

(defconst smart-lisp-identifier (concat smart-lisp-identifier-first-char-regexp "[" smart-lisp-identifier-chars "]*") "\
Regexp matching a Lisp identifier.")

(autoload 'smart-lisp-mode-p "hmouse-tag" "\
Return t if in a mode which use Lisp symbols." nil nil)

(autoload 'smart-objc "hmouse-tag" "\
Jump to the definition of optional Objective-C IDENTIFIER or the one at point.
Optional second arg NEXT means jump to next matching Objective-C tag.

It assumes that its caller has already checked that the key was pressed in an
appropriate buffer and has moved the cursor to the selected buffer.

See the documentation for `smart-objc-oo-browser' for the behavior of this
function when the OO-Browser has been loaded.
Otherwise:
 (1) on a `#include' statement, the include file is displayed;
     Look for include file in directory lists `objc-cpp-include-path' and
     `objc-include-path';
 (2) on an Objective-C identifier, the identifier definition is displayed,
     assuming the identifier is found within an `etags' generated tag file
     in the current directory or any of its ancestor directories;
 (3) if `smart-c-use-lib-man' is non-nil, the Objective-C identifier is
     recognized as a library symbol, and a man page is found for the
     identifier, then the man page is displayed.

\(fn &optional IDENTIFIER NEXT)" t nil)

(autoload 'smart-objc-tag "hmouse-tag" "\


\(fn &optional IDENTIFIER NEXT)" nil nil)

(autoload 'smart-python "hmouse-tag" "\
Jump to the definition of optional Python IDENTIFIER or the one at point.
Optional second arg NEXT means jump to next matching Python tag.

It assumes that its caller has already checked that the key was pressed in an
appropriate buffer and has moved the cursor to the selected buffer.

See the documentation for `smart-python-jedi-to-definition-p' for the
behavior when the Jedi python identifier server is in use.

See the documentation for `smart-python-oo-browser' for the behavior of this
function when the OO-Browser has been loaded.

Otherwise, on a Python identifier, the identifier definition is displayed,
assuming the identifier is found within an `etags' generated tag file
in the current directory or any of its ancestor directories.

\(fn &optional IDENTIFIER NEXT)" t nil)

(autoload 'smart-python-tag "hmouse-tag" "\
Jump to the definition of optional Python IDENTIFIER or the one at point.
Optional second arg NEXT means jump to next matching Python tag.

\(fn &optional IDENTIFIER NEXT)" nil nil)

(autoload 'smart-python-at-tag-p "hmouse-tag" "\
Return Python tag name that point is within, else nil.
When optional NO-FLASH, do not flash.

\(fn &optional NO-FLASH)" nil nil)

(autoload 'smart-tags-file-path "hmouse-tag" "\
Expand relative FILE name by looking it up within appropriate tags files.
Return FILE unchanged if it exists relative to the current directory or
cannot be expanded via a tags file.

\(fn FILE)" nil nil)

(autoload 'smart-tags-file-list "hmouse-tag" "\
Return tag files list for optional CURR-DIR-OR-FILENAME or `default-directory'.
Optional NAME-OF-TAGS-FILE is the literal filename (no directory) for which
to look.  If no tags file is found, an error is signaled.

\(fn &optional CURR-DIR-OR-FILENAME NAME-OF-TAGS-FILE)" nil nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hmouse-tag" '("find-" "smart-")))

;;;***

;;;### (autoloads nil "hpath" "hpath.el" (0 0 0 0))
;;; Generated autoloads from hpath.el

(defvar hpath:posix-mount-point-to-mswindows-alist nil "\
Automatically set alist of (posix-mount-point . window-path-prefix) elements.
Used to expand posix mount points to Windows UNC paths during
posix-to-mswindows conversion.")

(autoload 'hpath:mswindows-to-posix "hpath" "\
Convert a MSWindows PATH to a Posix-style path or return the path unchanged.
If path begins with an MSWindows drive letter, prefix the
converted path with the value of `hpath:mswindows-mount-prefix'.

\(fn PATH)" t nil)

(autoload 'hpath:posix-to-mswindows "hpath" "\
Convert a Posix-style PATH to an MSWindows path or return the path unchanged.
If path begins with an optional mount prefix,
`hpath:mswindows-mount-prefix', followed by an MSWindows drive
letter, remove the mount prefix.

\(fn PATH)" t nil)

(autoload 'hpath:substitute-posix-or-mswindows-at-point "hpath" "\
If point is in a Posix or MSWindows path, change the path to the other type." t nil)

(autoload 'hpath:substitute-posix-or-mswindows "hpath" "\
Change a recognizable Posix or MSWindows PATH to the other type of path.

\(fn PATH)" nil nil)

(autoload 'hpath:cache-mswindows-mount-points "hpath" "\
Cache valid MSWindows mounts when under a non-MSWindows OS, e.g. WSL.
Mount points are cached in `directory-abbrev-alist'.
Call this function manually if mount points change after Hyperbole is loaded." t nil)

(autoload 'hpath:display-buffer "hpath" "\
Display and select BUFFER at optional DISPLAY-WHERE or at `hpath:display-where'.
BUFFER must be a buffer or a buffer name.

See the documentation of `hpath:display-buffer-alist' for valid
values of DISPLAY-WHERE.  Return the window in which the buffer
is displayed or nil if not displayed because BUFFER is invalid.

\(fn BUFFER &optional DISPLAY-WHERE)" t nil)

(autoload 'hpath:find-file-urls-mode "hpath" "\
Toggle use of ftp and www Urls as arguments to `find-file' commands.
With optional prefix ARG, enable this feature if ARG is positive or turn it
off otherwise.

\(fn &optional ARG)" t nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hpath" '("hpath:")))

;;;***

;;;### (autoloads nil "hrmail" "hrmail.el" (0 0 0 0))
;;; Generated autoloads from hrmail.el

(autoload 'Rmail-init "hrmail" "\
Initialize Hyperbole support for Rmail mail reading." t nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hrmail" '("Rmail-")))

;;;***

;;;### (autoloads nil "hsettings" "hsettings.el" (0 0 0 0))
;;; Generated autoloads from hsettings.el

(autoload 'hyperbole-toggle-messaging "hsettings" "\
Toggle Hyperbole support for explicit buttons in mail and news buffers.
Toggle the boolean variable `inhibit-hyperbole-messaging’ and either
add hooks (nil value) or remove them (t value).

With optional prefix ARG > 0, enable support.  If ARG <= 0,
disable/inhibit support.

\(fn &optional ARG)" t nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hsettings" '("hkey-always-display-menu" "hmouse-middle-flag" "hui:but-flash" "hyperbole-" "inhibit-hyperbole-messaging" "smart-scroll-proportional")))

;;;***

;;;### (autoloads nil "hsmail" "hsmail.el" (0 0 0 0))
;;; Generated autoloads from hsmail.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hsmail" '("mail-yank-original" "message--yank-original-internal" "smail:")))

;;;***

;;;### (autoloads nil "hsys-flymake" "hsys-flymake.el" (0 0 0 0))
;;; Generated autoloads from hsys-flymake.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hsys-flymake" '("hsys-flymake-")))

;;;***

;;;### (autoloads nil "hsys-org" "hsys-org.el" (0 0 0 0))
;;; Generated autoloads from hsys-org.el

(defvar hsys-org-enable-smart-keys 'unset "\
This applies in Org major/minor modes only when `hyperbole-mode' is active.
If set to \\='unset prior to loading Hyperbole, then Hyperbole initialization
will set its value.

The following table shows what the Smart Keys do in various contexts with
different settings of this option.  For example, a nil value makes {M-RET}
operate as it normally does within Org mode contexts.

|---------+-------------------+------------------+----------+------------------|
| Setting | Smart Key Context | Hyperbole Button | Org Link | Fallback Command |
|---------+-------------------+------------------+----------+------------------|
| buttons | Ignore            | Activate         | Activate | org-meta-return  |
| nil     | Ignore            | Ignore           | Ignore   | org-meta-return  |
| t       | Activate          | Activate         | Activate | None             |
|---------+-------------------+------------------+----------+------------------|")

(custom-autoload 'hsys-org-enable-smart-keys "hsys-org" t)

(defvar hsys-org-mode-function #'hsys-org-mode-p "\
*Boolean function that returns non-nil when point is in an Org-related buffer.")

(autoload 'hsys-org-fix-version "hsys-org" "\
If multiple Org versions are loaded, use the one first on `load-path'.
Always ensure Org libraries have been required.
Return t if Org is reloaded, else nil." nil nil)

(autoload 'hsys-org-log-and-fix-version "hsys-org" "\
Log before/after state of Org libraries when fixing a mixed installation." nil nil)

(autoload 'hsys-org-meta-return-shared-p "hsys-org" "\
Return non-nil if hyperbole-mode is active and shares the org-meta-return key." nil nil)

(autoload 'hsys-org-meta-return "hsys-org" "\
Call `org-meta-return' with the numeric value of any prefix arg when given." t nil)

(autoload 'hsys-org-consult-grep "hsys-org" "\
Prompt for search terms and run consult grep over `org-directory'.
Actual grep function used is given by the variable,
`hsys-org-consult-grep-func'." t nil)

(autoload 'hsys-org-mode-p "hsys-org" "\
Return non-nil if point is within an Org major or minor-mode buffer." nil nil)

(autoload 'hsys-org-at-read-only-p "hsys-org" "\
Return non-nil if point is in an Org read-only context." nil nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hsys-org" '("hsys-org-" "org-")))

;;;***

;;;### (autoloads nil "hsys-org-roam" "hsys-org-roam.el" (0 0 0 0))
;;; Generated autoloads from hsys-org-roam.el

(autoload 'hsys-org-roam-consult-grep "hsys-org-roam" "\
Prompt for search terms and run consult grep over `org-roam-directory'.
Actual grep function used is given by the variable,
`consult-org-roam-grep-func'." t nil)

;;;***

;;;### (autoloads nil "hsys-www" "hsys-www.el" (0 0 0 0))
;;; Generated autoloads from hsys-www.el

(autoload 'www-url-expand-file-name "hsys-www" "\
Expand and return non-url and non-remote PATH in DIR.
Return http urls unchanged.  Normalize remote paths.

\(fn PATH &optional DIR)" nil nil)

(autoload 'www-url-find-file-noselect "hsys-www" "\
Find PATH without selecting its buffer.
Handle http urls.  ARGS is the optional arguments to
`find-file-noselect'.  If PATH is a list ARGS is set to remainder
after that the first element is extracted as the PATH.

\(fn PATH &rest ARGS)" nil nil)

(autoload 'eww-browse-url "hsys-www" "\
Ask the eww browser to load URL.

Interactively, if the variable `browse-url-new-window-flag' is non-nil,
loads the document in a new buffer tab on the window tab-line.  A non-nil
prefix argument reverses the effect of `browse-url-new-window-flag'.

If `tab-bar-mode' is enabled, then whenever a document would
otherwise be loaded in a new buffer, it is loaded in a new tab
in the tab-bar on an existing frame.  See more options in
`eww-browse-url-new-window-is-tab'.

Non-interactively, this uses the optional second argument NEW-WINDOW
instead of `browse-url-new-window-flag'.

\(fn URL &optional NEW-WINDOW)" nil nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hsys-www" '("www-url")))

;;;***

;;;### (autoloads nil "hsys-xref" "hsys-xref.el" (0 0 0 0))
;;; Generated autoloads from hsys-xref.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hsys-xref" '("hsys-xref-" "xref--item-at-point")))

;;;***

;;;### (autoloads nil "hsys-youtube" "hsys-youtube.el" (0 0 0 0))
;;; Generated autoloads from hsys-youtube.el

(require 'hact)

(defact yt-info (video-id) "Display a web page with the metadata information about VIDEO-ID." (hact #'actypes::www-url (format "https://mattw.io/youtube-metadata/?url=https://youtu.be/%s&submit=true" video-id)))

(defact yt-play (video-id &optional start-time-string end-time-string) "Play a VIDEO-ID from the point specified by optional START-TIME-STRING.\nIf not given, START-TIME-STRING is set to \"0s\" representing the beginning\nof the video.  START-TIME-STRING is a colon-separated hours:minutes:seconds\nstring, e.g. 1:2:44 (1 hour, two minutes, 45 seconds), where the hours\nand minutes are optional." (hact #'actypes::www-url (hsys-youtube-get-url video-id start-time-string end-time-string)))

(defact yt-search (search-term) "Search Youtube for SEARCH-TERM." (interactive "sSearch Youtube for: ") (hyperbole-web-search "Youtube" search-term))

(defact yt-url (video-id &optional start-time-string end-time-string) "Return url to play VIDEO-ID from point specified by optional START-TIME-STRING.\nReturn nil if START-TIME-STRING is given but is invalid.  If not given,\nSTART-TIME-STRING is set to \"0s\" representing the beginning of the video.\n\nSTART-TIME-STRING is a colon-separated hours:minutes:seconds string,\ne.g. 1:2:44 (1 hour, two minutes, 45 seconds), where the hours and\nminutes are optional." (if end-time-string (progn (setq start-time-string (hsys-youtube-time-in-seconds start-time-string) end-time-string (hsys-youtube-time-in-seconds end-time-string)) (hsys-youtube-end-url video-id start-time-string end-time-string)) (setq start-time-string (hsys-youtube-time-in-hms start-time-string) end-time-string (hsys-youtube-time-in-hms end-time-string)) (hsys-youtube-start-url video-id start-time-string)))

(autoload 'hsys-youtube-play:help "hsys-youtube" "\
Show in the minibuffer the url for an `hsys-youtube-play' action button, HBUT.
Called when the Assist Key is pressed on such a button.

\(fn HBUT)" nil nil)

(defalias 'hsys-youtube-info (htype:symbol 'yt-info 'actypes))

(defalias 'hsys-youtube-play (htype:symbol 'yt-play 'actypes))

(defalias 'hsys-youtube-search (htype:symbol 'yt-search 'actypes))

(autoload 'hsys-youtube-search:help "hsys-youtube" "\
Display in the minibuffer the Youtube url to search for SEARCH-TERM.

\(fn SEARCH-TERM)" t nil)

(defalias 'hsys-youtube-get-url (htype:symbol 'yt-url 'actypes))

(autoload 'hsys-youtube-get-url:help "hsys-youtube" "\
Show in minibuffer the url from an `hsys-youtube-get-url' action button, HBUT.
Called when the Assist Key is pressed on such a button.

\(fn HBUT)" nil nil)

(autoload 'hsys-youtube-end-url "hsys-youtube" "\
Return url to play VIDEO-ID from optional START-TIME-STRING to END-TIME-STRING.
VIDEO-ID must be a string and can be a video identifier,
e.g. WkwZHSbHmPg, or a full url to the video.

\(fn VIDEO-ID &optional START-TIME-STRING END-TIME-STRING)" nil nil)

(autoload 'hsys-youtube-start-url "hsys-youtube" "\
Return url to play VIDEO-ID starting at beginning or optional START-TIME-STRING.
VIDEO-ID must be a string and can be a video identifier,
e.g. WkwZHSbHmPg, or a full url to the video.

\(fn VIDEO-ID &optional START-TIME-STRING)" nil nil)

(autoload 'hsys-youtube-time-in-hms "hsys-youtube" "\
Return the start time for a Youtube url from START-TIME-STRING.
Start time is returned as hours, minutes and seconds.
Hours and minutes are optional within the START-TIME-STRING, e.g. 1:2:44 (1
hour, two minutes, 45 seconds into a video).  If the START-TIME-STRING
format is invalid, return it unchanged.

\(fn START-TIME-STRING)" nil nil)

(autoload 'hsys-youtube-time-in-seconds "hsys-youtube" "\
Return the number of seconds time for a Youtube url given a START-TIME-STRING.
Hours and minutes are optional within the START-TIME-STRING,
e.g. 1:2:44 (1 hour, two minutes, 45 seconds into a video).  The
formats 1h2m44s or 1h:2m:44s may also be used.  If the
START-TIME-STRING format is invalid, return it unchanged.

\(fn START-TIME-STRING)" nil nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hsys-youtube" '("hsys-youtube-")))

;;;***

;;;### (autoloads nil "htz" "htz.el" (0 0 0 0))
;;; Generated autoloads from htz.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "htz" '("htz:")))

;;;***

;;;### (autoloads nil "hui" "hui.el" (0 0 0 0))
;;; Generated autoloads from hui.el

(autoload 'hui-copy-to-register "hui" "\
Copy region or thing into REGISTER.  With prefix arg, delete as well.
Called from program, takes five args: REGISTER, START, END, DELETE-FLAG,
and REGION-FLAG.  START and END are buffer positions indicating what to copy.
The optional argument REGION-FLAG if non-nil, indicates that we're not just
copying some text between START and END, but we're copying the region.

Interactively, reads the register using `register-read-with-preview'.

If called interactively, `transient-mark-mode' is non-nil, and
there is no active region, copy any delimited selectable thing at
point; see `hui:delimited-selectable-thing'.

\(fn REGISTER START END &optional DELETE-FLAG REGION-FLAG)" t nil)

(autoload 'hui-kill-ring-save "hui" "\
Save the active region as if killed, but don't kill it.
In Transient Mark mode, deactivate the mark.
If `interprogram-cut-function' is non-nil, also save the text for a window
system cut and paste.

If called interactively, `transient-mark-mode' is non-nil, and
there is no active region, copy any delimited selectable thing at
point; see `hui:delimited-selectable-thing'.

If you want to append the killed region to the last killed text,
use \\[append-next-kill] before \\[kill-ring-save].

The copied text is filtered by `filter-buffer-substring' before it is
saved in the kill ring, so the actual saved text might be different
from what was in the buffer.

When called from Lisp, save in the kill ring the stretch of text
between BEG and END, unless the optional argument REGION is
non-nil, in which case ignore BEG and END, and save the current
region instead.

This command is similar to `copy-region-as-kill', except that it gives
visual feedback indicating the extent of the region being copied.

\(fn BEG END &optional REGION)" t nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hui" '("hui:")))

;;;***

;;;### (autoloads nil "hui-dired-sidebar" "hui-dired-sidebar.el"
;;;;;;  (0 0 0 0))
;;; Generated autoloads from hui-dired-sidebar.el

(autoload 'smart-dired-sidebar "hui-dired-sidebar" "\
Use a single key or mouse key to manipulate directory entries.

Invoked via a key press when in dired-sidebar-mode.  It assumes
that its caller has already checked that the key was pressed in
an appropriate buffer and has moved the cursor there.

If key is pressed:
 (1) within an entry line, the item is displayed for editing,
     normally in another window, or if it is a directory and
     `dired-sidebar-cycle-subtree-on-click' is t it will expand
     and collapse the entry
 (2) at the end of an entry line: invoke `action-key-eol-function',
     typically to scroll up proportionally, if an Action Key press; invoke
     `assist-key-eol-function', typically to scroll down proportionally,
     if an Asisst Key press;
 (3) on the first line of the buffer (other than the end of line),
     Dired is run on the current directory of this dired-sidebar;
 (4) at the end of the first or last line of the buffer,
     this dired-sidebar invocation is hidden." t nil)

;;;***

;;;### (autoloads nil "hui-em-but" "hui-em-but.el" (0 0 0 0))
;;; Generated autoloads from hui-em-but.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hui-em-but" '("hproperty:")))

;;;***

;;;### (autoloads nil "hui-jmenu" "hui-jmenu.el" (0 0 0 0))
;;; Generated autoloads from hui-jmenu.el

(autoload 'hui-menu-of-buffers "hui-jmenu" "\
Buffer menu." nil nil)

(autoload 'hui-menu-screen-commands "hui-jmenu" "\
Popup a menu of buffers, frames, and windows, allowing user to jump to one." t nil)

(autoload 'hui-menu-jump-to-buffer "hui-jmenu" "\
Popup a menu of existing buffers categorized by mode name.
Jump to chosen buffer." t nil)

(autoload 'hui-menu-jump-to-frame "hui-jmenu" "\
Popup a menu of existing frames.  Jump to chosen frame." t nil)

(autoload 'hui-menu-jump-to-window "hui-jmenu" "\
Popup a menu of existing frames.  Jump to chosen frame." t nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hui-jmenu" '("hui-menu-")))

;;;***

;;;### (autoloads nil "hui-menu" "hui-menu.el" (0 0 0 0))
;;; Generated autoloads from hui-menu.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hui-menu" '("hui-menu-" "hyperbole-" "infodock-hyperbole-menu")))

;;;***

;;;### (autoloads nil "hui-mini" "hui-mini.el" (0 0 0 0))
;;; Generated autoloads from hui-mini.el

(autoload 'hyperbole "hui-mini" "\
Invoke the Hyperbole minibuffer menu when not already active.
\\[hyperbole] runs this.  Non-interactively, return t if a menu is
displayed by this call, else nil (e.g. when already in a Hyperbole
mini-menu).

Two optional arguments may be given to invoke alternative menus.
MENU (a symbol) specifies the menu to invoke from MENU-LIST, (a
Hyperbole menu list structure).  MENU defaults to \\='hyperbole and MENU-LIST
to `hui:menus'.  See `hui:menus' definition for the format of the menu list
structure.

Two additional optional arguments may be given when documentation for
a menu item should be shown rather than display of a menu.  DOC-FLAG
non-nil means show documentation for any item that is selected by the
user.  HELP-STRING-FLAG non-nil means show only the first line of the
documentation, not the full text.

\(fn &optional MENU MENU-LIST DOC-FLAG HELP-STRING-FLAG)" t nil)

(autoload 'hyperbole-demo "hui-mini" "\
Display the Hyperbole FAST-DEMO.
With a prefix ARG, display the older, more extensive \"DEMO\" file.

\(fn &optional ARG)" t nil)

(autoload 'hyperbole-set-key "hui-mini" "\
In KEYMAP, bind KEY to Hyperbole minibuffer BINDING.
If KEYMAP is nil, use the value of (global-key-map).

KEY is a key sequence; noninteractively, it is a string or vector
of characters or event types, and non-ASCII characters with codes
above 127 (such as ISO Latin-1) can be included if you use a vector.

BINDING is one of:
  nil     - immediately remove key binding from keymap
  string  - upon key press, execute the BINDING string as a key series
  command - upon key press, run the command interactively.

Note that other local or minor mode bindings may shadow/override any
binding made with this function.

\(fn KEYMAP KEY BINDING)" t nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hui-mini" '("hui" "hyperbole-minibuffer-menu")))

;;;***

;;;### (autoloads nil "hui-mouse" "hui-mouse.el" (0 0 0 0))
;;; Generated autoloads from hui-mouse.el

(autoload 'smart-eobp "hui-mouse" "\
Return t if point is past the last visible buffer line with text." nil nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hui-mouse" '("action-key-" "assist-key-" "first-line-p" "hkey-" "hmouse-" "last-line-p" "smart-")))

;;;***

;;;### (autoloads nil "hui-register" "hui-register.el" (0 0 0 0))
;;; Generated autoloads from hui-register.el

(autoload 'hui-register-struct-at-point "hui-register" "\
Make a Hyperbole link to button register struct for button at point." nil nil)

;;;***

;;;### (autoloads nil "hui-select" "hui-select.el" (0 0 0 0))
;;; Generated autoloads from hui-select.el

(autoload 'hui-select-at-p "hui-select" "\
Non-nil means character matches a syntax entry in `hui-select-syntax-alist'.
The character is after optional POS or point.  The non-nil value
returned is the function to call to select that syntactic unit.

\(fn &optional POS)" t nil)

(autoload 'hui-select-goto-matching-delimiter "hui-select" "\
Jump back and forth between the start and end delimiters of a thing.

If the key that invokes this command in `hyperbole-minor-mode' is
also bound in the current major mode map, then interactively
invoke that command instead.  Typically prevents clashes over
{\\`C-c' .}." t nil)

(autoload 'hui-select-initialize "hui-select" "\
Initialize the hui-select mode on a double click of the left mouse key.
Also, add language-specific syntax setups to aid in thing selection." t nil)

(autoload 'hui-select-get-thing "hui-select" "\
Return the thing at point that `hui-select-thing' would select." nil nil)

(autoload 'hui-select-thing "hui-select" "\
Select a region based on the syntax of the thing at point.
If invoked repeatedly, this selects bigger and bigger things.
If `hui-select-display-type' is non-nil and this is called
interactively, the type of selection is displayed in the minibuffer.

If the key that invokes this command in `hyperbole-minor-mode' is
also bound in the current major mode map, then interactively
invoke that command instead.  Typically prevents clashes over
{\\`C-c' RET}, {\\`C-c´ \\`C-m'}." t nil)

(autoload 'hui-select-thing-with-mouse "hui-select" "\
Select a region based on the syntax of the character from a mouse click EVENT.
If the click occurs at the same point as the last click, select
the next larger syntactic structure.  If `hui-select-display-type' is
non-nil and this is called interactively, the type of selection is
displayed in the minibuffer.

\(fn EVENT)" t nil)

(autoload 'hui-select-goto-matching-tag "hui-select" "\
Move point to start of the tag paired with closest tag point is at or precedes.
Tag in this context is an sgml-like tag surrounded by angle brackets, <>.
Enabled in major modes contained in the list, `hui-select-markup-modes'.
Return t if point is moved, else nil.  Signal an error if no tag is found
following point or if the closing tag does not have a `>' terminator character." t nil)

(autoload 'hui-select-and-copy-thing "hui-select" "\
Copy the region surrounding the syntactical unit at point to the kill ring." t nil)

(autoload 'hui-select-and-kill-thing "hui-select" "\
Kill the region surrounding the syntactical unit at point." t nil)

(autoload 'hui-select-double-click-hook "hui-select" "\
Select region based on the character syntax where the mouse is double-clicked.
If the double-click EVENT occurs at the same point as the last
double-click, select the next larger syntactic structure.  If
`hui-select-display-type' is non-nil, the type of selection is
displayed in the minibuffer.

\(fn EVENT CLICK-COUNT)" nil nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hui-select" '("hui-")))

;;;***

;;;### (autoloads nil "hui-treemacs" "hui-treemacs.el" (0 0 0 0))
;;; Generated autoloads from hui-treemacs.el

(autoload 'smart-treemacs "hui-treemacs" "\
Use a single key or mouse key to manipulate directory entries.

Invoked via a key press when in treemacs-mode.  It assumes that its
caller has already checked that the key was pressed in an appropriate buffer
and has moved the cursor there.

If key is pressed:
 (1) on an entry icon, the treemacs TAB command is run to expand and
     collapse the entry;
 (2) elsewhere within an entry line, the item is displayed for editing,
     normally in another window;
 (3) at the end of an entry line: invoke `action-key-eol-function',
     typically to scroll up proportionally, if an Action Key press; invoke
     `assist-key-eol-function', typically to scroll down proportionally,
     if an Asisst Key press;
 (4) on the first line of the buffer (other than the end of line),
     Dired is run on the current directory of this Treemacs;
 (5) at the end of the first or last line of the buffer,
     this Treemacs invocation is quit." t nil)

(autoload 'smart-treemacs-modeline "hui-treemacs" "\
Toggle display of Treemacs from Smart Action Key click on a modeline.

When pressed on the Treemacs buffer modeline or Treemacs is displaying
the default directory of the buffer modeline clicked upon, then
quit/hide the Treemacs window.  Otherwise, display the Treemacs window
with the default directory of the buffer modeline clicked upon.

Suitable for use as a value of `action-key-modeline-buffer-id-function'." nil nil)

;;;***

;;;### (autoloads nil "hui-window" "hui-window.el" (0 0 0 0))
;;; Generated autoloads from hui-window.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hui-window" '("action-key-m" "assist-key-m" "hmouse-" "smart-")))

;;;***

;;;### (autoloads nil "hvar" "hvar.el" (0 0 0 0))
;;; Generated autoloads from hvar.el

(autoload 'var:add-and-run-hook "hvar" "\
Add to mode HOOK the HOOK-FUNCTION; call it in matching major-mode buffers.
HOOK is a symbol whose name begins with a major-mode name and ends with
\"-hook\".

\(fn HOOK HOOK-FUNCTION)" nil nil)

(autoload 'var:append "hvar" "\
Append to value held by VAR-SYMBOL, LIST-TO-ADD.  Return new value.
If VAR-SYMBOL is unbound, it is set to LIST-TO-ADD.
Use to append to hook variables.  Store all values for later removal.
Do nothing when `inhibit-hyperbole-messaging' is non-nil.

\(fn VAR-SYMBOL LIST-TO-ADD)" nil nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hvar" '("var:")))

;;;***

;;;### (autoloads nil "hversion" "hversion.el" (0 0 0 0))
;;; Generated autoloads from hversion.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hversion" '("hyperb:")))

;;;***

;;;### (autoloads nil "hycontrol" "hycontrol.el" (0 0 0 0))
;;; Generated autoloads from hycontrol.el

(eval-after-load "buff-menu" '(define-key Buffer-menu-mode-map "@" 'hycontrol-windows-grid))

(eval-after-load "ibuffer" '(define-key ibuffer-mode-map "@" 'hycontrol-windows-grid))

(eval-after-load "dired" '(define-key dired-mode-map "@" 'hycontrol-windows-grid))

(autoload 'hycontrol-enable-frames-mode "hycontrol" "\
Globally enable HyControl Frames mode for rapid Emacs frame control.

  Interactively delete, jump to, move, replicate, and resize frames.
With optional numeric prefix ARG, move and resize by ARG (an
integer) units.  If ARG is < 1, it is set to 1.  If it is >
`hycontrol-maximum-units', it is set to `hycontrol-maximum-units'.

\(fn &optional ARG)" t nil)

(autoload 'hycontrol-enable-windows-mode "hycontrol" "\
Globally enable HyControl Windows mode for rapid Emacs window control.

Interactively delete, jump to, rebalance, resize, and split windows.
Optional non-negative numeric prefix ARG is used as the number of
units for commands issued while the mode is active.  If ARG is < 1, it
is set to 1.  If it is > `hycontrol-maximum-units', it is set to
`hycontrol-maximum-units'.

\(fn &optional ARG)" t nil)

(autoload 'hycontrol-local-frames-mode "hycontrol" "\
Toggle Hyperbole Frames control minor mode in the current buffer.

If called interactively, enable Hycontrol-Local-Frames mode if
ARG is positive, and disable it if ARG is zero or negative.  If
called from Lisp, also enable the mode if ARG is omitted or nil,
and toggle it if ARG is `toggle'; disable the mode otherwise.

\(fn &optional ARG)" t nil)

(put 'hycontrol-frames-mode 'globalized-minor-mode t)

(defvar hycontrol-frames-mode nil "\
Non-nil if Hycontrol-Frames mode is enabled.
See the `hycontrol-frames-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `hycontrol-frames-mode'.")

(custom-autoload 'hycontrol-frames-mode "hycontrol" nil)

(autoload 'hycontrol-frames-mode "hycontrol" "\
Toggle Hycontrol-Local-Frames mode in all buffers.
With prefix ARG, enable Hycontrol-Frames mode if ARG is positive;
otherwise, disable it.  If called from Lisp, enable the mode if
ARG is omitted or nil.

Hycontrol-Local-Frames mode is enabled in all buffers where
`(lambda nil (hycontrol-local-frames-mode 1))' would do it.
See `hycontrol-local-frames-mode' for more information on Hycontrol-Local-Frames mode.

\(fn &optional ARG)" t nil)

(autoload 'hycontrol-local-windows-mode "hycontrol" "\
Toggle Hyperbole Windows control minor mode in the current buffer.

If called interactively, enable Hycontrol-Local-Windows mode if
ARG is positive, and disable it if ARG is zero or negative.  If
called from Lisp, also enable the mode if ARG is omitted or nil,
and toggle it if ARG is `toggle'; disable the mode otherwise.

\(fn &optional ARG)" t nil)

(put 'hycontrol-windows-mode 'globalized-minor-mode t)

(defvar hycontrol-windows-mode nil "\
Non-nil if Hycontrol-Windows mode is enabled.
See the `hycontrol-windows-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `hycontrol-windows-mode'.")

(custom-autoload 'hycontrol-windows-mode "hycontrol" nil)

(autoload 'hycontrol-windows-mode "hycontrol" "\
Toggle Hycontrol-Local-Windows mode in all buffers.
With prefix ARG, enable Hycontrol-Windows mode if ARG is positive;
otherwise, disable it.  If called from Lisp, enable the mode if
ARG is omitted or nil.

Hycontrol-Local-Windows mode is enabled in all buffers where
`(lambda nil (hycontrol-local-windows-mode 1))' would do it.
See `hycontrol-local-windows-mode' for more information on Hycontrol-Local-Windows mode.

\(fn &optional ARG)" t nil)

(autoload 'hycontrol-frame-adjust-widths "hycontrol" "\
Cycle through different common width adjustments of a frame.
Widths are given in screen percentages by the list
`hycontrol-frame-widths' and typically go from widest to narrowest." t nil)

(autoload 'hycontrol-frame-adjust-widths-full-height "hycontrol" "\
Cycle through frame width adjustments after fixing its height full-screen.
Widths are given in screen percentages by the list
`hycontrol-frame-widths' and typically go from widest to narrowest." t nil)

(autoload 'hycontrol-frame-adjust-heights "hycontrol" "\
Cycle through different common height adjustments of a frame.
Heights are given in screen percentages by the list
`hycontrol-frame-heights' and typically go from tallest to shortest." t nil)

(autoload 'hycontrol-frame-adjust-heights-full-width "hycontrol" "\
Cycle through height adjustments of a frame after fixing its width full-screen.
Heights are given in screen percentages by the list
`hycontrol-frame-heights' and typically go from tallest to shortest." t nil)

(autoload 'hycontrol-windows-grid "hycontrol" "\
Display a grid of windows in the selected frame, sized to prefix ARG.
Left digit of ARG is the number of grid rows and the right digit
is the number of grid columns.  Use {\\`C-h' h h} to restore the
prior frame configuration after a grid is displayed.

If ARG is 0, prompt for a major mode whose buffers should be
displayed in the grid windows, then prompt for the grid size.

If ARG is < 0, prompt for a glob-type file pattern and display
files that match the pattern in an abs(ARG) sized windows grid
or an autosized one if the ARG value is invalid.

Otherwise, prompt for the grid size if ARG is an invalid size
\(positive and more than two digits).

With a current buffer in Dired, Buffer Menu or IBuffer mode that
contains marked items, the buffers associated with those items
are displayed in the grid (unless ARG is 0).

By default, the most recently used buffers are displayed in each
window, first selecting only those buffers which match any of the
predicate expressions in `hycontrol-display-buffer-predicate-list'.
\(The default predicate list chooses buffers with attached files).
Then, if there are not enough buffers for all windows, the buffers
that failed to match to any predicate are used.  In all cases,
buffers whose names start with a space are ignored.

When done, this resets the persistent HyControl prefix argument to
1 to prevent following commands from using the often large grid size
argument.

If the key that invokes this command in `hyperbole-minor-mode' is also
bound in the current major mode map, then interactively invoke that
command instead.  Typically prevents clashes over {\\`C-c' @}.

\(fn ARG)" t nil)

(autoload 'hycontrol-windows-grid-by-file-pattern "hycontrol" "\
Display up to an abs(prefix ARG)-sized window grid of files matching PATTERN.
Use absolute file paths if called interactively or optional
FULL-FLAG is non-nil.  PATTERN is a shell file glob pattern.

Left digit of ARG is the number of grid rows and the right digit
is the number of grid columns.  If ARG is nil, 0, 1, less than
11, greater than 99, then autosize the grid to fit the number of
files matched by PATTERN.  Otherwise, if ARG ends in a 0, adjust the
grid size to the closest valid size.

\(fn ARG PATTERN &optional FULL-FLAG)" t nil)

(autoload 'hycontrol-windows-grid-by-major-mode "hycontrol" "\
Display a prefix ARG-sized grid of windows with buffers of major MODE.
Left digit of ARG is the number of grid rows and the right digit
is the number of grid columns.

See documentation of `hycontrol-windows-grid' for further details.

\(fn ARG MODE)" t nil)

(autoload 'hycontrol-windows-grid-repeatedly "hycontrol" "\
Repeatedly display different window grid layouts according to prefix ARG.
ARG is prompted for each time.  Left digit of ARG is the number
of grid rows and the right digit is the number of grid columns.

See documentation of `hycontrol-windows-grid' for further details.

\(fn &optional ARG)" t nil)

(autoload 'hycontrol-window-to-new-frame "hycontrol" "\
Create a new frame sized to match the selected window with the same buffer.
If there is only one window in the source frame or if
`hycontrol-keep-window-flag' is non-nil, leave the original
window and just clone it into the new frame; otherwise, delete
the original window." t nil)

(autoload 'hycontrol-clone-window-to-new-frame "hycontrol" "\
Create a new frame sized to match the selected window with the same buffer." t nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hycontrol" '("hycontrol-")))

;;;***

;;;### (autoloads nil "hypb" "hypb.el" (0 0 0 0))
;;; Generated autoloads from hypb.el

(autoload 'hypb:add-to-invisibility-spec "hypb" "\
Add ELEMENT to `buffer-invisibility-spec'.
See documentation for `buffer-invisibility-spec' for the kind of elements
that can be added.

If `buffer-invisibility-spec' isn't a list before calling this
function, `buffer-invisibility-spec' will afterwards be a list
with the value `(t ELEMENT)'.  This means that if text exists
that invisibility values that aren't either t or ELEMENT, that
text will become visible.

\(fn ELEMENT)" nil nil)

(autoload 'hypb:activate-interaction-log-mode "hypb" "\
Configure and enable the interaction-log package for use with Hyperbole.
This displays a clean log of Emacs keys used and commands executed." t nil)

(autoload 'hypb:count-visible-windows "hypb" "\
Return the number of visible, non-minibuffer windows across all frames." nil nil)

(autoload 'hypb:configuration "hypb" "\
Insert Emacs configuration information at the end of a buffer.
Use optional OUT-BUF if present, else the current buffer.

\(fn &optional OUT-BUF)" nil nil)

(autoload 'hypb:def-to-buffer "hypb" "\
Copy next optional ARG code definitions to the start of optional BUFFER.
Default ARG is 1 and default BUFFER is \"*scratch*\".  Leave
point at the start of the inserted text.

\(fn &optional ARG BUFFER)" t nil)

(autoload 'hypb:devdocs-lookup "hypb" "\
Prompt for and display a devdocs.io docset section within Emacs.
This will install the Emacs devdocs package if not yet installed." t nil)

(autoload 'hypb:helm-apropos "hypb" "\
Prompt for and display the doc for a command, function, variable or face.
With optional SYMBOL-NAME non-nil, display the doc for that.
This will this install the Emacs helm package when needed.

\(fn &optional SYMBOL-NAME)" t nil)

(autoload 'hypb:helm-info "hypb" "\
Prompt across all Info manuals and display the node selected.
With optional prefix arg REFRESH non-nil, refresh the cache of Info manuals.
This will this install the Emacs helm package when needed.

\(fn &optional REFRESH)" t nil)

(autoload 'hypb:locate "hypb" "\
Find file name match anywhere and put results in the `*Locate*' buffer.
Pass it SEARCH-STRING as argument.  Interactively, prompt for SEARCH-STRING.
With prefix arg ARG, prompt for the exact shell command to run instead.

This program searches for those file names in a database that match
SEARCH-STRING and normally outputs all matching absolute file names,
one per line.  The database normally consists of all files on your
system, or of all files that you have access to.  Consult the
documentation of the program for the details about how it determines
which file names match SEARCH-STRING.  (Those details vary highly with
the version.)

You can specify another program for this command to run by customizing
the variables `locate-command' or `locate-make-command-line'.

The main use of FILTER is to implement `locate-with-filter'.  See
the docstring of that function for its meaning.

After preparing the results buffer, this runs `dired-mode-hook' and
then `locate-post-command-hook'.

\(fn SEARCH-STRING &optional FILTER ARG)" t nil)

(autoload 'hypb:map-plist "hypb" "\
Apply FUNC of two args, key and value, to key-value pairs in PLIST.

\(fn FUNC PLIST)" nil nil)

(autoload 'hypb:require-package "hypb" "\
Prompt user to install, if necessary, and require the Emacs PACKAGE-NAME.
PACKAGE-NAME may be a symbol or a string.

\(fn PACKAGE-NAME)" nil nil)

(autoload 'hypb:do-remove-from-plist "hypb" "\
Remove from property list PLIST a NAME string.

\(fn PLIST NAME)" nil nil)

(autoload 'hypb:remove-from-plist "hypb" "\
Remove from property list PLACE a NAME string.
PLACE may be a symbol, or any generalized variable allowed by
`setf'.  The form generated by the macro returns true if NAME was
found and removed, nil otherwise.

\(fn PLACE NAME)" nil t)

(autoload 'hypb:rgrep "hypb" "\
Recursively grep with symbol at point or PATTERN.
Grep over all non-backup and non-autosave files in the current
directory tree.  If in an Emacs Lisp mode buffer and no optional
PREFX-ARG is given, limit search to only .el and .el.gz files.

\(fn PATTERN &optional PREFX-ARG)" t nil)

(autoload 'hypb:display-file-with-logo "hypb" "\
Display a text FILE in view mode with the Hyperbole banner prepended.
If FILE is not an absolute path, expand it relative to `hyperb:dir'.

\(fn FILE)" nil nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hypb" '("hypb:")))

;;;***

;;;### (autoloads nil "hypb-ert" "hypb-ert.el" (0 0 0 0))
;;; Generated autoloads from hypb-ert.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hypb-ert" '("hyp")))

;;;***

;;;### (autoloads nil "hypb-maintenance" "hypb-maintenance.el" (0
;;;;;;  0 0 0))
;;; Generated autoloads from hypb-maintenance.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hypb-maintenance" '("hypb:")))

;;;***

;;;### (autoloads nil "hyperbole" "hyperbole.el" (0 0 0 0))
;;; Generated autoloads from hyperbole.el

(defvar hyperbole-mode nil "\
Non-nil if Hyperbole mode is enabled.
See the `hyperbole-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `hyperbole-mode'.")

(custom-autoload 'hyperbole-mode "hyperbole" nil)

(autoload 'hyperbole-mode "hyperbole" "\
Toggle Hyperbole global minor mode.

If called interactively, enable Hyperbole mode if ARG is
positive, and disable it if ARG is zero or negative.  If called
from Lisp, also enable the mode if ARG is omitted or nil, and
toggle it if ARG is `toggle'; disable the mode otherwise.

Hyperbole is the Everyday Hypertextual Information Manager.

When Hyperbole mode is enabled, the `hyperbole-mode' variable
is non-nil, Hyperbole menus are enabled, as are Hyperbole keys.

Invoke the Hyperbole minibuffer menu with \\[hyperbole].  See the
Info documentation at \"(hyperbole)Top\".

\\{hyperbole-mode-map}

\(fn &optional ARG)" t nil)

(let ((us (if (fboundp 'macroexp-file-name) (macroexp-file-name) load-file-name))) (when us (add-to-list 'load-path (expand-file-name "kotl" (file-name-directory us))) (require 'kotl-autoloads nil t)))

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hyperbole" '("hkey-" "hyperb")))

;;;***

;;;### (autoloads nil "hyrolo" "hyrolo.el" (0 0 0 0))
;;; Generated autoloads from hyrolo.el

(autoload 'hyrolo-add "hyrolo" "\
Add a new entry in personal rolo for NAME.
Last name first is best, e.g. \"Smith, John\".
With prefix argument, prompts for optional FILE to add entry within.
NAME may be of the form: parent/child to insert child below a parent
entry which begins with the parent string.

\(fn NAME &optional FILE)" t nil)

(autoload 'hyrolo-display-matches "hyrolo" "\
Display optional DISPLAY-BUF buffer of previously found rolo matches.
If DISPLAY-BUF is nil, use the value in `hyrolo-display-buffer'.
Second arg RETURN-TO-BUFFER is the buffer to leave point within
after the display.

\(fn &optional DISPLAY-BUF RETURN-TO-BUFFER)" t nil)

(autoload 'hyrolo-edit "hyrolo" "\
Edit a hyrolo entry matching NAME from FILE-OR-BUF.
With prefix argument, prompt for optional FILE-OR-BUF from `hyrolo-file-list',
within which to locate entry.  With no NAME arg, simply display
FILE-OR-BUF or the first entry in `hyrolo-file-list' in an editable
mode.  NAME may be of the form: parent/child to edit child below
a parent entry which begins with the parent string.

\(fn &optional NAME FILE-OR-BUF)" t nil)

(autoload 'hyrolo-fgrep "hyrolo" "\
Display rolo entries matching STRING or a logical match expression.
Return count of matches.

To a maximum of optional prefix arg MAX-MATCHES, in file(s) from optional
HYROLO-FILE or `hyrolo-file-list'.  Default is to find all matching entries.
Each entry is displayed with all of its sub-entries.  Optional COUNT-ONLY
non-nil skips retrieval of matching entries.  Optional HEADLINE-ONLY searches
only the first line of entries, not the full text.  Optional NO-DISPLAY non-nil
retrieves entries but does not display them.

Nil value of MAX-MATCHES means find all matches, t value means find all
matches but omit file headers, negative values mean find up to the inverse of
that number of entries and omit file headers.

Return number of entries matched.  See also documentation for the variable
`hyrolo-file-list' and the function `hyrolo-fgrep-logical' for documentation on
the logical sexpression matching.

\(fn STRING &optional MAX-MATCHES HYROLO-FILE COUNT-ONLY HEADLINE-ONLY NO-DISPLAY)" t nil)

(autoload 'hyrolo-find-file "hyrolo" "\
Find an optional FILE with FIND-FUNCTION and rest of ARGS.
When called interactively, select from the list of files referenced
by `hyrolo-file-list' unless given a prefix argument, in which case
use the first file generated by the list.

FIND-FUNCTION must return the buffer of the file found but need not
select it.

\(fn &optional FILE FIND-FUNCTION &rest ARGS)" t nil)

(autoload 'hyrolo-find-file-noselect "hyrolo" "\
HyRolo function to read a FILE in without selecting it.
It uses the setting of `hyrolo-find-file-noselect-function' and
overrides file major modes with any settings in `hyrolo-auto-mode-alist'.

\(fn &optional FILE)" nil nil)

(autoload 'hyrolo-grep "hyrolo" "\
Display HyRolo entries matching REGEXP and return count of matches.
To a maximum of prefix arg MAX-MATCHES, in buffer(s) from
optional HYROLO-FILE-OR-BUFS or `hyrolo-get-file-list'.  Default
is to find all matching entries.  Each entry is displayed with
all of its sub-entries.  Optional COUNT-ONLY non-nil means don't
retrieve and don't display matching entries.  Optional
HEADLINE-ONLY searches only the first line of entries, not the
full text.  Optional NO-DISPLAY non-nil retrieves entries but
does not display.

Nil value of MAX-MATCHES means find all matches, t value means find all matches
but omit file headers, negative values mean find up to the inverse of that
number of entries and omit file headers.

Return number of entries matched.  See also documentation for the variable
`hyrolo-file-list'.

\(fn REGEXP &optional MAX-MATCHES HYROLO-FILE-OR-BUFS COUNT-ONLY HEADLINE-ONLY NO-DISPLAY)" t nil)

(autoload 'hyrolo-grep-or-fgrep "hyrolo" "\
Grep over `hyrolo-file-list' and display the results as rolo entries.
With optional prefix ARG, do an fgrep string match instead of a regexp match.

\(fn &optional ARG)" t nil)

(autoload 'hyrolo-kill "hyrolo" "\
Kill a rolo entry given by NAME within `hyrolo-file-list'.
With prefix argument, prompts for optional FILE to locate entry within.
NAME may be of the form: parent/child to kill child below a parent entry
which begins with the parent string.
Return t if entry is killed, nil otherwise.

\(fn NAME &optional FILE)" t nil)

(autoload 'hyrolo-markdown-mode "hyrolo" "\
Major mode for editing Markdown files.

\(fn)" t nil)

(autoload 'hyrolo-let-file-list "hyrolo" "\


\(fn SYMBOL VALUE)" nil nil)

(autoload 'hyrolo-set-file-list "hyrolo" "\


\(fn SYMBOL VALUE)" nil nil)

(autoload 'hyrolo-sort "hyrolo" "\
Sort up to 14 levels of entries in HYROLO-FILE (default is personal hyrolo).
Assume entries are delimited by one or more `*' characters.
Return list of number of groupings at each entry level.

\(fn &optional HYROLO-FILE)" t nil)

(autoload 'hyrolo-toggle-datestamps "hyrolo" "\
Toggle whether datestamps are updated when rolo entries are modified.
With optional ARG, turn them on iff ARG is positive.

\(fn &optional ARG)" t nil)

(autoload 'hyrolo-word "hyrolo" "\
Display rolo entries with whole word match for STRING.
To a maximum of optional prefix arg MAX-MATCHES, in file(s) from optional
HYROLO-FILE or hyrolo-file-list.  Default is to find all matching entries.  Each
entry is displayed with all of its sub-entries.  Optional COUNT-ONLY
non-nil skips retrieval of matching entries.  Optional HEADLINE-ONLY searches
only the first line of entries, not the full text.  Optional NO-DISPLAY non-nil
retrieves entries but does not display them.

Nil value of MAX-MATCHES means find all matches, t value means find all matches
but omit file headers, negative values mean find up to the inverse of that
number of entries and omit file headers.

Return number of entries matched.  See also documentation for the variable
hyrolo-file-list.

\(fn STRING &optional MAX-MATCHES HYROLO-FILE COUNT-ONLY HEADLINE-ONLY NO-DISPLAY)" t nil)

(autoload 'hyrolo-yank "hyrolo" "\
Insert at point the first rolo entry matching NAME.
With optional prefix arg, REGEXP-P, treats NAME as a regular expression instead
of a string.

\(fn NAME &optional REGEXP-P)" t nil)

(autoload 'hyrolo-bbdb-fgrep "hyrolo" "\
Fgrep over a bbdb database and format the results as rolo entries.
With optional prefix ARG, do a grep regexp match instead of a string match.

\(fn &optional ARG)" t nil)

(autoload 'hyrolo-bbdb-grep "hyrolo" "\
Grep over a bbdb database and format the results as rolo entries.
With optional prefix ARG, do an fgrep string match instead of a regexp match.

Output looks like so:
======================================================================
@loc> \".bbdb\"
======================================================================
* Jones     Tom                <tj@groovycat.org>
* Sera      Kate               <uptown@singular.net>
* Yako      Maso               <ym@destination.ny>

\(fn &optional ARG)" t nil)

(autoload 'hyrolo-google-contacts-fgrep "hyrolo" "\
Fgrep over a buffer of Google Contacts and format the results as rolo entries.
With optional prefix ARG, do a grep regexp match instead of a string match.

\(fn &optional ARG)" t nil)

(autoload 'hyrolo-google-contacts-grep "hyrolo" "\
Grep over a buffer of Google Contacts and format the results as rolo entries.
With optional prefix ARG, do an fgrep string match instead of a regexp match.

Output looks like so:
======================================================================
@loc> <buffer *Google Contacts*>
======================================================================
* Jones     Tom
* Sera      Kate
* Yako      Maso

\(fn &optional ARG)" t nil)

(autoload 'hyrolo-helm-org-rifle "hyrolo" "\
Search with helm and interactively show all matches from `hyrolo-file-list'.
Prompt for the search pattern.
Search readable .org, .otl and .outl files only.  With optional prefix
arg CONTEXT-ONLY-FLAG, show one extra line only of context around
a matching line, rather than entire entries.

\(fn &optional CONTEXT-ONLY-FLAG)" t nil)

(autoload 'hyrolo-helm-org-rifle-directory "hyrolo" "\
Interactively search over `org-directory'.
With optional prefix arg CONTEXT-ONLY-FLAG, show one extra line
only of context around a matching line, rather than entire
entries.

\(fn &optional CONTEXT-ONLY-FLAG)" t nil)

(autoload 'hyrolo-helm-org-rifle-directories "hyrolo" "\
Interactively search over Emacs outline format files in rest of DIRS.
Search readable .org, .otl and .outl files only.  With optional prefix
arg CONTEXT-ONLY-FLAG, show one extra line only of context around
a matching line, rather than entire entries.

\(fn &optional CONTEXT-ONLY-FLAG &rest DIRS)" t nil)

(autoload 'hyrolo-org "hyrolo" "\
Search `org-directory' files for STRING or logic-based matches.
OPTIONAL prefix arg, MAX-MATCHES, limits the number of matches
returned to the number given.

\(fn STRING &optional MAX-MATCHES)" t nil)

(autoload 'hyrolo-org-roam "hyrolo" "\
Search `org-roam-directory' files for STRING or logical sexpression.
OPTIONAL prefix arg, MAX-MATCHES, limits the number of matches
returned to the number given.

\(fn STRING &optional MAX-MATCHES)" t nil)

(autoload 'hyrolo-consult-grep "hyrolo" "\
Interactively search `hyrolo-file-list' with a consult package grep command.
Use ripgrep (rg) if found, otherwise, plain grep.  Interactively
show all matches from `hyrolo-file-list'.  Initialize search with
optional REGEXP and interactively prompt for changes.  Limit matches
per file to the absolute value of MAX-MATCHES if given.

\(fn &optional REGEXP MAX-MATCHES)" t nil)

(autoload 'hyrolo-fgrep-directories "hyrolo" "\
String/logical HyRolo search over files matching FILE-REGEXP in rest of DIRS.

\(fn FILE-REGEXP &rest DIRS)" nil nil)

(autoload 'hyrolo-grep-directories "hyrolo" "\
Regexp HyRolo search over files matching FILE-REGEXP in rest of DIRS.

\(fn FILE-REGEXP &rest DIRS)" nil nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hyrolo" '("hyrolo-" "reveal-post-command")))

;;;***

;;;### (autoloads nil "hyrolo-demo" "hyrolo-demo.el" (0 0 0 0))
;;; Generated autoloads from hyrolo-demo.el

(autoload 'hyrolo-demo-fgrep "hyrolo-demo" "\
Display rolo entries in \"DEMO-ROLO.otl\" matching STRING or a logical sexp.
Display to a maximum of optional prefix arg MAX-MATCHES.
Each entry is displayed with all of its sub-entries.

Nil value of MAX-MATCHES means find all matches, t value means find all
matches but omit file headers, negative values mean find up to the inverse of
that number of entries and omit file headers.

Returns number of entries matched.  See also documentation for
the function `hyrolo-demo-fgrep-logical' for documentation on the
logical sexpression matching.

\(fn STRING &optional MAX-MATCHES)" t nil)

(autoload 'hyrolo-demo-fgrep-logical "hyrolo-demo" "\
Display rolo entries in \"DEMO-ROLO.otl\" matching EXPR.
EXPR may contain prefix logical operators.
If optional COUNT-ONLY is non-nil, don't display entries, return
count of matching entries only.  If optional INCLUDE-SUB-ENTRIES
flag is non-nil, SEXP will be applied across all sub-entries at
once.  Default is to apply SEXP to each entry and sub-entry
separately.  Entries are displayed with all of their sub-entries
unless INCLUDE-SUB-ENTRIES is nil and optional NO-SUB-ENTRIES-OUT
flag is non-nil.

A complex example of EXPR might be:
  (and (or (not time card) (xor (french balloons) spanish)) teacher pet)
which means:
  Match neither `time' nor `card'
    or
  Matches exactly one of `french balloons' or `spanish'
    and
  Matches `teacher' and `pet'.

Either double quotes or parentheses may be used to group multiple words as a
single argument.

\(fn EXPR &optional COUNT-ONLY INCLUDE-SUB-ENTRIES NO-SUB-ENTRIES-OUT)" t nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hyrolo-demo" '("hyrolo-demo-")))

;;;***

;;;### (autoloads nil "hyrolo-logic" "hyrolo-logic.el" (0 0 0 0))
;;; Generated autoloads from hyrolo-logic.el

(autoload 'hyrolo-fgrep-logical "hyrolo-logic" "\
Display rolo entries matching EXPR.
EXPR is a string that may contain sexpression logical prefix operators.
If optional COUNT-ONLY is non-nil, don't display entries, return
count of matching entries only.  If optional INCLUDE-SUB-ENTRIES
flag is non-nil, SEXP will be applied across all sub-entries at
once.  Default is to apply SEXP to each entry and sub-entry
separately.  Entries are displayed with all of their sub-entries
unless INCLUDE-SUB-ENTRIES is nil and optional NO-SUB-ENTRIES-OUT
flag is non-nil.  With optional KOUTLINE-FLAG, map entries with
`hyrolo-map-kotl' rather than `hyrolo-map-entries'.

A complex example of EXPR might be:
  (and
   (or (not time card) (xor (and french \"red balloons\") spanish))
   teacher
   pet)
which means:
  (Match neither `time' nor `card'
     or
   Match exactly one of (`french' and `red balloons') or (`spanish'))
    and
  must include the terms `teacher' as well as `pet' to match.

Double quotes may be used to group multiple words as a single argument.

\(fn EXPR &optional COUNT-ONLY INCLUDE-SUB-ENTRIES NO-SUB-ENTRIES-OUT KOUTLINE-FLAG)" t nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hyrolo-logic" '("hyrolo-")))

;;;***

;;;### (autoloads nil "hyrolo-menu" "hyrolo-menu.el" (0 0 0 0))
;;; Generated autoloads from hyrolo-menu.el

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hyrolo-menu" '("hyrolo-" "id-popup-hyrolo-menu" "infodock-hyrolo-menu")))

;;;***

;;;### (autoloads nil "hywconfig" "hywconfig.el" (0 0 0 0))
;;; Generated autoloads from hywconfig.el

(autoload 'hywconfig-add-by-name "hywconfig" "\
Save the current window configuration under the string NAME.
When called interactively and a window configuration already exists under
NAME, confirm whether or not to replace it.

Return t if name is added or replaced, else nil.

\(fn NAME)" t nil)

(autoload 'hywconfig-delete-by-name "hywconfig" "\
Delete frame-specific window configuration saved with NAME.

Return t if name exists and is deleted, else nil.

\(fn NAME)" t nil)

(autoload 'hywconfig-restore-by-name "hywconfig" "\
Restore frame-specific window configuration saved with NAME.

Return t if name exists and is restored, else nil.

\(fn NAME)" t nil)

(autoload 'hywconfig-delete-pop "hywconfig" "\
Replace the selected frame's window configuration with the most recently saved.
Then delete this new configuration from the ring." t nil)

(autoload 'hywconfig-delete-pop-continue "hywconfig" "\
Replace selected frame's window configuration with the most recently saved.
Then delete this new configuration from the ring.  If the hywconfig
ring is not empty, then stay in the hywconfig menu." t nil)

(autoload 'hywconfig-ring-empty-p "hywconfig" "\
Return t if the wconfig ring for the selected frame is empty; nil otherwise." nil nil)

(autoload 'hywconfig-ring-save "hywconfig" "\
Save the selected frame's window configuration onto the save ring.
Use {\\[hywconfig-yank-pop]} to restore it at a later time." t nil)

(autoload 'hywconfig-yank-pop "hywconfig" "\
Replace selected frame's window config with prefix arg Nth prior one in ring.
Interactively, default value of N = 1, means the last saved window
configuration is displayed.

The sequence of window configurations wraps around, so that after the
oldest one comes the newest one.

\(fn N)" t nil)

(autoload 'hywconfig-yank-pop-continue "hywconfig" "\
Replace selected frame's window config with prefix arg Nth prior one in ring.
If there are more than one entries in the ring, then stay in the hywconfig menu.

Interactively, default value of N = 1, means the last saved window
configuration is displayed.

The sequence of window configurations wraps around, so that after the
oldest one comes the newest one.

\(fn N)" t nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "hywconfig" '("hywconfig-")))

;;;***

;;;### (autoloads nil "set" "set.el" (0 0 0 0))
;;; Generated autoloads from set.el

(autoload 'set:create "set" "\
Return a new set created from any number of ELEMENTS.
If no ELEMENTS are given, return the empty set.  Uses `set:equal-op'
for comparison.

\(fn &rest ELEMENTS)" nil nil)

(if (fboundp 'register-definition-prefixes) (register-definition-prefixes "set" '("set:")))

;;;***

;;;### (autoloads nil nil ("../../../tmp/hyperbole-9.0.1/hact.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hbut.el" "../../../tmp/hyperbole-9.0.1/hgnus.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hinit.el" "../../../tmp/hyperbole-9.0.1/hmail.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hmh.el" "../../../tmp/hyperbole-9.0.1/hmouse-drv.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hmouse-info.el" "../../../tmp/hyperbole-9.0.1/hmouse-mod.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hmouse-tag.el" "../../../tmp/hyperbole-9.0.1/hpath.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hrmail.el" "../../../tmp/hyperbole-9.0.1/hsettings.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hsys-org-roam.el" "../../../tmp/hyperbole-9.0.1/hsys-org.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hsys-www.el" "../../../tmp/hyperbole-9.0.1/hsys-youtube.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hui-dired-sidebar.el" "../../../tmp/hyperbole-9.0.1/hui-jmenu.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hui-mini.el" "../../../tmp/hyperbole-9.0.1/hui-mouse.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hui-register.el" "../../../tmp/hyperbole-9.0.1/hui-select.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hui-treemacs.el" "../../../tmp/hyperbole-9.0.1/hui.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hvar.el" "../../../tmp/hyperbole-9.0.1/hycontrol.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hypb.el" "../../../tmp/hyperbole-9.0.1/hyperbole-autoloads.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hyperbole.el" "../../../tmp/hyperbole-9.0.1/hyrolo-demo.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hyrolo-logic.el" "../../../tmp/hyperbole-9.0.1/hyrolo.el"
;;;;;;  "../../../tmp/hyperbole-9.0.1/hywconfig.el" "../../../tmp/hyperbole-9.0.1/set.el")
;;;;;;  (0 0 0 0))

;;;***

(provide 'hyperbole-autoloads)
;; Local Variables:
;; version-control: never
;; no-byte-compile: t
;; no-update-autoloads: t
;; coding: utf-8
;; End:
;;; hyperbole-autoloads.el ends here
