/*-------------------------------------------------------------------------*/
/* GNU Prolog                                                              */
/*                                                                         */
/* Part  : line-edit library                                               */
/* File  : linedit.h                                                       */
/* Descr.: line editor - header file                                       */
/* Author: Daniel Diaz                                                     */
/*                                                                         */
/* Copyright (C) 1999 Daniel Diaz                                          */
/*                                                                         */
/* GNU Prolog is free software; you can redistribute it and/or modify it   */
/* under the terms of the GNU General Public License as published by the   */
/* Free Software Foundation; either version 2, or any later version.       */
/*                                                                         */
/* GNU Prolog is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of              */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        */
/* General Public License for more details.                                */
/*                                                                         */
/* You should have received a copy of the GNU General Public License along */
/* with this program; if not, write to the Free Software Foundation, Inc.  */
/* 59 Temple Place - Suite 330, Boston, MA 02111, USA.                     */
/*-------------------------------------------------------------------------*/

/*---------------------------------*/
/* Constants                       */
/*---------------------------------*/


/*---------------------------------*/
/* Type Definitions                */
/*---------------------------------*/


/*---------------------------------*/
/* Global Variables                */
/*---------------------------------*/

/*---------------------------------*/
/* Function Prototypes             */
/*---------------------------------*/

char     *LE_Gets               (char *str);
char     *LE_FGets              (char *str,int size,int fd_in,int fd_out,
                                 char *prompt,int display_prompt);

char     *LE_Get_Separators     (void);
char     *LE_Set_Separators     (char *sep_str);

char     *LE_Compl_Add_Word     (char *word,int word_length);
char     *LE_Compl_Del_Word     (char *word);
char     *LE_Compl_Init_Match   (char *prefix,int *nb_match,int *max_lg);
char     *LE_Compl_Find_Match   (int *is_last);

int       LE_FGetc_No_Echo      (int fd_in,int fd_out);
