// java-chartables.h - Character tables for java.lang.Character -*- c++ -*-

#ifndef __JAVA_CHARTABLES_H__
#define __JAVA_CHARTABLES_H__

// These tables are automatically generated by the chartables.pl
// script.  DO NOT EDIT the tables.  Instead, fix the script
// and run it again.

// This file should only be included by natCharacter.cc

static const jchar title_to_lower_table[][2] =
  {
    { 0x01c5, 0x01c6 },   // LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
    { 0x01c8, 0x01c9 },   // LATIN CAPITAL LETTER L WITH SMALL LETTER J
    { 0x01cb, 0x01cc },   // LATIN CAPITAL LETTER N WITH SMALL LETTER J
    { 0x01f2, 0x01f3 }    // LATIN CAPITAL LETTER D WITH SMALL LETTER Z
  };

static const jchar title_to_upper_table[][2] =
  {
    { 0x01c5, 0x01c4 },   // LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
    { 0x01c8, 0x01c7 },   // LATIN CAPITAL LETTER L WITH SMALL LETTER J
    { 0x01cb, 0x01ca },   // LATIN CAPITAL LETTER N WITH SMALL LETTER J
    { 0x01f2, 0x01f1 }    // LATIN CAPITAL LETTER D WITH SMALL LETTER Z
  };

#ifdef COMPACT_CHARACTER

#define TAMIL_DIGIT_ONE 0x0be7

static const jchar numeric_table[] =
  { 0x00b2, 0x00b3, 0x00b9, 0x00bc, 0x00bd, 
    0x00be, 0x09f4, 0x09f5, 0x09f6, 0x09f7, 
    0x09f8, 0x09f9, 0x0bf0, 0x0bf1, 0x0bf2, 
    0x2070, 0x2074, 0x2075, 0x2076, 0x2077, 
    0x2078, 0x2079, 0x2080, 0x2081, 0x2082, 
    0x2083, 0x2084, 0x2085, 0x2086, 0x2087, 
    0x2088, 0x2089, 0x2153, 0x2154, 0x2155, 
    0x2156, 0x2157, 0x2158, 0x2159, 0x215a, 
    0x215b, 0x215c, 0x215d, 0x215e, 0x215f, 
    0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 
    0x2165, 0x2166, 0x2167, 0x2168, 0x2169, 
    0x216a, 0x216b, 0x216c, 0x216d, 0x216e, 
    0x216f, 0x2170, 0x2171, 0x2172, 0x2173, 
    0x2174, 0x2175, 0x2176, 0x2177, 0x2178, 
    0x2179, 0x217a, 0x217b, 0x217c, 0x217d, 
    0x217e, 0x217f, 0x2180, 0x2181, 0x2182, 
    0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 
    0x2465, 0x2466, 0x2467, 0x2468, 0x2469, 
    0x246a, 0x246b, 0x246c, 0x246d, 0x246e, 
    0x246f, 0x2470, 0x2471, 0x2472, 0x2473, 
    0x2474, 0x2475, 0x2476, 0x2477, 0x2478, 
    0x2479, 0x247a, 0x247b, 0x247c, 0x247d, 
    0x247e, 0x247f, 0x2480, 0x2481, 0x2482, 
    0x2483, 0x2484, 0x2485, 0x2486, 0x2487, 
    0x2488, 0x2489, 0x248a, 0x248b, 0x248c, 
    0x248d, 0x248e, 0x248f, 0x2490, 0x2491, 
    0x2492, 0x2493, 0x2494, 0x2495, 0x2496, 
    0x2497, 0x2498, 0x2499, 0x249a, 0x249b, 
    0x24ea, 0x2776, 0x2777, 0x2778, 0x2779, 
    0x277a, 0x277b, 0x277c, 0x277d, 0x277e, 
    0x277f, 0x2780, 0x2781, 0x2782, 0x2783, 
    0x2784, 0x2785, 0x2786, 0x2787, 0x2788, 
    0x2789, 0x278a, 0x278b, 0x278c, 0x278d, 
    0x278e, 0x278f, 0x2790, 0x2791, 0x2792, 
    0x2793, 0x3007, 0x3021, 0x3022, 0x3023, 
    0x3024, 0x3025, 0x3026, 0x3027, 0x3028, 
    0x3029, 0x3280, 0x3281, 0x3282, 0x3283, 
    0x3284, 0x3285, 0x3286, 0x3287, 0x3288, 
    0x3289 };

static const jshort numeric_value[] =
  { 2, 3, 1, -2, -2, -2, 1, 2, 3, 4, 
    -2, 16, 10, 100, 1000, 0, 4, 5, 6, 7, 
    8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 
    8, 9, -2, -2, -2, -2, -2, -2, -2, -2, 
    -2, -2, -2, -2, 1, 1, 2, 3, 4, 5, 
    6, 7, 8, 9, 10, 11, 12, 50, 100, 500, 
    1000, 1, 2, 3, 4, 5, 6, 7, 8, 9, 
    10, 11, 12, 50, 100, 500, 1000, 1000, 5000, 10000, 
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 
    11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 
    11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 
    11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 
    10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 
    10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 
    10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 
    9, 1, 2, 3, 4, 5, 6, 7, 8, 9, 
    10 };

static const jchar digit_table[][2] =
  {
    { 0x0030, 0x0039 },
    { 0x0660, 0x0669 },
    { 0x06f0, 0x06f9 },
    { 0x0966, 0x096f },
    { 0x09e6, 0x09ef },
    { 0x0a66, 0x0a6f },
    { 0x0ae6, 0x0aef },
    { 0x0b66, 0x0b6f },
    { 0x0be7, 0x0bef },
    { 0x0c66, 0x0c6f },
    { 0x0ce6, 0x0cef },
    { 0x0d66, 0x0d6f },
    { 0x0e50, 0x0e59 },
    { 0x0ed0, 0x0ed9 },
    { 0x0f20, 0x0f29 },
    { 0xff10, 0xff19 }
  };

static const jchar space_table[][2] =
  {
    { 0x0020, 0x0020 },
    { 0x00a0, 0x00a0 },
    { 0x2000, 0x200b },
    { 0x2028, 0x2029 },
    { 0x3000, 0x3000 }
  };

static const jchar upper_case_table[][2] =
  {
    { 0x0041, 0x005a },
    { 0x00c0, 0x00d6 },
    { 0x00d8, 0x00de },
    { 0x0100, 0x0100 },
    { 0x0102, 0x0102 },
    { 0x0104, 0x0104 },
    { 0x0106, 0x0106 },
    { 0x0108, 0x0108 },
    { 0x010a, 0x010a },
    { 0x010c, 0x010c },
    { 0x010e, 0x010e },
    { 0x0110, 0x0110 },
    { 0x0112, 0x0112 },
    { 0x0114, 0x0114 },
    { 0x0116, 0x0116 },
    { 0x0118, 0x0118 },
    { 0x011a, 0x011a },
    { 0x011c, 0x011c },
    { 0x011e, 0x011e },
    { 0x0120, 0x0120 },
    { 0x0122, 0x0122 },
    { 0x0124, 0x0124 },
    { 0x0126, 0x0126 },
    { 0x0128, 0x0128 },
    { 0x012a, 0x012a },
    { 0x012c, 0x012c },
    { 0x012e, 0x012e },
    { 0x0130, 0x0130 },
    { 0x0132, 0x0132 },
    { 0x0134, 0x0134 },
    { 0x0136, 0x0136 },
    { 0x0139, 0x0139 },
    { 0x013b, 0x013b },
    { 0x013d, 0x013d },
    { 0x013f, 0x013f },
    { 0x0141, 0x0141 },
    { 0x0143, 0x0143 },
    { 0x0145, 0x0145 },
    { 0x0147, 0x0147 },
    { 0x014a, 0x014a },
    { 0x014c, 0x014c },
    { 0x014e, 0x014e },
    { 0x0150, 0x0150 },
    { 0x0152, 0x0152 },
    { 0x0154, 0x0154 },
    { 0x0156, 0x0156 },
    { 0x0158, 0x0158 },
    { 0x015a, 0x015a },
    { 0x015c, 0x015c },
    { 0x015e, 0x015e },
    { 0x0160, 0x0160 },
    { 0x0162, 0x0162 },
    { 0x0164, 0x0164 },
    { 0x0166, 0x0166 },
    { 0x0168, 0x0168 },
    { 0x016a, 0x016a },
    { 0x016c, 0x016c },
    { 0x016e, 0x016e },
    { 0x0170, 0x0170 },
    { 0x0172, 0x0172 },
    { 0x0174, 0x0174 },
    { 0x0176, 0x0176 },
    { 0x0178, 0x0178 },
    { 0x0179, 0x0179 },
    { 0x017b, 0x017b },
    { 0x017d, 0x017d },
    { 0x0181, 0x0181 },
    { 0x0182, 0x0182 },
    { 0x0184, 0x0184 },
    { 0x0186, 0x0186 },
    { 0x0187, 0x0187 },
    { 0x0189, 0x018a },
    { 0x018b, 0x018b },
    { 0x018e, 0x018e },
    { 0x018f, 0x018f },
    { 0x0190, 0x0190 },
    { 0x0191, 0x0191 },
    { 0x0193, 0x0193 },
    { 0x0194, 0x0194 },
    { 0x0196, 0x0196 },
    { 0x0197, 0x0197 },
    { 0x0198, 0x0198 },
    { 0x019c, 0x019c },
    { 0x019d, 0x019d },
    { 0x019f, 0x019f },
    { 0x01a0, 0x01a0 },
    { 0x01a2, 0x01a2 },
    { 0x01a4, 0x01a4 },
    { 0x01a6, 0x01a6 },
    { 0x01a7, 0x01a7 },
    { 0x01a9, 0x01a9 },
    { 0x01ac, 0x01ac },
    { 0x01ae, 0x01ae },
    { 0x01af, 0x01af },
    { 0x01b1, 0x01b2 },
    { 0x01b3, 0x01b3 },
    { 0x01b5, 0x01b5 },
    { 0x01b7, 0x01b7 },
    { 0x01b8, 0x01b8 },
    { 0x01bc, 0x01bc },
    { 0x01c4, 0x01c4 },
    { 0x01c7, 0x01c7 },
    { 0x01ca, 0x01ca },
    { 0x01cd, 0x01cd },
    { 0x01cf, 0x01cf },
    { 0x01d1, 0x01d1 },
    { 0x01d3, 0x01d3 },
    { 0x01d5, 0x01d5 },
    { 0x01d7, 0x01d7 },
    { 0x01d9, 0x01d9 },
    { 0x01db, 0x01db },
    { 0x01de, 0x01de },
    { 0x01e0, 0x01e0 },
    { 0x01e2, 0x01e2 },
    { 0x01e4, 0x01e4 },
    { 0x01e6, 0x01e6 },
    { 0x01e8, 0x01e8 },
    { 0x01ea, 0x01ea },
    { 0x01ec, 0x01ec },
    { 0x01ee, 0x01ee },
    { 0x01f1, 0x01f1 },
    { 0x01f4, 0x01f4 },
    { 0x01fa, 0x01fa },
    { 0x01fc, 0x01fc },
    { 0x01fe, 0x01fe },
    { 0x0200, 0x0200 },
    { 0x0202, 0x0202 },
    { 0x0204, 0x0204 },
    { 0x0206, 0x0206 },
    { 0x0208, 0x0208 },
    { 0x020a, 0x020a },
    { 0x020c, 0x020c },
    { 0x020e, 0x020e },
    { 0x0210, 0x0210 },
    { 0x0212, 0x0212 },
    { 0x0214, 0x0214 },
    { 0x0216, 0x0216 },
    { 0x0386, 0x0386 },
    { 0x0388, 0x038a },
    { 0x038c, 0x038c },
    { 0x038e, 0x038f },
    { 0x0391, 0x03a1 },
    { 0x03a3, 0x03ab },
    { 0x03e2, 0x03e2 },
    { 0x03e4, 0x03e4 },
    { 0x03e6, 0x03e6 },
    { 0x03e8, 0x03e8 },
    { 0x03ea, 0x03ea },
    { 0x03ec, 0x03ec },
    { 0x03ee, 0x03ee },
    { 0x0401, 0x040c },
    { 0x040e, 0x040f },
    { 0x0410, 0x042f },
    { 0x0460, 0x0460 },
    { 0x0462, 0x0462 },
    { 0x0464, 0x0464 },
    { 0x0466, 0x0466 },
    { 0x0468, 0x0468 },
    { 0x046a, 0x046a },
    { 0x046c, 0x046c },
    { 0x046e, 0x046e },
    { 0x0470, 0x0470 },
    { 0x0472, 0x0472 },
    { 0x0474, 0x0474 },
    { 0x0476, 0x0476 },
    { 0x0478, 0x0478 },
    { 0x047a, 0x047a },
    { 0x047c, 0x047c },
    { 0x047e, 0x047e },
    { 0x0480, 0x0480 },
    { 0x0490, 0x0490 },
    { 0x0492, 0x0492 },
    { 0x0494, 0x0494 },
    { 0x0496, 0x0496 },
    { 0x0498, 0x0498 },
    { 0x049a, 0x049a },
    { 0x049c, 0x049c },
    { 0x049e, 0x049e },
    { 0x04a0, 0x04a0 },
    { 0x04a2, 0x04a2 },
    { 0x04a4, 0x04a4 },
    { 0x04a6, 0x04a6 },
    { 0x04a8, 0x04a8 },
    { 0x04aa, 0x04aa },
    { 0x04ac, 0x04ac },
    { 0x04ae, 0x04ae },
    { 0x04b0, 0x04b0 },
    { 0x04b2, 0x04b2 },
    { 0x04b4, 0x04b4 },
    { 0x04b6, 0x04b6 },
    { 0x04b8, 0x04b8 },
    { 0x04ba, 0x04ba },
    { 0x04bc, 0x04bc },
    { 0x04be, 0x04be },
    { 0x04c1, 0x04c1 },
    { 0x04c3, 0x04c3 },
    { 0x04c7, 0x04c7 },
    { 0x04cb, 0x04cb },
    { 0x04d0, 0x04d0 },
    { 0x04d2, 0x04d2 },
    { 0x04d4, 0x04d4 },
    { 0x04d6, 0x04d6 },
    { 0x04d8, 0x04d8 },
    { 0x04da, 0x04da },
    { 0x04dc, 0x04dc },
    { 0x04de, 0x04de },
    { 0x04e0, 0x04e0 },
    { 0x04e2, 0x04e2 },
    { 0x04e4, 0x04e4 },
    { 0x04e6, 0x04e6 },
    { 0x04e8, 0x04e8 },
    { 0x04ea, 0x04ea },
    { 0x04ee, 0x04ee },
    { 0x04f0, 0x04f0 },
    { 0x04f2, 0x04f2 },
    { 0x04f4, 0x04f4 },
    { 0x04f8, 0x04f8 },
    { 0x0531, 0x0556 },
    { 0x10a0, 0x10c5 },
    { 0x1e00, 0x1e00 },
    { 0x1e02, 0x1e02 },
    { 0x1e04, 0x1e04 },
    { 0x1e06, 0x1e06 },
    { 0x1e08, 0x1e08 },
    { 0x1e0a, 0x1e0a },
    { 0x1e0c, 0x1e0c },
    { 0x1e0e, 0x1e0e },
    { 0x1e10, 0x1e10 },
    { 0x1e12, 0x1e12 },
    { 0x1e14, 0x1e14 },
    { 0x1e16, 0x1e16 },
    { 0x1e18, 0x1e18 },
    { 0x1e1a, 0x1e1a },
    { 0x1e1c, 0x1e1c },
    { 0x1e1e, 0x1e1e },
    { 0x1e20, 0x1e20 },
    { 0x1e22, 0x1e22 },
    { 0x1e24, 0x1e24 },
    { 0x1e26, 0x1e26 },
    { 0x1e28, 0x1e28 },
    { 0x1e2a, 0x1e2a },
    { 0x1e2c, 0x1e2c },
    { 0x1e2e, 0x1e2e },
    { 0x1e30, 0x1e30 },
    { 0x1e32, 0x1e32 },
    { 0x1e34, 0x1e34 },
    { 0x1e36, 0x1e36 },
    { 0x1e38, 0x1e38 },
    { 0x1e3a, 0x1e3a },
    { 0x1e3c, 0x1e3c },
    { 0x1e3e, 0x1e3e },
    { 0x1e40, 0x1e40 },
    { 0x1e42, 0x1e42 },
    { 0x1e44, 0x1e44 },
    { 0x1e46, 0x1e46 },
    { 0x1e48, 0x1e48 },
    { 0x1e4a, 0x1e4a },
    { 0x1e4c, 0x1e4c },
    { 0x1e4e, 0x1e4e },
    { 0x1e50, 0x1e50 },
    { 0x1e52, 0x1e52 },
    { 0x1e54, 0x1e54 },
    { 0x1e56, 0x1e56 },
    { 0x1e58, 0x1e58 },
    { 0x1e5a, 0x1e5a },
    { 0x1e5c, 0x1e5c },
    { 0x1e5e, 0x1e5e },
    { 0x1e60, 0x1e60 },
    { 0x1e62, 0x1e62 },
    { 0x1e64, 0x1e64 },
    { 0x1e66, 0x1e66 },
    { 0x1e68, 0x1e68 },
    { 0x1e6a, 0x1e6a },
    { 0x1e6c, 0x1e6c },
    { 0x1e6e, 0x1e6e },
    { 0x1e70, 0x1e70 },
    { 0x1e72, 0x1e72 },
    { 0x1e74, 0x1e74 },
    { 0x1e76, 0x1e76 },
    { 0x1e78, 0x1e78 },
    { 0x1e7a, 0x1e7a },
    { 0x1e7c, 0x1e7c },
    { 0x1e7e, 0x1e7e },
    { 0x1e80, 0x1e80 },
    { 0x1e82, 0x1e82 },
    { 0x1e84, 0x1e84 },
    { 0x1e86, 0x1e86 },
    { 0x1e88, 0x1e88 },
    { 0x1e8a, 0x1e8a },
    { 0x1e8c, 0x1e8c },
    { 0x1e8e, 0x1e8e },
    { 0x1e90, 0x1e90 },
    { 0x1e92, 0x1e92 },
    { 0x1e94, 0x1e94 },
    { 0x1ea0, 0x1ea0 },
    { 0x1ea2, 0x1ea2 },
    { 0x1ea4, 0x1ea4 },
    { 0x1ea6, 0x1ea6 },
    { 0x1ea8, 0x1ea8 },
    { 0x1eaa, 0x1eaa },
    { 0x1eac, 0x1eac },
    { 0x1eae, 0x1eae },
    { 0x1eb0, 0x1eb0 },
    { 0x1eb2, 0x1eb2 },
    { 0x1eb4, 0x1eb4 },
    { 0x1eb6, 0x1eb6 },
    { 0x1eb8, 0x1eb8 },
    { 0x1eba, 0x1eba },
    { 0x1ebc, 0x1ebc },
    { 0x1ebe, 0x1ebe },
    { 0x1ec0, 0x1ec0 },
    { 0x1ec2, 0x1ec2 },
    { 0x1ec4, 0x1ec4 },
    { 0x1ec6, 0x1ec6 },
    { 0x1ec8, 0x1ec8 },
    { 0x1eca, 0x1eca },
    { 0x1ecc, 0x1ecc },
    { 0x1ece, 0x1ece },
    { 0x1ed0, 0x1ed0 },
    { 0x1ed2, 0x1ed2 },
    { 0x1ed4, 0x1ed4 },
    { 0x1ed6, 0x1ed6 },
    { 0x1ed8, 0x1ed8 },
    { 0x1eda, 0x1eda },
    { 0x1edc, 0x1edc },
    { 0x1ede, 0x1ede },
    { 0x1ee0, 0x1ee0 },
    { 0x1ee2, 0x1ee2 },
    { 0x1ee4, 0x1ee4 },
    { 0x1ee6, 0x1ee6 },
    { 0x1ee8, 0x1ee8 },
    { 0x1eea, 0x1eea },
    { 0x1eec, 0x1eec },
    { 0x1eee, 0x1eee },
    { 0x1ef0, 0x1ef0 },
    { 0x1ef2, 0x1ef2 },
    { 0x1ef4, 0x1ef4 },
    { 0x1ef6, 0x1ef6 },
    { 0x1ef8, 0x1ef8 },
    { 0x1f08, 0x1f0f },
    { 0x1f18, 0x1f1d },
    { 0x1f28, 0x1f2f },
    { 0x1f38, 0x1f3f },
    { 0x1f48, 0x1f4d },
    { 0x1f59, 0x1f59 },
    { 0x1f5b, 0x1f5b },
    { 0x1f5d, 0x1f5d },
    { 0x1f5f, 0x1f5f },
    { 0x1f68, 0x1f6f },
    { 0x1f88, 0x1f8f },
    { 0x1f98, 0x1f9f },
    { 0x1fa8, 0x1faf },
    { 0x1fb8, 0x1fb9 },
    { 0x1fba, 0x1fbb },
    { 0x1fbc, 0x1fbc },
    { 0x1fc8, 0x1fcb },
    { 0x1fcc, 0x1fcc },
    { 0x1fd8, 0x1fd9 },
    { 0x1fda, 0x1fdb },
    { 0x1fe8, 0x1fe9 },
    { 0x1fea, 0x1feb },
    { 0x1fec, 0x1fec },
    { 0x1ff8, 0x1ff9 },
    { 0x1ffa, 0x1ffb },
    { 0x1ffc, 0x1ffc },
    { 0x2160, 0x216f },
    { 0x24b6, 0x24cf },
    { 0xff21, 0xff3a }
  };

static const jchar upper_case_map_table[] =
  { 0x0061, 0x00e0, 0x00f8, 0x0101, 0x0103, 
    0x0105, 0x0107, 0x0109, 0x010b, 0x010d, 
    0x010f, 0x0111, 0x0113, 0x0115, 0x0117, 
    0x0119, 0x011b, 0x011d, 0x011f, 0x0121, 
    0x0123, 0x0125, 0x0127, 0x0129, 0x012b, 
    0x012d, 0x012f, 0x0069, 0x0133, 0x0135, 
    0x0137, 0x013a, 0x013c, 0x013e, 0x0140, 
    0x0142, 0x0144, 0x0146, 0x0148, 0x014b, 
    0x014d, 0x014f, 0x0151, 0x0153, 0x0155, 
    0x0157, 0x0159, 0x015b, 0x015d, 0x015f, 
    0x0161, 0x0163, 0x0165, 0x0167, 0x0169, 
    0x016b, 0x016d, 0x016f, 0x0171, 0x0173, 
    0x0175, 0x0177, 0x00ff, 0x017a, 0x017c, 
    0x017e, 0x0253, 0x0183, 0x0185, 0x0254, 
    0x0188, 0x0256, 0x018c, 0x01dd, 0x0259, 
    0x025b, 0x0192, 0x0260, 0x0263, 0x0269, 
    0x0268, 0x0199, 0x026f, 0x0272, 0x0275, 
    0x01a1, 0x01a3, 0x01a5, 0x0280, 0x01a8, 
    0x0283, 0x01ad, 0x0288, 0x01b0, 0x028a, 
    0x01b4, 0x01b6, 0x0292, 0x01b9, 0x01bd, 
    0x01c6, 0x01c9, 0x01cc, 0x01ce, 0x01d0, 
    0x01d2, 0x01d4, 0x01d6, 0x01d8, 0x01da, 
    0x01dc, 0x01df, 0x01e1, 0x01e3, 0x01e5, 
    0x01e7, 0x01e9, 0x01eb, 0x01ed, 0x01ef, 
    0x01f3, 0x01f5, 0x01fb, 0x01fd, 0x01ff, 
    0x0201, 0x0203, 0x0205, 0x0207, 0x0209, 
    0x020b, 0x020d, 0x020f, 0x0211, 0x0213, 
    0x0215, 0x0217, 0x03ac, 0x03ad, 0x03cc, 
    0x03cd, 0x03b1, 0x03c3, 0x03e3, 0x03e5, 
    0x03e7, 0x03e9, 0x03eb, 0x03ed, 0x03ef, 
    0x0451, 0x045e, 0x0430, 0x0461, 0x0463, 
    0x0465, 0x0467, 0x0469, 0x046b, 0x046d, 
    0x046f, 0x0471, 0x0473, 0x0475, 0x0477, 
    0x0479, 0x047b, 0x047d, 0x047f, 0x0481, 
    0x0491, 0x0493, 0x0495, 0x0497, 0x0499, 
    0x049b, 0x049d, 0x049f, 0x04a1, 0x04a3, 
    0x04a5, 0x04a7, 0x04a9, 0x04ab, 0x04ad, 
    0x04af, 0x04b1, 0x04b3, 0x04b5, 0x04b7, 
    0x04b9, 0x04bb, 0x04bd, 0x04bf, 0x04c2, 
    0x04c4, 0x04c8, 0x04cc, 0x04d1, 0x04d3, 
    0x04d5, 0x04d7, 0x04d9, 0x04db, 0x04dd, 
    0x04df, 0x04e1, 0x04e3, 0x04e5, 0x04e7, 
    0x04e9, 0x04eb, 0x04ef, 0x04f1, 0x04f3, 
    0x04f5, 0x04f9, 0x0561, 0x10d0, 0x1e01, 
    0x1e03, 0x1e05, 0x1e07, 0x1e09, 0x1e0b, 
    0x1e0d, 0x1e0f, 0x1e11, 0x1e13, 0x1e15, 
    0x1e17, 0x1e19, 0x1e1b, 0x1e1d, 0x1e1f, 
    0x1e21, 0x1e23, 0x1e25, 0x1e27, 0x1e29, 
    0x1e2b, 0x1e2d, 0x1e2f, 0x1e31, 0x1e33, 
    0x1e35, 0x1e37, 0x1e39, 0x1e3b, 0x1e3d, 
    0x1e3f, 0x1e41, 0x1e43, 0x1e45, 0x1e47, 
    0x1e49, 0x1e4b, 0x1e4d, 0x1e4f, 0x1e51, 
    0x1e53, 0x1e55, 0x1e57, 0x1e59, 0x1e5b, 
    0x1e5d, 0x1e5f, 0x1e61, 0x1e63, 0x1e65, 
    0x1e67, 0x1e69, 0x1e6b, 0x1e6d, 0x1e6f, 
    0x1e71, 0x1e73, 0x1e75, 0x1e77, 0x1e79, 
    0x1e7b, 0x1e7d, 0x1e7f, 0x1e81, 0x1e83, 
    0x1e85, 0x1e87, 0x1e89, 0x1e8b, 0x1e8d, 
    0x1e8f, 0x1e91, 0x1e93, 0x1e95, 0x1ea1, 
    0x1ea3, 0x1ea5, 0x1ea7, 0x1ea9, 0x1eab, 
    0x1ead, 0x1eaf, 0x1eb1, 0x1eb3, 0x1eb5, 
    0x1eb7, 0x1eb9, 0x1ebb, 0x1ebd, 0x1ebf, 
    0x1ec1, 0x1ec3, 0x1ec5, 0x1ec7, 0x1ec9, 
    0x1ecb, 0x1ecd, 0x1ecf, 0x1ed1, 0x1ed3, 
    0x1ed5, 0x1ed7, 0x1ed9, 0x1edb, 0x1edd, 
    0x1edf, 0x1ee1, 0x1ee3, 0x1ee5, 0x1ee7, 
    0x1ee9, 0x1eeb, 0x1eed, 0x1eef, 0x1ef1, 
    0x1ef3, 0x1ef5, 0x1ef7, 0x1ef9, 0x1f00, 
    0x1f10, 0x1f20, 0x1f30, 0x1f40, 0x1f51, 
    0x1f53, 0x1f55, 0x1f57, 0x1f60, 0x1f80, 
    0x1f90, 0x1fa0, 0x1fb0, 0x1f70, 0x1fb3, 
    0x1f72, 0x1fc3, 0x1fd0, 0x1f76, 0x1fe0, 
    0x1f7a, 0x1fe5, 0x1f78, 0x1f7c, 0x1ff3, 
    0x2170, 0x24d0, 0xff41  };

static const jchar lower_case_table[][2] =
  {
    { 0x0061, 0x007a },
    { 0x00e0, 0x00f6 },
    { 0x00f8, 0x00fe },
    { 0x00ff, 0x00ff },
    { 0x0101, 0x0101 },
    { 0x0103, 0x0103 },
    { 0x0105, 0x0105 },
    { 0x0107, 0x0107 },
    { 0x0109, 0x0109 },
    { 0x010b, 0x010b },
    { 0x010d, 0x010d },
    { 0x010f, 0x010f },
    { 0x0111, 0x0111 },
    { 0x0113, 0x0113 },
    { 0x0115, 0x0115 },
    { 0x0117, 0x0117 },
    { 0x0119, 0x0119 },
    { 0x011b, 0x011b },
    { 0x011d, 0x011d },
    { 0x011f, 0x011f },
    { 0x0121, 0x0121 },
    { 0x0123, 0x0123 },
    { 0x0125, 0x0125 },
    { 0x0127, 0x0127 },
    { 0x0129, 0x0129 },
    { 0x012b, 0x012b },
    { 0x012d, 0x012d },
    { 0x012f, 0x012f },
    { 0x0131, 0x0131 },
    { 0x0133, 0x0133 },
    { 0x0135, 0x0135 },
    { 0x0137, 0x0137 },
    { 0x013a, 0x013a },
    { 0x013c, 0x013c },
    { 0x013e, 0x013e },
    { 0x0140, 0x0140 },
    { 0x0142, 0x0142 },
    { 0x0144, 0x0144 },
    { 0x0146, 0x0146 },
    { 0x0148, 0x0148 },
    { 0x014b, 0x014b },
    { 0x014d, 0x014d },
    { 0x014f, 0x014f },
    { 0x0151, 0x0151 },
    { 0x0153, 0x0153 },
    { 0x0155, 0x0155 },
    { 0x0157, 0x0157 },
    { 0x0159, 0x0159 },
    { 0x015b, 0x015b },
    { 0x015d, 0x015d },
    { 0x015f, 0x015f },
    { 0x0161, 0x0161 },
    { 0x0163, 0x0163 },
    { 0x0165, 0x0165 },
    { 0x0167, 0x0167 },
    { 0x0169, 0x0169 },
    { 0x016b, 0x016b },
    { 0x016d, 0x016d },
    { 0x016f, 0x016f },
    { 0x0171, 0x0171 },
    { 0x0173, 0x0173 },
    { 0x0175, 0x0175 },
    { 0x0177, 0x0177 },
    { 0x017a, 0x017a },
    { 0x017c, 0x017c },
    { 0x017e, 0x017e },
    { 0x017f, 0x017f },
    { 0x0183, 0x0183 },
    { 0x0185, 0x0185 },
    { 0x0188, 0x0188 },
    { 0x018c, 0x018c },
    { 0x0192, 0x0192 },
    { 0x0199, 0x0199 },
    { 0x01a1, 0x01a1 },
    { 0x01a3, 0x01a3 },
    { 0x01a5, 0x01a5 },
    { 0x01a8, 0x01a8 },
    { 0x01ad, 0x01ad },
    { 0x01b0, 0x01b0 },
    { 0x01b4, 0x01b4 },
    { 0x01b6, 0x01b6 },
    { 0x01b9, 0x01b9 },
    { 0x01bd, 0x01bd },
    { 0x01c6, 0x01c6 },
    { 0x01c9, 0x01c9 },
    { 0x01cc, 0x01cc },
    { 0x01ce, 0x01ce },
    { 0x01d0, 0x01d0 },
    { 0x01d2, 0x01d2 },
    { 0x01d4, 0x01d4 },
    { 0x01d6, 0x01d6 },
    { 0x01d8, 0x01d8 },
    { 0x01da, 0x01da },
    { 0x01dc, 0x01dc },
    { 0x01dd, 0x01dd },
    { 0x01df, 0x01df },
    { 0x01e1, 0x01e1 },
    { 0x01e3, 0x01e3 },
    { 0x01e5, 0x01e5 },
    { 0x01e7, 0x01e7 },
    { 0x01e9, 0x01e9 },
    { 0x01eb, 0x01eb },
    { 0x01ed, 0x01ed },
    { 0x01ef, 0x01ef },
    { 0x01f3, 0x01f3 },
    { 0x01f5, 0x01f5 },
    { 0x01fb, 0x01fb },
    { 0x01fd, 0x01fd },
    { 0x01ff, 0x01ff },
    { 0x0201, 0x0201 },
    { 0x0203, 0x0203 },
    { 0x0205, 0x0205 },
    { 0x0207, 0x0207 },
    { 0x0209, 0x0209 },
    { 0x020b, 0x020b },
    { 0x020d, 0x020d },
    { 0x020f, 0x020f },
    { 0x0211, 0x0211 },
    { 0x0213, 0x0213 },
    { 0x0215, 0x0215 },
    { 0x0217, 0x0217 },
    { 0x0253, 0x0253 },
    { 0x0254, 0x0254 },
    { 0x0256, 0x0257 },
    { 0x0259, 0x0259 },
    { 0x025b, 0x025b },
    { 0x0260, 0x0260 },
    { 0x0263, 0x0263 },
    { 0x0268, 0x0268 },
    { 0x0269, 0x0269 },
    { 0x026f, 0x026f },
    { 0x0272, 0x0272 },
    { 0x0275, 0x0275 },
    { 0x0280, 0x0280 },
    { 0x0283, 0x0283 },
    { 0x0288, 0x0288 },
    { 0x028a, 0x028b },
    { 0x0292, 0x0292 },
    { 0x0345, 0x0345 },
    { 0x03ac, 0x03ac },
    { 0x03ad, 0x03af },
    { 0x03b1, 0x03c1 },
    { 0x03c2, 0x03c2 },
    { 0x03c3, 0x03cb },
    { 0x03cc, 0x03cc },
    { 0x03cd, 0x03ce },
    { 0x03d0, 0x03d0 },
    { 0x03d1, 0x03d1 },
    { 0x03d5, 0x03d5 },
    { 0x03d6, 0x03d6 },
    { 0x03e3, 0x03e3 },
    { 0x03e5, 0x03e5 },
    { 0x03e7, 0x03e7 },
    { 0x03e9, 0x03e9 },
    { 0x03eb, 0x03eb },
    { 0x03ed, 0x03ed },
    { 0x03ef, 0x03ef },
    { 0x03f0, 0x03f0 },
    { 0x03f1, 0x03f1 },
    { 0x03f2, 0x03f2 },
    { 0x0430, 0x044f },
    { 0x0451, 0x045c },
    { 0x045e, 0x045f },
    { 0x0461, 0x0461 },
    { 0x0463, 0x0463 },
    { 0x0465, 0x0465 },
    { 0x0467, 0x0467 },
    { 0x0469, 0x0469 },
    { 0x046b, 0x046b },
    { 0x046d, 0x046d },
    { 0x046f, 0x046f },
    { 0x0471, 0x0471 },
    { 0x0473, 0x0473 },
    { 0x0475, 0x0475 },
    { 0x0477, 0x0477 },
    { 0x0479, 0x0479 },
    { 0x047b, 0x047b },
    { 0x047d, 0x047d },
    { 0x047f, 0x047f },
    { 0x0481, 0x0481 },
    { 0x0491, 0x0491 },
    { 0x0493, 0x0493 },
    { 0x0495, 0x0495 },
    { 0x0497, 0x0497 },
    { 0x0499, 0x0499 },
    { 0x049b, 0x049b },
    { 0x049d, 0x049d },
    { 0x049f, 0x049f },
    { 0x04a1, 0x04a1 },
    { 0x04a3, 0x04a3 },
    { 0x04a5, 0x04a5 },
    { 0x04a7, 0x04a7 },
    { 0x04a9, 0x04a9 },
    { 0x04ab, 0x04ab },
    { 0x04ad, 0x04ad },
    { 0x04af, 0x04af },
    { 0x04b1, 0x04b1 },
    { 0x04b3, 0x04b3 },
    { 0x04b5, 0x04b5 },
    { 0x04b7, 0x04b7 },
    { 0x04b9, 0x04b9 },
    { 0x04bb, 0x04bb },
    { 0x04bd, 0x04bd },
    { 0x04bf, 0x04bf },
    { 0x04c2, 0x04c2 },
    { 0x04c4, 0x04c4 },
    { 0x04c8, 0x04c8 },
    { 0x04cc, 0x04cc },
    { 0x04d1, 0x04d1 },
    { 0x04d3, 0x04d3 },
    { 0x04d5, 0x04d5 },
    { 0x04d7, 0x04d7 },
    { 0x04d9, 0x04d9 },
    { 0x04db, 0x04db },
    { 0x04dd, 0x04dd },
    { 0x04df, 0x04df },
    { 0x04e1, 0x04e1 },
    { 0x04e3, 0x04e3 },
    { 0x04e5, 0x04e5 },
    { 0x04e7, 0x04e7 },
    { 0x04e9, 0x04e9 },
    { 0x04eb, 0x04eb },
    { 0x04ef, 0x04ef },
    { 0x04f1, 0x04f1 },
    { 0x04f3, 0x04f3 },
    { 0x04f5, 0x04f5 },
    { 0x04f9, 0x04f9 },
    { 0x0561, 0x0586 },
    { 0x1e01, 0x1e01 },
    { 0x1e03, 0x1e03 },
    { 0x1e05, 0x1e05 },
    { 0x1e07, 0x1e07 },
    { 0x1e09, 0x1e09 },
    { 0x1e0b, 0x1e0b },
    { 0x1e0d, 0x1e0d },
    { 0x1e0f, 0x1e0f },
    { 0x1e11, 0x1e11 },
    { 0x1e13, 0x1e13 },
    { 0x1e15, 0x1e15 },
    { 0x1e17, 0x1e17 },
    { 0x1e19, 0x1e19 },
    { 0x1e1b, 0x1e1b },
    { 0x1e1d, 0x1e1d },
    { 0x1e1f, 0x1e1f },
    { 0x1e21, 0x1e21 },
    { 0x1e23, 0x1e23 },
    { 0x1e25, 0x1e25 },
    { 0x1e27, 0x1e27 },
    { 0x1e29, 0x1e29 },
    { 0x1e2b, 0x1e2b },
    { 0x1e2d, 0x1e2d },
    { 0x1e2f, 0x1e2f },
    { 0x1e31, 0x1e31 },
    { 0x1e33, 0x1e33 },
    { 0x1e35, 0x1e35 },
    { 0x1e37, 0x1e37 },
    { 0x1e39, 0x1e39 },
    { 0x1e3b, 0x1e3b },
    { 0x1e3d, 0x1e3d },
    { 0x1e3f, 0x1e3f },
    { 0x1e41, 0x1e41 },
    { 0x1e43, 0x1e43 },
    { 0x1e45, 0x1e45 },
    { 0x1e47, 0x1e47 },
    { 0x1e49, 0x1e49 },
    { 0x1e4b, 0x1e4b },
    { 0x1e4d, 0x1e4d },
    { 0x1e4f, 0x1e4f },
    { 0x1e51, 0x1e51 },
    { 0x1e53, 0x1e53 },
    { 0x1e55, 0x1e55 },
    { 0x1e57, 0x1e57 },
    { 0x1e59, 0x1e59 },
    { 0x1e5b, 0x1e5b },
    { 0x1e5d, 0x1e5d },
    { 0x1e5f, 0x1e5f },
    { 0x1e61, 0x1e61 },
    { 0x1e63, 0x1e63 },
    { 0x1e65, 0x1e65 },
    { 0x1e67, 0x1e67 },
    { 0x1e69, 0x1e69 },
    { 0x1e6b, 0x1e6b },
    { 0x1e6d, 0x1e6d },
    { 0x1e6f, 0x1e6f },
    { 0x1e71, 0x1e71 },
    { 0x1e73, 0x1e73 },
    { 0x1e75, 0x1e75 },
    { 0x1e77, 0x1e77 },
    { 0x1e79, 0x1e79 },
    { 0x1e7b, 0x1e7b },
    { 0x1e7d, 0x1e7d },
    { 0x1e7f, 0x1e7f },
    { 0x1e81, 0x1e81 },
    { 0x1e83, 0x1e83 },
    { 0x1e85, 0x1e85 },
    { 0x1e87, 0x1e87 },
    { 0x1e89, 0x1e89 },
    { 0x1e8b, 0x1e8b },
    { 0x1e8d, 0x1e8d },
    { 0x1e8f, 0x1e8f },
    { 0x1e91, 0x1e91 },
    { 0x1e93, 0x1e93 },
    { 0x1e95, 0x1e95 },
    { 0x1e9b, 0x1e9b },
    { 0x1ea1, 0x1ea1 },
    { 0x1ea3, 0x1ea3 },
    { 0x1ea5, 0x1ea5 },
    { 0x1ea7, 0x1ea7 },
    { 0x1ea9, 0x1ea9 },
    { 0x1eab, 0x1eab },
    { 0x1ead, 0x1ead },
    { 0x1eaf, 0x1eaf },
    { 0x1eb1, 0x1eb1 },
    { 0x1eb3, 0x1eb3 },
    { 0x1eb5, 0x1eb5 },
    { 0x1eb7, 0x1eb7 },
    { 0x1eb9, 0x1eb9 },
    { 0x1ebb, 0x1ebb },
    { 0x1ebd, 0x1ebd },
    { 0x1ebf, 0x1ebf },
    { 0x1ec1, 0x1ec1 },
    { 0x1ec3, 0x1ec3 },
    { 0x1ec5, 0x1ec5 },
    { 0x1ec7, 0x1ec7 },
    { 0x1ec9, 0x1ec9 },
    { 0x1ecb, 0x1ecb },
    { 0x1ecd, 0x1ecd },
    { 0x1ecf, 0x1ecf },
    { 0x1ed1, 0x1ed1 },
    { 0x1ed3, 0x1ed3 },
    { 0x1ed5, 0x1ed5 },
    { 0x1ed7, 0x1ed7 },
    { 0x1ed9, 0x1ed9 },
    { 0x1edb, 0x1edb },
    { 0x1edd, 0x1edd },
    { 0x1edf, 0x1edf },
    { 0x1ee1, 0x1ee1 },
    { 0x1ee3, 0x1ee3 },
    { 0x1ee5, 0x1ee5 },
    { 0x1ee7, 0x1ee7 },
    { 0x1ee9, 0x1ee9 },
    { 0x1eeb, 0x1eeb },
    { 0x1eed, 0x1eed },
    { 0x1eef, 0x1eef },
    { 0x1ef1, 0x1ef1 },
    { 0x1ef3, 0x1ef3 },
    { 0x1ef5, 0x1ef5 },
    { 0x1ef7, 0x1ef7 },
    { 0x1ef9, 0x1ef9 },
    { 0x1f00, 0x1f07 },
    { 0x1f10, 0x1f15 },
    { 0x1f20, 0x1f27 },
    { 0x1f30, 0x1f37 },
    { 0x1f40, 0x1f45 },
    { 0x1f51, 0x1f51 },
    { 0x1f53, 0x1f53 },
    { 0x1f55, 0x1f55 },
    { 0x1f57, 0x1f57 },
    { 0x1f60, 0x1f67 },
    { 0x1f70, 0x1f71 },
    { 0x1f72, 0x1f75 },
    { 0x1f76, 0x1f77 },
    { 0x1f78, 0x1f79 },
    { 0x1f7a, 0x1f7b },
    { 0x1f7c, 0x1f7d },
    { 0x1f80, 0x1f87 },
    { 0x1f90, 0x1f97 },
    { 0x1fa0, 0x1fa7 },
    { 0x1fb0, 0x1fb1 },
    { 0x1fb3, 0x1fb3 },
    { 0x1fbe, 0x1fbe },
    { 0x1fc3, 0x1fc3 },
    { 0x1fd0, 0x1fd1 },
    { 0x1fe0, 0x1fe1 },
    { 0x1fe5, 0x1fe5 },
    { 0x1ff3, 0x1ff3 },
    { 0x2170, 0x217f },
    { 0x24d0, 0x24e9 },
    { 0xff41, 0xff5a }
  };

static const jchar lower_case_map_table[] =
  { 0x0041, 0x00c0, 0x00d8, 0x0178, 0x0100, 
    0x0102, 0x0104, 0x0106, 0x0108, 0x010a, 
    0x010c, 0x010e, 0x0110, 0x0112, 0x0114, 
    0x0116, 0x0118, 0x011a, 0x011c, 0x011e, 
    0x0120, 0x0122, 0x0124, 0x0126, 0x0128, 
    0x012a, 0x012c, 0x012e, 0x0049, 0x0132, 
    0x0134, 0x0136, 0x0139, 0x013b, 0x013d, 
    0x013f, 0x0141, 0x0143, 0x0145, 0x0147, 
    0x014a, 0x014c, 0x014e, 0x0150, 0x0152, 
    0x0154, 0x0156, 0x0158, 0x015a, 0x015c, 
    0x015e, 0x0160, 0x0162, 0x0164, 0x0166, 
    0x0168, 0x016a, 0x016c, 0x016e, 0x0170, 
    0x0172, 0x0174, 0x0176, 0x0179, 0x017b, 
    0x017d, 0x0053, 0x0182, 0x0184, 0x0187, 
    0x018b, 0x0191, 0x0198, 0x01a0, 0x01a2, 
    0x01a4, 0x01a7, 0x01ac, 0x01af, 0x01b3, 
    0x01b5, 0x01b8, 0x01bc, 0x01c4, 0x01c7, 
    0x01ca, 0x01cd, 0x01cf, 0x01d1, 0x01d3, 
    0x01d5, 0x01d7, 0x01d9, 0x01db, 0x018e, 
    0x01de, 0x01e0, 0x01e2, 0x01e4, 0x01e6, 
    0x01e8, 0x01ea, 0x01ec, 0x01ee, 0x01f1, 
    0x01f4, 0x01fa, 0x01fc, 0x01fe, 0x0200, 
    0x0202, 0x0204, 0x0206, 0x0208, 0x020a, 
    0x020c, 0x020e, 0x0210, 0x0212, 0x0214, 
    0x0216, 0x0181, 0x0186, 0x0189, 0x018f, 
    0x0190, 0x0193, 0x0194, 0x0197, 0x0196, 
    0x019c, 0x019d, 0x019f, 0x01a6, 0x01a9, 
    0x01ae, 0x01b1, 0x01b7, 0x0399, 0x0386, 
    0x0388, 0x0391, 0x03a3, 0x03a3, 0x038c, 
    0x038e, 0x0392, 0x0398, 0x03a6, 0x03a0, 
    0x03e2, 0x03e4, 0x03e6, 0x03e8, 0x03ea, 
    0x03ec, 0x03ee, 0x039a, 0x03a1, 0x03a3, 
    0x0410, 0x0401, 0x040e, 0x0460, 0x0462, 
    0x0464, 0x0466, 0x0468, 0x046a, 0x046c, 
    0x046e, 0x0470, 0x0472, 0x0474, 0x0476, 
    0x0478, 0x047a, 0x047c, 0x047e, 0x0480, 
    0x0490, 0x0492, 0x0494, 0x0496, 0x0498, 
    0x049a, 0x049c, 0x049e, 0x04a0, 0x04a2, 
    0x04a4, 0x04a6, 0x04a8, 0x04aa, 0x04ac, 
    0x04ae, 0x04b0, 0x04b2, 0x04b4, 0x04b6, 
    0x04b8, 0x04ba, 0x04bc, 0x04be, 0x04c1, 
    0x04c3, 0x04c7, 0x04cb, 0x04d0, 0x04d2, 
    0x04d4, 0x04d6, 0x04d8, 0x04da, 0x04dc, 
    0x04de, 0x04e0, 0x04e2, 0x04e4, 0x04e6, 
    0x04e8, 0x04ea, 0x04ee, 0x04f0, 0x04f2, 
    0x04f4, 0x04f8, 0x0531, 0x1e00, 0x1e02, 
    0x1e04, 0x1e06, 0x1e08, 0x1e0a, 0x1e0c, 
    0x1e0e, 0x1e10, 0x1e12, 0x1e14, 0x1e16, 
    0x1e18, 0x1e1a, 0x1e1c, 0x1e1e, 0x1e20, 
    0x1e22, 0x1e24, 0x1e26, 0x1e28, 0x1e2a, 
    0x1e2c, 0x1e2e, 0x1e30, 0x1e32, 0x1e34, 
    0x1e36, 0x1e38, 0x1e3a, 0x1e3c, 0x1e3e, 
    0x1e40, 0x1e42, 0x1e44, 0x1e46, 0x1e48, 
    0x1e4a, 0x1e4c, 0x1e4e, 0x1e50, 0x1e52, 
    0x1e54, 0x1e56, 0x1e58, 0x1e5a, 0x1e5c, 
    0x1e5e, 0x1e60, 0x1e62, 0x1e64, 0x1e66, 
    0x1e68, 0x1e6a, 0x1e6c, 0x1e6e, 0x1e70, 
    0x1e72, 0x1e74, 0x1e76, 0x1e78, 0x1e7a, 
    0x1e7c, 0x1e7e, 0x1e80, 0x1e82, 0x1e84, 
    0x1e86, 0x1e88, 0x1e8a, 0x1e8c, 0x1e8e, 
    0x1e90, 0x1e92, 0x1e94, 0x1e60, 0x1ea0, 
    0x1ea2, 0x1ea4, 0x1ea6, 0x1ea8, 0x1eaa, 
    0x1eac, 0x1eae, 0x1eb0, 0x1eb2, 0x1eb4, 
    0x1eb6, 0x1eb8, 0x1eba, 0x1ebc, 0x1ebe, 
    0x1ec0, 0x1ec2, 0x1ec4, 0x1ec6, 0x1ec8, 
    0x1eca, 0x1ecc, 0x1ece, 0x1ed0, 0x1ed2, 
    0x1ed4, 0x1ed6, 0x1ed8, 0x1eda, 0x1edc, 
    0x1ede, 0x1ee0, 0x1ee2, 0x1ee4, 0x1ee6, 
    0x1ee8, 0x1eea, 0x1eec, 0x1eee, 0x1ef0, 
    0x1ef2, 0x1ef4, 0x1ef6, 0x1ef8, 0x1f08, 
    0x1f18, 0x1f28, 0x1f38, 0x1f48, 0x1f59, 
    0x1f5b, 0x1f5d, 0x1f5f, 0x1f68, 0x1fba, 
    0x1fc8, 0x1fda, 0x1ff8, 0x1fea, 0x1ffa, 
    0x1f88, 0x1f98, 0x1fa8, 0x1fb8, 0x1fbc, 
    0x0399, 0x1fcc, 0x1fd8, 0x1fe8, 0x1fec, 
    0x1ffc, 0x2160, 0x24b6, 0xff21  };

static const jchar lower_anomalous_table[] =
  { 0x00df, 0x0138, 0x0149, 0x0180, 0x018d, 
    0x0195, 0x019a, 0x019b, 0x019e, 0x01ab, 
    0x01ba, 0x01f0, 0x0250, 0x0251, 0x0252, 
    0x0255, 0x0258, 0x025a, 0x025c, 0x025d, 
    0x025e, 0x025f, 0x0261, 0x0264, 0x0265, 
    0x0266, 0x0267, 0x026b, 0x026c, 0x026d, 
    0x026e, 0x0270, 0x0271, 0x0273, 0x0277, 
    0x0278, 0x0279, 0x027a, 0x027b, 0x027c, 
    0x027d, 0x027e, 0x027f, 0x0282, 0x0284, 
    0x0285, 0x0286, 0x0287, 0x0289, 0x028c, 
    0x028d, 0x028e, 0x0290, 0x0291, 0x0293, 
    0x029a, 0x029d, 0x029e, 0x02a0, 0x02a3, 
    0x02a4, 0x02a5, 0x02a6, 0x02a7, 0x02a8, 
    0x0390, 0x03b0, 0x0587, 0x1e96, 0x1e97, 
    0x1e98, 0x1e99, 0x1e9a, 0x1f50, 0x1f52, 
    0x1f54, 0x1f56, 0x1fb2, 0x1fb4, 0x1fb6, 
    0x1fb7, 0x1fc2, 0x1fc4, 0x1fc6, 0x1fc7, 
    0x1fd2, 0x1fd3, 0x1fd6, 0x1fd7, 0x1fe2, 
    0x1fe3, 0x1fe4, 0x1fe6, 0x1fe7, 0x1ff2, 
    0x1ff4, 0x1ff6, 0x1ff7, 0x207f, 0x2129, 
    0x249c, 0x249d, 0x249e, 0x249f, 0x24a0, 
    0x24a1, 0x24a2, 0x24a3, 0x24a4, 0x24a5, 
    0x24a6, 0x24a7, 0x24a8, 0x24a9, 0x24aa, 
    0x24ab, 0x24ac, 0x24ad, 0x24ae, 0x24af, 
    0x24b0, 0x24b1, 0x24b2, 0x24b3, 0x24b4, 
    0x24b5, 0xfb00, 0xfb01, 0xfb02, 0xfb03, 
    0xfb04, 0xfb05, 0xfb06, 0xfb13, 0xfb14, 
    0xfb15, 0xfb16, 0xfb17  };

static const jchar all_table[][2] =
  {
    { 0x0000, 0x001f },
    { 0x0020, 0x0020 },
    { 0x0021, 0x0023 },
    { 0x0024, 0x0024 },
    { 0x0025, 0x0027 },
    { 0x0028, 0x0028 },
    { 0x0029, 0x0029 },
    { 0x002a, 0x002a },
    { 0x002b, 0x002b },
    { 0x002c, 0x002c },
    { 0x002d, 0x002d },
    { 0x002e, 0x002f },
    { 0x0030, 0x0039 },
    { 0x003a, 0x003b },
    { 0x003c, 0x003e },
    { 0x003f, 0x0040 },
    { 0x0041, 0x005a },
    { 0x005b, 0x005b },
    { 0x005c, 0x005c },
    { 0x005d, 0x005d },
    { 0x005e, 0x005e },
    { 0x005f, 0x005f },
    { 0x0060, 0x0060 },
    { 0x0061, 0x007a },
    { 0x007b, 0x007b },
    { 0x007c, 0x007c },
    { 0x007d, 0x007d },
    { 0x007e, 0x007e },
    { 0x007f, 0x009f },
    { 0x00a0, 0x00a0 },
    { 0x00a1, 0x00a1 },
    { 0x00a2, 0x00a5 },
    { 0x00a6, 0x00a7 },
    { 0x00a8, 0x00a8 },
    { 0x00a9, 0x00a9 },
    { 0x00aa, 0x00aa },
    { 0x00ab, 0x00ab },
    { 0x00ac, 0x00ac },
    { 0x00ad, 0x00ad },
    { 0x00ae, 0x00ae },
    { 0x00af, 0x00af },
    { 0x00b0, 0x00b0 },
    { 0x00b1, 0x00b1 },
    { 0x00b2, 0x00b3 },
    { 0x00b4, 0x00b4 },
    { 0x00b5, 0x00b5 },
    { 0x00b6, 0x00b6 },
    { 0x00b7, 0x00b7 },
    { 0x00b8, 0x00b8 },
    { 0x00b9, 0x00b9 },
    { 0x00ba, 0x00ba },
    { 0x00bb, 0x00bb },
    { 0x00bc, 0x00be },
    { 0x00bf, 0x00bf },
    { 0x00c0, 0x00d6 },
    { 0x00d7, 0x00d7 },
    { 0x00d8, 0x00de },
    { 0x00df, 0x00f6 },
    { 0x00f7, 0x00f7 },
    { 0x00f8, 0x00ff },
    { 0x0100, 0x0100 },
    { 0x0101, 0x0101 },
    { 0x0102, 0x0102 },
    { 0x0103, 0x0103 },
    { 0x0104, 0x0104 },
    { 0x0105, 0x0105 },
    { 0x0106, 0x0106 },
    { 0x0107, 0x0107 },
    { 0x0108, 0x0108 },
    { 0x0109, 0x0109 },
    { 0x010a, 0x010a },
    { 0x010b, 0x010b },
    { 0x010c, 0x010c },
    { 0x010d, 0x010d },
    { 0x010e, 0x010e },
    { 0x010f, 0x010f },
    { 0x0110, 0x0110 },
    { 0x0111, 0x0111 },
    { 0x0112, 0x0112 },
    { 0x0113, 0x0113 },
    { 0x0114, 0x0114 },
    { 0x0115, 0x0115 },
    { 0x0116, 0x0116 },
    { 0x0117, 0x0117 },
    { 0x0118, 0x0118 },
    { 0x0119, 0x0119 },
    { 0x011a, 0x011a },
    { 0x011b, 0x011b },
    { 0x011c, 0x011c },
    { 0x011d, 0x011d },
    { 0x011e, 0x011e },
    { 0x011f, 0x011f },
    { 0x0120, 0x0120 },
    { 0x0121, 0x0121 },
    { 0x0122, 0x0122 },
    { 0x0123, 0x0123 },
    { 0x0124, 0x0124 },
    { 0x0125, 0x0125 },
    { 0x0126, 0x0126 },
    { 0x0127, 0x0127 },
    { 0x0128, 0x0128 },
    { 0x0129, 0x0129 },
    { 0x012a, 0x012a },
    { 0x012b, 0x012b },
    { 0x012c, 0x012c },
    { 0x012d, 0x012d },
    { 0x012e, 0x012e },
    { 0x012f, 0x012f },
    { 0x0130, 0x0130 },
    { 0x0131, 0x0131 },
    { 0x0132, 0x0132 },
    { 0x0133, 0x0133 },
    { 0x0134, 0x0134 },
    { 0x0135, 0x0135 },
    { 0x0136, 0x0136 },
    { 0x0137, 0x0138 },
    { 0x0139, 0x0139 },
    { 0x013a, 0x013a },
    { 0x013b, 0x013b },
    { 0x013c, 0x013c },
    { 0x013d, 0x013d },
    { 0x013e, 0x013e },
    { 0x013f, 0x013f },
    { 0x0140, 0x0140 },
    { 0x0141, 0x0141 },
    { 0x0142, 0x0142 },
    { 0x0143, 0x0143 },
    { 0x0144, 0x0144 },
    { 0x0145, 0x0145 },
    { 0x0146, 0x0146 },
    { 0x0147, 0x0147 },
    { 0x0148, 0x0149 },
    { 0x014a, 0x014a },
    { 0x014b, 0x014b },
    { 0x014c, 0x014c },
    { 0x014d, 0x014d },
    { 0x014e, 0x014e },
    { 0x014f, 0x014f },
    { 0x0150, 0x0150 },
    { 0x0151, 0x0151 },
    { 0x0152, 0x0152 },
    { 0x0153, 0x0153 },
    { 0x0154, 0x0154 },
    { 0x0155, 0x0155 },
    { 0x0156, 0x0156 },
    { 0x0157, 0x0157 },
    { 0x0158, 0x0158 },
    { 0x0159, 0x0159 },
    { 0x015a, 0x015a },
    { 0x015b, 0x015b },
    { 0x015c, 0x015c },
    { 0x015d, 0x015d },
    { 0x015e, 0x015e },
    { 0x015f, 0x015f },
    { 0x0160, 0x0160 },
    { 0x0161, 0x0161 },
    { 0x0162, 0x0162 },
    { 0x0163, 0x0163 },
    { 0x0164, 0x0164 },
    { 0x0165, 0x0165 },
    { 0x0166, 0x0166 },
    { 0x0167, 0x0167 },
    { 0x0168, 0x0168 },
    { 0x0169, 0x0169 },
    { 0x016a, 0x016a },
    { 0x016b, 0x016b },
    { 0x016c, 0x016c },
    { 0x016d, 0x016d },
    { 0x016e, 0x016e },
    { 0x016f, 0x016f },
    { 0x0170, 0x0170 },
    { 0x0171, 0x0171 },
    { 0x0172, 0x0172 },
    { 0x0173, 0x0173 },
    { 0x0174, 0x0174 },
    { 0x0175, 0x0175 },
    { 0x0176, 0x0176 },
    { 0x0177, 0x0177 },
    { 0x0178, 0x0179 },
    { 0x017a, 0x017a },
    { 0x017b, 0x017b },
    { 0x017c, 0x017c },
    { 0x017d, 0x017d },
    { 0x017e, 0x0180 },
    { 0x0181, 0x0182 },
    { 0x0183, 0x0183 },
    { 0x0184, 0x0184 },
    { 0x0185, 0x0185 },
    { 0x0186, 0x0187 },
    { 0x0188, 0x0188 },
    { 0x0189, 0x018b },
    { 0x018c, 0x018d },
    { 0x018e, 0x0191 },
    { 0x0192, 0x0192 },
    { 0x0193, 0x0194 },
    { 0x0195, 0x0195 },
    { 0x0196, 0x0198 },
    { 0x0199, 0x019b },
    { 0x019c, 0x019d },
    { 0x019e, 0x019e },
    { 0x019f, 0x01a0 },
    { 0x01a1, 0x01a1 },
    { 0x01a2, 0x01a2 },
    { 0x01a3, 0x01a3 },
    { 0x01a4, 0x01a4 },
    { 0x01a5, 0x01a5 },
    { 0x01a6, 0x01a7 },
    { 0x01a8, 0x01a8 },
    { 0x01a9, 0x01a9 },
    { 0x01aa, 0x01aa },
    { 0x01ab, 0x01ab },
    { 0x01ac, 0x01ac },
    { 0x01ad, 0x01ad },
    { 0x01ae, 0x01af },
    { 0x01b0, 0x01b0 },
    { 0x01b1, 0x01b3 },
    { 0x01b4, 0x01b4 },
    { 0x01b5, 0x01b5 },
    { 0x01b6, 0x01b6 },
    { 0x01b7, 0x01b8 },
    { 0x01b9, 0x01ba },
    { 0x01bb, 0x01bb },
    { 0x01bc, 0x01bc },
    { 0x01bd, 0x01bd },
    { 0x01be, 0x01c3 },
    { 0x01c4, 0x01c4 },
    { 0x01c5, 0x01c5 },
    { 0x01c6, 0x01c6 },
    { 0x01c7, 0x01c7 },
    { 0x01c8, 0x01c8 },
    { 0x01c9, 0x01c9 },
    { 0x01ca, 0x01ca },
    { 0x01cb, 0x01cb },
    { 0x01cc, 0x01cc },
    { 0x01cd, 0x01cd },
    { 0x01ce, 0x01ce },
    { 0x01cf, 0x01cf },
    { 0x01d0, 0x01d0 },
    { 0x01d1, 0x01d1 },
    { 0x01d2, 0x01d2 },
    { 0x01d3, 0x01d3 },
    { 0x01d4, 0x01d4 },
    { 0x01d5, 0x01d5 },
    { 0x01d6, 0x01d6 },
    { 0x01d7, 0x01d7 },
    { 0x01d8, 0x01d8 },
    { 0x01d9, 0x01d9 },
    { 0x01da, 0x01da },
    { 0x01db, 0x01db },
    { 0x01dc, 0x01dd },
    { 0x01de, 0x01de },
    { 0x01df, 0x01df },
    { 0x01e0, 0x01e0 },
    { 0x01e1, 0x01e1 },
    { 0x01e2, 0x01e2 },
    { 0x01e3, 0x01e3 },
    { 0x01e4, 0x01e4 },
    { 0x01e5, 0x01e5 },
    { 0x01e6, 0x01e6 },
    { 0x01e7, 0x01e7 },
    { 0x01e8, 0x01e8 },
    { 0x01e9, 0x01e9 },
    { 0x01ea, 0x01ea },
    { 0x01eb, 0x01eb },
    { 0x01ec, 0x01ec },
    { 0x01ed, 0x01ed },
    { 0x01ee, 0x01ee },
    { 0x01ef, 0x01f0 },
    { 0x01f1, 0x01f1 },
    { 0x01f2, 0x01f2 },
    { 0x01f3, 0x01f3 },
    { 0x01f4, 0x01f4 },
    { 0x01f5, 0x01f5 },
    { 0x01f6, 0x01f9 },
    { 0x01fa, 0x01fa },
    { 0x01fb, 0x01fb },
    { 0x01fc, 0x01fc },
    { 0x01fd, 0x01fd },
    { 0x01fe, 0x01fe },
    { 0x01ff, 0x01ff },
    { 0x0200, 0x0200 },
    { 0x0201, 0x0201 },
    { 0x0202, 0x0202 },
    { 0x0203, 0x0203 },
    { 0x0204, 0x0204 },
    { 0x0205, 0x0205 },
    { 0x0206, 0x0206 },
    { 0x0207, 0x0207 },
    { 0x0208, 0x0208 },
    { 0x0209, 0x0209 },
    { 0x020a, 0x020a },
    { 0x020b, 0x020b },
    { 0x020c, 0x020c },
    { 0x020d, 0x020d },
    { 0x020e, 0x020e },
    { 0x020f, 0x020f },
    { 0x0210, 0x0210 },
    { 0x0211, 0x0211 },
    { 0x0212, 0x0212 },
    { 0x0213, 0x0213 },
    { 0x0214, 0x0214 },
    { 0x0215, 0x0215 },
    { 0x0216, 0x0216 },
    { 0x0217, 0x0217 },
    { 0x0218, 0x024f },
    { 0x0250, 0x02a8 },
    { 0x02a9, 0x02af },
    { 0x02b0, 0x02b8 },
    { 0x02b9, 0x02ba },
    { 0x02bb, 0x02c1 },
    { 0x02c2, 0x02cf },
    { 0x02d0, 0x02d1 },
    { 0x02d2, 0x02de },
    { 0x02df, 0x02df },
    { 0x02e0, 0x02e4 },
    { 0x02e5, 0x02e9 },
    { 0x02ea, 0x02ff },
    { 0x0300, 0x0345 },
    { 0x0346, 0x035f },
    { 0x0360, 0x0361 },
    { 0x0362, 0x0373 },
    { 0x0374, 0x0375 },
    { 0x0376, 0x0379 },
    { 0x037a, 0x037a },
    { 0x037b, 0x037d },
    { 0x037e, 0x037e },
    { 0x037f, 0x0383 },
    { 0x0384, 0x0385 },
    { 0x0386, 0x0386 },
    { 0x0387, 0x0387 },
    { 0x0388, 0x038a },
    { 0x038b, 0x038b },
    { 0x038c, 0x038c },
    { 0x038d, 0x038d },
    { 0x038e, 0x038f },
    { 0x0390, 0x0390 },
    { 0x0391, 0x03a1 },
    { 0x03a2, 0x03a2 },
    { 0x03a3, 0x03ab },
    { 0x03ac, 0x03ce },
    { 0x03cf, 0x03cf },
    { 0x03d0, 0x03d1 },
    { 0x03d2, 0x03d4 },
    { 0x03d5, 0x03d6 },
    { 0x03d7, 0x03d9 },
    { 0x03da, 0x03da },
    { 0x03db, 0x03db },
    { 0x03dc, 0x03dc },
    { 0x03dd, 0x03dd },
    { 0x03de, 0x03de },
    { 0x03df, 0x03df },
    { 0x03e0, 0x03e0 },
    { 0x03e1, 0x03e1 },
    { 0x03e2, 0x03e2 },
    { 0x03e3, 0x03e3 },
    { 0x03e4, 0x03e4 },
    { 0x03e5, 0x03e5 },
    { 0x03e6, 0x03e6 },
    { 0x03e7, 0x03e7 },
    { 0x03e8, 0x03e8 },
    { 0x03e9, 0x03e9 },
    { 0x03ea, 0x03ea },
    { 0x03eb, 0x03eb },
    { 0x03ec, 0x03ec },
    { 0x03ed, 0x03ed },
    { 0x03ee, 0x03ee },
    { 0x03ef, 0x03f2 },
    { 0x03f3, 0x03f3 },
    { 0x03f4, 0x0400 },
    { 0x0401, 0x040c },
    { 0x040d, 0x040d },
    { 0x040e, 0x042f },
    { 0x0430, 0x044f },
    { 0x0450, 0x0450 },
    { 0x0451, 0x045c },
    { 0x045d, 0x045d },
    { 0x045e, 0x045f },
    { 0x0460, 0x0460 },
    { 0x0461, 0x0461 },
    { 0x0462, 0x0462 },
    { 0x0463, 0x0463 },
    { 0x0464, 0x0464 },
    { 0x0465, 0x0465 },
    { 0x0466, 0x0466 },
    { 0x0467, 0x0467 },
    { 0x0468, 0x0468 },
    { 0x0469, 0x0469 },
    { 0x046a, 0x046a },
    { 0x046b, 0x046b },
    { 0x046c, 0x046c },
    { 0x046d, 0x046d },
    { 0x046e, 0x046e },
    { 0x046f, 0x046f },
    { 0x0470, 0x0470 },
    { 0x0471, 0x0471 },
    { 0x0472, 0x0472 },
    { 0x0473, 0x0473 },
    { 0x0474, 0x0474 },
    { 0x0475, 0x0475 },
    { 0x0476, 0x0476 },
    { 0x0477, 0x0477 },
    { 0x0478, 0x0478 },
    { 0x0479, 0x0479 },
    { 0x047a, 0x047a },
    { 0x047b, 0x047b },
    { 0x047c, 0x047c },
    { 0x047d, 0x047d },
    { 0x047e, 0x047e },
    { 0x047f, 0x047f },
    { 0x0480, 0x0480 },
    { 0x0481, 0x0481 },
    { 0x0482, 0x0482 },
    { 0x0483, 0x0486 },
    { 0x0487, 0x048f },
    { 0x0490, 0x0490 },
    { 0x0491, 0x0491 },
    { 0x0492, 0x0492 },
    { 0x0493, 0x0493 },
    { 0x0494, 0x0494 },
    { 0x0495, 0x0495 },
    { 0x0496, 0x0496 },
    { 0x0497, 0x0497 },
    { 0x0498, 0x0498 },
    { 0x0499, 0x0499 },
    { 0x049a, 0x049a },
    { 0x049b, 0x049b },
    { 0x049c, 0x049c },
    { 0x049d, 0x049d },
    { 0x049e, 0x049e },
    { 0x049f, 0x049f },
    { 0x04a0, 0x04a0 },
    { 0x04a1, 0x04a1 },
    { 0x04a2, 0x04a2 },
    { 0x04a3, 0x04a3 },
    { 0x04a4, 0x04a4 },
    { 0x04a5, 0x04a5 },
    { 0x04a6, 0x04a6 },
    { 0x04a7, 0x04a7 },
    { 0x04a8, 0x04a8 },
    { 0x04a9, 0x04a9 },
    { 0x04aa, 0x04aa },
    { 0x04ab, 0x04ab },
    { 0x04ac, 0x04ac },
    { 0x04ad, 0x04ad },
    { 0x04ae, 0x04ae },
    { 0x04af, 0x04af },
    { 0x04b0, 0x04b0 },
    { 0x04b1, 0x04b1 },
    { 0x04b2, 0x04b2 },
    { 0x04b3, 0x04b3 },
    { 0x04b4, 0x04b4 },
    { 0x04b5, 0x04b5 },
    { 0x04b6, 0x04b6 },
    { 0x04b7, 0x04b7 },
    { 0x04b8, 0x04b8 },
    { 0x04b9, 0x04b9 },
    { 0x04ba, 0x04ba },
    { 0x04bb, 0x04bb },
    { 0x04bc, 0x04bc },
    { 0x04bd, 0x04bd },
    { 0x04be, 0x04be },
    { 0x04bf, 0x04bf },
    { 0x04c0, 0x04c0 },
    { 0x04c1, 0x04c1 },
    { 0x04c2, 0x04c2 },
    { 0x04c3, 0x04c3 },
    { 0x04c4, 0x04c4 },
    { 0x04c5, 0x04c6 },
    { 0x04c7, 0x04c7 },
    { 0x04c8, 0x04c8 },
    { 0x04c9, 0x04ca },
    { 0x04cb, 0x04cb },
    { 0x04cc, 0x04cc },
    { 0x04cd, 0x04cf },
    { 0x04d0, 0x04d0 },
    { 0x04d1, 0x04d1 },
    { 0x04d2, 0x04d2 },
    { 0x04d3, 0x04d3 },
    { 0x04d4, 0x04d4 },
    { 0x04d5, 0x04d5 },
    { 0x04d6, 0x04d6 },
    { 0x04d7, 0x04d7 },
    { 0x04d8, 0x04d8 },
    { 0x04d9, 0x04d9 },
    { 0x04da, 0x04da },
    { 0x04db, 0x04db },
    { 0x04dc, 0x04dc },
    { 0x04dd, 0x04dd },
    { 0x04de, 0x04de },
    { 0x04df, 0x04df },
    { 0x04e0, 0x04e0 },
    { 0x04e1, 0x04e1 },
    { 0x04e2, 0x04e2 },
    { 0x04e3, 0x04e3 },
    { 0x04e4, 0x04e4 },
    { 0x04e5, 0x04e5 },
    { 0x04e6, 0x04e6 },
    { 0x04e7, 0x04e7 },
    { 0x04e8, 0x04e8 },
    { 0x04e9, 0x04e9 },
    { 0x04ea, 0x04ea },
    { 0x04eb, 0x04eb },
    { 0x04ec, 0x04ed },
    { 0x04ee, 0x04ee },
    { 0x04ef, 0x04ef },
    { 0x04f0, 0x04f0 },
    { 0x04f1, 0x04f1 },
    { 0x04f2, 0x04f2 },
    { 0x04f3, 0x04f3 },
    { 0x04f4, 0x04f4 },
    { 0x04f5, 0x04f5 },
    { 0x04f6, 0x04f7 },
    { 0x04f8, 0x04f8 },
    { 0x04f9, 0x04f9 },
    { 0x04fa, 0x0530 },
    { 0x0531, 0x0556 },
    { 0x0557, 0x0558 },
    { 0x0559, 0x0559 },
    { 0x055a, 0x055f },
    { 0x0560, 0x0560 },
    { 0x0561, 0x0587 },
    { 0x0588, 0x0588 },
    { 0x0589, 0x0589 },
    { 0x058a, 0x0590 },
    { 0x0591, 0x05a1 },
    { 0x05a2, 0x05a2 },
    { 0x05a3, 0x05b9 },
    { 0x05ba, 0x05ba },
    { 0x05bb, 0x05bd },
    { 0x05be, 0x05be },
    { 0x05bf, 0x05bf },
    { 0x05c0, 0x05c0 },
    { 0x05c1, 0x05c2 },
    { 0x05c3, 0x05c3 },
    { 0x05c4, 0x05c4 },
    { 0x05c5, 0x05cf },
    { 0x05d0, 0x05ea },
    { 0x05eb, 0x05ef },
    { 0x05f0, 0x05f2 },
    { 0x05f3, 0x05f4 },
    { 0x05f5, 0x060b },
    { 0x060c, 0x060c },
    { 0x060d, 0x061a },
    { 0x061b, 0x061b },
    { 0x061c, 0x061e },
    { 0x061f, 0x061f },
    { 0x0620, 0x0620 },
    { 0x0621, 0x063a },
    { 0x063b, 0x063f },
    { 0x0640, 0x0640 },
    { 0x0641, 0x064a },
    { 0x064b, 0x0652 },
    { 0x0653, 0x065f },
    { 0x0660, 0x0669 },
    { 0x066a, 0x066d },
    { 0x066e, 0x066f },
    { 0x0670, 0x0670 },
    { 0x0671, 0x06b7 },
    { 0x06b8, 0x06b9 },
    { 0x06ba, 0x06be },
    { 0x06bf, 0x06bf },
    { 0x06c0, 0x06ce },
    { 0x06cf, 0x06cf },
    { 0x06d0, 0x06d3 },
    { 0x06d4, 0x06d4 },
    { 0x06d5, 0x06d5 },
    { 0x06d6, 0x06dc },
    { 0x06dd, 0x06de },
    { 0x06df, 0x06e4 },
    { 0x06e5, 0x06e6 },
    { 0x06e7, 0x06e8 },
    { 0x06e9, 0x06e9 },
    { 0x06ea, 0x06ed },
    { 0x06ee, 0x06ef },
    { 0x06f0, 0x06f9 },
    { 0x06fa, 0x0900 },
    { 0x0901, 0x0902 },
    { 0x0903, 0x0903 },
    { 0x0904, 0x0904 },
    { 0x0905, 0x0939 },
    { 0x093a, 0x093b },
    { 0x093c, 0x093c },
    { 0x093d, 0x093d },
    { 0x093e, 0x0940 },
    { 0x0941, 0x0948 },
    { 0x0949, 0x094c },
    { 0x094d, 0x094d },
    { 0x094e, 0x094f },
    { 0x0950, 0x0950 },
    { 0x0951, 0x0954 },
    { 0x0955, 0x0957 },
    { 0x0958, 0x0961 },
    { 0x0962, 0x0963 },
    { 0x0964, 0x0965 },
    { 0x0966, 0x096f },
    { 0x0970, 0x0970 },
    { 0x0971, 0x0980 },
    { 0x0981, 0x0981 },
    { 0x0982, 0x0983 },
    { 0x0984, 0x0984 },
    { 0x0985, 0x098c },
    { 0x098d, 0x098e },
    { 0x098f, 0x0990 },
    { 0x0991, 0x0992 },
    { 0x0993, 0x09a8 },
    { 0x09a9, 0x09a9 },
    { 0x09aa, 0x09b0 },
    { 0x09b1, 0x09b1 },
    { 0x09b2, 0x09b2 },
    { 0x09b3, 0x09b5 },
    { 0x09b6, 0x09b9 },
    { 0x09ba, 0x09bb },
    { 0x09bc, 0x09bc },
    { 0x09bd, 0x09bd },
    { 0x09be, 0x09c0 },
    { 0x09c1, 0x09c4 },
    { 0x09c5, 0x09c6 },
    { 0x09c7, 0x09c8 },
    { 0x09c9, 0x09ca },
    { 0x09cb, 0x09cc },
    { 0x09cd, 0x09cd },
    { 0x09ce, 0x09d6 },
    { 0x09d7, 0x09d7 },
    { 0x09d8, 0x09db },
    { 0x09dc, 0x09dd },
    { 0x09de, 0x09de },
    { 0x09df, 0x09e1 },
    { 0x09e2, 0x09e3 },
    { 0x09e4, 0x09e5 },
    { 0x09e6, 0x09ef },
    { 0x09f0, 0x09f1 },
    { 0x09f2, 0x09f3 },
    { 0x09f4, 0x09f9 },
    { 0x09fa, 0x09fa },
    { 0x09fb, 0x0a01 },
    { 0x0a02, 0x0a02 },
    { 0x0a03, 0x0a04 },
    { 0x0a05, 0x0a0a },
    { 0x0a0b, 0x0a0e },
    { 0x0a0f, 0x0a10 },
    { 0x0a11, 0x0a12 },
    { 0x0a13, 0x0a28 },
    { 0x0a29, 0x0a29 },
    { 0x0a2a, 0x0a30 },
    { 0x0a31, 0x0a31 },
    { 0x0a32, 0x0a33 },
    { 0x0a34, 0x0a34 },
    { 0x0a35, 0x0a36 },
    { 0x0a37, 0x0a37 },
    { 0x0a38, 0x0a39 },
    { 0x0a3a, 0x0a3b },
    { 0x0a3c, 0x0a3c },
    { 0x0a3d, 0x0a3d },
    { 0x0a3e, 0x0a40 },
    { 0x0a41, 0x0a42 },
    { 0x0a43, 0x0a46 },
    { 0x0a47, 0x0a48 },
    { 0x0a49, 0x0a4a },
    { 0x0a4b, 0x0a4d },
    { 0x0a4e, 0x0a58 },
    { 0x0a59, 0x0a5c },
    { 0x0a5d, 0x0a5d },
    { 0x0a5e, 0x0a5e },
    { 0x0a5f, 0x0a65 },
    { 0x0a66, 0x0a6f },
    { 0x0a70, 0x0a71 },
    { 0x0a72, 0x0a74 },
    { 0x0a75, 0x0a80 },
    { 0x0a81, 0x0a82 },
    { 0x0a83, 0x0a83 },
    { 0x0a84, 0x0a84 },
    { 0x0a85, 0x0a8b },
    { 0x0a8c, 0x0a8c },
    { 0x0a8d, 0x0a8d },
    { 0x0a8e, 0x0a8e },
    { 0x0a8f, 0x0a91 },
    { 0x0a92, 0x0a92 },
    { 0x0a93, 0x0aa8 },
    { 0x0aa9, 0x0aa9 },
    { 0x0aaa, 0x0ab0 },
    { 0x0ab1, 0x0ab1 },
    { 0x0ab2, 0x0ab3 },
    { 0x0ab4, 0x0ab4 },
    { 0x0ab5, 0x0ab9 },
    { 0x0aba, 0x0abb },
    { 0x0abc, 0x0abc },
    { 0x0abd, 0x0abd },
    { 0x0abe, 0x0ac0 },
    { 0x0ac1, 0x0ac5 },
    { 0x0ac6, 0x0ac6 },
    { 0x0ac7, 0x0ac8 },
    { 0x0ac9, 0x0ac9 },
    { 0x0aca, 0x0aca },
    { 0x0acb, 0x0acc },
    { 0x0acd, 0x0acd },
    { 0x0ace, 0x0acf },
    { 0x0ad0, 0x0ad0 },
    { 0x0ad1, 0x0adf },
    { 0x0ae0, 0x0ae0 },
    { 0x0ae1, 0x0ae5 },
    { 0x0ae6, 0x0aef },
    { 0x0af0, 0x0b00 },
    { 0x0b01, 0x0b01 },
    { 0x0b02, 0x0b03 },
    { 0x0b04, 0x0b04 },
    { 0x0b05, 0x0b0c },
    { 0x0b0d, 0x0b0e },
    { 0x0b0f, 0x0b10 },
    { 0x0b11, 0x0b12 },
    { 0x0b13, 0x0b28 },
    { 0x0b29, 0x0b29 },
    { 0x0b2a, 0x0b30 },
    { 0x0b31, 0x0b31 },
    { 0x0b32, 0x0b33 },
    { 0x0b34, 0x0b35 },
    { 0x0b36, 0x0b39 },
    { 0x0b3a, 0x0b3b },
    { 0x0b3c, 0x0b3c },
    { 0x0b3d, 0x0b3d },
    { 0x0b3e, 0x0b3e },
    { 0x0b3f, 0x0b3f },
    { 0x0b40, 0x0b40 },
    { 0x0b41, 0x0b43 },
    { 0x0b44, 0x0b46 },
    { 0x0b47, 0x0b48 },
    { 0x0b49, 0x0b4a },
    { 0x0b4b, 0x0b4c },
    { 0x0b4d, 0x0b4d },
    { 0x0b4e, 0x0b55 },
    { 0x0b56, 0x0b56 },
    { 0x0b57, 0x0b57 },
    { 0x0b58, 0x0b5b },
    { 0x0b5c, 0x0b5d },
    { 0x0b5e, 0x0b5e },
    { 0x0b5f, 0x0b61 },
    { 0x0b62, 0x0b65 },
    { 0x0b66, 0x0b6f },
    { 0x0b70, 0x0b70 },
    { 0x0b71, 0x0b81 },
    { 0x0b82, 0x0b82 },
    { 0x0b83, 0x0b83 },
    { 0x0b84, 0x0b84 },
    { 0x0b85, 0x0b8a },
    { 0x0b8b, 0x0b8d },
    { 0x0b8e, 0x0b90 },
    { 0x0b91, 0x0b91 },
    { 0x0b92, 0x0b95 },
    { 0x0b96, 0x0b98 },
    { 0x0b99, 0x0b9a },
    { 0x0b9b, 0x0b9b },
    { 0x0b9c, 0x0b9c },
    { 0x0b9d, 0x0b9d },
    { 0x0b9e, 0x0b9f },
    { 0x0ba0, 0x0ba2 },
    { 0x0ba3, 0x0ba4 },
    { 0x0ba5, 0x0ba7 },
    { 0x0ba8, 0x0baa },
    { 0x0bab, 0x0bad },
    { 0x0bae, 0x0bb5 },
    { 0x0bb6, 0x0bb6 },
    { 0x0bb7, 0x0bb9 },
    { 0x0bba, 0x0bbd },
    { 0x0bbe, 0x0bbf },
    { 0x0bc0, 0x0bc0 },
    { 0x0bc1, 0x0bc2 },
    { 0x0bc3, 0x0bc5 },
    { 0x0bc6, 0x0bc8 },
    { 0x0bc9, 0x0bc9 },
    { 0x0bca, 0x0bcc },
    { 0x0bcd, 0x0bcd },
    { 0x0bce, 0x0bd6 },
    { 0x0bd7, 0x0bd7 },
    { 0x0bd8, 0x0be6 },
    { 0x0be7, 0x0bef },
    { 0x0bf0, 0x0bf2 },
    { 0x0bf3, 0x0c00 },
    { 0x0c01, 0x0c03 },
    { 0x0c04, 0x0c04 },
    { 0x0c05, 0x0c0c },
    { 0x0c0d, 0x0c0d },
    { 0x0c0e, 0x0c10 },
    { 0x0c11, 0x0c11 },
    { 0x0c12, 0x0c28 },
    { 0x0c29, 0x0c29 },
    { 0x0c2a, 0x0c33 },
    { 0x0c34, 0x0c34 },
    { 0x0c35, 0x0c39 },
    { 0x0c3a, 0x0c3d },
    { 0x0c3e, 0x0c40 },
    { 0x0c41, 0x0c44 },
    { 0x0c45, 0x0c45 },
    { 0x0c46, 0x0c48 },
    { 0x0c49, 0x0c49 },
    { 0x0c4a, 0x0c4d },
    { 0x0c4e, 0x0c54 },
    { 0x0c55, 0x0c56 },
    { 0x0c57, 0x0c5f },
    { 0x0c60, 0x0c61 },
    { 0x0c62, 0x0c65 },
    { 0x0c66, 0x0c6f },
    { 0x0c70, 0x0c81 },
    { 0x0c82, 0x0c83 },
    { 0x0c84, 0x0c84 },
    { 0x0c85, 0x0c8c },
    { 0x0c8d, 0x0c8d },
    { 0x0c8e, 0x0c90 },
    { 0x0c91, 0x0c91 },
    { 0x0c92, 0x0ca8 },
    { 0x0ca9, 0x0ca9 },
    { 0x0caa, 0x0cb3 },
    { 0x0cb4, 0x0cb4 },
    { 0x0cb5, 0x0cb9 },
    { 0x0cba, 0x0cbd },
    { 0x0cbe, 0x0cbe },
    { 0x0cbf, 0x0cbf },
    { 0x0cc0, 0x0cc4 },
    { 0x0cc5, 0x0cc5 },
    { 0x0cc6, 0x0cc6 },
    { 0x0cc7, 0x0cc8 },
    { 0x0cc9, 0x0cc9 },
    { 0x0cca, 0x0ccb },
    { 0x0ccc, 0x0ccd },
    { 0x0cce, 0x0cd4 },
    { 0x0cd5, 0x0cd6 },
    { 0x0cd7, 0x0cdd },
    { 0x0cde, 0x0cde },
    { 0x0cdf, 0x0cdf },
    { 0x0ce0, 0x0ce1 },
    { 0x0ce2, 0x0ce5 },
    { 0x0ce6, 0x0cef },
    { 0x0cf0, 0x0d01 },
    { 0x0d02, 0x0d03 },
    { 0x0d04, 0x0d04 },
    { 0x0d05, 0x0d0c },
    { 0x0d0d, 0x0d0d },
    { 0x0d0e, 0x0d10 },
    { 0x0d11, 0x0d11 },
    { 0x0d12, 0x0d28 },
    { 0x0d29, 0x0d29 },
    { 0x0d2a, 0x0d39 },
    { 0x0d3a, 0x0d3d },
    { 0x0d3e, 0x0d40 },
    { 0x0d41, 0x0d43 },
    { 0x0d44, 0x0d45 },
    { 0x0d46, 0x0d48 },
    { 0x0d49, 0x0d49 },
    { 0x0d4a, 0x0d4c },
    { 0x0d4d, 0x0d4d },
    { 0x0d4e, 0x0d56 },
    { 0x0d57, 0x0d57 },
    { 0x0d58, 0x0d5f },
    { 0x0d60, 0x0d61 },
    { 0x0d62, 0x0d65 },
    { 0x0d66, 0x0d6f },
    { 0x0d70, 0x0e00 },
    { 0x0e01, 0x0e30 },
    { 0x0e31, 0x0e31 },
    { 0x0e32, 0x0e33 },
    { 0x0e34, 0x0e3a },
    { 0x0e3b, 0x0e3e },
    { 0x0e3f, 0x0e3f },
    { 0x0e40, 0x0e45 },
    { 0x0e46, 0x0e46 },
    { 0x0e47, 0x0e4e },
    { 0x0e4f, 0x0e4f },
    { 0x0e50, 0x0e59 },
    { 0x0e5a, 0x0e5b },
    { 0x0e5c, 0x0e80 },
    { 0x0e81, 0x0e82 },
    { 0x0e83, 0x0e83 },
    { 0x0e84, 0x0e84 },
    { 0x0e85, 0x0e86 },
    { 0x0e87, 0x0e88 },
    { 0x0e89, 0x0e89 },
    { 0x0e8a, 0x0e8a },
    { 0x0e8b, 0x0e8c },
    { 0x0e8d, 0x0e8d },
    { 0x0e8e, 0x0e93 },
    { 0x0e94, 0x0e97 },
    { 0x0e98, 0x0e98 },
    { 0x0e99, 0x0e9f },
    { 0x0ea0, 0x0ea0 },
    { 0x0ea1, 0x0ea3 },
    { 0x0ea4, 0x0ea4 },
    { 0x0ea5, 0x0ea5 },
    { 0x0ea6, 0x0ea6 },
    { 0x0ea7, 0x0ea7 },
    { 0x0ea8, 0x0ea9 },
    { 0x0eaa, 0x0eab },
    { 0x0eac, 0x0eac },
    { 0x0ead, 0x0eb0 },
    { 0x0eb1, 0x0eb1 },
    { 0x0eb2, 0x0eb3 },
    { 0x0eb4, 0x0eb9 },
    { 0x0eba, 0x0eba },
    { 0x0ebb, 0x0ebc },
    { 0x0ebd, 0x0ebd },
    { 0x0ebe, 0x0ebf },
    { 0x0ec0, 0x0ec4 },
    { 0x0ec5, 0x0ec5 },
    { 0x0ec6, 0x0ec6 },
    { 0x0ec7, 0x0ec7 },
    { 0x0ec8, 0x0ecd },
    { 0x0ece, 0x0ecf },
    { 0x0ed0, 0x0ed9 },
    { 0x0eda, 0x0edb },
    { 0x0edc, 0x0edd },
    { 0x0ede, 0x0eff },
    { 0x0f00, 0x0f00 },
    { 0x0f01, 0x0f03 },
    { 0x0f04, 0x0f12 },
    { 0x0f13, 0x0f17 },
    { 0x0f18, 0x0f19 },
    { 0x0f1a, 0x0f1f },
    { 0x0f20, 0x0f29 },
    { 0x0f2a, 0x0f33 },
    { 0x0f34, 0x0f34 },
    { 0x0f35, 0x0f35 },
    { 0x0f36, 0x0f36 },
    { 0x0f37, 0x0f37 },
    { 0x0f38, 0x0f38 },
    { 0x0f39, 0x0f39 },
    { 0x0f3a, 0x0f3a },
    { 0x0f3b, 0x0f3b },
    { 0x0f3c, 0x0f3c },
    { 0x0f3d, 0x0f3d },
    { 0x0f3e, 0x0f3f },
    { 0x0f40, 0x0f47 },
    { 0x0f48, 0x0f48 },
    { 0x0f49, 0x0f69 },
    { 0x0f6a, 0x0f70 },
    { 0x0f71, 0x0f7e },
    { 0x0f7f, 0x0f7f },
    { 0x0f80, 0x0f84 },
    { 0x0f85, 0x0f85 },
    { 0x0f86, 0x0f87 },
    { 0x0f88, 0x0f8b },
    { 0x0f8c, 0x0f8f },
    { 0x0f90, 0x0f95 },
    { 0x0f96, 0x0f96 },
    { 0x0f97, 0x0f97 },
    { 0x0f98, 0x0f98 },
    { 0x0f99, 0x0fad },
    { 0x0fae, 0x0fb0 },
    { 0x0fb1, 0x0fb7 },
    { 0x0fb8, 0x0fb8 },
    { 0x0fb9, 0x0fb9 },
    { 0x0fba, 0x109f },
    { 0x10a0, 0x10c5 },
    { 0x10c6, 0x10cf },
    { 0x10d0, 0x10f6 },
    { 0x10f7, 0x10fa },
    { 0x10fb, 0x10fb },
    { 0x10fc, 0x10ff },
    { 0x1100, 0x1159 },
    { 0x115a, 0x115e },
    { 0x115f, 0x11a2 },
    { 0x11a3, 0x11a7 },
    { 0x11a8, 0x11f9 },
    { 0x11fa, 0x1dff },
    { 0x1e00, 0x1e00 },
    { 0x1e01, 0x1e01 },
    { 0x1e02, 0x1e02 },
    { 0x1e03, 0x1e03 },
    { 0x1e04, 0x1e04 },
    { 0x1e05, 0x1e05 },
    { 0x1e06, 0x1e06 },
    { 0x1e07, 0x1e07 },
    { 0x1e08, 0x1e08 },
    { 0x1e09, 0x1e09 },
    { 0x1e0a, 0x1e0a },
    { 0x1e0b, 0x1e0b },
    { 0x1e0c, 0x1e0c },
    { 0x1e0d, 0x1e0d },
    { 0x1e0e, 0x1e0e },
    { 0x1e0f, 0x1e0f },
    { 0x1e10, 0x1e10 },
    { 0x1e11, 0x1e11 },
    { 0x1e12, 0x1e12 },
    { 0x1e13, 0x1e13 },
    { 0x1e14, 0x1e14 },
    { 0x1e15, 0x1e15 },
    { 0x1e16, 0x1e16 },
    { 0x1e17, 0x1e17 },
    { 0x1e18, 0x1e18 },
    { 0x1e19, 0x1e19 },
    { 0x1e1a, 0x1e1a },
    { 0x1e1b, 0x1e1b },
    { 0x1e1c, 0x1e1c },
    { 0x1e1d, 0x1e1d },
    { 0x1e1e, 0x1e1e },
    { 0x1e1f, 0x1e1f },
    { 0x1e20, 0x1e20 },
    { 0x1e21, 0x1e21 },
    { 0x1e22, 0x1e22 },
    { 0x1e23, 0x1e23 },
    { 0x1e24, 0x1e24 },
    { 0x1e25, 0x1e25 },
    { 0x1e26, 0x1e26 },
    { 0x1e27, 0x1e27 },
    { 0x1e28, 0x1e28 },
    { 0x1e29, 0x1e29 },
    { 0x1e2a, 0x1e2a },
    { 0x1e2b, 0x1e2b },
    { 0x1e2c, 0x1e2c },
    { 0x1e2d, 0x1e2d },
    { 0x1e2e, 0x1e2e },
    { 0x1e2f, 0x1e2f },
    { 0x1e30, 0x1e30 },
    { 0x1e31, 0x1e31 },
    { 0x1e32, 0x1e32 },
    { 0x1e33, 0x1e33 },
    { 0x1e34, 0x1e34 },
    { 0x1e35, 0x1e35 },
    { 0x1e36, 0x1e36 },
    { 0x1e37, 0x1e37 },
    { 0x1e38, 0x1e38 },
    { 0x1e39, 0x1e39 },
    { 0x1e3a, 0x1e3a },
    { 0x1e3b, 0x1e3b },
    { 0x1e3c, 0x1e3c },
    { 0x1e3d, 0x1e3d },
    { 0x1e3e, 0x1e3e },
    { 0x1e3f, 0x1e3f },
    { 0x1e40, 0x1e40 },
    { 0x1e41, 0x1e41 },
    { 0x1e42, 0x1e42 },
    { 0x1e43, 0x1e43 },
    { 0x1e44, 0x1e44 },
    { 0x1e45, 0x1e45 },
    { 0x1e46, 0x1e46 },
    { 0x1e47, 0x1e47 },
    { 0x1e48, 0x1e48 },
    { 0x1e49, 0x1e49 },
    { 0x1e4a, 0x1e4a },
    { 0x1e4b, 0x1e4b },
    { 0x1e4c, 0x1e4c },
    { 0x1e4d, 0x1e4d },
    { 0x1e4e, 0x1e4e },
    { 0x1e4f, 0x1e4f },
    { 0x1e50, 0x1e50 },
    { 0x1e51, 0x1e51 },
    { 0x1e52, 0x1e52 },
    { 0x1e53, 0x1e53 },
    { 0x1e54, 0x1e54 },
    { 0x1e55, 0x1e55 },
    { 0x1e56, 0x1e56 },
    { 0x1e57, 0x1e57 },
    { 0x1e58, 0x1e58 },
    { 0x1e59, 0x1e59 },
    { 0x1e5a, 0x1e5a },
    { 0x1e5b, 0x1e5b },
    { 0x1e5c, 0x1e5c },
    { 0x1e5d, 0x1e5d },
    { 0x1e5e, 0x1e5e },
    { 0x1e5f, 0x1e5f },
    { 0x1e60, 0x1e60 },
    { 0x1e61, 0x1e61 },
    { 0x1e62, 0x1e62 },
    { 0x1e63, 0x1e63 },
    { 0x1e64, 0x1e64 },
    { 0x1e65, 0x1e65 },
    { 0x1e66, 0x1e66 },
    { 0x1e67, 0x1e67 },
    { 0x1e68, 0x1e68 },
    { 0x1e69, 0x1e69 },
    { 0x1e6a, 0x1e6a },
    { 0x1e6b, 0x1e6b },
    { 0x1e6c, 0x1e6c },
    { 0x1e6d, 0x1e6d },
    { 0x1e6e, 0x1e6e },
    { 0x1e6f, 0x1e6f },
    { 0x1e70, 0x1e70 },
    { 0x1e71, 0x1e71 },
    { 0x1e72, 0x1e72 },
    { 0x1e73, 0x1e73 },
    { 0x1e74, 0x1e74 },
    { 0x1e75, 0x1e75 },
    { 0x1e76, 0x1e76 },
    { 0x1e77, 0x1e77 },
    { 0x1e78, 0x1e78 },
    { 0x1e79, 0x1e79 },
    { 0x1e7a, 0x1e7a },
    { 0x1e7b, 0x1e7b },
    { 0x1e7c, 0x1e7c },
    { 0x1e7d, 0x1e7d },
    { 0x1e7e, 0x1e7e },
    { 0x1e7f, 0x1e7f },
    { 0x1e80, 0x1e80 },
    { 0x1e81, 0x1e81 },
    { 0x1e82, 0x1e82 },
    { 0x1e83, 0x1e83 },
    { 0x1e84, 0x1e84 },
    { 0x1e85, 0x1e85 },
    { 0x1e86, 0x1e86 },
    { 0x1e87, 0x1e87 },
    { 0x1e88, 0x1e88 },
    { 0x1e89, 0x1e89 },
    { 0x1e8a, 0x1e8a },
    { 0x1e8b, 0x1e8b },
    { 0x1e8c, 0x1e8c },
    { 0x1e8d, 0x1e8d },
    { 0x1e8e, 0x1e8e },
    { 0x1e8f, 0x1e8f },
    { 0x1e90, 0x1e90 },
    { 0x1e91, 0x1e91 },
    { 0x1e92, 0x1e92 },
    { 0x1e93, 0x1e93 },
    { 0x1e94, 0x1e94 },
    { 0x1e95, 0x1e9b },
    { 0x1e9c, 0x1e9f },
    { 0x1ea0, 0x1ea0 },
    { 0x1ea1, 0x1ea1 },
    { 0x1ea2, 0x1ea2 },
    { 0x1ea3, 0x1ea3 },
    { 0x1ea4, 0x1ea4 },
    { 0x1ea5, 0x1ea5 },
    { 0x1ea6, 0x1ea6 },
    { 0x1ea7, 0x1ea7 },
    { 0x1ea8, 0x1ea8 },
    { 0x1ea9, 0x1ea9 },
    { 0x1eaa, 0x1eaa },
    { 0x1eab, 0x1eab },
    { 0x1eac, 0x1eac },
    { 0x1ead, 0x1ead },
    { 0x1eae, 0x1eae },
    { 0x1eaf, 0x1eaf },
    { 0x1eb0, 0x1eb0 },
    { 0x1eb1, 0x1eb1 },
    { 0x1eb2, 0x1eb2 },
    { 0x1eb3, 0x1eb3 },
    { 0x1eb4, 0x1eb4 },
    { 0x1eb5, 0x1eb5 },
    { 0x1eb6, 0x1eb6 },
    { 0x1eb7, 0x1eb7 },
    { 0x1eb8, 0x1eb8 },
    { 0x1eb9, 0x1eb9 },
    { 0x1eba, 0x1eba },
    { 0x1ebb, 0x1ebb },
    { 0x1ebc, 0x1ebc },
    { 0x1ebd, 0x1ebd },
    { 0x1ebe, 0x1ebe },
    { 0x1ebf, 0x1ebf },
    { 0x1ec0, 0x1ec0 },
    { 0x1ec1, 0x1ec1 },
    { 0x1ec2, 0x1ec2 },
    { 0x1ec3, 0x1ec3 },
    { 0x1ec4, 0x1ec4 },
    { 0x1ec5, 0x1ec5 },
    { 0x1ec6, 0x1ec6 },
    { 0x1ec7, 0x1ec7 },
    { 0x1ec8, 0x1ec8 },
    { 0x1ec9, 0x1ec9 },
    { 0x1eca, 0x1eca },
    { 0x1ecb, 0x1ecb },
    { 0x1ecc, 0x1ecc },
    { 0x1ecd, 0x1ecd },
    { 0x1ece, 0x1ece },
    { 0x1ecf, 0x1ecf },
    { 0x1ed0, 0x1ed0 },
    { 0x1ed1, 0x1ed1 },
    { 0x1ed2, 0x1ed2 },
    { 0x1ed3, 0x1ed3 },
    { 0x1ed4, 0x1ed4 },
    { 0x1ed5, 0x1ed5 },
    { 0x1ed6, 0x1ed6 },
    { 0x1ed7, 0x1ed7 },
    { 0x1ed8, 0x1ed8 },
    { 0x1ed9, 0x1ed9 },
    { 0x1eda, 0x1eda },
    { 0x1edb, 0x1edb },
    { 0x1edc, 0x1edc },
    { 0x1edd, 0x1edd },
    { 0x1ede, 0x1ede },
    { 0x1edf, 0x1edf },
    { 0x1ee0, 0x1ee0 },
    { 0x1ee1, 0x1ee1 },
    { 0x1ee2, 0x1ee2 },
    { 0x1ee3, 0x1ee3 },
    { 0x1ee4, 0x1ee4 },
    { 0x1ee5, 0x1ee5 },
    { 0x1ee6, 0x1ee6 },
    { 0x1ee7, 0x1ee7 },
    { 0x1ee8, 0x1ee8 },
    { 0x1ee9, 0x1ee9 },
    { 0x1eea, 0x1eea },
    { 0x1eeb, 0x1eeb },
    { 0x1eec, 0x1eec },
    { 0x1eed, 0x1eed },
    { 0x1eee, 0x1eee },
    { 0x1eef, 0x1eef },
    { 0x1ef0, 0x1ef0 },
    { 0x1ef1, 0x1ef1 },
    { 0x1ef2, 0x1ef2 },
    { 0x1ef3, 0x1ef3 },
    { 0x1ef4, 0x1ef4 },
    { 0x1ef5, 0x1ef5 },
    { 0x1ef6, 0x1ef6 },
    { 0x1ef7, 0x1ef7 },
    { 0x1ef8, 0x1ef8 },
    { 0x1ef9, 0x1ef9 },
    { 0x1efa, 0x1eff },
    { 0x1f00, 0x1f07 },
    { 0x1f08, 0x1f0f },
    { 0x1f10, 0x1f15 },
    { 0x1f16, 0x1f17 },
    { 0x1f18, 0x1f1d },
    { 0x1f1e, 0x1f1f },
    { 0x1f20, 0x1f27 },
    { 0x1f28, 0x1f2f },
    { 0x1f30, 0x1f37 },
    { 0x1f38, 0x1f3f },
    { 0x1f40, 0x1f45 },
    { 0x1f46, 0x1f47 },
    { 0x1f48, 0x1f4d },
    { 0x1f4e, 0x1f4f },
    { 0x1f50, 0x1f57 },
    { 0x1f58, 0x1f58 },
    { 0x1f59, 0x1f59 },
    { 0x1f5a, 0x1f5a },
    { 0x1f5b, 0x1f5b },
    { 0x1f5c, 0x1f5c },
    { 0x1f5d, 0x1f5d },
    { 0x1f5e, 0x1f5e },
    { 0x1f5f, 0x1f5f },
    { 0x1f60, 0x1f67 },
    { 0x1f68, 0x1f6f },
    { 0x1f70, 0x1f7d },
    { 0x1f7e, 0x1f7f },
    { 0x1f80, 0x1f87 },
    { 0x1f88, 0x1f8f },
    { 0x1f90, 0x1f97 },
    { 0x1f98, 0x1f9f },
    { 0x1fa0, 0x1fa7 },
    { 0x1fa8, 0x1faf },
    { 0x1fb0, 0x1fb4 },
    { 0x1fb5, 0x1fb5 },
    { 0x1fb6, 0x1fb7 },
    { 0x1fb8, 0x1fbc },
    { 0x1fbd, 0x1fbd },
    { 0x1fbe, 0x1fbe },
    { 0x1fbf, 0x1fc1 },
    { 0x1fc2, 0x1fc4 },
    { 0x1fc5, 0x1fc5 },
    { 0x1fc6, 0x1fc7 },
    { 0x1fc8, 0x1fcc },
    { 0x1fcd, 0x1fcf },
    { 0x1fd0, 0x1fd3 },
    { 0x1fd4, 0x1fd5 },
    { 0x1fd6, 0x1fd7 },
    { 0x1fd8, 0x1fdb },
    { 0x1fdc, 0x1fdc },
    { 0x1fdd, 0x1fdf },
    { 0x1fe0, 0x1fe7 },
    { 0x1fe8, 0x1fec },
    { 0x1fed, 0x1fef },
    { 0x1ff0, 0x1ff1 },
    { 0x1ff2, 0x1ff4 },
    { 0x1ff5, 0x1ff5 },
    { 0x1ff6, 0x1ff7 },
    { 0x1ff8, 0x1ffc },
    { 0x1ffd, 0x1ffe },
    { 0x1fff, 0x1fff },
    { 0x2000, 0x200b },
    { 0x200c, 0x200f },
    { 0x2010, 0x2015 },
    { 0x2016, 0x2017 },
    { 0x2018, 0x2018 },
    { 0x2019, 0x2019 },
    { 0x201a, 0x201a },
    { 0x201b, 0x201c },
    { 0x201d, 0x201d },
    { 0x201e, 0x201e },
    { 0x201f, 0x201f },
    { 0x2020, 0x2027 },
    { 0x2028, 0x2028 },
    { 0x2029, 0x2029 },
    { 0x202a, 0x202e },
    { 0x202f, 0x202f },
    { 0x2030, 0x2038 },
    { 0x2039, 0x2039 },
    { 0x203a, 0x203a },
    { 0x203b, 0x203e },
    { 0x203f, 0x2040 },
    { 0x2041, 0x2043 },
    { 0x2044, 0x2044 },
    { 0x2045, 0x2045 },
    { 0x2046, 0x2046 },
    { 0x2047, 0x2069 },
    { 0x206a, 0x206f },
    { 0x2070, 0x2070 },
    { 0x2071, 0x2073 },
    { 0x2074, 0x2079 },
    { 0x207a, 0x207c },
    { 0x207d, 0x207d },
    { 0x207e, 0x207e },
    { 0x207f, 0x207f },
    { 0x2080, 0x2089 },
    { 0x208a, 0x208c },
    { 0x208d, 0x208d },
    { 0x208e, 0x208e },
    { 0x208f, 0x209f },
    { 0x20a0, 0x20ac },
    { 0x20ad, 0x20cf },
    { 0x20d0, 0x20dc },
    { 0x20dd, 0x20e0 },
    { 0x20e1, 0x20e1 },
    { 0x20e2, 0x20ff },
    { 0x2100, 0x2101 },
    { 0x2102, 0x2102 },
    { 0x2103, 0x2106 },
    { 0x2107, 0x2107 },
    { 0x2108, 0x2109 },
    { 0x210a, 0x210a },
    { 0x210b, 0x210d },
    { 0x210e, 0x210f },
    { 0x2110, 0x2112 },
    { 0x2113, 0x2113 },
    { 0x2114, 0x2114 },
    { 0x2115, 0x2115 },
    { 0x2116, 0x2117 },
    { 0x2118, 0x2118 },
    { 0x2119, 0x211d },
    { 0x211e, 0x2123 },
    { 0x2124, 0x2124 },
    { 0x2125, 0x2125 },
    { 0x2126, 0x2126 },
    { 0x2127, 0x2127 },
    { 0x2128, 0x2128 },
    { 0x2129, 0x2129 },
    { 0x212a, 0x212d },
    { 0x212e, 0x212f },
    { 0x2130, 0x2131 },
    { 0x2132, 0x2132 },
    { 0x2133, 0x2133 },
    { 0x2134, 0x2134 },
    { 0x2135, 0x2138 },
    { 0x2139, 0x2152 },
    { 0x2153, 0x215f },
    { 0x2160, 0x2182 },
    { 0x2183, 0x218f },
    { 0x2190, 0x2194 },
    { 0x2195, 0x21d1 },
    { 0x21d2, 0x21d2 },
    { 0x21d3, 0x21d3 },
    { 0x21d4, 0x21d4 },
    { 0x21d5, 0x21ea },
    { 0x21eb, 0x21ff },
    { 0x2200, 0x22f1 },
    { 0x22f2, 0x22ff },
    { 0x2300, 0x2300 },
    { 0x2301, 0x2301 },
    { 0x2302, 0x2307 },
    { 0x2308, 0x230b },
    { 0x230c, 0x231f },
    { 0x2320, 0x2321 },
    { 0x2322, 0x2328 },
    { 0x2329, 0x2329 },
    { 0x232a, 0x232a },
    { 0x232b, 0x237a },
    { 0x237b, 0x23ff },
    { 0x2400, 0x2424 },
    { 0x2425, 0x243f },
    { 0x2440, 0x244a },
    { 0x244b, 0x245f },
    { 0x2460, 0x249b },
    { 0x249c, 0x24e9 },
    { 0x24ea, 0x24ea },
    { 0x24eb, 0x24ff },
    { 0x2500, 0x2595 },
    { 0x2596, 0x259f },
    { 0x25a0, 0x25ef },
    { 0x25f0, 0x25ff },
    { 0x2600, 0x2613 },
    { 0x2614, 0x2619 },
    { 0x261a, 0x266f },
    { 0x2670, 0x2700 },
    { 0x2701, 0x2704 },
    { 0x2705, 0x2705 },
    { 0x2706, 0x2709 },
    { 0x270a, 0x270b },
    { 0x270c, 0x2727 },
    { 0x2728, 0x2728 },
    { 0x2729, 0x274b },
    { 0x274c, 0x274c },
    { 0x274d, 0x274d },
    { 0x274e, 0x274e },
    { 0x274f, 0x2752 },
    { 0x2753, 0x2755 },
    { 0x2756, 0x2756 },
    { 0x2757, 0x2757 },
    { 0x2758, 0x275e },
    { 0x275f, 0x2760 },
    { 0x2761, 0x2767 },
    { 0x2768, 0x2775 },
    { 0x2776, 0x2793 },
    { 0x2794, 0x2794 },
    { 0x2795, 0x2797 },
    { 0x2798, 0x27af },
    { 0x27b0, 0x27b0 },
    { 0x27b1, 0x27be },
    { 0x27bf, 0x2fff },
    { 0x3000, 0x3000 },
    { 0x3001, 0x3003 },
    { 0x3004, 0x3004 },
    { 0x3005, 0x3005 },
    { 0x3006, 0x3006 },
    { 0x3007, 0x3007 },
    { 0x3008, 0x3008 },
    { 0x3009, 0x3009 },
    { 0x300a, 0x300a },
    { 0x300b, 0x300b },
    { 0x300c, 0x300c },
    { 0x300d, 0x300d },
    { 0x300e, 0x300e },
    { 0x300f, 0x300f },
    { 0x3010, 0x3010 },
    { 0x3011, 0x3011 },
    { 0x3012, 0x3013 },
    { 0x3014, 0x3014 },
    { 0x3015, 0x3015 },
    { 0x3016, 0x3016 },
    { 0x3017, 0x3017 },
    { 0x3018, 0x3018 },
    { 0x3019, 0x3019 },
    { 0x301a, 0x301a },
    { 0x301b, 0x301b },
    { 0x301c, 0x301c },
    { 0x301d, 0x301d },
    { 0x301e, 0x301f },
    { 0x3020, 0x3020 },
    { 0x3021, 0x3029 },
    { 0x302a, 0x302f },
    { 0x3030, 0x3030 },
    { 0x3031, 0x3035 },
    { 0x3036, 0x3037 },
    { 0x3038, 0x303e },
    { 0x303f, 0x303f },
    { 0x3040, 0x3040 },
    { 0x3041, 0x3094 },
    { 0x3095, 0x3098 },
    { 0x3099, 0x309a },
    { 0x309b, 0x309c },
    { 0x309d, 0x309e },
    { 0x309f, 0x30a0 },
    { 0x30a1, 0x30fa },
    { 0x30fb, 0x30fb },
    { 0x30fc, 0x30fe },
    { 0x30ff, 0x3104 },
    { 0x3105, 0x312c },
    { 0x312d, 0x3130 },
    { 0x3131, 0x318e },
    { 0x318f, 0x318f },
    { 0x3190, 0x3191 },
    { 0x3192, 0x3195 },
    { 0x3196, 0x319f },
    { 0x31a0, 0x31ff },
    { 0x3200, 0x321c },
    { 0x321d, 0x321f },
    { 0x3220, 0x3229 },
    { 0x322a, 0x3243 },
    { 0x3244, 0x325f },
    { 0x3260, 0x327b },
    { 0x327c, 0x327e },
    { 0x327f, 0x327f },
    { 0x3280, 0x3289 },
    { 0x328a, 0x32b0 },
    { 0x32b1, 0x32bf },
    { 0x32c0, 0x32cb },
    { 0x32cc, 0x32cf },
    { 0x32d0, 0x32fe },
    { 0x32ff, 0x32ff },
    { 0x3300, 0x3376 },
    { 0x3377, 0x337a },
    { 0x337b, 0x33dd },
    { 0x33de, 0x33df },
    { 0x33e0, 0x33fe },
    { 0x33ff, 0x4dff },
    { 0x4e00, 0x9fa5 },
    { 0x9fa6, 0xabff },
    { 0xac00, 0xd7a3 },
    { 0xd7a4, 0xd7ff },
    { 0xd800, 0xdfff },
    { 0xe000, 0xf8ff },
    { 0xf900, 0xfa2d },
    { 0xfa2e, 0xfaff },
    { 0xfb00, 0xfb06 },
    { 0xfb07, 0xfb12 },
    { 0xfb13, 0xfb17 },
    { 0xfb18, 0xfb1d },
    { 0xfb1e, 0xfb1e },
    { 0xfb1f, 0xfb28 },
    { 0xfb29, 0xfb29 },
    { 0xfb2a, 0xfb36 },
    { 0xfb37, 0xfb37 },
    { 0xfb38, 0xfb3c },
    { 0xfb3d, 0xfb3d },
    { 0xfb3e, 0xfb3e },
    { 0xfb3f, 0xfb3f },
    { 0xfb40, 0xfb41 },
    { 0xfb42, 0xfb42 },
    { 0xfb43, 0xfb44 },
    { 0xfb45, 0xfb45 },
    { 0xfb46, 0xfbb1 },
    { 0xfbb2, 0xfbd2 },
    { 0xfbd3, 0xfd3d },
    { 0xfd3e, 0xfd3e },
    { 0xfd3f, 0xfd3f },
    { 0xfd40, 0xfd4f },
    { 0xfd50, 0xfd8f },
    { 0xfd90, 0xfd91 },
    { 0xfd92, 0xfdc7 },
    { 0xfdc8, 0xfdef },
    { 0xfdf0, 0xfdfb },
    { 0xfdfc, 0xfe1f },
    { 0xfe20, 0xfe23 },
    { 0xfe24, 0xfe2f },
    { 0xfe30, 0xfe30 },
    { 0xfe31, 0xfe32 },
    { 0xfe33, 0xfe34 },
    { 0xfe35, 0xfe35 },
    { 0xfe36, 0xfe36 },
    { 0xfe37, 0xfe37 },
    { 0xfe38, 0xfe38 },
    { 0xfe39, 0xfe39 },
    { 0xfe3a, 0xfe3a },
    { 0xfe3b, 0xfe3b },
    { 0xfe3c, 0xfe3c },
    { 0xfe3d, 0xfe3d },
    { 0xfe3e, 0xfe3e },
    { 0xfe3f, 0xfe3f },
    { 0xfe40, 0xfe40 },
    { 0xfe41, 0xfe41 },
    { 0xfe42, 0xfe42 },
    { 0xfe43, 0xfe43 },
    { 0xfe44, 0xfe44 },
    { 0xfe45, 0xfe48 },
    { 0xfe49, 0xfe4c },
    { 0xfe4d, 0xfe4f },
    { 0xfe50, 0xfe52 },
    { 0xfe53, 0xfe53 },
    { 0xfe54, 0xfe57 },
    { 0xfe58, 0xfe58 },
    { 0xfe59, 0xfe59 },
    { 0xfe5a, 0xfe5a },
    { 0xfe5b, 0xfe5b },
    { 0xfe5c, 0xfe5c },
    { 0xfe5d, 0xfe5d },
    { 0xfe5e, 0xfe5e },
    { 0xfe5f, 0xfe61 },
    { 0xfe62, 0xfe62 },
    { 0xfe63, 0xfe63 },
    { 0xfe64, 0xfe66 },
    { 0xfe67, 0xfe67 },
    { 0xfe68, 0xfe68 },
    { 0xfe69, 0xfe69 },
    { 0xfe6a, 0xfe6b },
    { 0xfe6c, 0xfe6f },
    { 0xfe70, 0xfe72 },
    { 0xfe73, 0xfe73 },
    { 0xfe74, 0xfe74 },
    { 0xfe75, 0xfe75 },
    { 0xfe76, 0xfefc },
    { 0xfefd, 0xfefe },
    { 0xfeff, 0xfeff },
    { 0xff00, 0xff00 },
    { 0xff01, 0xff03 },
    { 0xff04, 0xff04 },
    { 0xff05, 0xff07 },
    { 0xff08, 0xff08 },
    { 0xff09, 0xff09 },
    { 0xff0a, 0xff0a },
    { 0xff0b, 0xff0b },
    { 0xff0c, 0xff0c },
    { 0xff0d, 0xff0d },
    { 0xff0e, 0xff0f },
    { 0xff10, 0xff19 },
    { 0xff1a, 0xff1b },
    { 0xff1c, 0xff1e },
    { 0xff1f, 0xff20 },
    { 0xff21, 0xff3a },
    { 0xff3b, 0xff3b },
    { 0xff3c, 0xff3c },
    { 0xff3d, 0xff3d },
    { 0xff3e, 0xff3e },
    { 0xff3f, 0xff3f },
    { 0xff40, 0xff40 },
    { 0xff41, 0xff5a },
    { 0xff5b, 0xff5b },
    { 0xff5c, 0xff5c },
    { 0xff5d, 0xff5d },
    { 0xff5e, 0xff5e },
    { 0xff5f, 0xff60 },
    { 0xff61, 0xff61 },
    { 0xff62, 0xff62 },
    { 0xff63, 0xff63 },
    { 0xff64, 0xff64 },
    { 0xff65, 0xff65 },
    { 0xff66, 0xff6f },
    { 0xff70, 0xff70 },
    { 0xff71, 0xff9d },
    { 0xff9e, 0xff9f },
    { 0xffa0, 0xffbe },
    { 0xffbf, 0xffc1 },
    { 0xffc2, 0xffc7 },
    { 0xffc8, 0xffc9 },
    { 0xffca, 0xffcf },
    { 0xffd0, 0xffd1 },
    { 0xffd2, 0xffd7 },
    { 0xffd8, 0xffd9 },
    { 0xffda, 0xffdc },
    { 0xffdd, 0xffdf },
    { 0xffe0, 0xffe1 },
    { 0xffe2, 0xffe2 },
    { 0xffe3, 0xffe3 },
    { 0xffe4, 0xffe4 },
    { 0xffe5, 0xffe6 },
    { 0xffe7, 0xffe7 },
    { 0xffe8, 0xffec },
    { 0xffed, 0xffee },
    { 0xffef, 0xfffb },
    { 0xfffc, 0xfffd },
    { 0xfffe, 0xffff }
  };

static const jbyte category_table[] =
  { java::lang::Character::CONTROL, 
    java::lang::Character::SPACE_SEPARATOR, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::CURRENCY_SYMBOL, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::DASH_PUNCTUATION, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::CONNECTOR_PUNCTUATION, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::CONTROL, 
    java::lang::Character::SPACE_SEPARATOR, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::CURRENCY_SYMBOL, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::DASH_PUNCTUATION, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::TITLECASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::TITLECASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::TITLECASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::TITLECASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::ENCLOSING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::CURRENCY_SYMBOL, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::CURRENCY_SYMBOL, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::COMBINING_SPACING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::SPACE_SEPARATOR, 
    java::lang::Character::FORMAT, 
    java::lang::Character::DASH_PUNCTUATION, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::LINE_SEPARATOR, 
    java::lang::Character::PARAGRAPH_SEPARATOR, 
    java::lang::Character::FORMAT, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::CONNECTOR_PUNCTUATION, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::FORMAT, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::CURRENCY_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::ENCLOSING_MARK, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::LETTER_NUMBER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::SPACE_SEPARATOR, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::LETTER_NUMBER, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::DASH_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::LETTER_NUMBER, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::DASH_PUNCTUATION, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::CONNECTOR_PUNCTUATION, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::OTHER_NUMBER, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::SURROGATE, 
    java::lang::Character::PRIVATE_USE, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::NON_SPACING_MARK, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::DASH_PUNCTUATION, 
    java::lang::Character::CONNECTOR_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::CONNECTOR_PUNCTUATION, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::DASH_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::DASH_PUNCTUATION, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::CURRENCY_SYMBOL, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::FORMAT, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::CURRENCY_SYMBOL, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::DASH_PUNCTUATION, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::DECIMAL_DIGIT_NUMBER, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::UPPERCASE_LETTER, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::CONNECTOR_PUNCTUATION, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::LOWERCASE_LETTER, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::START_PUNCTUATION, 
    java::lang::Character::END_PUNCTUATION, 
    java::lang::Character::OTHER_PUNCTUATION, 
    java::lang::Character::CONNECTOR_PUNCTUATION, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::MODIFIER_LETTER, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_LETTER, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::CURRENCY_SYMBOL, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::MODIFIER_SYMBOL, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::CURRENCY_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::MATH_SYMBOL, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED, 
    java::lang::Character::OTHER_SYMBOL, 
    java::lang::Character::UNASSIGNED
      };

#else /* COMPACT_CHARACTER */

#define ROMAN_START 0x2160
#define ROMAN_END   0x217f

static const jbyte type_table[] =
{ java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::SPACE_SEPARATOR,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::DASH_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::CONNECTOR_PUNCTUATION,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::CONTROL,
    java::lang::Character::SPACE_SEPARATOR,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::DASH_PUNCTUATION,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::TITLECASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::TITLECASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::TITLECASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::TITLECASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::ENCLOSING_MARK,
    java::lang::Character::ENCLOSING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::DECIMAL_DIGIT_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::COMBINING_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::SPACE_SEPARATOR,
    java::lang::Character::SPACE_SEPARATOR,
    java::lang::Character::SPACE_SEPARATOR,
    java::lang::Character::SPACE_SEPARATOR,
    java::lang::Character::SPACE_SEPARATOR,
    java::lang::Character::SPACE_SEPARATOR,
    java::lang::Character::SPACE_SEPARATOR,
    java::lang::Character::SPACE_SEPARATOR,
    java::lang::Character::SPACE_SEPARATOR,
    java::lang::Character::SPACE_SEPARATOR,
    java::lang::Character::SPACE_SEPARATOR,
    java::lang::Character::SPACE_SEPARATOR,
    java::lang::Character::FORMAT,
    java::lang::Character::FORMAT,
    java::lang::Character::FORMAT,
    java::lang::Character::FORMAT,
    java::lang::Character::DASH_PUNCTUATION,
    java::lang::Character::DASH_PUNCTUATION,
    java::lang::Character::DASH_PUNCTUATION,
    java::lang::Character::DASH_PUNCTUATION,
    java::lang::Character::DASH_PUNCTUATION,
    java::lang::Character::DASH_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::LINE_SEPARATOR,
    java::lang::Character::PARAGRAPH_SEPARATOR,
    java::lang::Character::FORMAT,
    java::lang::Character::FORMAT,
    java::lang::Character::FORMAT,
    java::lang::Character::FORMAT,
    java::lang::Character::FORMAT,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::CONNECTOR_PUNCTUATION,
    java::lang::Character::CONNECTOR_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::FORMAT,
    java::lang::Character::FORMAT,
    java::lang::Character::FORMAT,
    java::lang::Character::FORMAT,
    java::lang::Character::FORMAT,
    java::lang::Character::FORMAT,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::CURRENCY_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::ENCLOSING_MARK,
    java::lang::Character::ENCLOSING_MARK,
    java::lang::Character::ENCLOSING_MARK,
    java::lang::Character::ENCLOSING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UPPERCASE_LETTER,
    java::lang::Character::LOWERCASE_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::MATH_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::SPACE_SEPARATOR,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_PUNCTUATION,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::DASH_PUNCTUATION,
    java::lang::Character::START_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::END_PUNCTUATION,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::LETTER_NUMBER,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::DASH_PUNCTUATION,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::NON_SPACING_MARK,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_SYMBOL,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::CONNECTOR_PUNCTUATION,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::MODIFIER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_NUMBER,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::OTHER_SYMBOL,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::UNASSIGNED,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    java::lang::Character::OTHER_LETTER,
    jav