/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.result;

import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.result.NetObjReport;

public class PartReport
extends NetObjReport {
    static final long serialVersionUID = 0L;
    private final NccNameProxy.PartNameProxy nameProxy;
    private final String typeString;
    public VarContext pContext;
    private boolean isMos;
    private boolean isResistor;
    private boolean isInductor;
    private boolean isJosephson;
    private double width;
    private double length;

    private void checkLenWidValid() {
        Job.error(!this.isMos && !this.isResistor && !this.isInductor && !this.isJosephson, "PartReport has no width or length");
    }

    public PartReport(PartReportable p) {
        super(p);
        if (p instanceof Part) {
            this.pContext = ((Part)p).getContext();
        }
        this.nameProxy = p.getNameProxy();
        this.typeString = p.typeString();
        this.isMos = p.isMos();
        this.isResistor = p.isResistor();
        this.isInductor = p.isInductor();
        this.isJosephson = p.isJosephson();
        if (this.isMos || this.isResistor) {
            this.width = p.getWidth();
            this.length = p.getLength();
        }
        if (this.isInductor || this.isJosephson) {
            this.length = p.getLength();
        }
    }

    public NccNameProxy.PartNameProxy getNameProxy() {
        return this.nameProxy;
    }

    public boolean isMos() {
        return this.isMos;
    }

    public boolean isResistor() {
        return this.isResistor;
    }

    public boolean isInductor() {
        return this.isInductor;
    }

    public boolean isJosephson() {
        return this.isJosephson;
    }

    public double getWidth() {
        this.checkLenWidValid();
        return this.width;
    }

    public double getLength() {
        this.checkLenWidValid();
        return this.length;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public static interface PartReportable
    extends NetObjReport.NetObjReportable {
        public NccNameProxy.PartNameProxy getNameProxy();

        public String typeString();

        public boolean isMos();

        public boolean isResistor();

        public boolean isInductor();

        public boolean isJosephson();

        public double getWidth();

        public double getLength();
    }
}

