/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc.wellcheck;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.erc.ERCWellCheck;
import com.sun.electric.tool.erc.wellcheck.Utils;
import com.sun.electric.tool.erc.wellcheck.WellCheckAnalysisStrategy;
import com.sun.electric.tool.erc.wellcheck.WellCon;
import com.sun.electric.util.CollectionFactory;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OnRailCheck
implements WellCheckAnalysisStrategy {
    private Set<Integer> networkExportAvailable;
    private Set<Integer> networkWithExportCache;
    private Map<Integer, List<ERCWellCheck.Transistor>> transistors;
    private Set<ERCWellCheck.Transistor> alreadyHit;
    private ERCWellCheck.StrategyParameter parameter;

    public OnRailCheck(ERCWellCheck.StrategyParameter parameter, Set<Integer> networkExportAvailable, Map<Integer, List<ERCWellCheck.Transistor>> transistors) {
        this.networkExportAvailable = networkExportAvailable;
        this.transistors = transistors;
        this.networkWithExportCache = CollectionFactory.createHashSet();
        this.parameter = parameter;
    }

    @Override
    public void execute() {
        int total = this.parameter.getWellCons().size();
        int count = 0;
        Job.getUserInterface().startProgressDialog("Checking rails on " + total + " well contacts", null);
        for (WellCon wc : this.parameter.getWellCons()) {
            if (!wc.isOnRail()) {
                if (this.networkExportAvailable.contains(wc.getNetNum())) {
                    wc.setOnRail(true);
                } else if (this.networkWithExportCache.contains(wc.getNetNum())) {
                    wc.setOnRail(true);
                } else {
                    HashSet<Integer> startPath = new HashSet<Integer>();
                    List<ERCWellCheck.Transistor> startTrans = this.transistors.get(wc.getNetNum());
                    if (startTrans != null && this.createTransistorChain(startPath, startTrans.get(0), false)) {
                        wc.setOnRail(true);
                        this.networkWithExportCache.addAll(startPath);
                    }
                }
            }
            if (!wc.isOnRail() && !wc.isOnProperRail()) {
                if (Utils.canBeSubstrateTap(wc.getFun())) {
                    if (this.parameter.getWellPrefs().mustConnectPWellToGround) {
                        this.parameter.logError("P-Well contact '" + wc.getNi().getName() + "' not connected to ground", wc);
                    }
                } else if (this.parameter.getWellPrefs().mustConnectNWellToPower) {
                    this.parameter.logError("N-Well contact '" + wc.getNi().getName() + "' not connected to ground", wc);
                }
            }
            if (++count % 10 != 0) continue;
            Job.getUserInterface().setProgressValue(count * 100 / total);
        }
        Job.getUserInterface().stopProgressDialog();
    }

    private boolean createTransistorChain(Set<Integer> path, ERCWellCheck.Transistor node, boolean result) {
        this.alreadyHit = new HashSet<ERCWellCheck.Transistor>();
        if (!(result |= this.createTransistorRec(path, node, result, node.getDrainNet().get()))) {
            result |= this.createTransistorRec(path, node, result, node.getSourceNet().get());
        }
        return result;
    }

    private boolean createTransistorRec(Set<Integer> path, ERCWellCheck.Transistor node, boolean result, int num) {
        LinkedList<ERCWellCheck.Transistor> transis = new LinkedList<ERCWellCheck.Transistor>();
        transis.add(node);
        this.alreadyHit.add(node);
        while (transis.size() > 0) {
            ERCWellCheck.Transistor transistor = (ERCWellCheck.Transistor)transis.get(0);
            transis.remove(transistor);
            Integer neighbor = null;
            neighbor = transistor.getDrainNet().get() == num ? Integer.valueOf(transistor.getSourceNet().get()) : Integer.valueOf(transistor.getDrainNet().get());
            path.add(neighbor);
            num = neighbor;
            if (!(result |= this.networkExportAvailable.contains(neighbor))) {
                result |= this.networkWithExportCache.contains(neighbor);
            }
            if (result) {
                return result;
            }
            for (ERCWellCheck.Transistor trans : this.transistors.get(neighbor)) {
                if (this.alreadyHit.contains(trans)) continue;
                transis.add(trans);
                this.alreadyHit.add(trans);
            }
        }
        return result;
    }
}

