/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.math;

import com.sun.electric.util.math.AbstractFixpPoint;
import com.sun.electric.util.math.AbstractFixpRectangle;
import com.sun.electric.util.math.ECoord;
import com.sun.electric.util.math.FixpCoord;
import com.sun.electric.util.math.Orientation;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class FixpTransform
extends AffineTransform {
    private long fixpX;
    private long fixpY;
    private Orientation orient;

    public FixpTransform() {
        this.orient = Orientation.IDENT;
    }

    public FixpTransform(AffineTransform Tx) {
        super(Tx);
        if (Tx instanceof FixpTransform && ((FixpTransform)Tx).orient != null) {
            FixpTransform ft = (FixpTransform)Tx;
            this.fixpX = ft.fixpX;
            this.fixpY = ft.fixpY;
            this.orient = ft.orient;
        }
    }

    public FixpTransform(float m00, float m10, float m01, float m11, float m02, float m12) {
        super(m00, m10, m01, m11, m02, m12);
    }

    public FixpTransform(float[] flatmatrix) {
        super(flatmatrix);
    }

    public FixpTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        super(m00, m10, m01, m11, m02, m12);
    }

    public FixpTransform(double[] flatmatrix) {
        super(flatmatrix);
    }

    public FixpTransform(FixpTransform Tx) {
        this.setTransform(Tx.fixpX, Tx.fixpY, Tx.orient);
    }

    public FixpTransform(long fixpX, long fixpY, Orientation orient) {
        super.setTransform(orient.m00, orient.m10, orient.m01, orient.m11, FixpCoord.fixpToLambda(fixpX), FixpCoord.fixpToLambda(fixpY));
        this.fixpX = fixpX;
        this.fixpY = fixpY;
        this.orient = orient;
    }

    public FixpTransform(AbstractFixpPoint anchor, Orientation orient) {
        this(anchor.getFixpX(), anchor.getFixpY(), orient);
    }

    public static FixpTransform getTranslateInstance(double tx, double ty) {
        FixpTransform ft = new FixpTransform();
        ft.setToTranslation(tx, ty);
        return ft;
    }

    public static FixpTransform getRotateInstance(double theta) {
        FixpTransform ft = new FixpTransform();
        ft.setToRotation(theta);
        return ft;
    }

    public static FixpTransform getRotateInstance(double theta, double anchorx, double anchory) {
        FixpTransform ft = new FixpTransform();
        ft.setToRotation(theta, anchorx, anchory);
        return ft;
    }

    public static FixpTransform getRotateInstance(double vecx, double vecy) {
        FixpTransform ft = new FixpTransform();
        ft.setToRotation(vecx, vecy);
        return ft;
    }

    public static FixpTransform getRotateInstance(double vecx, double vecy, double anchorx, double anchory) {
        FixpTransform ft = new FixpTransform();
        ft.setToRotation(vecx, vecy, anchorx, anchory);
        return ft;
    }

    public static FixpTransform getQuadrantRotateInstance(int numquadrants) {
        FixpTransform ft = new FixpTransform();
        ft.setToQuadrantRotation(numquadrants);
        return ft;
    }

    public static FixpTransform getQuadrantRotateInstance(int numquadrants, double anchorx, double anchory) {
        FixpTransform ft = new FixpTransform();
        ft.setToQuadrantRotation(numquadrants, anchorx, anchory);
        return ft;
    }

    public static FixpTransform getScaleInstance(double sx, double sy) {
        FixpTransform ft = new FixpTransform();
        ft.setToScale(sx, sy);
        return ft;
    }

    public static FixpTransform getShearInstance(double sx, double sy) {
        FixpTransform ft = new FixpTransform();
        ft.setToShear(sx, sy);
        return ft;
    }

    @Override
    public int getType() {
        if (this.orient != null) {
            int type = this.orient.getType();
            if ((this.fixpX | this.fixpY) != 0L) {
                type |= 1;
            }
            return type;
        }
        return super.getType();
    }

    @Override
    public double getDeterminant() {
        return this.orient != null ? this.orient.getDeterminant() : super.getDeterminant();
    }

    @Override
    public void translate(double tx, double ty) {
        if (this.orient != null) {
            long fixpTx = FixpCoord.lambdaToFixp(tx);
            long fixpTy = FixpCoord.lambdaToFixp(ty);
            this.setTransform(this.fixpX + this.orient.transformX(fixpTx, fixpTy), this.fixpY + this.orient.transformY(fixpTx, fixpTy), this.orient);
        } else {
            super.translate(tx, ty);
            this.orient = null;
        }
    }

    public void translateFixp(long fixpx, long fixpy) {
        if (this.orient != null) {
            this.setTransform(this.fixpX + this.orient.transformX(fixpx, fixpy), this.fixpY + this.orient.transformY(fixpx, fixpy), this.orient);
        } else {
            super.translate(FixpCoord.fixpToLambda(fixpx), FixpCoord.fixpToLambda(fixpy));
            this.orient = null;
        }
    }

    @Override
    public void rotate(double theta) {
        super.rotate(theta);
        this.orient = null;
    }

    @Override
    public void rotate(double theta, double anchorx, double anchory) {
        super.rotate(theta, anchorx, anchory);
        this.orient = null;
    }

    @Override
    public void rotate(double vecx, double vecy) {
        super.rotate(vecx, vecy);
        this.orient = null;
    }

    @Override
    public void rotate(double vecx, double vecy, double anchorx, double anchory) {
        super.rotate(vecx, vecy, anchorx, anchory);
        this.orient = null;
    }

    @Override
    public void quadrantRotate(int numquadrants) {
        if (this.orient != null) {
            this.setTransform(this.fixpX, this.fixpY, this.orient.concatenate(Orientation.fromQuadrants(numquadrants)));
        } else {
            super.quadrantRotate(numquadrants);
        }
    }

    @Override
    public void quadrantRotate(int numquadrants, double anchorx, double anchory) {
        if (this.orient != null) {
            Orientation rotate = Orientation.fromQuadrants(numquadrants);
            long fixpAnchorX = FixpCoord.lambdaToFixp(anchorx);
            long fixpAnchorY = FixpCoord.lambdaToFixp(anchory);
            long newFixpX = this.fixpX + fixpAnchorX + rotate.transformX(-fixpAnchorX, -fixpAnchorY);
            long newFixpY = this.fixpY + fixpAnchorY + rotate.transformY(-fixpAnchorX, -fixpAnchorY);
            this.setTransform(newFixpX, newFixpY, this.orient.concatenate(rotate));
        } else {
            super.quadrantRotate(numquadrants, anchorx, anchory);
        }
    }

    @Override
    public void scale(double sx, double sy) {
        super.scale(sx, sy);
        this.orient = null;
    }

    @Override
    public void shear(double shx, double shy) {
        super.shear(shx, shy);
        this.orient = null;
    }

    @Override
    public void setToIdentity() {
        this.setTransform(0L, 0L, Orientation.IDENT);
    }

    @Override
    public void setToTranslation(double tx, double ty) {
        this.setTransform(FixpCoord.lambdaToFixp(tx), FixpCoord.lambdaToFixp(ty), Orientation.IDENT);
    }

    @Override
    public void setToRotation(double theta) {
        super.setToRotation(theta);
        this.orient = null;
    }

    @Override
    public void setToRotation(double theta, double anchorx, double anchory) {
        super.setToRotation(theta, anchorx, anchory);
        this.orient = null;
    }

    @Override
    public void setToRotation(double vecx, double vecy) {
        super.setToRotation(vecx, vecy);
        this.orient = null;
    }

    @Override
    public void setToRotation(double vecx, double vecy, double anchorx, double anchory) {
        super.setToRotation(vecx, vecy, anchorx, anchory);
        this.orient = null;
    }

    @Override
    public void setToQuadrantRotation(int numquadrants) {
        this.setTransform(0L, 0L, Orientation.fromQuadrants(numquadrants));
    }

    @Override
    public void setToQuadrantRotation(int numquadrants, double anchorx, double anchory) {
        Orientation rotate = Orientation.fromQuadrants(numquadrants);
        long fixpAnchorX = FixpCoord.lambdaToFixp(anchorx);
        long fixpAnchorY = FixpCoord.lambdaToFixp(anchory);
        long newFixpX = fixpAnchorX + rotate.transformX(-fixpAnchorX, -fixpAnchorY);
        long newFixpY = fixpAnchorY + rotate.transformY(-fixpAnchorX, -fixpAnchorY);
        this.setTransform(newFixpX, newFixpY, rotate);
    }

    @Override
    public void setToScale(double sx, double sy) {
        super.setToScale(sx, sy);
        this.orient = null;
    }

    @Override
    public void setToShear(double shx, double shy) {
        super.setToShear(shx, shy);
        this.orient = null;
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        super.setTransform(Tx);
        this.orient = null;
    }

    @Override
    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        super.setTransform(m00, m10, m01, m11, m02, m12);
        this.orient = null;
    }

    public void setTransform(long fixpX, long fixpY, Orientation orient) {
        super.setTransform(orient.m00, orient.m10, orient.m01, orient.m11, FixpCoord.fixpToLambda(fixpX), FixpCoord.fixpToLambda(fixpY));
        this.fixpX = fixpX;
        this.fixpY = fixpY;
        this.orient = orient;
    }

    @Override
    public void concatenate(AffineTransform Tx) {
        if (this.orient != null && Tx instanceof FixpTransform && ((FixpTransform)Tx).orient != null) {
            FixpTransform ft = (FixpTransform)Tx;
            long fixpTx = ft.fixpX;
            long fixpTy = ft.fixpY;
            Orientation orientTx = ft.orient;
            long newFixpX = this.fixpX + this.orient.transformX(fixpTx, fixpTy);
            long newFixpY = this.fixpY + this.orient.transformY(fixpTx, fixpTy);
            this.setTransform(newFixpX, newFixpY, this.orient.concatenate(orientTx));
        } else {
            super.concatenate(Tx);
            this.orient = null;
        }
    }

    @Override
    public void preConcatenate(AffineTransform Tx) {
        if (this.orient != null && Tx instanceof FixpTransform && ((FixpTransform)Tx).orient != null) {
            FixpTransform ft = (FixpTransform)Tx;
            long fixpTx = ft.fixpX;
            long fixpTy = ft.fixpY;
            Orientation orientTx = ft.orient;
            long newFixpX = fixpTx + orientTx.transformX(this.fixpX, this.fixpY);
            long newFixpY = fixpTy + orientTx.transformY(this.fixpX, this.fixpY);
            this.setTransform(newFixpX, newFixpY, orientTx.concatenate(this.orient));
        } else {
            super.preConcatenate(Tx);
            this.orient = null;
        }
    }

    @Override
    public FixpTransform createInverse() throws NoninvertibleTransformException {
        if (this.orient != null) {
            return new FixpTransform(-this.orient.transformX(this.fixpX, this.fixpY), -this.orient.transformY(this.fixpX, this.fixpY), this.orient.inverse());
        }
        FixpTransform ft = new FixpTransform(this);
        ft.invert();
        return ft;
    }

    @Override
    public void invert() throws NoninvertibleTransformException {
        if (this.orient != null) {
            this.setTransform(-this.orient.transformX(this.fixpX, this.fixpY), -this.orient.transformY(this.fixpX, this.fixpY), this.orient.inverse());
        } else {
            super.invert();
        }
    }

    @Override
    public Point2D transform(Point2D ptSrc, Point2D ptDst) {
        return this.orient != null ? this.orient.transform(this.fixpX, this.fixpY, ptSrc, ptDst) : super.transform(ptSrc, ptDst);
    }

    @Override
    public void transform(Point2D[] ptSrc, int srcOff, Point2D[] ptDst, int dstOff, int numPts) {
        if (this.orient != null && ptSrc instanceof AbstractFixpPoint[] && ptDst instanceof AbstractFixpPoint[]) {
            this.orient.transform(this.fixpX, this.fixpY, (AbstractFixpPoint[])ptSrc, srcOff, (AbstractFixpPoint[])ptDst, dstOff, numPts);
        } else {
            while (--numPts >= 0) {
                Point2D dst;
                Point2D src = ptSrc[srcOff++];
                if ((dst = ptDst[dstOff++]) == null) {
                    ptDst[dstOff - 1] = this.transform(src, null);
                    continue;
                }
                this.transform(src, dst);
            }
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public Point2D inverseTransform(Point2D ptSrc, Point2D ptDst) {
        if (ptSrc instanceof AbstractFixpPoint) {
            AbstractFixpPoint fpSrc = (AbstractFixpPoint)ptSrc;
            long srcX = fpSrc.getFixpX() - this.fixpX;
            long srcY = fpSrc.getFixpY() - this.fixpY;
            Orientation inverse = this.orient.inverse();
            long dstX = inverse.transformX(srcX, srcY);
            long dstY = inverse.transformY(srcX, srcY);
            if (ptDst == null) {
                ptDst = fpSrc.create(dstX, dstY);
            } else if (ptDst instanceof AbstractFixpPoint) {
                ((AbstractFixpPoint)ptDst).setFixpLocation(dstX, dstY);
            } else {
                ptDst.setLocation(FixpCoord.fixpToLambda(dstX), FixpCoord.fixpToLambda(dstY));
            }
            return ptDst;
        }
        double srcX = ptSrc.getX() - FixpCoord.fixpToLambda(this.fixpX);
        double srcY = ptSrc.getY() - FixpCoord.fixpToLambda(this.fixpY);
        double dstX = this.orient.transformX(srcX, srcY);
        double dstY = this.orient.transformY(srcX, srcY);
        if (ptDst == null) {
            ptDst = ptSrc instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        ptDst.setLocation(dstX, dstY);
        return ptDst;
    }

    @Override
    public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        try {
            super.inverseTransform(srcPts, srcOff, dstPts, dstOff, numPts);
        }
        catch (NoninvertibleTransformException e) {
            throw new AssertionError();
        }
    }

    @Override
    public Point2D deltaTransform(Point2D ptSrc, Point2D ptDst) {
        return this.orient != null ? this.orient.transform(0L, 0L, ptSrc, ptDst) : super.deltaTransform(ptSrc, ptDst);
    }

    @Override
    public void deltaTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        super.deltaTransform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    public void transform(AbstractFixpRectangle rectSrc, AbstractFixpRectangle rectDst) {
        if (this.orient != null) {
            this.orient.rectangleBounds(rectSrc, this.fixpX, this.fixpY, rectDst);
        } else {
            double[] coords = new double[]{rectSrc.getMinX(), rectSrc.getMinY(), rectSrc.getMaxX(), rectSrc.getMaxY()};
            this.transform(coords, 0, coords, 0, 2);
            rectDst.setFrameFromDiagonal(coords[0], coords[1], coords[2], coords[3]);
        }
    }

    public void transform(Rectangle2D rectSrc, Rectangle2D rectDst) {
        if (rectSrc instanceof AbstractFixpRectangle && rectDst instanceof AbstractFixpRectangle) {
            this.transform((AbstractFixpRectangle)rectSrc, (AbstractFixpRectangle)rectDst);
        } else if (this.orient != null) {
            this.orient.rectangleBounds(rectSrc.getMinX(), rectSrc.getMinY(), rectSrc.getMaxX(), rectSrc.getMaxY(), ECoord.fixpToLambda(this.fixpX), ECoord.fixpToLambda(this.fixpY), rectDst);
        } else {
            double[] coords = new double[]{rectSrc.getMinX(), rectSrc.getMinY(), rectSrc.getMaxX(), rectSrc.getMaxY()};
            this.transform(coords, 0, coords, 0, 2);
            rectDst.setFrameFromDiagonal(coords[0], coords[1], coords[2], coords[3]);
        }
    }

    @Override
    public Shape createTransformedShape(Shape pSrc) {
        return super.createTransformedShape(pSrc);
    }

    @Override
    public boolean isIdentity() {
        return this.orient != null ? this.orient.isIdent() && (this.fixpX | this.fixpY) == 0L : super.isIdentity();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FixpTransform) {
            FixpTransform that = (FixpTransform)obj;
            if (this.orient != null && that.orient != null) {
                return this.orient.canonic() == that.orient.canonic() && this.fixpX == that.fixpX && this.fixpY == that.fixpY;
            }
        }
        return super.equals(obj);
    }

    private static boolean isFixp(AffineTransform Tx) {
        if (Tx instanceof FixpTransform) {
            return ((FixpTransform)Tx).orient != null;
        }
        return FixpTransform.getOrient(Tx) != null && FixpCoord.fixpToLambda(FixpTransform.getFixpX(Tx)) == Tx.getTranslateX() && FixpCoord.fixpToLambda(FixpTransform.getFixpY(Tx)) == Tx.getTranslateY();
    }

    private static long getFixpX(AffineTransform Tx) {
        if (Tx instanceof FixpTransform) {
            return ((FixpTransform)Tx).fixpX;
        }
        return FixpCoord.lambdaToFixp(Tx.getTranslateX());
    }

    private static long getFixpY(AffineTransform Tx) {
        if (Tx instanceof FixpTransform) {
            return ((FixpTransform)Tx).fixpY;
        }
        return FixpCoord.lambdaToFixp(Tx.getTranslateY());
    }

    private static Orientation getOrient(AffineTransform Tx) {
        if (Tx instanceof FixpTransform) {
            return ((FixpTransform)Tx).orient;
        }
        double m00 = Tx.getScaleX();
        double m01 = Tx.getShearX();
        double m10 = Tx.getShearY();
        double m11 = Tx.getScaleY();
        Orientation or = null;
        if (Math.abs(m00) == 1.0 && Math.abs(m11) == 1.0 && m01 == 0.0 && m10 == 0.0) {
            or = m00 > 0.0 ? (m11 > 0.0 ? Orientation.IDENT : Orientation.Y) : (m11 > 0.0 ? Orientation.X : Orientation.RR);
        } else if (Math.abs(m01) == 1.0 && Math.abs(m10) == 1.0 && m00 == 0.0 && m11 == 0.0) {
            or = m01 > 0.0 ? (m10 > 0.0 ? Orientation.YRRR : Orientation.RRR) : (m10 > 0.0 ? Orientation.R : Orientation.YR);
        } else {
            return null;
        }
        assert (m00 == or.m00);
        assert (m01 == or.m01);
        assert (m10 == or.m10);
        assert (m11 == or.m11);
        return or;
    }
}

