/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class TextUtils {
    private static NumberFormat numberFormatSpecific = null;

    public static boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    public static boolean isLetterOrDigit(char ch) {
        return TextUtils.isDigit(ch) || Character.isLetter(ch);
    }

    public static boolean startsWithIgnoreCase(String main2, String with) {
        int mainLen = main2.length();
        int withLen = with.length();
        if (withLen > mainLen) {
            return false;
        }
        for (int i = 0; i < withLen; ++i) {
            char withChr;
            char mainChr = Character.toLowerCase(main2.charAt(i));
            if (mainChr == (withChr = Character.toLowerCase(with.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static int atoi(String s2) {
        return TextUtils.atoi(s2, 0, 0);
    }

    public static int atoi(String s2, int pos) {
        return TextUtils.atoi(s2, pos, 0);
    }

    public static int atoi(String s2, int pos, int base) {
        char cat2;
        int digit;
        int num = 0;
        int sign = 1;
        int len = s2.length();
        if (pos < len && s2.charAt(pos) == '-') {
            ++pos;
            sign = -1;
        }
        if (base == 0) {
            base = 10;
            if (pos < len && s2.charAt(pos) == '0') {
                base = 8;
                if (++pos < len && (s2.charAt(pos) == 'x' || s2.charAt(pos) == 'X')) {
                    ++pos;
                    base = 16;
                } else if (pos < len && (s2.charAt(pos) == 'b' || s2.charAt(pos) == 'B')) {
                    ++pos;
                    base = 2;
                }
            }
        }
        while (pos < len && (digit = Character.digit(cat2 = s2.charAt(pos), base)) >= 0) {
            num = num * base + digit;
            ++pos;
        }
        return num * sign;
    }

    public static String formatDouble(double v) {
        return TextUtils.formatDouble(v, 3);
    }

    public static synchronized String formatDouble(double v, int numFractions) {
        if (numberFormatSpecific == null) {
            numberFormatSpecific = NumberFormat.getInstance(Locale.US);
            if (numberFormatSpecific != null) {
                numberFormatSpecific.setGroupingUsed(false);
            }
            try {
                DecimalFormat d = (DecimalFormat)numberFormatSpecific;
                d.setDecimalSeparatorAlwaysShown(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (numFractions == 0) {
            numberFormatSpecific.setMaximumFractionDigits(340);
        } else {
            numberFormatSpecific.setMaximumFractionDigits(numFractions);
        }
        return numberFormatSpecific.format(v);
    }
}

