/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Equipment;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.PowerChannel;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class HP548xxA
extends Equipment {
    public static final int STAT_LAST = 0;
    public static final int STAT_MIN = 1;
    public static final int STAT_MAX = 2;
    public static final int STAT_MEAN = 3;
    public static final int STAT_DEV = 4;
    public static final int STAT_NSAMP = 5;
    public static final int MIN_NSAMP = 10;
    public static final int NUM_CHAN = 4;
    public static final int RESULTS_PER_CHANNEL = 6;
    public static final float DELAY_FOR_SAMPLES = 4.0f;
    private static final String FREQ_NAME_START = "Frequency(";

    public HP548xxA(String name) {
        super(name);
    }

    public float getFrequency(int channel) {
        this.write("MEAS:FREQ? CHAN" + channel);
        String s2 = this.read(20).trim();
        return new Float(s2.split("\\s")[0]).floatValue();
    }

    public float[][] accumulateFrequencies(int nchan) {
        this.checkChannelNumber(nchan);
        this.write("MEAS:CLEAR");
        this.write("MEAS:STATISTICS ON");
        this.write("MEAS:FREQ CHAN1");
        if (nchan > 1) {
            this.write("MEAS:FREQ CHAN2");
        }
        if (nchan > 2) {
            this.write("MEAS:FREQ CHAN3");
        }
        if (nchan > 3) {
            this.write("MEAS:FREQ CHAN4");
        }
        float[][] results = new float[nchan + 1][6];
        int minSamples = 11;
        int minSamplesOld = 0;
        do {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.getStatistics(nchan, results);
            System.out.print("Got");
            for (int ichan = 1; ichan <= nchan; ++ichan) {
                int nsamp = Math.round(results[ichan][5]);
                System.out.print(" " + nsamp);
                if (nsamp >= minSamples) continue;
                minSamples = nsamp;
            }
            System.out.println(" samples");
            if (minSamples <= minSamplesOld) {
                Infrastructure.fatal("At least one channel not accumulating");
            }
            minSamplesOld = minSamples;
        } while (minSamples < 10);
        return results;
    }

    private void getStatistics(int nchan, float[][] results) {
        this.write("MEAS:RESULTS?");
        String s2 = this.read(400).trim();
        String[] strings = s2.split(",");
        results[0][4] = 0.0f;
        results[0][3] = 0.0f;
        results[0][0] = 0.0f;
        results[0][1] = Float.MAX_VALUE;
        results[0][2] = 0.0f;
        results[0][5] = 0.0f;
        for (int imeas = 1; imeas <= nchan; ++imeas) {
            int ind = 7 * (imeas - 1);
            String freqName = strings[ind];
            if (!freqName.startsWith(FREQ_NAME_START)) {
                Infrastructure.fatal("Expected Frequency(n), found " + freqName);
            }
            String freqNum = freqName.substring(FREQ_NAME_START.length(), freqName.length() - 1);
            int ichan = Integer.parseInt(freqNum);
            for (int iresult = 0; iresult < 6; ++iresult) {
                results[ichan][iresult] = Float.parseFloat(strings[ind + iresult + 1]);
            }
            float[] fArray = results[0];
            fArray[5] = fArray[5] + results[ichan][5];
            float[] fArray2 = results[0];
            fArray2[3] = fArray2[3] + results[ichan][3];
            results[0][1] = Math.min(results[0][1], results[ichan][1]);
            results[0][2] = Math.max(results[0][2], results[ichan][2]);
        }
        results[0][3] = results[0][3] / (float)nchan;
    }

    public void frequencyVsVoltage(String nameStart, PowerChannel supply, float startV, float endV, float stepV, int nchan) {
        this.checkChannelNumber(nchan);
        int startMilliV = Math.round(startV * 1000.0f);
        int endMilliV = Math.round(endV * 1000.0f);
        int stepMilliV = Math.round(stepV * 1000.0f);
        float origVdd = supply.getVoltageSetpoint();
        System.out.println("HP548xxA.frequencyVsVoltage() scan:");
        try {
            PrintWriter[] files = new PrintWriter[nchan + 1];
            for (int ichan = 0; ichan <= nchan; ++ichan) {
                files[ichan] = this.openFile(nameStart + ichan + ".dat");
            }
            PrintWriter file = this.openFile(nameStart + "all.dat");
            for (int mV = startMilliV; mV <= endMilliV; mV += stepMilliV) {
                float thisV = (float)mV / 1000.0f;
                supply.setVoltageWait(thisV);
                float[][] frequencies = this.accumulateFrequencies(nchan);
                System.out.print(thisV + ":");
                file.print(thisV);
                for (int ichan = 0; ichan <= nchan; ++ichan) {
                    System.out.print(" " + frequencies[ichan][3]);
                    file.print(" " + frequencies[ichan][3]);
                    file.print(" " + frequencies[ichan][4]);
                    files[ichan].print(thisV + " " + ichan);
                    files[ichan].print(" " + frequencies[ichan][3]);
                    files[ichan].print(" " + frequencies[ichan][4]);
                    files[ichan].print(" " + frequencies[ichan][1]);
                    files[ichan].print(" " + frequencies[ichan][2]);
                    files[ichan].println(" " + frequencies[ichan][5]);
                }
                System.out.println();
                file.println();
            }
            file.close();
            for (int ichan = 0; ichan <= nchan; ++ichan) {
                files[ichan].close();
            }
        }
        catch (Exception e) {
            System.err.println("exception occurred: " + e);
        }
        supply.setVoltageWait(origVdd);
    }

    private PrintWriter openFile(String name) throws IOException {
        PrintWriter file = new PrintWriter(new FileWriter(name));
        file.println("$DATA1 SOURCE='Lab' VERSION='1'");
        file.println(".TITLE '* file " + name + "'");
        file.println("vdd osctype freq_ave sigma freqmax freqmin samples");
        return file;
    }

    private void checkChannelNumber(int nchan) {
        if (nchan <= 0 || nchan > 4) {
            Infrastructure.fatal("Bad channel index " + nchan);
        }
    }
}

