/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.CellId;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.erc.ERC;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PromptAt;
import com.sun.electric.tool.user.tecEdit.ArcInfo;
import com.sun.electric.tool.user.tecEdit.Example;
import com.sun.electric.tool.user.tecEdit.GeneralInfo;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import com.sun.electric.tool.user.tecEdit.NodeInfo;
import com.sun.electric.tool.user.tecEdit.Sample;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class Manipulate {
    private static int[] copiedPattern = null;

    public static void renamedCell(String oldName, String newName) {
        if (oldName.startsWith("layer-") && newName.startsWith("layer-")) {
            Manipulate.renameSequence(Info.LAYERSEQUENCE_KEY, oldName.substring(6), newName.substring(6));
        }
        if (oldName.startsWith("arc-") && newName.startsWith("arc-")) {
            Manipulate.renameSequence(Info.ARCSEQUENCE_KEY, oldName.substring(4), newName.substring(4));
        }
        if (oldName.startsWith("node-") && newName.startsWith("node-")) {
            Manipulate.renameSequence(Info.NODESEQUENCE_KEY, oldName.substring(5), newName.substring(5));
        }
    }

    public static void deletedCell(Cell np) {
        if (np.getName().startsWith("layer-")) {
            String layerName = np.getName().substring(6);
            StringBuffer warning = null;
            Iterator<Cell> it = np.getLibrary().getCells();
            block0: while (it.hasNext()) {
                Cell oNp = it.next();
                boolean isNode = false;
                if (oNp.getName().startsWith("node-")) {
                    isNode = true;
                } else if (!oNp.getName().startsWith("arc-")) continue;
                Iterator<NodeInst> nIt = oNp.getNodes();
                while (nIt.hasNext()) {
                    NodeInst ni = nIt.next();
                    Variable var = ni.getVar(Info.LAYER_KEY);
                    if (var == null) continue;
                    CellId cID = (CellId)var.getObject();
                    Cell varCell = EDatabase.serverDatabase().getCell(cID);
                    if (varCell != np) continue;
                    if (warning != null) {
                        warning.append(",");
                    } else {
                        warning = new StringBuffer();
                        warning.append("Warning: layer " + layerName + " is used in");
                    }
                    if (isNode) {
                        warning.append(" node " + oNp.getName().substring(5));
                        continue block0;
                    }
                    warning.append(" arc " + oNp.getName().substring(4));
                    continue block0;
                }
            }
            if (warning != null) {
                System.out.println(warning.toString());
            }
            Manipulate.renamedCell(np.getName(), "");
        } else if (np.getName().startsWith("node-")) {
            Manipulate.renamedCell(np.getName(), "");
        }
    }

    private static void renameSequence(Variable.Key varName, String oldName, String newName) {
        Library lib = Library.getCurrent();
        Variable var = lib.getVar(varName);
        if (var == null) {
            return;
        }
        String[] strings = (String[])var.getObject();
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(oldName)) continue;
            strings[i] = newName;
        }
        lib.newVar(varName, (Object)strings);
    }

    public static boolean invalidCreation(NodeProto np, Cell cell) {
        if (!cell.getName().startsWith("node-") && !cell.getName().startsWith("arc-")) {
            System.out.println("Must be editing a node or arc to place geometry");
            return true;
        }
        if (np == Generic.tech.portNode && !cell.getName().startsWith("node-")) {
            System.out.println("Can only place ports in node descriptions");
            return true;
        }
        return false;
    }

    public static void makeCell(int type) {
        Library lib = Library.getCurrent();
        String cellName = null;
        switch (type) {
            case 1: {
                String layerName = JOptionPane.showInputDialog("Name of new layer:", (Object)"");
                if (layerName == null) {
                    return;
                }
                cellName = "layer-" + layerName;
                break;
            }
            case 2: {
                String arcName = JOptionPane.showInputDialog("Name of new arc:", (Object)"");
                if (arcName == null) {
                    return;
                }
                cellName = "arc-" + arcName;
                break;
            }
            case 3: {
                String nodeName = JOptionPane.showInputDialog("Name of new node:", (Object)"");
                if (nodeName == null) {
                    return;
                }
                cellName = "node-" + nodeName;
                break;
            }
            case 4: {
                cellName = "factors";
            }
        }
        Cell cell = lib.findNodeProto(cellName);
        if (cell != null) {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf != null) {
                wf.setCellWindow(cell, null);
            }
            return;
        }
        MakeOneCellJob job = new MakeOneCellJob(lib, cellName, type);
    }

    public static void completeNodeCreation(NodeInst newNi, NodeInst niTemplate) {
        Variable v;
        String portName = null;
        if (newNi.getProto() == Generic.tech.portNode && (portName = JOptionPane.showInputDialog("Port name:", (Object)"")) == null) {
            return;
        }
        boolean isHighlight = false;
        if (niTemplate != null && (v = niTemplate.getVar(Info.OPTION_KEY)) != null && v.getObject() instanceof Integer && (Integer)v.getObject() == 19) {
            isHighlight = true;
        }
        new AddTechEditMarks(newNi, isHighlight, portName);
    }

    public static void editLibraryDependencies() {
        EditDependentLibraries dialog = new EditDependentLibraries();
    }

    public static void identifyLayers(boolean doPorts) {
        int i;
        EditWindow wnd = EditWindow.getCurrent();
        Cell np = WindowFrame.needCurCell();
        if (wnd == null || np == null) {
            return;
        }
        if (doPorts) {
            if (!np.getName().startsWith("node-")) {
                System.out.println("Must be editing a node to identify ports");
                return;
            }
        } else if (!np.getName().startsWith("node-") && !np.getName().startsWith("arc-")) {
            System.out.println("Must be editing a node or arc to identify layers");
            return;
        }
        Example neList = null;
        neList = np.getName().startsWith("node-") ? Example.getExamples(np, true) : Example.getExamples(np, false);
        if (neList == null) {
            return;
        }
        int total = 0;
        for (Sample ns : neList.samples) {
            if (!doPorts) {
                if (ns.layer == Generic.tech.portNode) continue;
                ++total;
                continue;
            }
            if (ns.layer != Generic.tech.portNode) continue;
            ++total;
        }
        if (total == 0) {
            System.out.println("There are no " + (doPorts ? "ports" : "layers") + " to identify");
            return;
        }
        double[] xPos = new double[total];
        double[] yPos = new double[total];
        Poly.Type[] style = new Poly.Type[total];
        Sample[] whichSam = new Sample[total];
        int qTotal = (total + 3) / 4;
        Rectangle2D screen = wnd.getBoundsInWindow();
        double ySep = screen.getHeight() / (double)qTotal;
        double xSep = screen.getWidth() / (double)qTotal;
        double indent = screen.getHeight() / 15.0;
        for (int i2 = 0; i2 < qTotal; ++i2) {
            xPos[i2] = screen.getMinX() + indent;
            yPos[i2] = screen.getMinY() + ySep * (double)i2 + ySep / 2.0;
            style[i2] = Poly.Type.TEXTLEFT;
            if (i2 + qTotal < total) {
                xPos[i2 + qTotal] = screen.getMinX() + xSep * (double)i2 + xSep / 2.0;
                yPos[i2 + qTotal] = screen.getMaxY() - indent;
                style[i2 + qTotal] = Poly.Type.TEXTTOP;
            }
            if (i2 + qTotal * 2 < total) {
                xPos[i2 + qTotal * 2] = screen.getMaxX() - indent;
                yPos[i2 + qTotal * 2] = screen.getMinY() + ySep * (double)i2 + ySep / 2.0;
                style[i2 + qTotal * 2] = Poly.Type.TEXTRIGHT;
            }
            if (i2 + qTotal * 3 >= total) continue;
            xPos[i2 + qTotal * 3] = screen.getMinX() + xSep * (double)i2 + xSep / 2.0;
            yPos[i2 + qTotal * 3] = screen.getMinY() + indent;
            style[i2 + qTotal * 3] = Poly.Type.TEXTBOT;
        }
        int k = 0;
        for (Sample ns : neList.samples) {
            if (!doPorts) {
                if (ns.layer == Generic.tech.portNode) continue;
                whichSam[k++] = ns;
                continue;
            }
            if (ns.layer != Generic.tech.portNode) continue;
            whichSam[k++] = ns;
        }
        double bestDist = Double.MAX_VALUE;
        int bestRot = 0;
        for (i = 0; i < total; ++i) {
            double dist = 0.0;
            for (int j = 0; j < total; ++j) {
                dist += new Point2D.Double(xPos[j], yPos[j]).distance(new Point2D.Double(whichSam[j].xPos, whichSam[j].yPos));
            }
            if (dist < bestDist) {
                bestDist = dist;
                bestRot = i;
            }
            Sample ns = whichSam[0];
            for (int j = 1; j < total; ++j) {
                whichSam[j - 1] = whichSam[j];
            }
            whichSam[total - 1] = ns;
        }
        for (i = 0; i < bestRot; ++i) {
            Sample ns = whichSam[0];
            for (int j = 1; j < total; ++j) {
                whichSam[j - 1] = whichSam[j];
            }
            whichSam[total - 1] = ns;
        }
        Highlighter highlighter = wnd.getHighlighter();
        highlighter.clear();
        for (int i3 = 0; i3 < total; ++i3) {
            Sample ns = whichSam[i3];
            String msg = null;
            if (ns.layer == null) {
                msg = "HIGHLIGHT";
            } else if (ns.layer == Generic.tech.cellCenterNode) {
                msg = "GRAB";
            } else if (ns.layer == Generic.tech.portNode) {
                msg = Info.getPortName(ns.node);
                if (msg == null) {
                    msg = "?";
                }
            } else {
                msg = ns.layer.getName().substring(6);
            }
            Point2D.Double curPt = new Point2D.Double(xPos[i3], yPos[i3]);
            highlighter.addMessage(np, msg, curPt);
            SizeOffset so = ns.node.getSizeOffset();
            Rectangle2D nodeBounds = ns.node.getBounds();
            Point2D.Double other = null;
            if (style[i3] == Poly.Type.TEXTLEFT) {
                other = new Point2D.Double(nodeBounds.getMinX() + so.getLowXOffset(), nodeBounds.getCenterY());
            } else if (style[i3] == Poly.Type.TEXTRIGHT) {
                other = new Point2D.Double(nodeBounds.getMaxX() - so.getHighXOffset(), nodeBounds.getCenterY());
            } else if (style[i3] == Poly.Type.TEXTTOP) {
                other = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getMaxY() - so.getHighYOffset());
            } else if (style[i3] == Poly.Type.TEXTBOT) {
                other = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getMinY() + so.getLowYOffset());
            }
            highlighter.addLine(curPt, other, np);
        }
        highlighter.finished();
    }

    public static String describeNodeMeaning(Geometric geom) {
        if (geom instanceof ArcInst) {
            ArcInst ai = (ArcInst)geom;
            if (ai.getProto() != Generic.tech.universal_arc) {
                return "This is an unimportant " + ai.getProto();
            }
            if (ai.getHeadPortInst().getNodeInst().getProto() != Generic.tech.portNode || ai.getTailPortInst().getNodeInst().getProto() != Generic.tech.portNode) {
                return "This arc makes an unimportant connection";
            }
            String pt1 = Info.getPortName(ai.getHeadPortInst().getNodeInst());
            String pt2 = Info.getPortName(ai.getTailPortInst().getNodeInst());
            if (pt1 == null || pt2 == null) {
                return "This arc connects two port objects";
            }
            return "This arc connects ports '" + pt1 + "' and '" + pt2 + "'";
        }
        NodeInst ni = (NodeInst)geom;
        Cell cell = ni.getParent();
        int opt = Manipulate.getOptionOnNode(ni);
        if (opt < 0) {
            return "No relevance";
        }
        switch (opt) {
            case 15: {
                return "The technology description";
            }
            case 14: {
                return "The technology scale";
            }
            case 38: {
                return "Minimum resistance of SPICE elements";
            }
            case 39: {
                return "Minimum capacitance of SPICE elements";
            }
            case 42: {
                return "The shrinkage of gates, in um";
            }
            case 43: {
                return "Whether gates are included in resistance";
            }
            case 44: {
                return "Whether to include the ground network in parasitics";
            }
            case 45: {
                return "The transparent colors";
            }
            case 31: {
                return "The 3D height of " + cell;
            }
            case 32: {
                return "The 3D thickness of " + cell;
            }
            case 1: {
                return "The transparency layer of " + cell;
            }
            case 3: {
                return "The CIF name of " + cell;
            }
            case 33: {
                return "The color of " + cell;
            }
            case 5: {
                return "The unique letter for " + cell + " (obsolete)";
            }
            case 30: {
                return "The DXF name(s) of " + cell + " (obsolete)";
            }
            case 17: {
                return "DRC minimum width " + cell + " (obsolete)";
            }
            case 4: {
                return "The function of " + cell;
            }
            case 20: {
                return "The Calma GDS-II number of " + cell;
            }
            case 7: {
                return "A stipple-pattern controller";
            }
            case 6: {
                return "One of the bitmap squares in " + cell;
            }
            case 28: {
                return "The SPICE capacitance of " + cell;
            }
            case 29: {
                return "The SPICE edge capacitance of " + cell;
            }
            case 27: {
                return "The SPICE resistance of " + cell;
            }
            case 2: {
                return "The style of " + cell;
            }
            case 41: {
                return "The desired coverage percentage for " + cell;
            }
            case 11: {
                return "Whether " + cell + " is fixed-angle";
            }
            case 9: {
                return "The function of " + cell;
            }
            case 23: {
                return "The prefered angle increment of " + cell;
            }
            case 13: {
                return "The arc extension of " + cell;
            }
            case 12: {
                return "Thie arc coverage of " + cell;
            }
            case 40: {
                return "The maximum antenna ratio for " + cell;
            }
            case 10: {
                return "The function of " + cell;
            }
            case 25: {
                return "Whether " + cell + " can be locked (used in array technologies)";
            }
            case 24: {
                return "The separation between multiple contact cuts in " + cell + " (obsolete)";
            }
            case 16: {
                return "Whether " + cell + " is a serpentine transistor";
            }
            case 21: {
                return "Whether " + cell + " is square";
            }
            case 22: {
                return "Whether " + cell + " disappears when conencted to one or two arcs";
            }
            case 26: {
                return "The grab point of " + cell;
            }
            case 8: 
            case 19: {
                Cell np = Manipulate.getLayerCell(ni);
                if (np == null) {
                    return "Highlight box";
                }
                String msg = "Layer '" + np.getName().substring(6) + "'";
                Variable var = ni.getVar(Info.MINSIZEBOX_KEY);
                if (var != null) {
                    msg = msg + " (at minimum size)";
                }
                return msg;
            }
            case 18: {
                String pt = Info.getPortName(ni);
                if (pt == null) {
                    return "Unnamed port";
                }
                return "Port '" + pt + "'";
            }
        }
        return "Unknown information";
    }

    static Cell getLayerCell(NodeInst ni) {
        Variable var = ni.getVar(Info.LAYER_KEY);
        if (var == null) {
            return null;
        }
        CellId cID = (CellId)var.getObject();
        Cell cell = EDatabase.serverDatabase().getCell(cID);
        if (cell != null) {
            Iterator<Cell> it = ni.getParent().getLibrary().getCells();
            while (it.hasNext()) {
                Cell oCell = it.next();
                if (oCell != cell) continue;
                return cell;
            }
        }
        return null;
    }

    public static void modifyObject(EditWindow wnd, NodeInst ni, int opt) {
        switch (opt) {
            case 15: {
                Manipulate.modTechDescription(wnd, ni);
                break;
            }
            case 14: {
                Manipulate.modTechScale(wnd, ni);
                break;
            }
            case 38: {
                Manipulate.modTechMinResistance(wnd, ni);
                break;
            }
            case 39: {
                Manipulate.modTechMinCapacitance(wnd, ni);
                break;
            }
            case 42: {
                Manipulate.modTechGateShrinkage(wnd, ni);
                break;
            }
            case 43: {
                Manipulate.modTechGateIncluded(wnd, ni);
                break;
            }
            case 44: {
                Manipulate.modTechGroundIncluded(wnd, ni);
                break;
            }
            case 45: {
                Manipulate.modTechTransparentColors(wnd, ni);
                break;
            }
            case 4: {
                Manipulate.modLayerFunction(wnd, ni);
                break;
            }
            case 33: {
                Manipulate.modLayerColor(wnd, ni);
                break;
            }
            case 1: {
                Manipulate.modLayerTransparency(wnd, ni);
                break;
            }
            case 2: {
                Manipulate.modLayerStyle(wnd, ni);
                break;
            }
            case 3: {
                Manipulate.modLayerCIF(wnd, ni);
                break;
            }
            case 20: {
                Manipulate.modLayerGDS(wnd, ni);
                break;
            }
            case 27: {
                Manipulate.modLayerResistance(wnd, ni);
                break;
            }
            case 28: {
                Manipulate.modLayerCapacitance(wnd, ni);
                break;
            }
            case 29: {
                Manipulate.modLayerEdgeCapacitance(wnd, ni);
                break;
            }
            case 31: {
                Manipulate.modLayerHeight(wnd, ni);
                break;
            }
            case 32: {
                Manipulate.modLayerThickness(wnd, ni);
                break;
            }
            case 6: {
                Manipulate.modLayerPattern(wnd, ni);
                break;
            }
            case 7: {
                Manipulate.doPatternControl(wnd, ni, 0);
                break;
            }
            case 34: {
                Manipulate.doPatternControl(wnd, ni, 1);
                break;
            }
            case 35: {
                Manipulate.doPatternControl(wnd, ni, 2);
                break;
            }
            case 36: {
                Manipulate.doPatternControl(wnd, ni, 3);
                break;
            }
            case 37: {
                Manipulate.doPatternControl(wnd, ni, 4);
                break;
            }
            case 8: {
                Manipulate.modLayerPatch(wnd, ni);
                break;
            }
            case 41: {
                Manipulate.modLayerCoverage(wnd, ni);
                break;
            }
            case 11: {
                Manipulate.modArcFixAng(wnd, ni);
                break;
            }
            case 9: {
                Manipulate.modArcFunction(wnd, ni);
                break;
            }
            case 23: {
                Manipulate.modArcAngInc(wnd, ni);
                break;
            }
            case 13: {
                Manipulate.modArcExtension(wnd, ni);
                break;
            }
            case 12: {
                Manipulate.modArcWipes(wnd, ni);
                break;
            }
            case 40: {
                Manipulate.modArcAntennaRatio(wnd, ni);
                break;
            }
            case 10: {
                Manipulate.modNodeFunction(wnd, ni);
                break;
            }
            case 25: {
                Manipulate.modNodeLockability(wnd, ni);
                break;
            }
            case 16: {
                Manipulate.modNodeSerpentine(wnd, ni);
                break;
            }
            case 21: {
                Manipulate.modNodeSquare(wnd, ni);
                break;
            }
            case 22: {
                Manipulate.modNodeWipes(wnd, ni);
                break;
            }
            case 18: {
                Manipulate.modPort(wnd, ni);
                break;
            }
            case 19: {
                System.out.println("Cannot modify highlight boxes");
                break;
            }
            default: {
                System.out.println("Cannot modify this object");
            }
        }
    }

    private static void modTechMinResistance(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Minimum Resistance", "Minimum resistance (for parasitics):", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "Minimum Resistance: " + newUnit);
        }
    }

    private static void modTechMinCapacitance(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Minimum Capacitance", "Minimum capacitance (for parasitics):", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "Minimum Capacitance: " + newUnit);
        }
    }

    private static void modArcAntennaRatio(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Antenna Ratio", "Maximum antenna ratio for this layer:", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "Antenna Ratio: " + newUnit);
        }
    }

    private static void modLayerCoverage(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Coverage Percent", "Desired coverage percentage:", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "Coverage percent: " + newUnit);
        }
    }

    private static void modTechGateShrinkage(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Gate Shrinkage", "Gate shrinkage (in um):", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "Gate Shrinkage: " + newUnit);
        }
    }

    private static void modTechGateIncluded(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Whether Gate is Included in Resistance", "Should the gate be included in resistance?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Gates Included in Resistance: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modTechGroundIncluded(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Whether parasitics include the ground network", "Should parasitics include the ground network?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Parasitics Includes Ground: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modTechTransparentColors(EditWindow wnd, NodeInst ni) {
        Variable var = ni.getVar(Info.TRANSLAYER_KEY);
        if (var == null) {
            return;
        }
        Color[] colors = GeneralInfo.getTransparentColors((String)var.getObject());
        while (true) {
            PromptAt.Field[][] fields = new PromptAt.Field[colors.length + 1][2];
            for (int i = 0; i < colors.length; ++i) {
                fields[i][0] = new PromptAt.Field("Transparent layer " + (i + 1) + ":", colors[i]);
                JButton but = new JButton("Remove");
                fields[i][1] = new PromptAt.Field("" + (i + 1), but);
            }
            JButton addBut = new JButton("Add");
            fields[colors.length][0] = new PromptAt.Field("add", addBut);
            String choice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Transparent Colors", fields);
            if (choice == null) {
                return;
            }
            if (choice.length() == 0) {
                for (int i = 0; i < colors.length; ++i) {
                    colors[i] = (Color)fields[i][0].getFinal();
                }
                break;
            }
            if (choice.equals("add")) {
                Color[] newColors = new Color[colors.length + 1];
                for (int i = 0; i < colors.length; ++i) {
                    newColors[i] = (Color)fields[i][0].getFinal();
                }
                newColors[colors.length] = new Color(128, 128, 128);
                colors = newColors;
                continue;
            }
            int remove = TextUtils.atoi(choice);
            Color[] newColors = new Color[colors.length - 1];
            int j = 0;
            for (int i = 0; i < colors.length; ++i) {
                if (i + 1 == remove) continue;
                newColors[j++] = (Color)fields[i][0].getFinal();
            }
            colors = newColors;
        }
        SetTransparentColorJob job = new SetTransparentColorJob(ni, GeneralInfo.makeTransparentColorsLine(colors));
        new RedoLayerGraphicsJob(ni.getParent());
    }

    private static void modLayerHeight(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newHei = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change 3D Height", "New 3D height (depth) for this layer:", initialMsg);
        if (newHei != null) {
            new SetTextJob(ni, "3D Height: " + newHei);
        }
    }

    private static void modLayerThickness(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newThk = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change 3D Thickness", "New 3D thickness for this layer:", initialMsg);
        if (newThk != null) {
            new SetTextJob(ni, "3D Thickness: " + newThk);
        }
    }

    private static void modLayerColor(EditWindow wnd, NodeInst ni) {
        String initialString = Info.getValueOnNode(ni);
        StringTokenizer st = new StringTokenizer(initialString, ",");
        if (st.countTokens() != 5) {
            System.out.println("Color information must have 5 fields, separated by commas");
            return;
        }
        PromptAt.Field[] fields = new PromptAt.Field[3];
        int r = TextUtils.atoi(st.nextToken());
        int g = TextUtils.atoi(st.nextToken());
        int b = TextUtils.atoi(st.nextToken());
        fields[0] = new PromptAt.Field("Color:", new Color(r, g, b));
        fields[1] = new PromptAt.Field("Opacity (0-1):", st.nextToken());
        fields[2] = new PromptAt.Field("Foreground:", new String[]{"on", "off"}, st.nextToken());
        String choice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Color", fields);
        if (choice == null) {
            return;
        }
        Color col = (Color)fields[0].getFinal();
        r = col.getRed();
        g = col.getGreen();
        b = col.getBlue();
        double o = TextUtils.atof((String)fields[1].getFinal());
        String oo = (String)fields[2].getFinal();
        new SetTextJob(ni, "Color: " + r + "," + g + "," + b + ", " + o + "," + oo);
        new RedoLayerGraphicsJob(ni.getParent());
    }

    private static void modLayerTransparency(EditWindow wnd, NodeInst ni) {
        String initialTransLayer = Info.getValueOnNode(ni);
        String[] transNames = new String[]{"none", "layer 1", "layer 2", "layer 3", "layer 4", "layer 5", "layer 6", "layer 7", "layer 8", "layer 9", "layer 10"};
        String choice = PromptAt.showPromptAt(wnd, ni, "Change Transparent Layer", "New transparent layer number for this layer:", initialTransLayer, transNames);
        if (choice == null) {
            return;
        }
        new SetTextJob(ni, "Transparency: " + choice);
        new RedoLayerGraphicsJob(ni.getParent());
    }

    private static void modLayerStyle(EditWindow wnd, NodeInst ni) {
        String initialStyleName = Info.getValueOnNode(ni);
        List<EGraphics.Outline> outlines = EGraphics.Outline.getOutlines();
        String[] styleNames = new String[outlines.size() + 1];
        styleNames[0] = "Solid";
        int i = 1;
        for (EGraphics.Outline o : outlines) {
            styleNames[i++] = "Patterned/Outline=" + o.getName();
        }
        String choice = PromptAt.showPromptAt(wnd, ni, "Change Layer Drawing Style", "New drawing style for this layer:", initialStyleName, styleNames);
        if (choice == null) {
            return;
        }
        new SetTextJob(ni, "Style: " + choice);
        new RedoLayerGraphicsJob(ni.getParent());
    }

    private static void modLayerCIF(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newCIF = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change CIF layer name", "New CIF symbol for this layer:", initialMsg);
        if (newCIF != null) {
            new SetTextJob(ni, "CIF Layer: " + newCIF);
        }
    }

    private static void modLayerGDS(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newGDS = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change GDS layer name", "New GDS symbol for this layer:", initialMsg);
        if (newGDS != null) {
            new SetTextJob(ni, "GDS-II Layer: " + newGDS);
        }
    }

    private static void modLayerResistance(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newRes = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change SPICE Layer Resistance", "New SPICE resistance for this layer:", initialMsg);
        if (newRes != null) {
            new SetTextJob(ni, "SPICE Resistance: " + newRes);
        }
    }

    private static void modLayerCapacitance(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newCap = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change SPICE Layer Capacitance", "New SPICE capacitance for this layer:", initialMsg);
        if (newCap != null) {
            new SetTextJob(ni, "SPICE Capacitance: " + newCap);
        }
    }

    private static void modLayerEdgeCapacitance(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newCap = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change SPICE Layer Edge Capacitance", "New SPICE edge capacitance for this layer:", initialMsg);
        if (newCap != null) {
            new SetTextJob(ni, "SPICE Edge Capacitance: " + newCap);
        }
    }

    private static void modLayerFunction(EditWindow wnd, NodeInst ni) {
        LayerInfo li;
        String initialFuncName = Info.getValueOnNode(ni);
        int commaPos = initialFuncName.indexOf(44);
        if (commaPos >= 0) {
            initialFuncName = initialFuncName.substring(0, commaPos);
        }
        List<Layer.Function> funs = Layer.Function.getFunctions();
        int[] extraBits = Layer.Function.getFunctionExtras();
        String[] functionNames = new String[funs.size() + extraBits.length];
        int j = 0;
        for (Layer.Function fun : funs) {
            functionNames[j++] = fun.toString();
        }
        for (int i = 0; i < extraBits.length; ++i) {
            functionNames[j++] = Layer.Function.getExtraName(extraBits[i]);
        }
        String choice = PromptAt.showPromptAt(wnd, ni, "Change Layer Function", "New function for this layer:", initialFuncName, functionNames);
        if (choice == null) {
            return;
        }
        int thisExtraBit = -1;
        for (int i = 0; i < extraBits.length; ++i) {
            if (!choice.equals(Layer.Function.getExtraName(extraBits[i]))) continue;
            thisExtraBit = extraBits[i];
            break;
        }
        if ((li = LayerInfo.parseCell(ni.getParent())) == null) {
            return;
        }
        if (thisExtraBit > 0) {
            li.funExtra = (li.funExtra & thisExtraBit) != 0 ? (li.funExtra &= ~thisExtraBit) : (li.funExtra |= thisExtraBit);
        } else {
            li.funExtra = 0;
            for (Layer.Function fun : funs) {
                if (!fun.toString().equalsIgnoreCase(choice)) continue;
                li.fun = fun;
                break;
            }
        }
        new SetTextJob(ni, "Function: " + LayerInfo.makeLayerFunctionName(li.fun, li.funExtra));
    }

    private static void doPatternControl(EditWindow wnd, NodeInst ni, int forced) {
        if (forced == 0) {
            String[] operationNames = new String[]{"Clear Pattern", "Invert Pattern", "Copy Pattern", "Paste Pattern"};
            String choice = PromptAt.showPromptAt(wnd, ni, "Pattern Operations", null, "", operationNames);
            if (choice == null) {
                return;
            }
            if (choice.equals("Clear Pattern")) {
                forced = 1;
            } else if (choice.equals("Invert Pattern")) {
                forced = 2;
            } else if (choice.equals("Copy Pattern")) {
                forced = 3;
            } else if (choice.equals("Paste Pattern")) {
                forced = 4;
            }
        }
        switch (forced) {
            case 1: {
                NodeInst pni;
                Iterator<NodeInst> it = ni.getParent().getNodes();
                while (it.hasNext()) {
                    int color;
                    pni = it.next();
                    int opt = Manipulate.getOptionOnNode(pni);
                    if (opt != 6 || (color = Manipulate.getLayerColor(pni)) == 0) continue;
                    new SetLayerPatternJob(pni, 0);
                }
                new RedoLayerGraphicsJob(ni.getParent());
                break;
            }
            case 2: {
                NodeInst pni;
                Iterator<NodeInst> it = ni.getParent().getNodes();
                while (it.hasNext()) {
                    pni = it.next();
                    int opt = Manipulate.getOptionOnNode(pni);
                    if (opt != 6) continue;
                    int color = Manipulate.getLayerColor(pni);
                    new SetLayerPatternJob(pni, ~color);
                }
                new RedoLayerGraphicsJob(ni.getParent());
                break;
            }
            case 3: {
                LayerInfo li = LayerInfo.parseCell(ni.getParent());
                if (li == null) {
                    return;
                }
                copiedPattern = li.desc.getPattern();
                break;
            }
            case 4: {
                if (copiedPattern == null) {
                    return;
                }
                Manipulate.setLayerPattern(ni.getParent(), copiedPattern);
                new RedoLayerGraphicsJob(ni.getParent());
            }
        }
    }

    private static int getLayerColor(NodeInst ni) {
        if (ni.getProto() == Artwork.tech.boxNode) {
            return 0;
        }
        if (ni.getProto() != Artwork.tech.filledBoxNode) {
            return 0;
        }
        Variable var = ni.getVar(Artwork.ART_PATTERN);
        if (var == null) {
            return 65535;
        }
        return ((Short[])var.getObject())[0].intValue();
    }

    private static void modLayerPattern(EditWindow wnd, NodeInst ni) {
        int color = Manipulate.getLayerColor(ni);
        new SetLayerPatternJob(ni, ~color);
        Highlighter h = wnd.getHighlighter();
        h.clear();
        h.addElectricObject(ni, ni.getParent());
        new RedoLayerGraphicsJob(ni.getParent());
    }

    private static String[] getLayerNameList() {
        Library[] dependentlibs = Info.getDependentLibraries(Library.getCurrent());
        Cell[] layerCells = Info.findCellSequence(dependentlibs, "layer-", Info.LAYERSEQUENCE_KEY);
        String[] layerNames = new String[layerCells.length];
        for (int i = 0; i < layerCells.length; ++i) {
            layerNames[i] = layerCells[i].getName().substring(6);
        }
        return layerNames;
    }

    private static String[] getArcNameList() {
        Library[] dependentlibs = Info.getDependentLibraries(Library.getCurrent());
        Cell[] arcCells = Info.findCellSequence(dependentlibs, "arc-", Info.ARCSEQUENCE_KEY);
        String[] arcNames = new String[arcCells.length];
        for (int i = 0; i < arcCells.length; ++i) {
            arcNames[i] = arcCells[i].getName().substring(4);
        }
        return arcNames;
    }

    private static String[] getNodeNameList() {
        Library[] dependentlibs = Info.getDependentLibraries(Library.getCurrent());
        Cell[] nodeCells = Info.findCellSequence(dependentlibs, "node-", Info.NODESEQUENCE_KEY);
        String[] nodeNames = new String[nodeCells.length];
        for (int i = 0; i < nodeCells.length; ++i) {
            nodeNames[i] = nodeCells[i].getName().substring(5);
        }
        return nodeNames;
    }

    private static void modLayerPatch(EditWindow wnd, NodeInst ni) {
        String choice;
        Library[] dependentlibs = Info.getDependentLibraries(Library.getCurrent());
        Cell[] layerCells = Info.findCellSequence(dependentlibs, "layer-", Info.LAYERSEQUENCE_KEY);
        if (layerCells == null) {
            return;
        }
        String[] options = new String[layerCells.length + 2];
        for (int i = 0; i < layerCells.length; ++i) {
            options[i] = layerCells[i].getName().substring(6);
        }
        options[layerCells.length] = "SET-MINIMUM-SIZE";
        options[layerCells.length + 1] = "CLEAR-MINIMUM-SIZE";
        String initial = options[0];
        Variable curLay = ni.getVar(Info.LAYER_KEY);
        if (curLay != null) {
            CellId cID = (CellId)curLay.getObject();
            Cell cell = EDatabase.serverDatabase().getCell(cID);
            initial = cell.getName().substring(6);
        }
        if ((choice = PromptAt.showPromptAt(wnd, ni, "Change Layer", "New layer for this geometry:", initial, options)) == null) {
            return;
        }
        ModifyLayerJob job = new ModifyLayerJob(ni, choice, layerCells);
    }

    private static void modPort(EditWindow wnd, NodeInst ni) {
        int i;
        ArrayList<Cell> allArcs = new ArrayList<Cell>();
        Iterator<Cell> it = ni.getParent().getLibrary().getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            if (!cell.getName().startsWith("arc-")) continue;
            allArcs.add(cell);
        }
        HashSet<Cell> connectSet = new HashSet<Cell>();
        Variable var = ni.getVar(Info.CONNECTION_KEY);
        if (var != null) {
            CellId[] connects = (CellId[])var.getObject();
            for (i = 0; i < connects.length; ++i) {
                connectSet.add(EDatabase.serverDatabase().getCell(connects[i]));
            }
        }
        PromptAt.Field[] fields = new PromptAt.Field[allArcs.size() + 2];
        for (i = 0; i < allArcs.size(); ++i) {
            Cell cell = (Cell)allArcs.get(i);
            boolean doesConnect = connectSet.contains(cell);
            fields[i] = new PromptAt.Field(cell.getName().substring(4), new String[]{"Allowed", "Disallowed"}, doesConnect ? "Allowed" : "Disallowed");
        }
        Variable angVar = ni.getVar(Info.PORTANGLE_KEY);
        int ang = 0;
        if (angVar != null) {
            ang = (Integer)angVar.getObject();
        }
        Variable rangeVar = ni.getVar(Info.PORTRANGE_KEY);
        int range = 180;
        if (rangeVar != null) {
            range = (Integer)rangeVar.getObject();
        }
        fields[allArcs.size()] = new PromptAt.Field("Angle:", TextUtils.formatDouble(ang));
        fields[allArcs.size() + 1] = new PromptAt.Field("Angle Range:", TextUtils.formatDouble(range));
        String choice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Port", fields);
        if (choice == null) {
            return;
        }
        String[] fieldValues = new String[allArcs.size()];
        for (int i2 = 0; i2 < allArcs.size(); ++i2) {
            fieldValues[i2] = (String)fields[i2].getFinal();
        }
        ModifyPortJob job = new ModifyPortJob(ni, allArcs, fieldValues);
    }

    private static void modArcFunction(EditWindow wnd, NodeInst ni) {
        String initialFuncName = Info.getValueOnNode(ni);
        List<ArcProto.Function> funs = ArcProto.Function.getFunctions();
        String[] functionNames = new String[funs.size()];
        for (int i = 0; i < funs.size(); ++i) {
            ArcProto.Function fun = funs.get(i);
            functionNames[i] = fun.toString();
        }
        String choice = PromptAt.showPromptAt(wnd, ni, "Change Arc Function", "New function for this arc:", initialFuncName, functionNames);
        if (choice == null) {
            return;
        }
        new SetTextJob(ni, "Function: " + choice);
    }

    private static void modArcFixAng(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set whether this Arc Remains at a Fixed Angle", "Should instances of this arc be created with the 'fixed angle' constraint?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Fixed-angle: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modArcWipes(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set Whether this Arc Can Obscure a Pin Node", "Can this arc obscure a pin node (that is obscurable)?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Wipes pins: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modArcExtension(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set Extension Default", "Are new instances of this arc drawn with ends extended?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Extend arcs: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modArcAngInc(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newInc = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Angle Increment", "New angular granularity for placing this type of arc:", initialMsg);
        if (newInc != null) {
            new SetTextJob(ni, "Angle increment: " + newInc);
        }
    }

    private static void modNodeFunction(EditWindow wnd, NodeInst ni) {
        String initialFuncName = Info.getValueOnNode(ni);
        List<PrimitiveNode.Function> funs = PrimitiveNode.Function.getFunctions();
        String[] functionNames = new String[funs.size()];
        for (int i = 0; i < funs.size(); ++i) {
            PrimitiveNode.Function fun = funs.get(i);
            functionNames[i] = fun.toString();
        }
        String choice = PromptAt.showPromptAt(wnd, ni, "Change Node Function", "New function for this node:", initialFuncName, functionNames);
        if (choice == null) {
            return;
        }
        new SetTextJob(ni, "Function: " + choice);
    }

    private static void modNodeSerpentine(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set Serpentine Transistor Capability", "Is this node a serpentine transistor?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Serpentine transistor: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modNodeSquare(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Does Node Remain Square", "Must this node remain square?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Square node: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modNodeWipes(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set How Arcs Obscure This Node", "Is this node invisible when 1 or 2 arcs connect to it?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Invisible with 1 or 2 arcs: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modNodeLockability(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set Node Lockability", "Is this node able to be locked down (used for FPGA primitives):", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Lockable: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modTechScale(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set Unit Size", "The scale of this technology (nanometers per grid unit):", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "Lambda: " + newUnit);
        }
    }

    private static void modTechDescription(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newDesc = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set Technology Description", "Full description of this technology:", initialMsg);
        if (newDesc != null) {
            new SetTextJob(ni, "Description: " + newDesc);
        }
    }

    static void setPatch(NodeInst ni, EGraphics desc) {
        if (desc.getTransparentLayer() > 0) {
            ni.newVar(Artwork.ART_COLOR, (Object)new Integer(EGraphics.makeIndex(desc.getTransparentLayer())));
        } else {
            ni.newVar(Artwork.ART_COLOR, (Object)new Integer(EGraphics.makeIndex(desc.getColor())));
        }
        if (desc.isPatternedOnDisplay()) {
            int[] raster = desc.getPattern();
            Integer[] pattern = new Integer[17];
            for (int i = 0; i < 16; ++i) {
                pattern[i] = new Integer(raster[i]);
            }
            pattern[16] = new Integer(desc.getOutlined().getIndex());
            ni.newVar(Artwork.ART_PATTERN, (Object)pattern);
        } else if (ni.getVar(Artwork.ART_PATTERN) != null) {
            ni.delVar(Artwork.ART_PATTERN);
        }
    }

    private static void setLayerPattern(Cell np, int[] pattern) {
        Variable var;
        NodeInst ni;
        int patternCount = 0;
        Rectangle2D patternBounds = null;
        Iterator<NodeInst> it = np.getNodes();
        while (it.hasNext()) {
            ni = it.next();
            if (ni.getProto() != Artwork.tech.boxNode && ni.getProto() != Artwork.tech.filledBoxNode || (var = ni.getVar(Info.OPTION_KEY)) == null || (Integer)var.getObject() != 6) continue;
            Rectangle2D bounds = ni.getBounds();
            if (patternCount == 0) {
                patternBounds = bounds;
            } else {
                Rectangle2D.union(patternBounds, bounds, patternBounds);
            }
            ++patternCount;
        }
        if (patternCount != 256 && patternCount != 128) {
            System.out.println("Incorrect number of pattern boxes in " + np + " (has " + patternCount + ", not " + 256 + ")");
            return;
        }
        it = np.getNodes();
        while (it.hasNext()) {
            int color;
            ni = it.next();
            if (ni.getProto() != Artwork.tech.boxNode && ni.getProto() != Artwork.tech.filledBoxNode || (var = ni.getVar(Info.OPTION_KEY)) == null || (Integer)var.getObject() != 6) continue;
            Rectangle2D niBounds = ni.getBounds();
            int x = (int)((niBounds.getMinX() - patternBounds.getMinX()) / (patternBounds.getWidth() / 16.0));
            int y = (int)((patternBounds.getMaxY() - niBounds.getMaxY()) / (patternBounds.getHeight() / 16.0));
            int wantColor = 0;
            if ((pattern[y] & 1 << 15 - x) != 0) {
                wantColor = 65535;
            }
            if ((color = Manipulate.getLayerColor(ni)) == wantColor) continue;
            new SetLayerPatternJob(ni, wantColor);
        }
    }

    public static int getOptionOnNode(NodeInst ni) {
        Variable var2;
        if (ni.getProto() == Generic.tech.portNode) {
            return 18;
        }
        if (ni.getProto() == Generic.tech.cellCenterNode) {
            return 26;
        }
        Variable var = ni.getVar(Info.OPTION_KEY);
        if (var == null) {
            return -1;
        }
        int option = (Integer)var.getObject();
        if (option == 8 && (var2 = ni.getVar(Info.LAYER_KEY)) != null && var2.getObject() == null) {
            return 19;
        }
        return option;
    }

    public static void reorderPrimitives(int type) {
        RearrangeOrder dialog = new RearrangeOrder();
        dialog.lib = Library.getCurrent();
        dialog.type = type;
        dialog.initComponents();
        dialog.setVisible(true);
    }

    public static void describeTechnology(Technology tech) {
        int layerCount = tech.getNumLayers();
        String[] layerNames = new String[layerCount + 1];
        String[] layerColors = new String[layerCount + 1];
        String[] layerStyles = new String[layerCount + 1];
        String[] layerCifs = new String[layerCount + 1];
        String[] layerGdss = new String[layerCount + 1];
        String[] layerFuncs = new String[layerCount + 1];
        String[] layerCoverage = new String[layerCount + 1];
        layerNames[0] = "Layer";
        layerColors[0] = "Color";
        layerStyles[0] = "Style";
        layerCifs[0] = "CIF";
        layerGdss[0] = "GDS";
        layerFuncs[0] = "Function";
        layerCoverage[0] = "Coverage";
        Foundry foundry = tech.getSelectedFoundry();
        for (int i = 0; i < layerCount; ++i) {
            Layer layer = tech.getLayer(i);
            layerNames[i + 1] = layer.getName();
            EGraphics gra = layer.getGraphics();
            if (gra.getTransparentLayer() > 0) {
                layerColors[i + 1] = "Transparent " + gra.getTransparentLayer();
            } else {
                Color col = gra.getColor();
                layerColors[i + 1] = "(" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + ")";
            }
            layerStyles[i + 1] = "?";
            layerStyles[i + 1] = gra.isPatternedOnDisplay() ? (gra.getOutlined() != EGraphics.Outline.NOPAT ? "pat/outl" : "pat") : "solid";
            layerCifs[i + 1] = layer.getCIFLayer();
            if (foundry != null) {
                layerGdss[i + 1] = foundry.getGDSLayer(layer);
            }
            layerFuncs[i + 1] = layer.getFunction().toString();
            layerCoverage[i + 1] = TextUtils.formatDouble(layer.getAreaCoverage());
        }
        String[][] fields = new String[][]{layerNames, layerColors, layerStyles, layerCifs, layerGdss, layerFuncs, layerCoverage};
        Manipulate.dumpFields(fields, layerCount + 1, "LAYERS IN " + tech.getTechName().toUpperCase());
        int tot = 1;
        Iterator<ArcProto> it = tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            ArcInst ai = ArcInst.makeDummyInstance(ap, 4000.0);
            Poly[] polys = tech.getShapeOfArc(ai);
            tot += polys.length;
        }
        String[] arcNames = new String[tot];
        String[] arcLayers = new String[tot];
        String[] arcLayerSizes = new String[tot];
        String[] arcExtensions = new String[tot];
        String[] arcAngles = new String[tot];
        String[] arcWipes = new String[tot];
        String[] arcFuncs = new String[tot];
        String[] arcAntennas = new String[tot];
        arcNames[0] = "Arc";
        arcLayers[0] = "Layer";
        arcLayerSizes[0] = "Size";
        arcExtensions[0] = "Extend";
        arcAngles[0] = "Angle";
        arcWipes[0] = "Wipes";
        arcFuncs[0] = "Function";
        arcAntennas[0] = "Antenna";
        tot = 1;
        Iterator<ArcProto> it2 = tech.getArcs();
        while (it2.hasNext()) {
            ArcProto ap = it2.next();
            arcNames[tot] = ap.getName();
            arcExtensions[tot] = ap.isExtended() ? "yes" : "no";
            arcAngles[tot] = "" + ap.getAngleIncrement();
            arcWipes[tot] = ap.isWipable() ? "yes" : "no";
            arcFuncs[tot] = ap.getFunction().toString();
            arcAntennas[tot] = TextUtils.formatDouble(ERC.getERCTool().getAntennaRatio(ap));
            ArcInst ai = ArcInst.makeDummyInstance(ap, 4000.0);
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int k = 0; k < polys.length; ++k) {
                Poly poly = polys[k];
                arcLayers[tot] = poly.getLayer().getName();
                Rectangle2D bounds = poly.getBounds2D();
                double area = Math.min(bounds.getWidth(), bounds.getHeight());
                arcLayerSizes[tot] = TextUtils.formatDouble(area);
                if (k > 0) {
                    arcNames[tot] = "";
                    arcExtensions[tot] = "";
                    arcAngles[tot] = "";
                    arcWipes[tot] = "";
                    arcFuncs[tot] = "";
                }
                ++tot;
            }
        }
        fields = new String[][]{arcNames, arcLayers, arcLayerSizes, arcExtensions, arcAngles, arcWipes, arcFuncs, arcAntennas};
        Manipulate.dumpFields(fields, tot, "ARCS IN " + tech.getTechName().toUpperCase());
        int total = 1;
        Iterator<PrimitiveNode> it3 = tech.getNodes();
        while (it3.hasNext()) {
            PrimitiveNode np = it3.next();
            NodeInst ni = NodeInst.makeDummyInstance(np);
            Poly[] polys = tech.getShapeOfNode(ni);
            int l = 0;
            Iterator<PortProto> pIt = np.getPorts();
            while (pIt.hasNext()) {
                PrimitivePort pp = (PrimitivePort)pIt.next();
                int m = 0;
                ArcProto[] apArray = pp.getConnections();
                for (int k = 0; k < apArray.length; ++k) {
                    if (apArray[k].getTechnology() != tech) continue;
                    ++m;
                }
                if (m == 0) {
                    m = 1;
                }
                l += m;
            }
            total += Math.max(polys.length, l);
        }
        String[] nodeNames = new String[total];
        String[] nodeFuncs = new String[total];
        String[] nodeLayers = new String[total];
        String[] nodeLayerSizes = new String[total];
        String[] nodePorts = new String[total];
        String[] nodePortSizes = new String[total];
        String[] nodePortAngles = new String[total];
        String[] nodeConnections = new String[total];
        nodeNames[0] = "Node";
        nodeFuncs[0] = "Function";
        nodeLayers[0] = "Layers";
        nodeLayerSizes[0] = "Size";
        nodePorts[0] = "Ports";
        nodePortSizes[0] = "Size";
        nodePortAngles[0] = "Angle";
        nodeConnections[0] = "Connections";
        tot = 1;
        Iterator<PrimitiveNode> it4 = tech.getNodes();
        while (it4.hasNext()) {
            PrimitiveNode np = it4.next();
            int base = tot;
            nodeNames[tot] = np.getName();
            nodeFuncs[tot] = np.getFunction().getName();
            NodeInst ni = NodeInst.makeDummyInstance(np);
            Poly[] polys = tech.getShapeOfNode(ni);
            for (int k = 0; k < polys.length; ++k) {
                Poly poly = polys[k];
                if (tot >= total) {
                    System.out.println("ARRAY OVERFLOW: LIMIT IS " + total);
                    break;
                }
                nodeLayers[tot] = poly.getLayer().getName();
                Rectangle2D polyBounds = poly.getBounds2D();
                nodeLayerSizes[tot] = polyBounds.getWidth() + " x " + polyBounds.getHeight();
                if (k > 0) {
                    nodeNames[tot] = "";
                    nodeFuncs[tot] = "";
                }
                ++tot;
            }
            Iterator<PortProto> pIt = np.getPorts();
            while (pIt.hasNext()) {
                PrimitivePort pp = (PrimitivePort)pIt.next();
                nodePorts[base] = pp.getName();
                Poly portPoly = ni.getShapeOfPort(pp);
                Rectangle2D portRect = portPoly.getBounds2D();
                nodePortSizes[base] = portRect.getWidth() + " x " + portRect.getHeight();
                nodePortAngles[base] = pp.getAngleRange() == 180 ? "" : "" + pp.getAngle();
                int m = 0;
                ArcProto[] conList = pp.getConnections();
                for (int k = 0; k < conList.length; ++k) {
                    if (conList[k].getTechnology() != tech) continue;
                    nodeConnections[base] = conList[k].getName();
                    if (m != 0) {
                        nodePorts[base] = "";
                        nodePortSizes[base] = "";
                        nodePortAngles[base] = "";
                    }
                    ++m;
                    ++base;
                }
                if (m != 0) continue;
                nodeConnections[base++] = "<NONE>";
            }
            while (base < tot) {
                nodePorts[base] = "";
                nodePortSizes[base] = "";
                nodePortAngles[base] = "";
                nodeConnections[base] = "";
                ++base;
            }
            while (tot < base) {
                nodeNames[tot] = "";
                nodeFuncs[tot] = "";
                nodeLayers[tot] = "";
                nodeLayerSizes[tot] = "";
                ++tot;
            }
        }
        fields = new String[][]{nodeNames, nodeFuncs, nodeLayers, nodeLayerSizes, nodePorts, nodePortSizes, nodePortAngles, nodeConnections};
        Manipulate.dumpFields(fields, tot, "NODES IN " + tech.getTechName().toUpperCase());
    }

    private static void dumpFields(String[][] fields, int length, String title) {
        int i;
        int j;
        int totWid = 0;
        int[] widths = new int[fields.length];
        for (int i2 = 0; i2 < fields.length; ++i2) {
            widths[i2] = 0;
            for (j = 0; j < length; ++j) {
                int len;
                if (fields[i2][j] == null || (len = fields[i2][j].length()) <= widths[i2]) continue;
                widths[i2] = len;
            }
            int n = i2;
            widths[n] = widths[n] + 2;
            totWid += widths[i2];
        }
        int stars = (totWid - title.length() - 4) / 2;
        for (i = 0; i < stars; ++i) {
            System.out.print("*");
        }
        System.out.print(" " + title + " ");
        for (i = 0; i < stars; ++i) {
            System.out.print("*");
        }
        System.out.println();
        for (j = 0; j < length; ++j) {
            int i3;
            for (i3 = 0; i3 < fields.length; ++i3) {
                int len = 0;
                if (fields[i3][j] != null) {
                    System.out.print(fields[i3][j]);
                    len = fields[i3][j].length();
                }
                if (i3 == fields.length - 1) continue;
                for (int k = len; k < widths[i3]; ++k) {
                    System.out.print(" ");
                }
            }
            System.out.println();
            if (j != 0) continue;
            for (i3 = 0; i3 < fields.length; ++i3) {
                for (int k = 2; k < widths[i3]; ++k) {
                    System.out.print("-");
                }
                System.out.print("  ");
            }
            System.out.println();
        }
        System.out.println();
    }

    private static class RearrangeOrder
    extends EDialog {
        private JList list;
        private DefaultListModel model;
        private Library lib;
        private int type;

        private RearrangeOrder() {
            super((Frame)null, true);
        }

        private void ok() {
            this.exit(true);
        }

        protected void escapePressed() {
            this.exit(false);
        }

        private void exit(boolean goodButton) {
            if (goodButton) {
                String[] newList = new String[this.model.size()];
                for (int i = 0; i < this.model.size(); ++i) {
                    newList[i] = (String)this.model.getElementAt(i);
                }
                new UpdateOrderingJob(this.lib, newList, this.type);
            }
            this.dispose();
        }

        private void moveSelected(int direction) {
            int index = this.list.getSelectedIndex();
            if (index < 0) {
                return;
            }
            int newIndex = index;
            switch (direction) {
                case -2: {
                    newIndex -= 10;
                    break;
                }
                case -1: {
                    --newIndex;
                    break;
                }
                case 1: {
                    ++newIndex;
                    break;
                }
                case 2: {
                    newIndex += 10;
                }
            }
            if (newIndex < 0) {
                newIndex = 0;
            }
            if (newIndex >= this.model.size()) {
                newIndex = this.model.size() - 1;
            }
            Object was = this.model.getElementAt(index);
            this.model.remove(index);
            this.model.add(newIndex, was);
            this.list.setSelectedIndex(newIndex);
            this.list.ensureIndexIsVisible(newIndex);
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            switch (this.type) {
                case 1: {
                    this.setTitle("Rearrange Layer Order");
                    break;
                }
                case 2: {
                    this.setTitle("Rearrange Arc Order");
                    break;
                }
                case 3: {
                    this.setTitle("Rearrange Node Order");
                }
            }
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    RearrangeOrder.this.exit(false);
                }
            });
            JScrollPane center = new JScrollPane();
            center.setMinimumSize(new Dimension(100, 50));
            center.setPreferredSize(new Dimension(300, 200));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridwidth = 2;
            gbc.gridheight = 4;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)center, gbc);
            this.model = new DefaultListModel();
            this.list = new JList(this.model);
            this.list.setSelectionMode(0);
            center.setViewportView(this.list);
            this.model.clear();
            String[] listNames = null;
            switch (this.type) {
                case 1: {
                    listNames = Manipulate.getLayerNameList();
                    break;
                }
                case 2: {
                    listNames = Manipulate.getArcNameList();
                    break;
                }
                case 3: {
                    listNames = Manipulate.getNodeNameList();
                }
            }
            for (int i = 0; i < listNames.length; ++i) {
                this.model.addElement(listNames[i]);
            }
            JButton farUp = new JButton("Far Up");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)farUp, gbc);
            farUp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    RearrangeOrder.this.moveSelected(-2);
                }
            });
            JButton up = new JButton("Up");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)up, gbc);
            up.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    RearrangeOrder.this.moveSelected(-1);
                }
            });
            JButton down = new JButton("Down");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 3;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)down, gbc);
            down.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    RearrangeOrder.this.moveSelected(1);
                }
            });
            JButton farDown = new JButton("Far Down");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 4;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)farDown, gbc);
            farDown.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    RearrangeOrder.this.moveSelected(2);
                }
            });
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    RearrangeOrder.this.exit(false);
                }
            });
            JButton ok = new JButton("OK");
            this.getRootPane().setDefaultButton(ok);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 5;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    RearrangeOrder.this.exit(true);
                }
            });
            this.pack();
        }

        private static class UpdateOrderingJob
        extends Job {
            private Library lib;
            private String[] newList;
            private int type;

            private UpdateOrderingJob(Library lib, String[] newList, int type) {
                super("Update Ordering", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
                this.lib = lib;
                this.newList = newList;
                this.type = type;
                this.startJob();
            }

            public boolean doIt() throws JobException {
                switch (this.type) {
                    case 1: {
                        this.lib.newVar(Info.LAYERSEQUENCE_KEY, (Object)this.newList);
                        break;
                    }
                    case 2: {
                        this.lib.newVar(Info.ARCSEQUENCE_KEY, (Object)this.newList);
                        break;
                    }
                    case 3: {
                        this.lib.newVar(Info.NODESEQUENCE_KEY, (Object)this.newList);
                    }
                }
                return true;
            }

            public void terminateOK() {
                WindowFrame.wantToRedoLibraryTree();
            }
        }
    }

    private static class RedoLayerGraphicsJob
    extends Job {
        private Cell cell;

        private RedoLayerGraphicsJob(Cell cell) {
            super("Redo Layer Graphics", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            NodeInst patchNi = null;
            Iterator<NodeInst> it = this.cell.getNodes();
            while (it.hasNext()) {
                int opt;
                NodeInst ni = it.next();
                if (ni.getProto() != Artwork.tech.filledBoxNode || (opt = Manipulate.getOptionOnNode(ni)) == 6) continue;
                patchNi = ni;
                break;
            }
            if (patchNi == null) {
                return false;
            }
            LayerInfo li = LayerInfo.parseCell(this.cell);
            if (li == null) {
                return false;
            }
            Manipulate.setPatch(patchNi, li.desc);
            Iterator<Cell> cIt = this.cell.getLibrary().getCells();
            while (cIt.hasNext()) {
                Cell onp = cIt.next();
                if (!onp.getName().startsWith("arc-") && !onp.getName().startsWith("node-")) continue;
                Iterator<NodeInst> nIt = onp.getNodes();
                while (nIt.hasNext()) {
                    Variable varLay;
                    NodeInst cNi = nIt.next();
                    if (Manipulate.getOptionOnNode(cNi) != 8 || (varLay = cNi.getVar(Info.LAYER_KEY)) == null) continue;
                    CellId cID = (CellId)varLay.getObject();
                    Cell varCell = EDatabase.serverDatabase().getCell(cID);
                    if (varCell != this.cell) continue;
                    Manipulate.setPatch(cNi, li.desc);
                }
            }
            return true;
        }
    }

    private static class SetTransparentColorJob
    extends Job {
        private NodeInst ni;
        private String chr;

        private SetTransparentColorJob(NodeInst ni, String chr) {
            super("Set Transparent Colors", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.chr = chr;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.ni.newVar(Info.TRANSLAYER_KEY, (Object)this.chr);
            return true;
        }
    }

    private static class SetTextJob
    extends Job {
        private NodeInst ni;
        private String chr;

        private SetTextJob(NodeInst ni, String chr) {
            super("Make Technology Library from Technology", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.chr = chr;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.ni.newDisplayVar(Artwork.ART_MESSAGE, this.chr);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModifyPortJob
    extends Job {
        private NodeInst ni;
        private List<Cell> allArcs;
        private String[] fieldValues;

        private ModifyPortJob(NodeInst ni, List<Cell> allArcs, String[] fieldValues) {
            super("Change Port Information", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.allArcs = allArcs;
            this.fieldValues = fieldValues;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            int numConnects = 0;
            for (int i = 0; i < this.allArcs.size(); ++i) {
                String answer = this.fieldValues[i];
                if (!answer.equals("Allowed")) continue;
                ++numConnects;
            }
            Cell[] newConnects = new Cell[numConnects];
            int k = 0;
            for (int i = 0; i < this.allArcs.size(); ++i) {
                String answer = this.fieldValues[i];
                if (!answer.equals("Allowed")) continue;
                newConnects[k++] = this.allArcs.get(i);
            }
            this.ni.newVar(Info.CONNECTION_KEY, (Object)newConnects);
            int newAngle = TextUtils.atoi(this.fieldValues[this.allArcs.size()]);
            this.ni.newVar(Info.PORTANGLE_KEY, (Object)new Integer(newAngle));
            int newRange = TextUtils.atoi(this.fieldValues[this.allArcs.size() + 1]);
            this.ni.newVar(Info.PORTRANGE_KEY, (Object)new Integer(newRange));
            return true;
        }
    }

    private static class ModifyLayerJob
    extends Job {
        private NodeInst ni;
        private String choice;
        private Cell[] layerCells;

        private ModifyLayerJob(NodeInst ni, String choice, Cell[] layerCells) {
            super("Change Layer Information", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.choice = choice;
            this.layerCells = layerCells;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            if (this.choice.equals("SET-MINIMUM-SIZE")) {
                if (!this.ni.getParent().getName().startsWith("node-")) {
                    System.out.println("Can only set minimum size in node descriptions");
                    return true;
                }
                Variable var = this.ni.newDisplayVar(Info.MINSIZEBOX_KEY, "MIN");
                return true;
            }
            if (this.choice.equals("CLEAR-MINIMUM-SIZE")) {
                if (this.ni.getVar(Info.MINSIZEBOX_KEY) == null) {
                    System.out.println("Minimum size is not set on this layer");
                    return true;
                }
                this.ni.delVar(Info.MINSIZEBOX_KEY);
                return true;
            }
            for (int i = 0; i < this.layerCells.length; ++i) {
                if (!this.choice.equals(this.layerCells[i].getName().substring(6))) continue;
                LayerInfo li = LayerInfo.parseCell(this.layerCells[i]);
                if (li == null) {
                    return true;
                }
                Manipulate.setPatch(this.ni, li.desc);
                this.ni.newVar(Info.LAYER_KEY, (Object)this.layerCells[i].getId());
            }
            System.out.println("Cannot find layer primitive " + this.choice);
            return true;
        }
    }

    private static class SetLayerPatternJob
    extends Job {
        private NodeInst ni;
        private int color;

        private SetLayerPatternJob(NodeInst ni, int color) {
            super("Change Pattern In Layer", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.color = color;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            if (this.ni.getProto() == Artwork.tech.boxNode) {
                if (this.color == 0) {
                    return true;
                }
                this.ni.replace(Artwork.tech.filledBoxNode, false, false);
            } else if (this.ni.getProto() == Artwork.tech.filledBoxNode) {
                Short[] col = new Short[16];
                for (int i = 0; i < 16; ++i) {
                    col[i] = new Short((short)this.color);
                }
                this.ni.newVar(Artwork.ART_PATTERN, (Object)col);
            }
            return true;
        }
    }

    private static class EditDependentLibraries
    extends EDialog {
        private JList allLibsList;
        private JList depLibsList;
        private DefaultListModel allLibsModel;
        private DefaultListModel depLibsModel;
        private JTextField libToAdd;

        private EditDependentLibraries() {
            super((Frame)null, true);
            this.initComponents();
            this.setVisible(true);
        }

        private void ok() {
            this.exit(true);
        }

        protected void escapePressed() {
            this.exit(false);
        }

        private void exit(boolean goodButton) {
            if (goodButton) {
                int numDeps = this.depLibsModel.size();
                String[] depLibs = new String[numDeps];
                for (int i = 0; i < numDeps; ++i) {
                    depLibs[i] = (String)this.depLibsModel.get(i);
                }
                new ModifyDependenciesJob(depLibs);
            }
            this.setVisible(false);
            this.dispose();
        }

        private void removeLib() {
            int index = this.depLibsList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            this.depLibsModel.remove(index);
        }

        private void addLib() {
            String value = (String)this.allLibsList.getSelectedValue();
            String specialLib = this.libToAdd.getText();
            if (specialLib.length() > 0) {
                value = specialLib;
                this.libToAdd.setText("");
            }
            if (value == null) {
                return;
            }
            for (int i = 0; i < this.depLibsModel.size(); ++i) {
                String depLib = (String)this.depLibsModel.get(i);
                if (!depLib.equals(value)) continue;
                return;
            }
            this.depLibsModel.addElement(value);
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Dependent Library Selection");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    EditDependentLibraries.this.exit(false);
                }
            });
            JLabel lab1 = new JLabel("Dependent Libraries:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab1, gbc);
            JScrollPane depLibsPane = new JScrollPane();
            this.depLibsModel = new DefaultListModel();
            this.depLibsList = new JList(this.depLibsModel);
            this.depLibsList.setSelectionMode(0);
            depLibsPane.setViewportView(this.depLibsList);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridheight = 4;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)depLibsPane, gbc);
            this.depLibsModel.clear();
            Library[] libs = Info.getDependentLibraries(Library.getCurrent());
            for (int i = 0; i < libs.length; ++i) {
                if (libs[i] == Library.getCurrent()) continue;
                this.depLibsModel.addElement(libs[i].getName());
            }
            JLabel lab2 = new JLabel("Current: " + Library.getCurrent().getName());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab2, gbc);
            JLabel lab3 = new JLabel("Libraries are examined from bottom up");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab3, gbc);
            JButton remove = new JButton("Remove");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)remove, gbc);
            remove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    EditDependentLibraries.this.removeLib();
                }
            });
            JButton add = new JButton("<< Add");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)add, gbc);
            add.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    EditDependentLibraries.this.addLib();
                }
            });
            JLabel lab4 = new JLabel("All Libraries:");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab4, gbc);
            JScrollPane allLibsPane = new JScrollPane();
            this.allLibsModel = new DefaultListModel();
            this.allLibsList = new JList(this.allLibsModel);
            this.allLibsList.setSelectionMode(0);
            allLibsPane.setViewportView(this.allLibsList);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.gridheight = 2;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)allLibsPane, gbc);
            this.allLibsModel.clear();
            for (Library lib : Library.getVisibleLibraries()) {
                this.allLibsModel.addElement(lib.getName());
            }
            JLabel lab5 = new JLabel("Library (if not in list):");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab5, gbc);
            this.libToAdd = new JTextField("");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 4;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.libToAdd, gbc);
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 6;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    EditDependentLibraries.this.exit(false);
                }
            });
            JButton ok = new JButton("OK");
            this.getRootPane().setDefaultButton(ok);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 6;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    EditDependentLibraries.this.exit(true);
                }
            });
            this.pack();
        }

        private static class ModifyDependenciesJob
        extends Job {
            private String[] depLibs;

            private ModifyDependenciesJob(String[] depLibs) {
                super("Modify Library Dependencies", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
                this.depLibs = depLibs;
                this.startJob();
            }

            public boolean doIt() throws JobException {
                Library lib = Library.getCurrent();
                if (this.depLibs.length == 0) {
                    if (lib.getVar(Info.DEPENDENTLIB_KEY) != null) {
                        lib.delVar(Info.DEPENDENTLIB_KEY);
                    }
                } else {
                    lib.newVar(Info.DEPENDENTLIB_KEY, (Object)this.depLibs);
                }
                return true;
            }
        }
    }

    private static class AddTechEditMarks
    extends Job {
        private NodeInst newNi;
        private boolean isHighlight;
        private String portName;

        private AddTechEditMarks(NodeInst newNi, boolean isHighlight, String portName) {
            super("Prepare node for technology editing", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.newNi = newNi;
            this.isHighlight = isHighlight;
            this.portName = portName;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            Cell cell;
            if (this.isHighlight) {
                this.newNi.newVar(Info.OPTION_KEY, (Object)new Integer(19));
                return true;
            }
            this.newNi.newVar(Info.OPTION_KEY, (Object)new Integer(8));
            if (this.newNi.getProto() == Generic.tech.portNode) {
                this.newNi.newDisplayVar(Info.PORTNAME_KEY, this.portName);
                return true;
            }
            String[] layerNames = Manipulate.getLayerNameList();
            if (layerNames != null && layerNames.length > 0 && (cell = Library.getCurrent().findNodeProto(layerNames[0])) != null) {
                this.newNi.newVar(Info.LAYER_KEY, (Object)cell.getId());
                LayerInfo li = LayerInfo.parseCell(cell);
                if (li != null) {
                    Manipulate.setPatch(this.newNi, li.desc);
                }
            }
            return true;
        }
    }

    private static class MakeOneCellJob
    extends Job {
        private Library lib;
        private String name;
        private int type;
        private Cell newCell;

        private MakeOneCellJob(Library lib, String name, int type) {
            super("Make Cell in Technology-Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.name = name;
            this.type = type;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.newCell = Cell.makeInstance(this.lib, this.name);
            if (this.newCell == null) {
                return false;
            }
            this.newCell.setInTechnologyLibrary();
            this.newCell.setTechnology(Artwork.tech);
            switch (this.type) {
                case 1: {
                    LayerInfo li = new LayerInfo();
                    li.generate(this.newCell);
                    break;
                }
                case 2: {
                    ArcInfo aIn = new ArcInfo();
                    aIn.generate(this.newCell);
                    break;
                }
                case 3: {
                    NodeInfo nIn = new NodeInfo();
                    nIn.generate(this.newCell);
                }
            }
            this.fieldVariableChanged("newCell");
            return true;
        }

        public void terminateOK() {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf != null && this.newCell != null) {
                wf.setCellWindow(this.newCell, null);
            }
        }
    }
}

