/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellChangeJobs {
    private CellChangeJobs() {
    }

    private static Cell graphMainView(Cell cell) {
        Cell cellInGroup;
        Cell mainSchem = cell.getCellGroup().getMainSchematics();
        if (mainSchem != null) {
            return mainSchem;
        }
        Iterator<Cell> it = cell.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = it.next();
            if (cellInGroup.getView() != View.LAYOUT) continue;
            return cellInGroup;
        }
        it = cell.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = it.next();
            if (cellInGroup.getView() != View.UNKNOWN) continue;
            return cellInGroup;
        }
        return null;
    }

    private static void extractOneNode(NodeInst topno, boolean copyExports) {
        NodeInst newNi;
        Cell cell = topno.getParent();
        Cell subCell = (Cell)topno.getProto();
        AffineTransform localTrans = topno.translateOut();
        AffineTransform localRot = topno.rotateOut();
        localTrans.preConcatenate(localRot);
        ArrayList<NodeInst> nodes = new ArrayList<NodeInst>();
        Iterator<NodeInst> it = subCell.getNodes();
        while (it.hasNext()) {
            nodes.add(it.next());
        }
        HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
        for (NodeInst ni : nodes) {
            NodeProto np = ni.getProto();
            if (np == Generic.tech.cellCenterNode || np == Generic.tech.essentialBoundsNode) continue;
            Point2D.Double pt = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
            localTrans.transform(pt, pt);
            String name = null;
            if (ni.isUsernamed()) {
                name = ElectricObject.uniqueObjectName(ni.getName(), cell, NodeInst.class, false);
            }
            Orientation orient = topno.getOrient().concatenate(ni.getOrient());
            newNi = NodeInst.makeInstance(np, pt, ni.getXSize(), ni.getYSize(), cell, orient, name, 0);
            if (newNi == null) {
                return;
            }
            newNodes.put(ni, newNi);
            newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME);
            newNi.copyStateBits(ni);
            newNi.copyVarsFrom(ni);
        }
        ArrayList<ArcInst> arcs = new ArrayList<ArcInst>();
        Iterator<ArcInst> it2 = subCell.getArcs();
        while (it2.hasNext()) {
            arcs.add(it2.next());
        }
        for (ArcInst ai : arcs) {
            ArcInst newAi;
            Poly polyTail;
            NodeInst niTail = (NodeInst)newNodes.get(ai.getTailPortInst().getNodeInst());
            NodeInst niHead = (NodeInst)newNodes.get(ai.getHeadPortInst().getNodeInst());
            if (niTail == null || niHead == null) continue;
            PortInst piTail = niTail.findPortInstFromProto(ai.getTailPortInst().getPortProto());
            PortInst piHead = niHead.findPortInstFromProto(ai.getHeadPortInst().getPortProto());
            Point2D.Double ptTail = new Point2D.Double();
            localTrans.transform(ai.getTailLocation(), ptTail);
            Point2D.Double ptHead = new Point2D.Double();
            localTrans.transform(ai.getHeadLocation(), ptHead);
            Poly polyHead = piHead.getPoly();
            if (!polyHead.isInside(ptHead)) {
                ((Point2D)ptHead).setLocation(polyHead.getCenterX(), polyHead.getCenterY());
            }
            if (!(polyTail = piTail.getPoly()).isInside(ptTail)) {
                ((Point2D)ptTail).setLocation(polyTail.getCenterX(), polyTail.getCenterY());
            }
            String name = null;
            if (ai.isUsernamed()) {
                name = ElectricObject.uniqueObjectName(ai.getName(), cell, ArcInst.class, false);
            }
            if ((newAi = ArcInst.makeInstance(ai.getProto(), ai.getWidth(), piHead, piTail, ptHead, ptTail, name)) == null) {
                return;
            }
            newAi.copyPropertiesFrom(ai);
        }
        ArrayList<ArcInst> replaceTheseArcs = new ArrayList<ArcInst>();
        Iterator<Connection> it3 = topno.getConnections();
        while (it3.hasNext()) {
            Connection con = it3.next();
            replaceTheseArcs.add(con.getArc());
        }
        for (ArcInst ai : replaceTheseArcs) {
            ArcProto ap = ai.getProto();
            double wid = ai.getWidth();
            String name = null;
            if (ai.isUsernamed()) {
                name = ElectricObject.uniqueObjectName(ai.getName(), cell, ArcInst.class, false);
            }
            PortInst[] pis = new PortInst[2];
            Point2D[] pts = new Point2D[2];
            for (int i = 0; i < 2; ++i) {
                Export pp;
                NodeInst subNi;
                NodeInst newNi2;
                pis[i] = ai.getPortInst(i);
                pts[i] = ai.getLocation(i);
                if (pis[i].getNodeInst() != topno || (newNi2 = (NodeInst)newNodes.get(subNi = (pp = (Export)pis[i].getPortProto()).getOriginalPort().getNodeInst())) == null) continue;
                pis[i] = newNi2.findPortInstFromProto(pp.getOriginalPort().getPortProto());
            }
            if (pis[0] == null || pis[1] == null) continue;
            ai.kill();
            ArcInst newAi = ArcInst.makeInstance(ap, wid, pis[0], pis[1], pts[0], pts[1], name);
            if (newAi == null) {
                return;
            }
            newAi.copyPropertiesFrom(ai);
        }
        ArrayList<Export> existingExports = new ArrayList<Export>();
        Iterator<Export> it4 = topno.getExports();
        while (it4.hasNext()) {
            existingExports.add(it4.next());
        }
        for (Export pp : existingExports) {
            Export subPp = (Export)pp.getOriginalPort().getPortProto();
            NodeInst subNi = subPp.getOriginalPort().getNodeInst();
            NodeInst newNi3 = (NodeInst)newNodes.get(subNi);
            if (newNi3 == null) continue;
            PortInst pi = newNi3.findPortInstFromProto(subPp.getOriginalPort().getPortProto());
            pp.move(pi);
        }
        if (copyExports) {
            it4 = subCell.getExports();
            while (it4.hasNext()) {
                String portName;
                Export newPp;
                Export pp;
                pp = it4.next();
                NodeInst subNi = pp.getOriginalPort().getNodeInst();
                newNi = (NodeInst)newNodes.get(subNi);
                if (newNi == null) continue;
                PortInst pi = newNi.findPortInstFromProto(pp.getOriginalPort().getPortProto());
                boolean alreadyDone = false;
                Iterator<Export> eIt = newNi.getExports();
                while (eIt.hasNext()) {
                    Export oPp = eIt.next();
                    if (oPp.getOriginalPort() != pi) continue;
                    alreadyDone = true;
                    break;
                }
                if (alreadyDone || (newPp = Export.newInstance(cell, pi, portName = ElectricObject.uniqueObjectName(pp.getName(), cell, PortProto.class, false))) == null) continue;
                newPp.setCharacteristic(pp.getCharacteristic());
                newPp.copyTextDescriptorFrom(pp, Export.EXPORT_NAME);
                newPp.copyVarsFrom(pp);
            }
        }
        CircuitChangeJobs.eraseNodeInst(topno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cell copyRecursively(List<Cell> fromCells, Library toLib, boolean verbose, boolean move, boolean allRelatedViews, boolean copySubCells, boolean useExisting) {
        Cell copiedCell = null;
        Cell.setAllowCircularLibraryDependences(true);
        try {
            HashSet<Cell> existing = new HashSet<Cell>();
            for (Cell fromCell : fromCells) {
                copiedCell = CellChangeJobs.copyRecursively(fromCell, toLib, verbose, move, "", true, allRelatedViews, allRelatedViews, copySubCells, useExisting, existing);
                if (copiedCell != null) continue;
                break;
            }
        }
        finally {
            Cell.setAllowCircularLibraryDependences(false);
        }
        return copiedCell;
    }

    private static Cell copyRecursively(Cell fromCell, Library toLib, boolean verbose, boolean move, String subDescript, boolean schematicRelatedView, boolean allRelatedViews, boolean allRelatedViewsThisLevel, boolean copySubCells, boolean useExisting, HashSet<Cell> existing) {
        Cell newFromCell;
        Iterator<ElectricObject> it;
        boolean found;
        if (copySubCells && !useExisting) {
            System.out.println("Cross-library copy warning: It makes no sense to copy subcells but not use them");
        }
        String toName = fromCell.getName();
        View toView = fromCell.getView();
        Cell copiedCell = CellChangeJobs.inDestLib(fromCell, existing);
        if (copiedCell != null) {
            return copiedCell;
        }
        if (copySubCells || fromCell.isSchematic()) {
            found = true;
            block0: while (found) {
                found = false;
                it = fromCell.getNodes();
                while (it.hasNext()) {
                    Cell oNp;
                    Cell cell;
                    NodeInst ni = it.next();
                    if (!copySubCells && !ni.isIconOfParent() || !ni.isCellInstance() || (cell = (Cell)ni.getProto()).getLibrary() == toLib || CellChangeJobs.inDestLib(cell, existing) != null || useExisting && toLib.findNodeProto(cell.noLibDescribe()) != null) continue;
                    boolean doCopySchematicView = true;
                    if (ni.isIconOfParent()) {
                        doCopySchematicView = false;
                    }
                    if ((oNp = CellChangeJobs.copyRecursively(cell, toLib, verbose, move, "subcell ", doCopySchematicView, allRelatedViews, allRelatedViewsThisLevel, copySubCells, useExisting, existing)) == null) {
                        if (move) {
                            System.out.println("Move of sub" + cell + " failed");
                        } else {
                            System.out.println("Copy of sub" + cell + " failed");
                        }
                        return null;
                    }
                    found = true;
                    continue block0;
                }
            }
        }
        if (!allRelatedViewsThisLevel) {
            if (toView == View.ICON && schematicRelatedView) {
                found = true;
                block2: while (found) {
                    found = false;
                    it = fromCell.getCellGroup().getCells();
                    while (it.hasNext()) {
                        Cell np = (Cell)it.next();
                        if (np.getView() != View.SCHEMATIC || CellChangeJobs.inDestLib(np, existing) != null) continue;
                        Cell oNp = CellChangeJobs.copyRecursively(np, toLib, verbose, move, "schematic view ", true, allRelatedViews, false, copySubCells, useExisting, existing);
                        if (oNp == null) {
                            if (move) {
                                System.out.println("Move of schematic view " + np + " failed");
                            } else {
                                System.out.println("Copy of schematic view " + np + " failed");
                            }
                            return null;
                        }
                        found = true;
                        continue block2;
                    }
                }
            }
        } else {
            Cell np;
            Iterator<Cell> it2;
            found = true;
            Cell fromCellWalk = fromCell;
            block4: while (found) {
                found = false;
                it2 = fromCellWalk.getCellGroup().getCells();
                while (it2.hasNext()) {
                    np = it2.next();
                    if (!np.isIcon() || CellChangeJobs.inDestLib(np, existing) != null) continue;
                    Cell oNp = CellChangeJobs.copyRecursively(np, toLib, verbose, move, "alternate view ", true, allRelatedViews, false, copySubCells, useExisting, existing);
                    if (oNp == null) {
                        if (move) {
                            System.out.println("Move of alternate view " + np + " failed");
                        } else {
                            System.out.println("Copy of alternate view " + np + " failed");
                        }
                        return null;
                    }
                    found = true;
                    continue block4;
                }
            }
            found = true;
            block6: while (found) {
                found = false;
                it2 = fromCellWalk.getCellGroup().getCells();
                while (it2.hasNext()) {
                    np = it2.next();
                    if (np.isIcon() || CellChangeJobs.inDestLib(np, existing) != null) continue;
                    Cell oNp = CellChangeJobs.copyRecursively(np, toLib, verbose, move, "alternate view ", true, allRelatedViews, false, copySubCells, useExisting, existing);
                    if (oNp == null) {
                        if (move) {
                            System.out.println("Move of alternate view " + np + " failed");
                        } else {
                            System.out.println("Copy of alternate view " + np + " failed");
                        }
                        return null;
                    }
                    found = true;
                    continue block6;
                }
            }
        }
        if ((copiedCell = CellChangeJobs.inDestLib(fromCell, existing)) != null) {
            return copiedCell;
        }
        String newName = toName;
        if (toView.getAbbreviation().length() > 0) {
            newName = toName + "{" + toView.getAbbreviation() + "}";
        }
        if (move) {
            fromCell.move(toLib);
            if (useExisting) {
                fromCell.replaceSubcellsByExisting();
            }
            newFromCell = fromCell;
        } else {
            newFromCell = Cell.copyNodeProto(fromCell, toLib, newName, useExisting);
            if (newFromCell == null) {
                System.out.println("Copy of " + subDescript + fromCell + " failed");
                return null;
            }
        }
        existing.add(newFromCell);
        if (verbose) {
            if (fromCell.getLibrary() != toLib) {
                String msg = "";
                msg = move ? msg + "Moved " : msg + "Copied ";
                msg = msg + subDescript + fromCell.libDescribe() + " to " + toLib;
                System.out.println(msg);
            } else {
                System.out.println("Copied " + subDescript + newFromCell);
            }
        }
        return newFromCell;
    }

    private static Cell inDestLib(Cell cell, HashSet<Cell> existing) {
        for (Cell copiedCell : existing) {
            if (!copiedCell.getName().equalsIgnoreCase(cell.getName()) || copiedCell.getView() != cell.getView()) continue;
            return copiedCell;
        }
        return null;
    }

    public static class DuplicateCell
    extends Job {
        private Cell cell;
        private String newName;
        private boolean entireGroup;
        private Cell dupCell;

        public DuplicateCell(Cell cell, String newName, boolean entireGroup) {
            super("Duplicate " + cell, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.newName = newName;
            this.entireGroup = entireGroup;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            HashMap<Cell, Cell> newCells = new HashMap<Cell, Cell>();
            String newCellName = this.newName + "{" + this.cell.getView().getAbbreviation() + "}";
            this.dupCell = Cell.copyNodeProto(this.cell, this.cell.getLibrary(), newCellName, false);
            if (this.dupCell == null) {
                System.out.println("Could not duplicate " + this.cell);
                return false;
            }
            newCells.put(this.cell, this.dupCell);
            this.fieldVariableChanged("dupCell");
            System.out.println("Duplicated cell " + this.cell + ".  New cell is " + this.dupCell + ".");
            Cell.CellGroup group = this.cell.getCellGroup();
            View thisView = this.cell.getView();
            Iterator<Cell> it = group.getCells();
            while (it.hasNext()) {
                Cell otherCell = it.next();
                if (otherCell == this.cell || !this.entireGroup && (thisView != View.SCHEMATIC || otherCell.getView() != View.ICON)) continue;
                Cell copyCell = Cell.copyNodeProto(otherCell, otherCell.getLibrary(), this.newName + "{" + otherCell.getView().getAbbreviation() + "}", false);
                if (copyCell == null) {
                    System.out.println("Could not duplicate cell " + otherCell);
                    break;
                }
                newCells.put(otherCell, copyCell);
                System.out.println("  Also duplicated cell " + otherCell + ".  New cell is " + copyCell + ".");
            }
            for (Cell oldCell : newCells.keySet()) {
                Cell replaceCell;
                Cell newCell = (Cell)newCells.get(oldCell);
                if (newCell.getView() != View.SCHEMATIC) continue;
                ArrayList<NodeInst> replaceThese = new ArrayList<NodeInst>();
                Iterator<NodeInst> it2 = newCell.getNodes();
                while (it2.hasNext()) {
                    NodeInst ni = it2.next();
                    replaceCell = (Cell)newCells.get(ni.getProto());
                    if (replaceCell == null) continue;
                    replaceThese.add(ni);
                }
                for (NodeInst ni : replaceThese) {
                    replaceCell = (Cell)newCells.get(ni.getProto());
                    NodeInst newNi2 = ni.replace(replaceCell, true, true);
                }
            }
            return true;
        }

        public void terminateOK() {
            WindowContent content;
            boolean found = false;
            WindowFrame curWf = WindowFrame.getCurrentWindowFrame();
            if (curWf != null && (content = curWf.getContent()) != null && content.getCell() == this.cell) {
                content.setCell(this.dupCell, VarContext.globalContext, null);
                content.repaint();
                found = true;
            }
            if (!found) {
                Iterator<WindowFrame> it = WindowFrame.getWindows();
                while (it.hasNext()) {
                    WindowFrame wf = it.next();
                    WindowContent content2 = wf.getContent();
                    if (content2 == null || content2.getCell() != this.cell) continue;
                    content2.setCell(this.dupCell, VarContext.globalContext, null);
                    content2.repaint();
                    break;
                }
            }
        }
    }

    public static class NewCellVersion
    extends Job {
        private Cell cell;
        private Cell newVersion;

        public NewCellVersion(Cell cell) {
            super("Create new Version of " + cell, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.newVersion = this.cell.makeNewVersion();
            if (this.newVersion == null) {
                return false;
            }
            this.fieldVariableChanged("newVersion");
            return true;
        }

        public void terminateOK() {
            if (this.newVersion == null) {
                return;
            }
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                WindowContent content = wf.getContent();
                if (content == null || content.getCell() != this.cell) continue;
                content.setCell(this.newVersion, VarContext.globalContext, null);
            }
            EditWindow.repaintAll();
            System.out.println("Created new version: " + this.newVersion + ", old version renamed to " + this.cell);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtractCellInstances
    extends Job {
        private List<NodeInst> nodes;
        private boolean copyExports;

        public ExtractCellInstances(List<NodeInst> highlighted, boolean copyExports, boolean startNow) {
            super("Extract Cell Instances", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.nodes = highlighted;
            this.copyExports = copyExports;
            if (!startNow) {
                this.startJob();
            } else {
                try {
                    this.doIt();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public boolean doIt() throws JobException {
            boolean foundInstance = false;
            for (NodeInst ni : this.nodes) {
                if (!ni.isCellInstance()) continue;
                foundInstance = true;
                CellChangeJobs.extractOneNode(ni, this.copyExports);
            }
            if (!foundInstance) {
                System.out.println("Must select cell instances to extract");
                return false;
            }
            return true;
        }
    }

    public static class PackageCell
    extends Job {
        Cell curCell;
        ERectangle bounds;
        String newCellName;

        public PackageCell(Cell curCell, Rectangle2D bounds, String newCellName) {
            super("Package Cell", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.curCell = curCell;
            this.bounds = new ERectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
            this.newCellName = newCellName;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            Geometric look;
            Cell cell = Cell.makeInstance(Library.getCurrent(), this.newCellName);
            if (cell == null) {
                return false;
            }
            HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
            Iterator<Geometric> sIt = this.curCell.searchIterator(this.bounds);
            while (sIt.hasNext()) {
                NodeInst newNi;
                look = sIt.next();
                if (!(look instanceof NodeInst)) continue;
                NodeInst ni = (NodeInst)look;
                String name = null;
                Name oldName = ni.getNameKey();
                if (!oldName.isTempname()) {
                    name = oldName.toString();
                }
                if ((newNi = NodeInst.makeInstance(ni.getProto(), new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY()), ni.getXSize(), ni.getYSize(), cell, ni.getOrient(), name, 0)) == null) {
                    return false;
                }
                newNodes.put(ni, newNi);
                newNi.copyStateBits(ni);
                newNi.copyVarsFrom(ni);
                newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME);
                Iterator<Export> it = ni.getExports();
                while (it.hasNext()) {
                    Export pp = it.next();
                    PortInst pi = newNi.findPortInstFromProto(pp.getOriginalPort().getPortProto());
                    Export newPp = Export.newInstance(cell, pi, pp.getName());
                    if (newPp == null) continue;
                    newPp.setCharacteristic(pp.getCharacteristic());
                    newPp.copyTextDescriptorFrom(pp, Export.EXPORT_NAME);
                    newPp.copyVarsFrom(pp);
                }
            }
            sIt = this.curCell.searchIterator(this.bounds);
            while (sIt.hasNext()) {
                ArcInst newAi;
                look = sIt.next();
                if (!(look instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)look;
                NodeInst niTail = (NodeInst)newNodes.get(ai.getTailPortInst().getNodeInst());
                NodeInst niHead = (NodeInst)newNodes.get(ai.getHeadPortInst().getNodeInst());
                if (niTail == null || niHead == null) continue;
                PortInst piTail = niTail.findPortInstFromProto(ai.getTailPortInst().getPortProto());
                PortInst piHead = niHead.findPortInstFromProto(ai.getHeadPortInst().getPortProto());
                String name = null;
                Name oldName = ai.getNameKey();
                if (!oldName.isTempname()) {
                    name = oldName.toString();
                }
                if ((newAi = ArcInst.makeInstance(ai.getProto(), ai.getWidth(), piHead, piTail, ai.getHeadLocation(), ai.getTailLocation(), name)) == null) {
                    return false;
                }
                newAi.copyPropertiesFrom(ai);
            }
            System.out.println("Cell " + cell.describe(true) + " created");
            return true;
        }
    }

    public static class GraphCells
    extends Job {
        private static final double TEXTHEIGHT = 2.0;
        private Cell top;
        private Cell graphCell;

        public GraphCells(Cell top) {
            super("Graph Cells", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.top = top;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            CellGraphNode cgn;
            Cell cell;
            Library lib;
            double xsc;
            NodeInst titleNi;
            CellGraphNode cgn2;
            Cell cell2;
            Iterator<Cell> cIt;
            Library lib2;
            CellGraphNode cgn3;
            Cell cell3;
            Iterator<Cell> cIt2;
            Library lib3;
            Cell trueCell;
            CellGraphNode cgn4;
            Cell cell4;
            Iterator<Cell> cIt3;
            this.graphCell = Cell.newInstance(Library.getCurrent(), "CellStructure");
            this.fieldVariableChanged("graphCell");
            if (this.graphCell == null) {
                return false;
            }
            if (this.graphCell.getNumVersions() > 1) {
                System.out.println("Creating new version of cell: CellStructure");
            } else {
                System.out.println("Creating cell: CellStructure");
            }
            HashMap<Cell, CellGraphNode> cellGraphNodes = new HashMap<Cell, CellGraphNode>();
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib4 = it.next();
                if (lib4.isHidden()) continue;
                cIt3 = lib4.getCells();
                while (cIt3.hasNext()) {
                    cell4 = cIt3.next();
                    cgn4 = new CellGraphNode();
                    cgn4.depth = -1;
                    cellGraphNodes.put(cell4, cgn4);
                }
            }
            if (this.top != null) {
                CellGraphNode cgn5 = (CellGraphNode)cellGraphNodes.get(this.top);
                cgn5.depth = 0;
            } else {
                Iterator<Cell> cIt4 = Library.getCurrent().getCells();
                while (cIt4.hasNext()) {
                    Cell cell5 = cIt4.next();
                    if (cell5.getNumUsagesIn() != 0) continue;
                    CellGraphNode cgn6 = (CellGraphNode)cellGraphNodes.get(cell5);
                    cgn6.depth = 0;
                }
            }
            int maxDepth = 0;
            boolean more = true;
            while (more) {
                more = false;
                Iterator<Library> it2 = Library.getLibraries();
                while (it2.hasNext()) {
                    Library lib5 = it2.next();
                    if (lib5.isHidden()) continue;
                    Iterator<Cell> cIt5 = lib5.getCells();
                    while (cIt5.hasNext()) {
                        Cell cell6 = cIt5.next();
                        CellGraphNode cgn7 = (CellGraphNode)cellGraphNodes.get(cell6);
                        if (cgn7.depth == -1) continue;
                        Iterator<NodeInst> nIt = cell6.getNodes();
                        while (nIt.hasNext()) {
                            NodeInst ni = nIt.next();
                            if (!ni.isCellInstance()) continue;
                            Cell sub = (Cell)ni.getProto();
                            if (ni.isIconOfParent()) continue;
                            CellGraphNode subCgn = (CellGraphNode)cellGraphNodes.get(sub);
                            if (subCgn.depth <= cgn7.depth) {
                                subCgn.depth = cgn7.depth + 1;
                                if (subCgn.depth > maxDepth) {
                                    maxDepth = subCgn.depth;
                                }
                                more = true;
                            }
                            if ((trueCell = sub.contentsView()) == null) continue;
                            CellGraphNode trueCgn = (CellGraphNode)cellGraphNodes.get(trueCell);
                            if (trueCgn.depth > cgn7.depth) continue;
                            trueCgn.depth = cgn7.depth + 1;
                            if (trueCgn.depth > maxDepth) {
                                maxDepth = trueCgn.depth;
                            }
                            more = true;
                        }
                    }
                }
                if (more || this.top != null) continue;
                cIt3 = Library.getCurrent().getCells();
                while (cIt3.hasNext()) {
                    cell4 = cIt3.next();
                    cgn4 = (CellGraphNode)cellGraphNodes.get(cell4);
                    if (cgn4.depth >= 0) continue;
                    cgn4.depth = 0;
                    more = true;
                }
            }
            double maxWidth = 0.0;
            double[] xval = new double[++maxDepth];
            double[] yoff = new double[maxDepth];
            for (int i = 0; i < maxDepth; ++i) {
                yoff[i] = 0.0;
                xval[i] = 0.0;
            }
            Iterator<Library> it3 = Library.getLibraries();
            while (it3.hasNext()) {
                lib3 = it3.next();
                if (lib3.isHidden()) continue;
                cIt2 = lib3.getCells();
                while (cIt2.hasNext()) {
                    cell3 = cIt2.next();
                    cgn3 = (CellGraphNode)cellGraphNodes.get(cell3);
                    if (cgn3.depth == -1) continue;
                    trueCell = CellChangeJobs.graphMainView(cell3);
                    if (trueCell != null && (cell3.getNumUsagesIn() == 0 || cell3.isIcon() || cell3.getView() == View.LAYOUTSKEL)) {
                        cgn3.depth = -1;
                        continue;
                    }
                    cgn3.x = xval[cgn3.depth];
                    int n = cgn3.depth;
                    xval[n] = xval[n] + (double)cell3.describe(false).length();
                    if (xval[cgn3.depth] > maxWidth) {
                        maxWidth = xval[cgn3.depth];
                    }
                    cgn3.y = cgn3.depth;
                    cgn3.yoff = 0.0;
                }
            }
            it3 = Library.getLibraries();
            while (it3.hasNext()) {
                lib3 = it3.next();
                if (lib3.isHidden()) continue;
                cIt2 = lib3.getCells();
                while (cIt2.hasNext()) {
                    cell3 = cIt2.next();
                    cgn3 = (CellGraphNode)cellGraphNodes.get(cell3);
                    if (cgn3.depth == -1 || !(xval[(int)cgn3.y] < maxWidth)) continue;
                    double spread = maxWidth / xval[(int)cgn3.y];
                    cgn3.x *= spread;
                }
            }
            double xScale = 0.6666666666666666;
            double yScale = 20.0;
            double yOffset = 2.5;
            Iterator<Library> it4 = Library.getLibraries();
            while (it4.hasNext()) {
                lib2 = it4.next();
                if (lib2.isHidden()) continue;
                cIt = lib2.getCells();
                while (cIt.hasNext()) {
                    cell2 = cIt.next();
                    cgn2 = (CellGraphNode)cellGraphNodes.get(cell2);
                    if (cgn2.depth == -1) continue;
                    double x = cgn2.x;
                    double y = cgn2.y;
                    int n = (int)cgn2.y;
                    double d = yoff[n];
                    yoff[n] = d + 1.0;
                    y = -y * yScale + d % 3.0 * yOffset;
                    cgn2.x = x *= xScale;
                    cgn2.y = y;
                }
            }
            if (this.top == null) {
                it4 = Library.getLibraries();
                while (it4.hasNext()) {
                    lib2 = it4.next();
                    if (lib2.isHidden()) continue;
                    cIt = lib2.getCells();
                    while (cIt.hasNext()) {
                        Cell trueCell2;
                        cell2 = cIt.next();
                        cgn2 = (CellGraphNode)cellGraphNodes.get(cell2);
                        if (cgn2.depth != -1 || cell2.getNumUsagesIn() != 0 && !cell2.isIcon() && cell2.getView() != View.LAYOUTSKEL || (trueCell2 = CellChangeJobs.graphMainView(cell2)) == null) continue;
                        CellGraphNode trueCgn = (CellGraphNode)cellGraphNodes.get(trueCell2);
                        if (trueCgn.depth == -1) continue;
                        cgn2.botPin = null;
                        cgn2.topPin = null;
                        cgn2.pin = null;
                        cgn2.main = trueCgn;
                        cgn2.yoff += yOffset * 2.0;
                        cgn2.x = trueCgn.x;
                        cgn2.y = trueCgn.y + trueCgn.yoff;
                    }
                }
            }
            if ((titleNi = NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(xsc = maxWidth * xScale / 2.0, yScale), 0.0, 0.0, this.graphCell)) == null) {
                return false;
            }
            StringBuffer infstr = new StringBuffer();
            if (this.top != null) {
                infstr.append("Structure below " + this.top);
            } else {
                infstr.append("Structure of library " + Library.getCurrent().getName());
            }
            TextDescriptor td = TextDescriptor.getNodeTextDescriptor().withRelSize(6.0);
            titleNi.newVar(Artwork.ART_MESSAGE, (Object)infstr.toString(), td);
            Iterator<Library> it5 = Library.getLibraries();
            while (it5.hasNext()) {
                lib = it5.next();
                if (lib.isHidden()) continue;
                Iterator<Cell> cIt6 = lib.getCells();
                while (cIt6.hasNext()) {
                    cell = cIt6.next();
                    if (cell == this.graphCell) continue;
                    cgn = (CellGraphNode)cellGraphNodes.get(cell);
                    if (cgn.depth == -1) continue;
                    double x = cgn.x;
                    double y = cgn.y;
                    cgn.pin = NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(x, y), 0.0, 0.0, this.graphCell);
                    if (cgn.pin == null) {
                        return false;
                    }
                    cgn.topPin = NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(x, y + 1.0), 0.0, 0.0, this.graphCell);
                    if (cgn.topPin == null) {
                        return false;
                    }
                    cgn.botPin = NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(x, y - 1.0), 0.0, 0.0, this.graphCell);
                    if (cgn.botPin == null) {
                        return false;
                    }
                    PortInst pinPi = cgn.pin.getOnlyPortInst();
                    PortInst toppinPi = cgn.botPin.getOnlyPortInst();
                    PortInst botPinPi = cgn.topPin.getOnlyPortInst();
                    ArcInst link1 = ArcInst.makeInstance(Generic.tech.invisible_arc, 0.0, toppinPi, pinPi);
                    ArcInst link2 = ArcInst.makeInstance(Generic.tech.invisible_arc, 0.0, pinPi, botPinPi);
                    link1.setRigid(true);
                    link2.setRigid(true);
                    link1.setHardSelect(true);
                    link2.setHardSelect(true);
                    cgn.topPin.setHardSelect();
                    cgn.botPin.setHardSelect();
                    TextDescriptor ctd = TextDescriptor.getNodeTextDescriptor().withRelSize(2.0);
                    cgn.pin.newVar(Artwork.ART_MESSAGE, (Object)cell.describe(false), ctd);
                }
            }
            it5 = Library.getLibraries();
            while (it5.hasNext()) {
                lib = it5.next();
                if (lib.isHidden()) continue;
                Iterator<Cell> cIt7 = lib.getCells();
                while (cIt7.hasNext()) {
                    cell = cIt7.next();
                    if (cell == this.graphCell) continue;
                    cgn = (CellGraphNode)cellGraphNodes.get(cell);
                    if (cgn.depth == -1 || cgn.main == null) continue;
                    PortInst firstPi = cgn.pin.getOnlyPortInst();
                    PortInst secondPi = cgn.main.pin.getOnlyPortInst();
                    ArcInst ai = ArcInst.makeInstance(Artwork.tech.solidArc, 0.0, firstPi, firstPi);
                    if (ai == null) {
                        return false;
                    }
                    ai.setRigid(true);
                    ai.setHardSelect(true);
                    ai.newVar(Artwork.ART_COLOR, (Object)new Integer(0));
                }
            }
            int clock = 0;
            Iterator<Library> it6 = Library.getLibraries();
            while (it6.hasNext()) {
                Library lib6 = it6.next();
                if (lib6.isHidden()) continue;
                Iterator<Cell> cIt8 = lib6.getCells();
                while (cIt8.hasNext()) {
                    Cell cell7 = cIt8.next();
                    if (cell7 == this.graphCell) continue;
                    Cell trueCell3 = cell7.contentsView();
                    if (trueCell3 == null) {
                        trueCell3 = cell7;
                    }
                    CellGraphNode trueCgn = (CellGraphNode)cellGraphNodes.get(trueCell3);
                    if (trueCgn.depth == -1) continue;
                    ++clock;
                    Iterator<NodeInst> nIt = trueCell3.getNodes();
                    while (nIt.hasNext()) {
                        NodeInst ni = nIt.next();
                        if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
                        Cell sub = (Cell)ni.getProto();
                        Cell truesubnp = sub.contentsView();
                        if (truesubnp == null) {
                            truesubnp = sub;
                        }
                        CellGraphNode trueSubCgn = (CellGraphNode)cellGraphNodes.get(truesubnp);
                        if (trueSubCgn.clock == clock) continue;
                        trueSubCgn.clock = clock;
                        if (trueSubCgn.depth == -1) continue;
                        PortInst toppinPi = trueCgn.botPin.getOnlyPortInst();
                        PortInst niBotPi = trueSubCgn.topPin.getOnlyPortInst();
                        ArcInst ai = ArcInst.makeInstance(Artwork.tech.solidArc, Artwork.tech.solidArc.getDefaultWidth(), toppinPi, niBotPi);
                        if (ai == null) {
                            return false;
                        }
                        ai.setRigid(false);
                        ai.setFixedAngle(false);
                        ai.setSlidable(false);
                        ai.setHardSelect(true);
                        int color = 14;
                        if (trueCgn.y - trueSubCgn.y > yScale + yOffset + yOffset) {
                            color = 10;
                        }
                        ai.newVar(Artwork.ART_COLOR, (Object)new Integer(color));
                    }
                }
            }
            return true;
        }

        public void terminateOK() {
            UserInterface ui = Job.getUserInterface();
            ui.displayCell(this.graphCell);
        }

        private static class CellGraphNode {
            int depth;
            int clock;
            double x;
            double y;
            double yoff;
            NodeInst pin;
            NodeInst topPin;
            NodeInst botPin;
            CellGraphNode main;

            private CellGraphNode() {
            }
        }
    }

    public static class DeleteUnusedOldCells
    extends Job {
        private int totalDeleted;

        public DeleteUnusedOldCells() {
            super("Delete Unused Old Cells", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() throws JobException {
            boolean found = true;
            this.totalDeleted = 0;
            block0: while (found) {
                found = false;
                Iterator<Cell> it = Library.getCurrent().getCells();
                while (it.hasNext()) {
                    Cell cell = it.next();
                    if (cell.getNewestVersion() == cell || cell.getInstancesOf().hasNext()) continue;
                    System.out.println("Deleting " + cell);
                    cell.kill();
                    found = true;
                    ++this.totalDeleted;
                    continue block0;
                }
            }
            this.fieldVariableChanged("totalDeleted");
            return true;
        }

        public void terminateOK() {
            if (this.totalDeleted == 0) {
                System.out.println("No unused old cell versions to delete");
            } else {
                System.out.println("Deleted " + this.totalDeleted + " cells");
                EditWindow.repaintAll();
            }
        }
    }

    public static class RenameCellGroup
    extends Job {
        Cell cellInGroup;
        String newName;

        public RenameCellGroup(Cell cellInGroup, String newName) {
            super("Rename Cell Group", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cellInGroup = cellInGroup;
            this.newName = newName;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            boolean allSameName = true;
            String lastName = null;
            Iterator<Cell> it = this.cellInGroup.getCellGroup().getCells();
            while (it.hasNext()) {
                String cellName = it.next().getName();
                if (lastName != null && !lastName.equals(cellName)) {
                    allSameName = false;
                    break;
                }
                lastName = cellName;
            }
            ArrayList<Cell> cells = new ArrayList<Cell>();
            Iterator<Cell> it2 = this.cellInGroup.getCellGroup().getCells();
            while (it2.hasNext()) {
                cells.add(it2.next());
            }
            Cell.CellGroup newGroup = null;
            for (Cell cell : cells) {
                if (allSameName) {
                    cell.rename(this.newName);
                    continue;
                }
                cell.rename(this.newName + cell.getName());
                if (newGroup != null) {
                    cell.setCellGroup(newGroup);
                }
                newGroup = cell.getCellGroup();
            }
            return true;
        }
    }

    public static class RenameCell
    extends Job {
        private Cell cell;
        private String newName;
        private String newGroupCell;

        public RenameCell(Cell cell, String newName, String newGroupCell) {
            super("Rename " + cell, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.newName = newName;
            this.newGroupCell = newGroupCell;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.cell.rename(this.newName);
            if (this.newGroupCell != null) {
                Cell.CellGroup newGroup = this.cell.getLibrary().findNodeProto(this.newGroupCell).getCellGroup();
                this.cell.setCellGroup(newGroup);
            }
            return true;
        }
    }

    public static class DeleteCell
    extends Job {
        Cell cell;

        public DeleteCell(Cell cell) {
            super("Delete " + cell, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            if (this.cell.isInUse("delete", false)) {
                return false;
            }
            this.cell.kill();
            return true;
        }
    }
}

