/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Analysis;
import com.sun.electric.tool.simulation.Stimuli;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class SpiceOut
extends Simulate {
    private boolean eofReached;
    private static final String CELLNAME_HEADER = "*** SPICE deck for cell ";

    SpiceOut() {
    }

    protected Stimuli readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        if (this.openTextInput(fileURL)) {
            return null;
        }
        SpiceOut.startProgressDialog("Spice output", fileURL.getFile());
        Stimuli sd = this.readSpiceFile(cell);
        SpiceOut.stopProgressDialog();
        this.closeInput();
        return sd;
    }

    private Stimuli readSpiceFile(Cell cell) throws IOException {
        String line;
        boolean dataMode = false;
        boolean first = true;
        boolean pastEnd = false;
        String cellName = null;
        int mostSignals = 0;
        ArrayList allNumbers = new ArrayList();
        while ((line = this.getLine()) != null) {
            int len;
            if (first) {
                String hsFormat;
                first = false;
                if (line.length() >= 20 && ((hsFormat = line.substring(16, 20)).equals("9007") || hsFormat.equals("9601"))) {
                    System.out.println("This is an HSPICE file, not a SPICE2 file");
                    System.out.println("Change the SPICE format (in Preferences) and reread");
                    return null;
                }
            }
            if ((len = line.length()) < 2) continue;
            if (cellName == null && line.startsWith(CELLNAME_HEADER)) {
                cellName = line.substring(CELLNAME_HEADER.length());
            }
            if (line.startsWith(".END") && !line.startsWith(".ENDS")) {
                pastEnd = true;
                continue;
            }
            if (line.startsWith("#Time")) {
                pastEnd = true;
                continue;
            }
            if (pastEnd && !dataMode && (Character.isWhitespace(line.charAt(0)) || line.charAt(0) == '-') && TextUtils.isDigit(line.charAt(1))) {
                dataMode = true;
            }
            if (pastEnd && dataMode && (!Character.isWhitespace(line.charAt(0)) && line.charAt(0) != '-' || !TextUtils.isDigit(line.charAt(1)))) {
                dataMode = false;
                pastEnd = false;
            }
            if (!dataMode) continue;
            ArrayList<Double> numbers = new ArrayList<Double>();
            for (int ptr = 0; ptr < len; ++ptr) {
                while (ptr < len && Character.isWhitespace(line.charAt(ptr))) {
                    ++ptr;
                }
                int start = ptr;
                while (ptr < len && !Character.isWhitespace(line.charAt(ptr))) {
                    ++ptr;
                }
                numbers.add(new Double(TextUtils.atof(line.substring(start, ptr))));
            }
            if (numbers.size() > mostSignals) {
                mostSignals = numbers.size();
            }
            allNumbers.add(numbers);
        }
        if (--mostSignals <= 0) {
            System.out.println("No data found in the file");
            return null;
        }
        Stimuli sd = new Stimuli();
        Analysis an = new Analysis(sd, Analysis.ANALYSIS_SIGNALS);
        sd.setCell(cell);
        int numEvents = allNumbers.size();
        an.buildCommonTime(numEvents);
        for (int i = 0; i < numEvents; ++i) {
            List row = (List)allNumbers.get(i);
            an.setCommonTime(i, (Double)row.get(0));
        }
        for (int j = 0; j < mostSignals; ++j) {
            AnalogSignal as = new AnalogSignal(an);
            as.setSignalName("Signal " + (j + 1));
            as.buildValues(numEvents);
            for (int i = 0; i < numEvents; ++i) {
                List row = (List)allNumbers.get(i);
                as.setValue(i, (Double)row.get(j + 1));
            }
        }
        return sd;
    }
}

