/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalibreDrcErrors {
    private int scale;
    private String topCellName;
    private Cell topCell;
    private ErrorLogger logger;
    private BufferedReader in;
    private List<DrcRuleViolation> ruleViolations;
    private int lineno;
    private HashMap<Cell, String> mangledNames;
    private String type;
    private String filename;
    private static final String spaces = "[\\s\\t ]+";

    public static void importErrors(String filename, HashMap<Cell, String> mangledNames, String type) {
        BufferedReader in;
        try {
            FileReader reader = new FileReader(filename);
            in = new BufferedReader(reader);
        }
        catch (IOException e) {
            System.out.println("Error importing " + type + " Errors: " + e.getMessage());
            return;
        }
        if (in == null) {
            return;
        }
        CalibreDrcErrors errors = new CalibreDrcErrors(in, mangledNames, type);
        errors.filename = filename;
        if (!errors.readTop()) {
            return;
        }
        if (!errors.readRules()) {
            return;
        }
        errors.done();
    }

    private CalibreDrcErrors(BufferedReader in, HashMap<Cell, String> mangledNames, String type) {
        assert (in != null);
        this.in = in;
        this.lineno = 0;
        this.ruleViolations = new ArrayList<DrcRuleViolation>();
        this.mangledNames = mangledNames;
        this.type = type;
    }

    private boolean readTop() {
        String line;
        this.scale = 1000;
        try {
            line = this.readLine(true);
        }
        catch (IOException e) {
            System.out.println("Error reading first line of file: " + e.getMessage());
            return false;
        }
        if (line == null) {
            return false;
        }
        String[] parts = line.trim().split(spaces);
        if (parts.length == 1) {
            this.topCellName = parts[0];
        } else if (parts.length == 2) {
            this.topCellName = parts[0];
            try {
                this.scale = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                System.out.println("Error converting precision '" + parts[1] + "' to a number, using default of " + this.scale);
                return false;
            }
        } else {
            System.out.println("Error on first line: Expected cell name and precision, or 'drc'");
            return false;
        }
        this.topCell = CalibreDrcErrors.getCell(this.topCellName, this.mangledNames);
        if (this.topCell == null) {
            System.out.println("Cannot find cell " + this.topCellName + " specified in error file, line number " + this.lineno + ", aborting");
            return false;
        }
        return true;
    }

    private boolean readRules() {
        try {
            DrcRuleViolation v;
            while ((v = this.readRule()) != null) {
                this.ruleViolations.add(v);
            }
        }
        catch (IOException e) {
            System.out.println("Error reading file: " + e.getMessage());
            return false;
        }
        return true;
    }

    private DrcRuleViolation readRule() throws IOException {
        DrcError drc;
        String ruleName = this.readLine(false);
        if (ruleName == null) {
            return null;
        }
        Header header = this.readHeader();
        if (header == null) {
            return null;
        }
        for (int i = 0; i < header.headerLength; ++i) {
            String s = this.readLine();
            if (s == null) {
                return null;
            }
            header.addHeaderLine(s);
        }
        if (header.comment.length() == 0) {
            header.comment.append(ruleName);
        }
        DrcRuleViolation v = new DrcRuleViolation(ruleName, header);
        for (int i = 0; i < header.currentDrcResultsCount && (drc = this.readErrorShape()) != null; ++i) {
            v.addError(drc);
        }
        return v;
    }

    private Header readHeader() throws IOException {
        String headerStart = this.readLine();
        if (headerStart == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(headerStart);
        Header header = null;
        try {
            String cur = tokenizer.nextToken();
            String orig = tokenizer.nextToken();
            String len = tokenizer.nextToken();
            int icur = Integer.parseInt(cur);
            int iorig = Integer.parseInt(orig);
            int ilen = Integer.parseInt(len);
            header = new Header(icur, iorig, ilen);
        }
        catch (NoSuchElementException e) {
            System.out.println("Error parsing header start line, expected three integers on line number " + this.lineno + ": " + headerStart);
            return null;
        }
        catch (NumberFormatException e) {
            System.out.println("Error converting count strings to integers on header start line, line number " + this.lineno + ": " + headerStart);
            return null;
        }
        return header;
    }

    private DrcError readErrorShape() throws IOException {
        boolean boolp;
        String nextLine = this.readLine().trim();
        boolean boole = nextLine.startsWith("e");
        boolean bl = boolp = nextLine.startsWith("p");
        if (boole || boolp) {
            String[] parts = nextLine.split(spaces);
            if (parts.length != 3) {
                System.out.println("Error on shape: expected ordinal and count numbers, line number " + this.lineno + ": " + nextLine);
                return null;
            }
            int ordinal = 0;
            int lines = 0;
            try {
                ordinal = Integer.parseInt(parts[1]);
                lines = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                System.out.println("Error on shape: expected ordinal and count numbers, line number " + this.lineno + ": " + nextLine);
                return null;
            }
            nextLine = this.readLine().trim();
            Cell incell = this.topCell;
            if (nextLine.startsWith("CN")) {
                parts = nextLine.split(spaces);
                if (parts.length < 3) {
                    System.out.println("Error reading CN line, expected at least three fields, line number " + this.lineno + ": " + nextLine);
                    return null;
                }
                String cellname = parts[1];
                String coordSpace = parts[2];
                if (coordSpace.equals("c") && (incell = CalibreDrcErrors.getCell(cellname, this.mangledNames)) == null) {
                    incell = this.topCell;
                }
                nextLine = this.readLine();
            }
            DrcError drc = new DrcError(incell);
            double lambdaScale = incell.getTechnology().getScale() / 1000.0;
            if (boole) {
                for (int i = 0; i < lines; ++i) {
                    Shape s;
                    if (i != 0) {
                        nextLine = this.readLine();
                    }
                    if ((s = this.parseErrorEdge(nextLine, lambdaScale)) == null) {
                        return drc;
                    }
                    drc.addShape(s);
                }
            } else {
                Point2D[] points = new Point2D[lines];
                for (int i = 0; i < lines; ++i) {
                    if (i != 0) {
                        nextLine = this.readLine();
                    }
                    if (this.parseErrorPoint(nextLine, points, i, lambdaScale)) continue;
                    return null;
                }
                PolyBase s = new PolyBase(points);
                drc.addShape(s);
            }
            return drc;
        }
        System.out.println("Error, expected Edge or Poly definition on line number " + this.lineno + ": " + nextLine);
        return null;
    }

    private Shape parseErrorEdge(String line, double lambdaScale) {
        String[] vals = line.trim().split(spaces);
        if (vals.length != 4) {
            System.out.println("Error, bad format for edge on line number " + this.lineno + ": " + line);
            return null;
        }
        try {
            double x1 = (double)Integer.parseInt(vals[0]) / (double)this.scale / lambdaScale;
            double y1 = (double)Integer.parseInt(vals[1]) / (double)this.scale / lambdaScale;
            double x2 = (double)Integer.parseInt(vals[2]) / (double)this.scale / lambdaScale;
            double y2 = (double)Integer.parseInt(vals[3]) / (double)this.scale / lambdaScale;
            Line2D.Double line2d = new Line2D.Double(x1, y1, x2, y2);
            return line2d;
        }
        catch (NumberFormatException e) {
            System.out.println("Error, bad format for edge on line number " + this.lineno + ": " + line);
            return null;
        }
    }

    private boolean parseErrorPoint(String line, Point2D[] points, int point, double lambdaScale) {
        String[] vals = line.trim().split(spaces);
        if (vals.length != 2) {
            System.out.println("Error, bad format for poly vertex on line number " + this.lineno + ": " + line);
            return false;
        }
        try {
            double x1 = (double)Integer.parseInt(vals[0]) / (double)this.scale / lambdaScale;
            double y1 = (double)Integer.parseInt(vals[1]) / (double)this.scale / lambdaScale;
            Point2D.Double p = new Point2D.Double(x1, y1);
            points[point] = p;
            return true;
        }
        catch (NumberFormatException e) {
            System.out.println("Error, bad format for poly vertex on line number " + this.lineno + ": " + line);
            return false;
        }
    }

    private void done() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.logger = ErrorLogger.newInstance("Calibre " + this.type + " Errors");
        int sortKey = 0;
        int count = 0;
        for (DrcRuleViolation v : this.ruleViolations) {
            String ruleDesc = v.header.comment.toString().replaceAll("\\n", ";");
            this.logger.setGroupName(sortKey, ruleDesc);
            int y = 1;
            for (DrcError drcError : v.errors) {
                Cell cell = drcError.cell;
                ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
                for (Shape shape : drcError.shapes) {
                    if (shape instanceof Line2D) {
                        Line2D line = (Line2D)shape;
                        lineList.add(new EPoint(line.getX1(), line.getY1()));
                        lineList.add(new EPoint(line.getX2(), line.getY2()));
                        continue;
                    }
                    if (shape instanceof PolyBase) {
                        PolyBase poly = (PolyBase)shape;
                        polyList.add(poly);
                        continue;
                    }
                    System.out.println("Unsupported drc error shape " + shape);
                }
                this.logger.logError(y + ". " + cell.getName() + ": " + ruleDesc, null, null, lineList, null, polyList, cell, sortKey);
                ++y;
                ++count;
            }
            ++sortKey;
        }
        System.out.println(this.type + " Imported " + count + " errors from " + this.filename);
        if (count == 0) {
            Job.getUserInterface().showInformationMessage(this.type + " Imported Zero Errors", this.type + " Import Complete");
        }
        this.logger.termLogging(true);
    }

    private String readLine() throws IOException {
        return this.readLine(true);
    }

    private String readLine(boolean errorOnEOF) throws IOException {
        if (this.in == null) {
            return null;
        }
        String line = this.in.readLine();
        if (line == null && errorOnEOF) {
            System.out.println("Unexpected End of File!");
            this.in = null;
            return null;
        }
        ++this.lineno;
        return line;
    }

    public static Cell getCell(String cellName, HashMap<Cell, String> mangledNames) {
        ArrayList<Cell> matchedNames = new ArrayList<Cell>();
        for (Map.Entry<Cell, String> entry : mangledNames.entrySet()) {
            String name = entry.getValue();
            if (!name.equals(cellName)) continue;
            matchedNames.add(entry.getKey());
        }
        if (matchedNames.size() == 0) {
            return null;
        }
        if (matchedNames.size() == 1) {
            return (Cell)matchedNames.get(0);
        }
        UserInterface ui = Job.getUserInterface();
        String[] choices = new String[matchedNames.size()];
        for (int i = 0; i < choices.length; ++i) {
            choices[i] = ((Cell)matchedNames.get(i)).describe(false);
        }
        int c = ui.askForChoice("Multiple cells matches, please choose one for \"" + cellName + "\":", "Ambiguity Found", choices, choices[0]);
        return (Cell)matchedNames.get(c);
    }

    private static class Header {
        private final int currentDrcResultsCount;
        private final int originalDrcResultsCount;
        private final int headerLength;
        private String ruleFilePath;
        private String ruleFileTitle;
        private StringBuffer comment;

        private Header(int currentDrcResultsCount, int originalDrcResultsCount, int headerLength) {
            this.currentDrcResultsCount = currentDrcResultsCount;
            this.originalDrcResultsCount = originalDrcResultsCount;
            this.headerLength = headerLength;
            this.comment = new StringBuffer();
        }

        public void addHeaderLine(String line) {
            if (line.startsWith("Rule File Pathname")) {
                this.ruleFilePath = line;
            } else if (line.startsWith("Rule File Title")) {
                this.ruleFileTitle = line;
            } else {
                if (this.comment.length() != 0) {
                    this.comment.append("\n");
                }
                this.comment.append(line);
            }
        }
    }

    private static class DrcError {
        private final Cell cell;
        private final List<Shape> shapes;

        private DrcError(Cell cell) {
            this.cell = cell;
            this.shapes = new ArrayList<Shape>();
        }

        private void addShape(Shape shape) {
            this.shapes.add(shape);
        }
    }

    private static class DrcRuleViolation {
        private final String ruleNumber;
        private final Header header;
        private final List<DrcError> errors;

        private DrcRuleViolation(String ruleNumber, Header header) {
            this.ruleNumber = ruleNumber;
            this.header = header;
            this.errors = new ArrayList<DrcError>();
        }

        private void addError(DrcError error) {
            this.errors.add(error);
        }
    }
}

