/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.tecEdit.ArcInfo;
import com.sun.electric.tool.user.tecEdit.Example;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import com.sun.electric.tool.user.tecEdit.Sample;
import java.util.Iterator;
import java.util.List;

public class NodeInfo
extends Info {
    String name;
    String abbrev;
    PrimitiveNode generated;
    PrimitiveNode.Function func = PrimitiveNode.Function.UNKNOWN;
    boolean serp;
    boolean square;
    boolean wipes;
    boolean lockable;
    LayerDetails[] nodeLayers;
    PortDetails[] nodePortDetails;
    PrimitivePort[] primPorts;
    SizeOffset so;
    int specialType;
    double[] specialValues;
    double xSize;
    double ySize;
    static Info.SpecialTextDescr[] nodeTextTable = new Info.SpecialTextDescr[]{new Info.SpecialTextDescr(0.0, 15.0, 10), new Info.SpecialTextDescr(0.0, 12.0, 16), new Info.SpecialTextDescr(0.0, 9.0, 21), new Info.SpecialTextDescr(0.0, 6.0, 22), new Info.SpecialTextDescr(0.0, 3.0, 25)};

    NodeInfo() {
    }

    public static Cell[] getNodeCells(Library lib) {
        Library[] oneLib = new Library[]{lib};
        return NodeInfo.findCellSequence(oneLib, "node-", NODESEQUENCE_KEY);
    }

    void generate(Cell np) {
        NodeInfo.loadTableEntry(nodeTextTable, 10, this.func);
        NodeInfo.loadTableEntry(nodeTextTable, 16, new Boolean(this.serp));
        NodeInfo.loadTableEntry(nodeTextTable, 21, new Boolean(this.square));
        NodeInfo.loadTableEntry(nodeTextTable, 22, new Boolean(this.wipes));
        NodeInfo.loadTableEntry(nodeTextTable, 25, new Boolean(this.lockable));
        NodeInfo.createSpecialText(np, nodeTextTable);
    }

    static NodeInfo parseCell(Cell np) {
        NodeInfo nIn = new NodeInfo();
        Iterator it = np.getNodes();
        block7: while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            Variable var = ni.getVar(OPTION_KEY);
            if (var == null) continue;
            String str = NodeInfo.getValueOnNode(ni);
            block0 : switch ((Integer)var.getObject()) {
                case 10: {
                    nIn.func = PrimitiveNode.Function.UNKNOWN;
                    List allFuncs = PrimitiveNode.Function.getFunctions();
                    Iterator fIt = allFuncs.iterator();
                    while (fIt.hasNext()) {
                        PrimitiveNode.Function fun = (PrimitiveNode.Function)fIt.next();
                        if (!fun.toString().equalsIgnoreCase(str)) continue;
                        nIn.func = fun;
                        break block0;
                    }
                    continue block7;
                }
                case 21: {
                    nIn.square = str.equalsIgnoreCase("yes");
                    break;
                }
                case 22: {
                    nIn.wipes = str.equalsIgnoreCase("yes");
                    break;
                }
                case 25: {
                    nIn.lockable = str.equalsIgnoreCase("yes");
                    break;
                }
                case 16: {
                    nIn.serp = str.equalsIgnoreCase("yes");
                }
            }
        }
        return nIn;
    }

    static void compactCell(Cell cell) {
        Example neList = Example.getExamples(cell, true);
        if (neList == null) {
            return;
        }
        int numExamples = 0;
        Example smallest = neList;
        Example biggest = neList;
        Example ne = neList;
        while (ne != null) {
            ++numExamples;
            if (ne.hx - ne.lx > biggest.hx - biggest.lx) {
                biggest = ne;
            }
            ne = ne.nextExample;
        }
        if (numExamples == 1) {
            NodeInfo.moveExample(neList, -(neList.lx + neList.hx) / 2.0, -neList.hy);
            return;
        }
        if (numExamples != 4) {
            return;
        }
        Example stretchX = null;
        Example stretchY = null;
        Example ne2 = neList;
        while (ne2 != null) {
            if (ne2 != biggest && ne2 != smallest) {
                if (stretchX == null) {
                    stretchX = ne2;
                } else if (stretchY == null) {
                    stretchY = ne2;
                }
            }
            ne2 = ne2.nextExample;
        }
        if (stretchX.hx - stretchX.lx < stretchY.hx - stretchY.lx) {
            Example swap = stretchX;
            stretchX = stretchY;
            stretchY = swap;
        }
        double separation = Math.min(smallest.hx - smallest.lx, smallest.hy - smallest.ly);
        double totalWid = stretchX.hx - stretchX.lx + (smallest.hx - smallest.lx) + separation;
        double totalHei = stretchY.hy - stretchY.ly + (smallest.hy - smallest.ly) + separation;
        double cX = -totalWid / 2.0 - smallest.lx;
        double cY = -smallest.hy - 1.0;
        NodeInfo.moveExample(smallest, cX, cY);
        cX = totalWid / 2.0 - stretchX.hx;
        cY = -stretchX.hy - 1.0;
        NodeInfo.moveExample(stretchX, cX, cY);
        cX = -totalWid / 2.0 - stretchY.lx;
        cY = -totalHei - stretchY.ly - 1.0;
        NodeInfo.moveExample(stretchY, cX, cY);
        cX = totalWid / 2.0 - biggest.hx;
        cY = -totalHei - biggest.ly - 1.0;
        NodeInfo.moveExample(biggest, cX, cY);
    }

    private static void moveExample(Example ne, double dX, double dY) {
        Iterator it = ne.samples.iterator();
        while (it.hasNext()) {
            Sample ns = (Sample)it.next();
            ns.node.move(dX, dY);
        }
    }

    static class LayerDetails {
        LayerInfo layer;
        Poly.Type style;
        int representation;
        Technology.TechPoint[] values;
        Sample ns;
        int portIndex;
        boolean multiCut;
        double multiXS;
        double multiYS;
        double multiIndent;
        double multiSep;
        double lWidth;
        double rWidth;
        double extendT;
        double extendB;

        LayerDetails() {
        }
    }

    static class PortDetails {
        String name;
        ArcInfo[] connections;
        int angle;
        int range;
        int netIndex;
        Technology.TechPoint[] values;

        PortDetails() {
        }
    }
}

