/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.Main;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.geometry.PolyQTree;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.GateRegression;
import com.sun.electric.tool.generator.layout.IvanFlat;
import com.sun.electric.tool.generator.layout.LayFlat;
import com.sun.electric.tool.generator.layout.Test;
import com.sun.electric.tool.logicaleffort.LENetlister;
import com.sun.electric.tool.ncc.NccJob;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ExecDialog;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.menus.ToolMenu;
import com.sun.electric.tool.user.menus.WindowMenu;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.ui.ZoomAndPanListener;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class DebugMenus {
    private static ArrayList sharedList = new ArrayList();

    protected static void addDebugMenus(MenuBar menuBar, MenuBar.Menu helpMenu) {
        helpMenu.addSeparator();
        helpMenu.addMenuItem("Make fake circuitry", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.makeFakeCircuitryCommand();
            }
        });
        helpMenu.addMenuItem("Make fake analog simulation window", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.makeFakeWaveformCommand();
            }
        });
        MenuBar.Menu russMenu = new MenuBar.Menu("Russell", 'R');
        menuBar.add(russMenu);
        russMenu.addMenuItem("hierarchical NCC schematic and layout views of current cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new NccJob(1, false, true);
            }
        });
        russMenu.addMenuItem("Gate Generator Regression", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new GateRegression();
            }
        });
        russMenu.addMenuItem("create flat netlists for Ivan", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new IvanFlat();
            }
        });
        russMenu.addMenuItem("layout flat", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new LayFlat();
            }
        });
        russMenu.addMenuItem("Random Test", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Test();
            }
        });
        MenuBar.Menu jongMenu = new MenuBar.Menu("JonG", 'J');
        menuBar.add(jongMenu);
        jongMenu.addMenuItem("Describe Vars", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.listVarsOnObject(false);
            }
        });
        jongMenu.addMenuItem("Describe Proto Vars", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.listVarsOnObject(true);
            }
        });
        jongMenu.addMenuItem("Describe Current Library Vars", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.listLibVars();
            }
        });
        jongMenu.addMenuItem("Eval Vars", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.evalVarsOnObject();
            }
        });
        jongMenu.addMenuItem("LE test1", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LENetlister.test1();
            }
        });
        jongMenu.addMenuItem("Display shaker", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.shakeDisplay();
            }
        });
        jongMenu.addMenuItem("Run command", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.runCommand();
            }
        });
        jongMenu.addMenuItem("Start defunct Job", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.startDefunctJob();
            }
        });
        MenuBar.Menu gildaMenu = new MenuBar.Menu("Gilda", 'G');
        menuBar.add(gildaMenu);
        gildaMenu.addMenuItem("List Geometry on Network", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.listGeometryOnNetworkCommand();
            }
        });
        gildaMenu.addMenuItem("3D View", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.create3DViewCommand();
            }
        });
        gildaMenu.addMenuItem("Merge Polyons", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.layerCoverageCommand(Job.Type.CHANGE, 1, true);
            }
        });
        gildaMenu.addMenuItem("Covering Implants", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.layerCoverageCommand(Job.Type.CHANGE, 2, true);
            }
        });
        gildaMenu.addMenuItem("Covering Implants Old", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenus.implantGeneratorCommand(false, false);
            }
        });
        gildaMenu.addMenuItem("List Layer Coverage", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolMenu.layerCoverageCommand(Job.Type.EXAMINE, 0, true);
            }
        });
    }

    public static void makeFakeCircuitryCommand() {
        MakeFakeCircuitry job = new MakeFakeCircuitry();
    }

    public static void makeFakeWaveformCommand() {
        int i;
        Simulation.SimData sd = new Simulation.SimData();
        double timeStep = 1.0E-10;
        sd.buildCommonTime(100);
        for (i = 0; i < 100; ++i) {
            sd.setCommonTime(i, (double)i * timeStep);
        }
        for (i = 0; i < 18; ++i) {
            Simulation.SimAnalogSignal as = new Simulation.SimAnalogSignal(sd);
            as.setSignalName("Signal" + (i + 1));
            as.setCommonTimeUse(true);
            as.buildValues(100);
            for (int k = 0; k < 100; ++k) {
                as.setValue(k, Math.sin((double)(k + i * 10) / (2.0 + (double)(i * 2))) * 4.0);
            }
        }
        sd.setCell(null);
        WindowFrame wf = WindowFrame.createWaveformWindow(sd);
        WaveformWindow ww = (WaveformWindow)wf.getContent();
        ww.setMainTimeCursor(timeStep * 22.0);
        ww.setExtensionTimeCursor(timeStep * 77.0);
        ww.setDefaultTimeRange(0.0, timeStep * 100.0);
        for (int i2 = 0; i2 < 6; ++i2) {
            WaveformWindow.Panel wp = new WaveformWindow.Panel(ww, true);
            wp.setValueRange(-5.0, 5.0);
            for (int j = 0; j < (i2 + 1) * 3; ++j) {
                Simulation.SimAnalogSignal as = (Simulation.SimAnalogSignal)sd.getSignals().get(j);
                WaveformWindow.Signal wsig = new WaveformWindow.Signal(wp, as);
            }
        }
    }

    public static void implantGeneratorCommand(boolean newIdea, boolean test) {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        Job job = null;
        job = newIdea ? new CoverImplant(curCell, test) : new CoverImplantOld(curCell);
    }

    public static void listVarsOnObject(boolean useproto) {
        if (Highlight.getNumHighlights() == 0) {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf == null) {
                return;
            }
            Cell cell = wf.getContent().getCell();
            cell.getInfo();
            return;
        }
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.EOBJ) continue;
            ElectricObject eobj = h.getElectricObject();
            if (eobj instanceof PortInst) {
                PortInst pi = (PortInst)eobj;
                pi.getInfo();
                eobj = pi.getNodeInst();
            }
            if (!(eobj instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)eobj;
            if (useproto) {
                System.out.println("using prototype");
                ni.getProto().getInfo();
                continue;
            }
            ni.getInfo();
        }
    }

    public static void evalVarsOnObject() {
        EditWindow curEdit = EditWindow.needCurrent();
        if (Highlight.getNumHighlights() == 0) {
            return;
        }
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.EOBJ) continue;
            ElectricObject eobj = h.getElectricObject();
            Iterator itVar = eobj.getVariables();
            while (itVar.hasNext()) {
                Variable var = (Variable)itVar.next();
                Object obj = curEdit.getVarContext().evalVar(var);
                System.out.print(var.getKey().getName() + ": ");
                System.out.println(obj);
            }
        }
    }

    public static void listLibVars() {
        Library lib = Library.getCurrent();
        Iterator itVar = lib.getVariables();
        System.out.println("----------" + lib + " Vars-----------");
        while (itVar.hasNext()) {
            Variable var = (Variable)itVar.next();
            Object obj = VarContext.globalContext.evalVar(var);
            System.out.println(var.getKey().getName() + ": " + obj);
        }
    }

    public static void shakeDisplay() {
        long startTime = System.currentTimeMillis();
        EditWindow wnd = EditWindow.getCurrent();
        for (int i = 0; i < 100; ++i) {
        }
        long endTime = System.currentTimeMillis();
        StringBuffer buf = new StringBuffer();
        Date start = new Date(startTime);
        buf.append("  start time: " + start + "\n");
        Date end = new Date(endTime);
        buf.append("  end time: " + end + "\n");
        long time = endTime - startTime;
        buf.append("  time taken: " + TextUtils.getElapsedTime(time) + "\n");
        System.out.println(buf.toString());
    }

    public static void startDefunctJob() {
        DefunctJob j = new DefunctJob();
    }

    private static void changeSharedList() {
        Object o = sharedList.get(0);
    }

    public static void runCommand() {
        ExecDialog d = new ExecDialog((Frame)TopLevel.getCurrentJFrame(), false);
        File dir = new File("/home/gainsley");
        d.startProcess("/bin/tcsh", null, dir);
    }

    public static void whitDiffieCommand() {
        MakeWhitDesign job = new MakeWhitDesign();
    }

    private static class MakeWhitDesign
    extends Job {
        protected MakeWhitDesign() {
            super("Make Whit design", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            String[] theStrings = new String[]{"a1f0f1k0p0", "a2f1f2k1p1", "a3f2f3k2p2", "a0a4f0f3f4k3p3", "a0a5f0f4f5k4p4", "a6f5f6k5p5", "a0a7f0f6f7k6p6", "a0f0f7k7p7", "a0f1k0k1p0", "a1f2k1k2p1", "a2f3k2k3p2", "a3f0f4k0k3k4p3", "a4f0f5k0k4k5p4", "a5f6k5k6p5", "a6f0f7k0k6k7p6", "a7f0k0k7p7", "a0f0k1p0p1", "a1f1k2p1p2", "a2f2k3p2p3", "a3f3k0k4p0p3p4", "a4f4k0k5p0p4p5", "a5f5k6p5p6", "a6f6k0k7p0p6p7", "a7f7k0p0p7", "a0a1f0k0p1", "a1a2f1k1p2", "a2a3f2k2p3", "a0a3a4f3k3p0p4", "a0a4a5f4k4p0p5", "a5a6f5k5p6", "a0a6a7f6k6p0p7", "a0a7f7k7p0", "b1g0g1l0m0", "b2g1g2l1m1", "b3g2g3l2m2", "b0b4g0g3g4l3m3", "b0b5g0g4g5l4m4", "b6g5g6l5m5", "b0b7g0g6g7l6m6", "b0g0g7l7m7", "b0g1l0l1m0", "b1g2l1l2m1", "b2g3l2l3m2", "b3g0g4l0l3l4m3", "b4g0g5l0l4l5m4", "b5g6l5l6m5", "b6g0g7l0l6l7m6", "b7g0l0l7m7", "b0g0l1m0m1", "b1g1l2m1m2", "b2g2l3m2m3", "b3g3l0l4m0m3m4", "b4g4l0l5m0m4m5", "b5g5l6m5m6", "b6g6l0l7m0m6m7", "b7g7l0m0m7", "b0b1g0l0m1", "b1b2g1l1m2", "b2b3g2l2m3", "b0b3b4g3l3m0m4", "b0b4b5g4l4m0m5", "b5b6g5l5m6", "b0b6b7g6l6m0m7", "b0b7g7l7m0", "c1h0h1i0n0", "c2h1h2i1n1", "c3h2h3i2n2", "c0c4h0h3h4i3n3", "c0c5h0h4h5i4n4", "c6h5h6i5n5", "c0c7h0h6h7i6n6", "c0h0h7i7n7", "c0h1i0i1n0", "c1h2i1i2n1", "c2h3i2i3n2", "c3h0h4i0i3i4n3", "c4h0h5i0i4i5n4", "c5h6i5i6n5", "c6h0h7i0i6i7n6", "c7h0i0i7n7", "c0h0i1n0n1", "c1h1i2n1n2", "c2h2i3n2n3", "c3h3i0i4n0n3n4", "c4h4i0i5n0n4n5", "c5h5i6n5n6", "c6h6i0i7n0n6n7", "c7h7i0n0n7", "c0c1h0i0n1", "c1c2h1i1n2", "c2c3h2i2n3", "c0c3c4h3i3n0n4", "c0c4c5h4i4n0n5", "c5c6h5i5n6", "c0c6c7h6i6n0n7", "c0c7h7i7n0", "d1e0e1j0o0", "d2e1e2j1o1", "d3e2e3j2o2", "d0d4e0e3e4j3o3", "d0d5e0e4e5j4o4", "d6e5e6j5o5", "d0d7e0e6e7j6o6", "d0e0e7j7o7", "d0e1j0j1o0", "d1e2j1j2o1", "d2e3j2j3o2", "d3e0e4j0j3j4o3", "d4e0e5j0j4j5o4", "d5e6j5j6o5", "d6e0e7j0j6j7o6", "d7e0j0j7o7", "d0e0j1o0o1", "d1e1j2o1o2", "d2e2j3o2o3", "d3e3j0j4o0o3o4", "d4e4j0j5o0o4o5", "d5e5j6o5o6", "d6e6j0j7o0o6o7", "d7e7j0o0o7", "d0d1e0j0o1", "d1d2e1j1o2", "d2d3e2j2o3", "d0d3d4e3j3o0o4", "d0d4d5e4j4o0o5", "d5d6e5j5o6", "d0d6d7e6j6o0o7", "d0d7e7j7o0"};
            boolean threePage = false;
            for (int v = 0; v < 33; ++v) {
                if (v != 32) continue;
                String title = "whit";
                if (v < 16) {
                    title = title + "Input" + (v + 1);
                } else if (v < 32) {
                    title = title + "Output" + (v - 15);
                }
                Cell myCell = Cell.newInstance(Library.getCurrent(), title + "{sch}");
                PrimitiveNode pinNp = Generic.tech.universalPinNode;
                NodeInst[] inputs = new NodeInst[128];
                NodeInst[] outputs = new NodeInst[128];
                NodeInst[] inputsAbove = new NodeInst[128];
                NodeInst[] outputsAbove = new NodeInst[128];
                NodeInst[] inputsBelow = new NodeInst[128];
                NodeInst[] outputsBelow = new NodeInst[128];
                for (int j = 0; j < 3; ++j) {
                    if (!threePage && j != 1) continue;
                    for (int i = 0; i < 128; ++i) {
                        int index = i;
                        if (j == 0) {
                            index += 128;
                        } else if (j == 2) {
                            index -= 128;
                        }
                        NodeInst in = NodeInst.newInstance(pinNp, new Point2D.Double(-200.0, index * 5), 1.0, 1.0, 0, myCell, null);
                        switch (j) {
                            case 0: {
                                inputsAbove[i] = in;
                                break;
                            }
                            case 1: {
                                inputs[i] = in;
                                break;
                            }
                            case 2: {
                                inputsBelow[i] = in;
                            }
                        }
                        if (j == 1) {
                            NodeInst leftArrow = NodeInst.newInstance(Artwork.tech.boxNode, new Point2D.Double(-267.0, i * 5), 10.0, 0.0, 0, myCell, null);
                            NodeInst leftArrowHead = NodeInst.newInstance(Artwork.tech.arrowNode, new Point2D.Double(-264.0, i * 5), 4.0, 4.0, 0, myCell, null);
                        }
                        NodeInst out = NodeInst.newInstance(pinNp, new Point2D.Double(200.0, index * 5), 0.0, 0.0, 0, myCell, null);
                        switch (j) {
                            case 0: {
                                outputsAbove[i] = out;
                                break;
                            }
                            case 1: {
                                outputs[i] = out;
                                break;
                            }
                            case 2: {
                                outputsBelow[i] = out;
                            }
                        }
                        if (j != 1) continue;
                        NodeInst circle = NodeInst.newInstance(Artwork.tech.circleNode, new Point2D.Double(202.5, i * 5), 5.0, 5.0, 0, myCell, null);
                        NodeInst horiz = NodeInst.newInstance(Artwork.tech.boxNode, new Point2D.Double(202.5, i * 5), 4.0, 0.0, 0, myCell, null);
                        NodeInst vert = NodeInst.newInstance(Artwork.tech.boxNode, new Point2D.Double(202.5, i * 5), 0.0, 4.0, 0, myCell, null);
                        NodeInst rightArrow = NodeInst.newInstance(Artwork.tech.boxNode, new Point2D.Double(210.0, i * 5), 10.0, 0.0, 0, myCell, null);
                        NodeInst rightArrowHead = NodeInst.newInstance(Artwork.tech.arrowNode, new Point2D.Double(213.0, i * 5), 4.0, 4.0, 0, myCell, null);
                    }
                }
                for (int i = 0; i < 16; ++i) {
                    NodeInst inputBox = NodeInst.newInstance(Artwork.tech.boxNode, new Point2D.Double(-222.0, (double)(i * 5 * 8 + 20) - 2.5), 40.0, 40.0, 0, myCell, null);
                    Variable inVar = inputBox.newVar("label", (Object)"S-box");
                    inVar.setDisplay(true);
                    inVar.getTextDescriptor().setRelSize(12.0);
                }
                NodeInst inputBox1 = NodeInst.newInstance(Artwork.tech.boxNode, new Point2D.Double(-252.0, 317.5), 20.0, 640.0, 0, myCell, null);
                Variable inVar1 = inputBox1.newVar("label", (Object)"Keying");
                inVar1.setDisplay(true);
                inVar1.getTextDescriptor().setRotation(TextDescriptor.Rotation.ROT90);
                inVar1.getTextDescriptor().setRelSize(15.0);
                NodeInst inputBox2 = NodeInst.newInstance(Artwork.tech.boxNode, new Point2D.Double(-282.0, 317.5), 20.0, 640.0, 0, myCell, null);
                Variable inVar2 = inputBox2.newVar("label", (Object)"Input");
                inVar2.setDisplay(true);
                inVar2.getTextDescriptor().setRotation(TextDescriptor.Rotation.ROT90);
                inVar2.getTextDescriptor().setRelSize(15.0);
                NodeInst outputBox = NodeInst.newInstance(Artwork.tech.boxNode, new Point2D.Double(225.0, 317.5), 20.0, 640.0, 0, myCell, null);
                Variable inVar3 = outputBox.newVar("label", (Object)"Output");
                inVar3.setDisplay(true);
                inVar3.getTextDescriptor().setRotation(TextDescriptor.Rotation.ROT90);
                inVar3.getTextDescriptor().setRelSize(15.0);
                NodeInst titleBox = NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(0.0, 670.0), 0.0, 0.0, 0, myCell, null);
                Variable inVar4 = titleBox.newVar("label", (Object)"One Round of AES");
                inVar4.setDisplay(true);
                inVar4.getTextDescriptor().setRelSize(24.0);
                PrimitiveArc wire = Generic.tech.universal_arc;
                for (int i = 0; i < theStrings.length; ++i) {
                    int len = theStrings[i].length();
                    for (int j = 0; j < len; j += 2) {
                        PortInst outPort;
                        PortInst inPort;
                        char letter = theStrings[i].charAt(j);
                        char number = theStrings[i].charAt(j + 1);
                        int index = (letter - 97) * 8 + (number - 48);
                        if (v >= 16 ? v < 32 && i / 8 != v - 16 : v + 97 != letter) continue;
                        if (threePage && Math.abs(index - i) > 64) {
                            if (i < 64) {
                                inPort = inputsBelow[index].getOnlyPortInst();
                                outPort = outputs[i].getOnlyPortInst();
                                ArcInst.newInstance(wire, 0.0, inPort, outPort, null);
                                inPort = inputs[index].getOnlyPortInst();
                                outPort = outputsAbove[i].getOnlyPortInst();
                                ArcInst.newInstance(wire, 0.0, inPort, outPort, null);
                                continue;
                            }
                            inPort = inputsAbove[index].getOnlyPortInst();
                            outPort = outputs[i].getOnlyPortInst();
                            ArcInst.newInstance(wire, 0.0, inPort, outPort, null);
                            inPort = inputs[index].getOnlyPortInst();
                            outPort = outputsBelow[i].getOnlyPortInst();
                            ArcInst.newInstance(wire, 0.0, inPort, outPort, null);
                            continue;
                        }
                        inPort = inputs[index].getOnlyPortInst();
                        outPort = outputs[i].getOnlyPortInst();
                        ArcInst.newInstance(wire, 0.0, inPort, outPort, null);
                    }
                }
                if (v != 32) continue;
                WindowFrame.createEditWindow(myCell);
            }
            return true;
        }
    }

    private static class DefunctJob
    extends Job {
        public DefunctJob() {
            super("Defunct Job", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            while (true) {
                DebugMenus.changeSharedList();
            }
        }
    }

    private static class RedisplayTest
    extends Job {
        private long delayTimeMS;

        private RedisplayTest(long delayTimeMS) {
            super("RedisplayTest", User.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.delayTimeMS = delayTimeMS;
            this.startJob();
        }

        public boolean doIt() {
            Random rand = new Random(143137493L);
            for (int i = 0; i < 200; ++i) {
                if (this.getScheduledToAbort()) {
                    return false;
                }
                WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                int next = i % 4;
                switch (next) {
                    case 0: {
                        ZoomAndPanListener.panX(wf, 1);
                        break;
                    }
                    case 1: {
                        ZoomAndPanListener.panY(wf, 1);
                        break;
                    }
                    case 2: {
                        ZoomAndPanListener.panX(wf, -1);
                        break;
                    }
                    case 3: {
                        ZoomAndPanListener.panY(wf, -1);
                    }
                }
                this.doWait();
            }
            System.out.println(this.getInfo());
            return true;
        }

        private void doWait() {
            try {
                boolean donesleeping = false;
                while (!donesleeping) {
                    Thread.sleep(this.delayTimeMS);
                    donesleeping = true;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class RedrawTest
    extends Job {
        private RedrawTest() {
            super("RedrawTest", User.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            long startTime = System.currentTimeMillis();
            EditWindow wnd = EditWindow.getCurrent();
            for (int i = 0; i < 100; ++i) {
                if (!this.getScheduledToAbort()) continue;
                return false;
            }
            long endTime = System.currentTimeMillis();
            StringBuffer buf = new StringBuffer();
            Date start = new Date(startTime);
            buf.append("  start time: " + start + "\n");
            Date end = new Date(endTime);
            buf.append("  end time: " + end + "\n");
            long time = endTime - startTime;
            buf.append("  time taken: " + TextUtils.getElapsedTime(time) + "\n");
            System.out.println(buf.toString());
            return true;
        }

        private void doWait() {
            try {
                boolean donesleeping = false;
                while (!donesleeping) {
                    Thread.sleep(100L);
                    donesleeping = true;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class CoverImplantOld
    extends Job {
        private Cell curCell;

        protected CoverImplantOld(Cell cell) {
            super("Coverage Implant Old", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.curCell = cell;
            this.setReportExecutionFlag(true);
            this.startJob();
        }

        public boolean doIt() {
            Poly poly;
            Poly[] polyList;
            Technology tech;
            PolyMerge merge = new PolyMerge();
            ArrayList<NodeInst> deleteList = new ArrayList<NodeInst>();
            HashMap<Layer, ArrayList<Poly>> allLayers = new HashMap<Layer, ArrayList<Poly>>();
            Iterator it = this.curCell.getArcs();
            while (it.hasNext()) {
                ArcInst arc = (ArcInst)it.next();
                ArcProto arcType = arc.getProto();
                tech = arcType.getTechnology();
                polyList = tech.getShapeOfArc(arc);
                for (int i = 0; i < polyList.length; ++i) {
                    Poly poly2 = polyList[i];
                    Layer layer = poly2.getLayer();
                    Layer.Function func = layer.getFunction();
                    if (!func.isSubstrate()) continue;
                    merge.addPolygon(layer, poly2);
                    ArrayList<Poly> rectList = (ArrayList<Poly>)allLayers.get(layer);
                    if (rectList == null) {
                        rectList = new ArrayList<Poly>();
                        allLayers.put(layer, rectList);
                    }
                    rectList.add(poly2);
                }
            }
            it = this.curCell.getNodes();
            while (it.hasNext()) {
                NodeInst node = (NodeInst)it.next();
                if (node.getFunction() == NodeProto.Function.NODE) {
                    deleteList.add(node);
                    continue;
                }
                NodeProto protoType = node.getProto();
                if (protoType instanceof Cell) continue;
                tech = protoType.getTechnology();
                polyList = tech.getShapeOfNode(node);
                AffineTransform transform = node.rotateOut();
                for (int i = 0; i < polyList.length; ++i) {
                    poly = polyList[i];
                    Layer layer = poly.getLayer();
                    Layer.Function func = layer.getFunction();
                    if (!func.isSubstrate()) continue;
                    poly.transform(transform);
                    merge.addPolygon(layer, poly);
                    ArrayList<Poly> rectList = (ArrayList<Poly>)allLayers.get(layer);
                    if (rectList == null) {
                        rectList = new ArrayList<Poly>();
                        allLayers.put(layer, rectList);
                    }
                    rectList.add(poly);
                }
            }
            Highlight.clear();
            ArrayList<NodeInst> nodesList = new ArrayList<NodeInst>();
            Iterator it2 = merge.getLayersUsed();
            while (it2.hasNext()) {
                Rectangle2D rect;
                Layer layer = (Layer)it2.next();
                List list = merge.getMergedPoints(layer);
                List rectList = (List)allLayers.get(layer);
                ArrayList<Poly> delList = new ArrayList<Poly>();
                Iterator iter = rectList.iterator();
                while (iter.hasNext()) {
                    Poly p = (Poly)iter.next();
                    rect = p.getBounds2D();
                    Iterator i = list.iterator();
                    while (i.hasNext()) {
                        Poly poly3 = (Poly)i.next();
                        Rectangle2D r = poly3.getBounds2D();
                        if (!r.equals(rect)) continue;
                        delList.add(poly3);
                    }
                }
                iter = delList.iterator();
                while (iter.hasNext()) {
                    list.remove(iter.next());
                }
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    poly = (Poly)i.next();
                    rect = poly.getBounds2D();
                    Point2D.Double center = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
                    PrimitiveNode priNode = layer.getPureLayerNode();
                    NodeInst node = NodeInst.makeInstance(priNode, center, rect.getWidth(), rect.getHeight(), 0, this.curCell, null);
                    Highlight.addElectricObject(node, this.curCell);
                    node.setHardSelect();
                    nodesList.add(node);
                }
            }
            Highlight.finished();
            it2 = deleteList.iterator();
            while (it2.hasNext()) {
                NodeInst node = (NodeInst)it2.next();
                node.kill();
            }
            if (nodesList.isEmpty()) {
                System.out.println("No implant areas added");
            }
            return true;
        }
    }

    private static class CoverImplant
    extends Job {
        private Cell curCell;
        private boolean testMerge = false;

        protected CoverImplant(Cell cell, boolean test) {
            super("Coverage Implant", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.curCell = cell;
            this.testMerge = test;
            this.setReportExecutionFlag(true);
            this.startJob();
        }

        public boolean doIt() {
            Poly[] polyList;
            Technology tech;
            ArrayList<NodeInst> deleteList = new ArrayList<NodeInst>();
            PolyQTree tree = new PolyQTree(this.curCell.getBounds());
            Iterator it = this.curCell.getArcs();
            while (it.hasNext()) {
                ArcInst arc = (ArcInst)it.next();
                ArcProto arcType = arc.getProto();
                tech = arcType.getTechnology();
                polyList = tech.getShapeOfArc(arc);
                for (int i = 0; i < polyList.length; ++i) {
                    Poly poly = polyList[i];
                    Layer layer = poly.getLayer();
                    Layer.Function func = layer.getFunction();
                    if (!Main.getDebug() && !func.isSubstrate()) continue;
                    tree.insert(layer, new PolyQTree.PolyNode(poly.getBounds2D()));
                }
            }
            it = this.curCell.getNodes();
            while (it.hasNext()) {
                NodeInst node = (NodeInst)it.next();
                if (!Main.getDebug() && node.getFunction() == NodeProto.Function.NODE) {
                    deleteList.add(node);
                    continue;
                }
                NodeProto protoType = node.getProto();
                if (protoType instanceof Cell) continue;
                tech = protoType.getTechnology();
                polyList = tech.getShapeOfNode(node);
                AffineTransform transform = node.rotateOut();
                for (int i = 0; i < polyList.length; ++i) {
                    Poly poly = polyList[i];
                    Layer layer = poly.getLayer();
                    Layer.Function func = layer.getFunction();
                    if (!Main.getDebug() && !func.isSubstrate()) continue;
                    poly.transform(transform);
                    tree.insert(layer, new PolyQTree.PolyNode(poly.getBounds2D()));
                }
            }
            Highlight.clear();
            boolean noNewNodes = true;
            Iterator it2 = tree.getKeyIterator();
            while (it2.hasNext()) {
                Layer layer = (Layer)it2.next();
                Set set = tree.getObjects(layer, true);
                Iterator i = set.iterator();
                while (i.hasNext()) {
                    PolyQTree.PolyNode qNode = (PolyQTree.PolyNode)i.next();
                    Rectangle2D rect = qNode.getBounds2D();
                    Point2D.Double center = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
                    PrimitiveNode priNode = layer.getPureLayerNode();
                    NodeInst node = NodeInst.makeInstance(priNode, center, rect.getWidth(), rect.getHeight(), 0, this.curCell, null);
                    Highlight.addElectricObject(node, this.curCell);
                    if (this.testMerge) {
                        Point2D[] points = qNode.getPoints();
                        node.newVar(NodeInst.TRACE, (Object)points);
                    } else {
                        node.setHardSelect();
                    }
                    noNewNodes = false;
                }
            }
            Highlight.finished();
            it2 = deleteList.iterator();
            while (it2.hasNext()) {
                NodeInst node = (NodeInst)it2.next();
                node.kill();
            }
            if (noNewNodes) {
                System.out.println("No implant areas added");
            }
            return true;
        }
    }

    private static class MakeFakeCircuitry
    extends Job {
        protected MakeFakeCircuitry() {
            super("Make fake circuitry", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            NodeProto m1m2Proto = NodeProto.findNodeProto("mocmos:Metal-1-Metal-2-Con");
            NodeProto m2PinProto = NodeProto.findNodeProto("mocmos:Metal-2-Pin");
            NodeProto p1PinProto = NodeProto.findNodeProto("mocmos:Polysilicon-1-Pin");
            NodeProto m1PolyConProto = NodeProto.findNodeProto("mocmos:Metal-1-Polysilicon-1-Con");
            NodeProto pTransProto = NodeProto.findNodeProto("mocmos:P-Transistor");
            NodeProto nTransProto = NodeProto.findNodeProto("mocmos:N-Transistor");
            NodeProto invisiblePinProto = NodeProto.findNodeProto("generic:Invisible-Pin");
            ArcProto m1Proto = ArcProto.findArcProto("mocmos:Metal-1");
            ArcProto m2Proto = ArcProto.findArcProto("mocmos:Metal-2");
            ArcProto p1Proto = ArcProto.findArcProto("mocmos:Polysilicon-1");
            Library mainLib = Library.getCurrent();
            Cell myCell = Cell.makeInstance(mainLib, "test{lay}");
            NodeInst metal12Via = NodeInst.newInstance(m1m2Proto, new Point2D.Double(-20.0, 20.0), m1m2Proto.getDefWidth(), m1m2Proto.getDefHeight(), 0, myCell, null);
            NodeInst contactNode = NodeInst.newInstance(m1PolyConProto, new Point2D.Double(20.0, 20.0), m1PolyConProto.getDefWidth(), m1PolyConProto.getDefHeight(), 0, myCell, null);
            NodeInst metal2Pin = NodeInst.newInstance(m2PinProto, new Point2D.Double(-20.0, 10.0), m2PinProto.getDefWidth(), m2PinProto.getDefHeight(), 0, myCell, null);
            NodeInst poly1PinA = NodeInst.newInstance(p1PinProto, new Point2D.Double(20.0, -20.0), p1PinProto.getDefWidth(), p1PinProto.getDefHeight(), 0, myCell, null);
            NodeInst poly1PinB = NodeInst.newInstance(p1PinProto, new Point2D.Double(20.0, -10.0), p1PinProto.getDefWidth(), p1PinProto.getDefHeight(), 0, myCell, null);
            NodeInst transistor = NodeInst.newInstance(pTransProto, new Point2D.Double(0.0, -20.0), pTransProto.getDefWidth(), pTransProto.getDefHeight(), 0, myCell, null);
            NodeInst rotTrans = NodeInst.newInstance(nTransProto, new Point2D.Double(0.0, 10.0), nTransProto.getDefWidth(), nTransProto.getDefHeight(), 3150, myCell, "rotated");
            if (metal12Via == null || contactNode == null || metal2Pin == null || poly1PinA == null || poly1PinB == null || transistor == null || rotTrans == null) {
                return false;
            }
            PortInst m1m2Port = metal12Via.getOnlyPortInst();
            PortInst contactPort = contactNode.getOnlyPortInst();
            PortInst m2Port = metal2Pin.getOnlyPortInst();
            PortInst p1PortA = poly1PinA.getOnlyPortInst();
            PortInst p1PortB = poly1PinB.getOnlyPortInst();
            PortInst transPortR = transistor.findPortInst("p-trans-poly-right");
            PortInst transRPortR = rotTrans.findPortInst("n-trans-poly-right");
            ArcInst metal2Arc = ArcInst.makeInstance(m2Proto, m2Proto.getWidth(), m2Port, m1m2Port, null);
            if (metal2Arc == null) {
                return false;
            }
            metal2Arc.setRigid();
            ArcInst metal1Arc = ArcInst.makeInstance(m1Proto, m1Proto.getWidth(), contactPort, m1m2Port, null);
            if (metal1Arc == null) {
                return false;
            }
            ArcInst polyArc1 = ArcInst.makeInstance(p1Proto, p1Proto.getWidth(), contactPort, p1PortB, null);
            if (polyArc1 == null) {
                return false;
            }
            ArcInst polyArc3 = ArcInst.makeInstance(p1Proto, p1Proto.getWidth(), p1PortB, p1PortA, null);
            if (polyArc3 == null) {
                return false;
            }
            ArcInst polyArc2 = ArcInst.makeInstance(p1Proto, p1Proto.getWidth(), transPortR, p1PortA, null);
            if (polyArc2 == null) {
                return false;
            }
            ArcInst polyArc4 = ArcInst.makeInstance(p1Proto, p1Proto.getWidth(), transRPortR, p1PortB, null);
            if (polyArc4 == null) {
                return false;
            }
            Export m1Export = Export.newInstance(myCell, m1m2Port, "in");
            m1Export.setCharacteristic(PortProto.Characteristic.IN);
            Export p1Export = Export.newInstance(myCell, p1PortA, "out");
            p1Export.setCharacteristic(PortProto.Characteristic.OUT);
            System.out.println("Created cell " + myCell.describe());
            Cell higherCell = Cell.makeInstance(mainLib, "higher{lay}");
            Rectangle2D bounds = myCell.getBounds();
            double myWidth = myCell.getDefWidth();
            double myHeight = myCell.getDefHeight();
            NodeInst instance1Node = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 0.0), myWidth, myHeight, 0, higherCell, null);
            instance1Node.setExpanded();
            NodeInst instance1UNode = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 100.0), myWidth, myHeight, 0, higherCell, null);
            NodeInst instance2Node = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 0.0), myWidth, myHeight, 900, higherCell, null);
            instance2Node.setExpanded();
            NodeInst instance2UNode = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 100.0), myWidth, myHeight, 900, higherCell, null);
            NodeInst instance3Node = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 0.0), myWidth, myHeight, 1800, higherCell, null);
            instance3Node.setExpanded();
            NodeInst instance3UNode = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 100.0), myWidth, myHeight, 1800, higherCell, null);
            NodeInst instance4Node = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 0.0), myWidth, myHeight, 2700, higherCell, null);
            instance4Node.setExpanded();
            NodeInst instance4UNode = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 100.0), myWidth, myHeight, 2700, higherCell, null);
            NodeInst instance5Node = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 200.0), -myWidth, myHeight, 0, higherCell, null);
            instance5Node.setExpanded();
            NodeInst instance5UNode = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 300.0), -myWidth, myHeight, 0, higherCell, null);
            NodeInst instance6Node = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 200.0), -myWidth, myHeight, 900, higherCell, null);
            instance6Node.setExpanded();
            NodeInst instance6UNode = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 300.0), -myWidth, myHeight, 900, higherCell, null);
            NodeInst instance7Node = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 200.0), -myWidth, myHeight, 1800, higherCell, null);
            instance7Node.setExpanded();
            NodeInst instance7UNode = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 300.0), -myWidth, myHeight, 1800, higherCell, null);
            NodeInst instance8Node = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 200.0), -myWidth, myHeight, 2700, higherCell, null);
            instance8Node.setExpanded();
            NodeInst instance8UNode = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 300.0), -myWidth, myHeight, 2700, higherCell, null);
            PortInst instance1Port = instance1Node.findPortInst("in");
            PortInst instance2Port = instance1UNode.findPortInst("in");
            ArcInst instanceArc = ArcInst.makeInstance(m1Proto, m1Proto.getWidth(), instance1Port, instance2Port, null);
            System.out.println("Created cell " + higherCell.describe());
            Cell rotTestCell = Cell.makeInstance(mainLib, "rotationTest{lay}");
            NodeInst r0Node = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 0.0), myWidth, myHeight, 0, rotTestCell, null);
            r0Node.setExpanded();
            NodeInst nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(0.0, -35.0), 0.0, 0.0, 0, rotTestCell, null);
            Variable var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 0");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            NodeInst r90Node = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 0.0), myWidth, myHeight, 900, rotTestCell, null);
            r90Node.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(100.0, -35.0), 0.0, 0.0, 0, rotTestCell, null);
            var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 90");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            NodeInst r180Node = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 0.0), myWidth, myHeight, 1800, rotTestCell, null);
            r180Node.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(200.0, -35.0), 0.0, 0.0, 0, rotTestCell, null);
            var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 180");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            NodeInst r270Node = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 0.0), myWidth, myHeight, 2700, rotTestCell, null);
            r270Node.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(300.0, -35.0), 0.0, 0.0, 0, rotTestCell, null);
            var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 270");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            NodeInst r0MXNode = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 100.0), -myWidth, myHeight, 0, rotTestCell, null);
            r0MXNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(0.0, 65.0), 0.0, 0.0, 0, rotTestCell, null);
            var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 0 MX");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            NodeInst r90MXNode = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 100.0), -myWidth, myHeight, 900, rotTestCell, null);
            r90MXNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(100.0, 65.0), 0.0, 0.0, 0, rotTestCell, null);
            var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 90 MX");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            NodeInst r180MXNode = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 100.0), -myWidth, myHeight, 1800, rotTestCell, null);
            r180MXNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(200.0, 65.0), 0.0, 0.0, 0, rotTestCell, null);
            var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 180 MX");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            NodeInst r270MXNode = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 100.0), -myWidth, myHeight, 2700, rotTestCell, null);
            r270MXNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(300.0, 65.0), 0.0, 0.0, 0, rotTestCell, null);
            var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 270 MX");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            NodeInst r0MYNode = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 200.0), myWidth, -myHeight, 0, rotTestCell, null);
            r0MYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(0.0, 165.0), 0.0, 0.0, 0, rotTestCell, null);
            var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 0 MY");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            NodeInst r90MYNode = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 200.0), myWidth, -myHeight, 900, rotTestCell, null);
            r90MYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(100.0, 165.0), 0.0, 0.0, 0, rotTestCell, null);
            var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 90 MY");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            NodeInst r180MYNode = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 200.0), myWidth, -myHeight, 1800, rotTestCell, null);
            r180MYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(200.0, 165.0), 0.0, 0.0, 0, rotTestCell, null);
            var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 180 MY");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            NodeInst r270MYNode = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 200.0), myWidth, -myHeight, 2700, rotTestCell, null);
            r270MYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(300.0, 165.0), 0.0, 0.0, 0, rotTestCell, null);
            var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 270 MY");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            NodeInst r0MXYNode = NodeInst.newInstance(myCell, new Point2D.Double(0.0, 300.0), -myWidth, -myHeight, 0, rotTestCell, null);
            r0MXYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(0.0, 265.0), 0.0, 0.0, 0, rotTestCell, null);
            var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 0 MXY");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            NodeInst r90MXYNode = NodeInst.newInstance(myCell, new Point2D.Double(100.0, 300.0), -myWidth, -myHeight, 900, rotTestCell, null);
            r90MXYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(100.0, 265.0), 0.0, 0.0, 0, rotTestCell, null);
            var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 90 MXY");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            NodeInst r180MXYNode = NodeInst.newInstance(myCell, new Point2D.Double(200.0, 300.0), -myWidth, -myHeight, 1800, rotTestCell, null);
            r180MXYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(200.0, 265.0), 0.0, 0.0, 0, rotTestCell, null);
            var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 180 MXY");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            NodeInst r270MXYNode = NodeInst.newInstance(myCell, new Point2D.Double(300.0, 300.0), -myWidth, -myHeight, 2700, rotTestCell, null);
            r270MXYNode.setExpanded();
            nodeLabel = NodeInst.newInstance(invisiblePinProto, new Point2D.Double(300.0, 265.0), 0.0, 0.0, 0, rotTestCell, null);
            var = nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)"Rotated 270 MXY");
            var.setDisplay(true);
            var.getTextDescriptor().setRelSize(10.0);
            System.out.println("Created cell " + rotTestCell.describe());
            Cell bigCell = Cell.makeInstance(mainLib, "big{lay}");
            int arraySize = 20;
            for (int y = 0; y < arraySize; ++y) {
                for (int x = 0; x < arraySize; ++x) {
                    String theName = "arr[" + x + "][" + y + "]";
                    NodeInst instanceNode = NodeInst.newInstance(myCell, new Point2D.Double((double)x * (myWidth + 2.0), (double)y * (myHeight + 2.0)), myWidth, myHeight, 0, bigCell, theName);
                    TextDescriptor td = instanceNode.getNameTextDescriptor();
                    td.setOff(0.0, 8.0);
                    instanceNode.setNameTextDescriptor(td);
                    if (x % 2 != y % 2) continue;
                    instanceNode.setExpanded();
                }
            }
            System.out.println("Created cell " + bigCell.describe());
            WindowFrame.createEditWindow(myCell);
            return true;
        }
    }
}

