/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class LogicalEffortTab
extends PreferencePanel {
    private JList leArcList;
    private DefaultListModel leArcListModel;
    private HashMap leArcOptions;
    private boolean leUseLocalSettingsInitial;
    private boolean leDisplayIntermediateCapsInitial;
    private boolean leHighlightComponentsInitial;
    private double leGlobalFanOutInitial;
    private double leConvergenceInitial;
    private int leMaxIterationsInitial;
    private double leGateCapacitanceInitial;
    private double leDefaultWireCapRatioInitial;
    private double leDiffToGateCapRatioInitial;
    private double leKeeperSizeRatioInitial;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel20;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane leArc;
    private JTextField leConvergence;
    private JTextField leDefaultWireCapRatio;
    private JTextField leDiffToGateCapRatio;
    private JCheckBox leDisplayIntermediateCaps;
    private JTextField leGateCapacitance;
    private JTextField leGlobalFanOut;
    private JButton leHelp;
    private JCheckBox leHighlightComponents;
    private JTextField leKeeperSizeRatio;
    private JTextField leMaxIterations;
    private JCheckBox leUseLocalSettings;
    private JTextField leWireRatio;
    private JPanel logicalEffort;

    public LogicalEffortTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.logicalEffort;
    }

    public String getName() {
        return "LogicalEffort";
    }

    public void init() {
        this.leHighlightComponentsInitial = LETool.isHighlightComponents();
        this.leHighlightComponents.setSelected(this.leHighlightComponentsInitial);
        this.leUseLocalSettingsInitial = LETool.isUseLocalSettings();
        this.leUseLocalSettings.setSelected(this.leUseLocalSettingsInitial);
        this.leDisplayIntermediateCapsInitial = LETool.isShowIntermediateCapacitances();
        this.leDisplayIntermediateCaps.setSelected(this.leDisplayIntermediateCapsInitial);
        this.leGlobalFanOutInitial = LETool.getGlobalFanout();
        this.leGlobalFanOut.setText(Double.toString(this.leGlobalFanOutInitial));
        this.leConvergenceInitial = LETool.getConvergenceEpsilon();
        this.leConvergence.setText(Double.toString(this.leConvergenceInitial));
        this.leMaxIterationsInitial = LETool.getMaxIterations();
        this.leMaxIterations.setText(Integer.toString(this.leMaxIterationsInitial));
        this.leGateCapacitanceInitial = LETool.getGateCapacitance();
        this.leGateCapacitance.setText(Double.toString(this.leGateCapacitanceInitial));
        this.leDefaultWireCapRatioInitial = LETool.getWireRatio();
        this.leDefaultWireCapRatio.setText(Double.toString(this.leDefaultWireCapRatioInitial));
        this.leDiffToGateCapRatioInitial = LETool.getDiffAlpha();
        this.leDiffToGateCapRatio.setText(Double.toString(this.leDiffToGateCapRatioInitial));
        this.leKeeperSizeRatioInitial = LETool.getKeeperRatio();
        this.leKeeperSizeRatio.setText(Double.toString(this.leKeeperSizeRatioInitial));
        this.leArcOptions = new HashMap();
        Iterator it = this.curTech.getArcs();
        while (it.hasNext()) {
            ArcProto arc = (ArcProto)it.next();
            this.leArcOptions.put(arc, Pref.makeDoublePref(null, null, LETool.tool.prefs.getDouble(arc.toString(), 0.0)));
        }
        this.leArcListModel = new DefaultListModel();
        this.leArcList = new JList(this.leArcListModel);
        this.leArcList.setSelectionMode(0);
        this.leArc.setViewportView(this.leArcList);
        this.leArcList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LogicalEffortTab.this.leArcListClick(evt);
            }
        });
        this.showArcsInTechnology(this.leArcListModel);
        this.leArcList.setSelectedIndex(0);
        this.leArcListClick(null);
        this.leWireRatio.getDocument().addDocumentListener(new ArcDocumentListener(this.leArcOptions, this.leArcList, this.leArcListModel, this.curTech));
        this.leHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogicalEffortTab.this.leHelpActionPerformed(evt);
            }
        });
    }

    private void leHelpActionPerformed(ActionEvent evt) {
        System.out.println("No help yet");
    }

    public void term() {
        int nowInt;
        double nowDouble;
        boolean nowBoolean = this.leUseLocalSettings.isSelected();
        if (this.leUseLocalSettingsInitial != nowBoolean) {
            LETool.setUseLocalSettings(nowBoolean);
        }
        if (this.leDisplayIntermediateCapsInitial != (nowBoolean = this.leDisplayIntermediateCaps.isSelected())) {
            LETool.setShowIntermediateCapacitances(nowBoolean);
        }
        if (this.leHighlightComponentsInitial != (nowBoolean = this.leHighlightComponents.isSelected())) {
            LETool.setHighlightComponents(nowBoolean);
        }
        if (this.leGlobalFanOutInitial != (nowDouble = TextUtils.atof(this.leGlobalFanOut.getText()))) {
            LETool.setGlobalFanout(nowDouble);
        }
        if (this.leConvergenceInitial != (nowDouble = TextUtils.atof(this.leConvergence.getText()))) {
            LETool.setConvergenceEpsilon(nowDouble);
        }
        if (this.leMaxIterationsInitial != (nowInt = TextUtils.atoi(this.leMaxIterations.getText()))) {
            LETool.setMaxIterations(nowInt);
        }
        if (this.leGateCapacitanceInitial != (nowDouble = TextUtils.atof(this.leGateCapacitance.getText()))) {
            LETool.setGateCapacitance(nowDouble);
        }
        if (this.leDefaultWireCapRatioInitial != (nowDouble = TextUtils.atof(this.leDefaultWireCapRatio.getText()))) {
            LETool.setWireRatio(nowDouble);
        }
        if (this.leDiffToGateCapRatioInitial != (nowDouble = TextUtils.atof(this.leDiffToGateCapRatio.getText()))) {
            LETool.setDiffAlpha(nowDouble);
        }
        if (this.leKeeperSizeRatioInitial != (nowDouble = TextUtils.atof(this.leKeeperSizeRatio.getText()))) {
            LETool.setKeeperRatio(nowDouble);
        }
        Iterator it = this.curTech.getArcs();
        while (it.hasNext()) {
            ArcProto arc = (ArcProto)it.next();
            Pref pref = (Pref)this.leArcOptions.get(arc);
            if (pref == null || pref.getDoubleFactoryValue() == pref.getDouble()) continue;
            LETool.tool.prefs.putDouble(arc.toString(), pref.getDouble());
        }
    }

    private void leArcListClick(MouseEvent evt) {
        PrimitiveArc arc;
        Pref pref;
        String arcName = (String)this.leArcList.getSelectedValue();
        int firstSpace = arcName.indexOf(32);
        if (firstSpace > 0) {
            arcName = arcName.substring(0, firstSpace);
        }
        if ((pref = (Pref)this.leArcOptions.get(arc = this.curTech.findArcProto(arcName))) == null) {
            return;
        }
        this.leWireRatio.setText(Double.toString(pref.getDouble()));
    }

    private void showArcsInTechnology(DefaultListModel model) {
        model.clear();
        Iterator it = this.curTech.getArcs();
        while (it.hasNext()) {
            ArcProto arc = (ArcProto)it.next();
            model.addElement(arc.getName() + " (" + ((Pref)this.leArcOptions.get(arc)).getDouble() + ")");
        }
    }

    private void initComponents() {
        this.logicalEffort = new JPanel();
        this.leArc = new JScrollPane();
        this.jLabel4 = new JLabel();
        this.leDisplayIntermediateCaps = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jLabel14 = new JLabel();
        this.leHelp = new JButton();
        this.jLabel15 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel25 = new JLabel();
        this.leUseLocalSettings = new JCheckBox();
        this.leHighlightComponents = new JCheckBox();
        this.leGlobalFanOut = new JTextField();
        this.leConvergence = new JTextField();
        this.leMaxIterations = new JTextField();
        this.leGateCapacitance = new JTextField();
        this.leDefaultWireCapRatio = new JTextField();
        this.leDiffToGateCapRatio = new JTextField();
        this.leKeeperSizeRatio = new JTextField();
        this.leWireRatio = new JTextField();
        this.jLabel24 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LogicalEffortTab.this.closeDialog(evt);
            }
        });
        this.logicalEffort.setLayout(new GridBagLayout());
        this.leArc.setMinimumSize(new Dimension(100, 100));
        this.leArc.setPreferredSize(new Dimension(100, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leArc, gridBagConstraints);
        this.jLabel4.setText("Global Fan-Out (step-up):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel4, gridBagConstraints);
        this.leDisplayIntermediateCaps.setText("Display intermediate capacitances");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leDisplayIntermediateCaps, gridBagConstraints);
        this.jLabel5.setText("Wire ratio for each layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel14.setText("Convergence epsilon:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel14, gridBagConstraints);
        this.leHelp.setText("Help");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leHelp, gridBagConstraints);
        this.jLabel15.setText("Maximum number of iterations:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel15, gridBagConstraints);
        this.jLabel20.setText("Gate capacitance (fF/Lambda):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel20, gridBagConstraints);
        this.jLabel22.setText("Default wire cap ratio (Cwire / Cgate):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel22, gridBagConstraints);
        this.jLabel23.setText("Diffusion to gate cap ratio (alpha) :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel25.setText("Keeper size ratio (keeper size / driver size):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel25, gridBagConstraints);
        this.leUseLocalSettings.setText("Use Local (cell) LE Settings");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leUseLocalSettings, gridBagConstraints);
        this.leHighlightComponents.setText("Highlight components");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leHighlightComponents, gridBagConstraints);
        this.leGlobalFanOut.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leGlobalFanOut, gridBagConstraints);
        this.leConvergence.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leConvergence, gridBagConstraints);
        this.leMaxIterations.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leMaxIterations, gridBagConstraints);
        this.leGateCapacitance.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leGateCapacitance, gridBagConstraints);
        this.leDefaultWireCapRatio.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leDefaultWireCapRatio, gridBagConstraints);
        this.leDiffToGateCapRatio.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leDiffToGateCapRatio, gridBagConstraints);
        this.leKeeperSizeRatio.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leKeeperSizeRatio, gridBagConstraints);
        this.leWireRatio.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leWireRatio, gridBagConstraints);
        this.jLabel24.setText("New Value:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        this.logicalEffort.add((Component)this.jLabel24, gridBagConstraints);
        this.getContentPane().add((Component)this.logicalEffort, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class ArcDocumentListener
    implements DocumentListener {
        HashMap optionMap;
        JList list;
        DefaultListModel model;
        Technology tech;

        ArcDocumentListener(HashMap optionMap, JList list, DefaultListModel model, Technology tech) {
            this.optionMap = optionMap;
            this.list = list;
            this.model = model;
            this.tech = tech;
        }

        private void change(DocumentEvent e) {
            String text;
            PrimitiveArc arc;
            Pref pref;
            String arcName = (String)this.list.getSelectedValue();
            int firstSpace = arcName.indexOf(32);
            if (firstSpace > 0) {
                arcName = arcName.substring(0, firstSpace);
            }
            if ((pref = (Pref)this.optionMap.get(arc = this.tech.findArcProto(arcName))) == null) {
                return;
            }
            Document doc = e.getDocument();
            int len = doc.getLength();
            try {
                text = doc.getText(0, len);
            }
            catch (BadLocationException ex) {
                return;
            }
            double v = TextUtils.atof(text);
            pref.setDouble(v);
            int index = this.list.getSelectedIndex();
            String newLine = arc.getName() + " (" + v + ")";
            this.model.setElementAt(newLine, index);
        }

        public void changedUpdate(DocumentEvent e) {
            this.change(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.change(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.change(e);
        }
    }
}

