/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class Change
extends EDialog {
    private static final int CHANGE_SELECTED = 1;
    private static final int CHANGE_CONNECTED = 2;
    private static final int CHANGE_CELL = 3;
    private static final int CHANGE_LIBRARY = 4;
    private static final int CHANGE_EVERYWHERE = 5;
    private static boolean nodesAndArcs = false;
    private static int whatToChange = 1;
    private static Geometric geomToChange;
    private static String libSelected;
    private JList changeList;
    private DefaultListModel changeListModel;
    private List changeNodeProtoList;
    private static final Pattern dummyName;
    private JCheckBox allowMissingPorts;
    private JButton cancel;
    private JRadioButton changeConnected;
    private JRadioButton changeEverywhere;
    private JRadioButton changeInCell;
    private JRadioButton changeInLibrary;
    private JCheckBox changeNodesWithArcs;
    private ButtonGroup changeOption;
    private JRadioButton changeSelected;
    private JCheckBox ignorePortNames;
    private JLabel jLabel1;
    private JComboBox librariesPopup;
    private JScrollPane listPane;
    private JButton ok;
    private JCheckBox showCells;
    private JCheckBox showPrimitives;

    public static void showChangeDialog() {
        List highs = Highlight.getHighlighted(true, true);
        Geometric geomToChange = null;
        if (highs.size() > 0) {
            geomToChange = (Geometric)highs.get(0);
        }
        if (geomToChange == null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Select an object before changing it.");
            return;
        }
        Change dialog = new Change((Frame)TopLevel.getCurrentJFrame(), true, geomToChange);
        dialog.setVisible(true);
    }

    private Change(Frame parent, boolean modal, Geometric geomToChange) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.changeListModel = new DefaultListModel();
        this.changeList = new JList(this.changeListModel);
        this.changeList.setSelectionMode(0);
        this.listPane.setViewportView(this.changeList);
        this.changeNodeProtoList = new ArrayList();
        this.changeList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Change.this.ok(null);
                }
            }
        });
        List libList = Library.getVisibleLibrariesSortedByName();
        int curIndex = libList.indexOf(Library.getCurrent());
        Iterator it = libList.iterator();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            this.librariesPopup.addItem(lib.getName());
            if (!lib.getName().equals(libSelected)) continue;
            curIndex = -1;
            this.librariesPopup.setSelectedItem(libSelected);
        }
        if (curIndex >= 0) {
            this.librariesPopup.setSelectedIndex(curIndex);
        }
        this.librariesPopup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload();
            }
        });
        Change.geomToChange = geomToChange;
        if (geomToChange instanceof NodeInst) {
            this.librariesPopup.setEnabled(true);
            this.ignorePortNames.setEnabled(true);
            this.allowMissingPorts.setEnabled(true);
            this.showPrimitives.setEnabled(true);
            this.showCells.setEnabled(true);
            NodeInst ni = (NodeInst)geomToChange;
            if (ni.getProto() instanceof Cell) {
                this.showCells.setSelected(true);
            } else {
                this.showPrimitives.setSelected(true);
            }
            this.changeNodesWithArcs.setSelected(false);
            this.changeNodesWithArcs.setEnabled(false);
        } else {
            this.librariesPopup.setEnabled(false);
            this.ignorePortNames.setEnabled(false);
            this.allowMissingPorts.setEnabled(false);
            this.showPrimitives.setEnabled(false);
            this.showCells.setEnabled(false);
            this.changeNodesWithArcs.setEnabled(true);
            this.changeNodesWithArcs.setSelected(nodesAndArcs);
        }
        this.showPrimitives.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload();
            }
        });
        this.showCells.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload();
            }
        });
        this.changeNodesWithArcs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload();
            }
        });
        this.changeSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeConnected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeInCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeInLibrary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeEverywhere.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        switch (whatToChange) {
            case 1: {
                this.changeSelected.setSelected(true);
                break;
            }
            case 2: {
                this.changeConnected.setSelected(true);
                break;
            }
            case 3: {
                this.changeInCell.setSelected(true);
                break;
            }
            case 4: {
                this.changeInLibrary.setSelected(true);
                break;
            }
            case 5: {
                this.changeEverywhere.setSelected(true);
            }
        }
        this.reload();
    }

    protected void escapePressed() {
        this.cancel(null);
    }

    private void whatToChangeChanged(ActionEvent evt) {
        JRadioButton src = (JRadioButton)evt.getSource();
        if (src == this.changeSelected) {
            whatToChange = 1;
        } else if (src == this.changeConnected) {
            whatToChange = 2;
        } else if (src == this.changeInCell) {
            whatToChange = 3;
        } else if (src == this.changeInLibrary) {
            whatToChange = 4;
        } else if (src == this.changeEverywhere) {
            whatToChange = 5;
        }
        if (whatToChange == 5) {
            if (geomToChange instanceof ArcInst) {
                if (this.changeNodesWithArcs.isSelected()) {
                    this.changeNodesWithArcs.setSelected(false);
                    this.reload();
                }
                this.changeNodesWithArcs.setEnabled(false);
            }
        } else if (geomToChange instanceof ArcInst) {
            this.changeNodesWithArcs.setEnabled(true);
        }
    }

    private void reload() {
        this.changeListModel.clear();
        this.changeNodeProtoList.clear();
        Technology curTech = Technology.getCurrent();
        if (geomToChange instanceof NodeInst) {
            if (this.showCells.isSelected()) {
                String libName = (String)this.librariesPopup.getSelectedItem();
                Library lib = Library.findLibrary(libName);
                List cells = lib.getCellsSortedByName();
                Iterator it = cells.iterator();
                while (it.hasNext()) {
                    Cell cell = (Cell)it.next();
                    this.changeListModel.addElement(cell.noLibDescribe());
                    this.changeNodeProtoList.add(cell);
                }
                this.changeList.setSelectedIndex(0);
                String geomName = ((NodeInst)geomToChange).getProto().describe();
                Matcher mat = dummyName.matcher(geomName);
                if (mat.matches()) {
                    this.changeList.setSelectedValue(mat.group(1) + "{" + mat.group(3), true);
                    this.librariesPopup.setSelectedItem(mat.group(2));
                } else {
                    this.changeList.setSelectedValue(geomName, true);
                }
            }
            if (this.showPrimitives.isSelected()) {
                Iterator it = curTech.getNodes();
                while (it.hasNext()) {
                    PrimitiveNode np = (PrimitiveNode)it.next();
                    this.changeListModel.addElement(np.describe());
                    this.changeNodeProtoList.add(np);
                }
                if (curTech != Generic.tech) {
                    this.changeListModel.addElement("Generic:Universal-Pin");
                    this.changeNodeProtoList.add(Generic.tech.universalPinNode);
                    this.changeListModel.addElement("Generic:Invisible-Pin");
                    this.changeNodeProtoList.add(Generic.tech.invisiblePinNode);
                    this.changeListModel.addElement("Generic:Unrouted-Pin");
                    this.changeNodeProtoList.add(Generic.tech.unroutedPinNode);
                }
                this.changeList.setSelectedIndex(0);
            }
        } else {
            Technology arcTech;
            PrimitiveArc ap;
            ArcInst ai = (ArcInst)geomToChange;
            PortProto pp1 = ai.getHead().getPortInst().getPortProto();
            PortProto pp2 = ai.getTail().getPortInst().getPortProto();
            Iterator it = curTech.getArcs();
            while (it.hasNext()) {
                ap = (PrimitiveArc)it.next();
                if (!this.changeNodesWithArcs.isSelected() && (!pp1.connectsTo(ap) || !pp2.connectsTo(ap))) continue;
                this.changeListModel.addElement(ap.describe());
            }
            if (curTech != Generic.tech) {
                it = Generic.tech.getArcs();
                while (it.hasNext()) {
                    ap = (PrimitiveArc)it.next();
                    if (!this.changeNodesWithArcs.isSelected() && (!pp1.connectsTo(ap) || !pp2.connectsTo(ap))) continue;
                    this.changeListModel.addElement(ap.describe());
                }
            }
            if ((arcTech = ai.getProto().getTechnology()) != curTech && arcTech != Generic.tech) {
                Iterator it2 = arcTech.getArcs();
                while (it2.hasNext()) {
                    PrimitiveArc ap2 = (PrimitiveArc)it2.next();
                    if (!this.changeNodesWithArcs.isSelected() && (!pp1.connectsTo(ap2) || !pp2.connectsTo(ap2))) continue;
                    this.changeListModel.addElement(ap2.describe());
                }
            }
            this.changeList.setSelectedIndex(0);
        }
    }

    private void doTheChange() {
        ChangeObject job = new ChangeObject(this);
    }

    protected String getLibSelected() {
        return (String)this.librariesPopup.getSelectedItem();
    }

    private void initComponents() {
        this.changeOption = new ButtonGroup();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.listPane = new JScrollPane();
        this.changeSelected = new JRadioButton();
        this.changeConnected = new JRadioButton();
        this.changeInCell = new JRadioButton();
        this.changeInLibrary = new JRadioButton();
        this.changeEverywhere = new JRadioButton();
        this.changeNodesWithArcs = new JCheckBox();
        this.showPrimitives = new JCheckBox();
        this.showCells = new JCheckBox();
        this.ignorePortNames = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.librariesPopup = new JComboBox();
        this.allowMissingPorts = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Change");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Change.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.listPane.setMinimumSize(new Dimension(150, 22));
        this.listPane.setPreferredSize(new Dimension(150, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.listPane, gridBagConstraints);
        this.changeSelected.setText("Change selected ones only");
        this.changeOption.add(this.changeSelected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.getContentPane().add((Component)this.changeSelected, gridBagConstraints);
        this.changeConnected.setText("Change all connected to this");
        this.changeOption.add(this.changeConnected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.changeConnected, gridBagConstraints);
        this.changeInCell.setText("Change all in this cell");
        this.changeOption.add(this.changeInCell);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.changeInCell, gridBagConstraints);
        this.changeInLibrary.setText("Change all in this library");
        this.changeOption.add(this.changeInLibrary);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.changeInLibrary, gridBagConstraints);
        this.changeEverywhere.setText("Change all in all libraries");
        this.changeOption.add(this.changeEverywhere);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 10, 4);
        this.getContentPane().add((Component)this.changeEverywhere, gridBagConstraints);
        this.changeNodesWithArcs.setText("Change nodes with arcs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 4, 4, 4);
        this.getContentPane().add((Component)this.changeNodesWithArcs, gridBagConstraints);
        this.showPrimitives.setText("Show primitives");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.showPrimitives, gridBagConstraints);
        this.showCells.setText("Show cells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.showCells, gridBagConstraints);
        this.ignorePortNames.setText("Ignore port names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ignorePortNames, gridBagConstraints);
        this.jLabel1.setText("Library:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.librariesPopup, gridBagConstraints);
        this.allowMissingPorts.setText("Allow missing ports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.allowMissingPorts, gridBagConstraints);
        this.pack();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        this.doTheChange();
        libSelected = (String)this.librariesPopup.getSelectedItem();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    static {
        libSelected = null;
        dummyName = Pattern.compile("(.*?)FROM(.*?)\\{(.*)");
    }

    private static class ChangeObject
    extends Job {
        Change dialog;
        NodeProto[] contactStack = new NodeProto[100];
        ArcProto[] contactStackArc = new ArcProto[100];

        protected ChangeObject(Change dialog) {
            super("Change type", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            if (geomToChange instanceof NodeInst) {
                NodeInst ni = (NodeInst)geomToChange;
                if (CircuitChanges.cantEdit(ni.getParent(), ni, true)) {
                    return false;
                }
                String line = this.dialog.getLibSelected();
                Library library = Library.findLibrary(line);
                if (library == null) {
                    return false;
                }
                int index = this.dialog.changeList.getSelectedIndex();
                NodeProto np = (NodeProto)this.dialog.changeNodeProtoList.get(index);
                if (np == null) {
                    return false;
                }
                NodeProto oldNType = ni.getProto();
                if (oldNType == np) {
                    System.out.println("Node already of type " + np.describe());
                    return false;
                }
                boolean ignorePortNames = this.dialog.ignorePortNames.isSelected();
                boolean allowMissingPorts = this.dialog.allowMissingPorts.isSelected();
                Highlight.clear();
                Highlight.finished();
                NodeInst onlyNewNi = CircuitChanges.replaceNodeInst(ni, np, ignorePortNames, allowMissingPorts);
                if (onlyNewNi == null) {
                    System.out.println(np.describe() + " does not fit in the place of " + oldNType.describe());
                    return false;
                }
                int total = 1;
                if (this.dialog.changeEverywhere.isSelected()) {
                    Iterator it = Library.getLibraries();
                    while (it.hasNext()) {
                        Library lib = (Library)it.next();
                        Iterator cIt = lib.getCells();
                        while (cIt.hasNext()) {
                            Cell cell = (Cell)cIt.next();
                            boolean found = true;
                            block2: while (found) {
                                found = false;
                                Iterator nIt = cell.getNodes();
                                while (nIt.hasNext()) {
                                    NodeInst newNi;
                                    NodeInst lNi = (NodeInst)nIt.next();
                                    if (lNi.getProto() != oldNType) continue;
                                    if (lNi.isIconOfParent()) {
                                        System.out.println("Example icon in cell " + cell.describe() + " not replaced");
                                        continue;
                                    }
                                    if (CircuitChanges.cantEdit(cell, lNi, true) || (newNi = CircuitChanges.replaceNodeInst(lNi, np, ignorePortNames, allowMissingPorts)) == null) continue;
                                    ++total;
                                    found = true;
                                    continue block2;
                                }
                            }
                        }
                    }
                    System.out.println("All " + total + " " + oldNType.describe() + " nodes in all libraries replaced with " + np.describe());
                } else if (this.dialog.changeInLibrary.isSelected()) {
                    Library lib = Library.getCurrent();
                    Iterator cIt = lib.getCells();
                    while (cIt.hasNext()) {
                        Cell cell = (Cell)cIt.next();
                        boolean found = true;
                        block5: while (found) {
                            found = false;
                            Iterator nIt = cell.getNodes();
                            while (nIt.hasNext()) {
                                NodeInst newNi;
                                NodeInst lNi = (NodeInst)nIt.next();
                                if (lNi.getProto() != oldNType || CircuitChanges.cantEdit(cell, lNi, true) || (newNi = CircuitChanges.replaceNodeInst(lNi, np, ignorePortNames, allowMissingPorts)) == null) continue;
                                ++total;
                                found = true;
                                continue block5;
                            }
                        }
                    }
                    System.out.println("All " + total + " " + oldNType.describe() + " nodes in library " + lib.getName() + " replaced with " + np.describe());
                } else if (this.dialog.changeInCell.isSelected()) {
                    Cell cell = WindowFrame.getCurrentCell();
                    boolean found = true;
                    block7: while (found) {
                        found = false;
                        Iterator nIt = cell.getNodes();
                        while (nIt.hasNext()) {
                            NodeInst newNi;
                            NodeInst lNi = (NodeInst)nIt.next();
                            if (lNi.getProto() != oldNType || CircuitChanges.cantEdit(cell, lNi, true) || (newNi = CircuitChanges.replaceNodeInst(lNi, np, ignorePortNames, allowMissingPorts)) == null) continue;
                            ++total;
                            found = true;
                            continue block7;
                        }
                    }
                    System.out.println("All " + total + " " + oldNType.describe() + " nodes in cell " + cell.describe() + " replaced with " + np.describe());
                } else if (this.dialog.changeConnected.isSelected()) {
                    NodeInst lNi;
                    Cell curCell = WindowFrame.getCurrentCell();
                    Netlist netlist = curCell.getUserNetlist();
                    ArrayList<NodeInst> others = new ArrayList<NodeInst>();
                    Iterator it = curCell.getNodes();
                    while (it.hasNext()) {
                        lNi = (NodeInst)it.next();
                        if (lNi.getProto() != oldNType || lNi == onlyNewNi) continue;
                        boolean found = false;
                        Iterator pIt = onlyNewNi.getPortInsts();
                        while (pIt.hasNext()) {
                            PortInst pi = (PortInst)pIt.next();
                            Iterator lPIt = lNi.getPortInsts();
                            while (lPIt.hasNext()) {
                                PortInst lPi = (PortInst)lPIt.next();
                                if (!netlist.sameNetwork(pi.getNodeInst(), pi.getPortProto(), lPi.getNodeInst(), lPi.getPortProto())) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                            break;
                        }
                        if (!found) continue;
                        others.add(lNi);
                    }
                    it = others.iterator();
                    while (it.hasNext()) {
                        NodeInst newNi;
                        lNi = (NodeInst)it.next();
                        if (CircuitChanges.cantEdit(curCell, lNi, true) || (newNi = CircuitChanges.replaceNodeInst(lNi, np, ignorePortNames, allowMissingPorts)) == null) continue;
                        ++total;
                    }
                    System.out.println("All " + total + " " + oldNType.describe() + " nodes connected to this replaced with " + np.describe());
                } else {
                    System.out.println("Node " + oldNType.describe() + " replaced with " + np.describe());
                }
            } else {
                ArcInst ai = (ArcInst)geomToChange;
                if (CircuitChanges.cantEdit(ai.getParent(), null, true)) {
                    return false;
                }
                String line = (String)this.dialog.changeList.getSelectedValue();
                ArcProto ap = ArcProto.findArcProto(line);
                if (ap == null) {
                    System.out.println("Nothing called '" + line + "'");
                    return false;
                }
                ArcProto oldAType = ai.getProto();
                if (oldAType == ap) {
                    System.out.println("Arc already of type " + ap.describe());
                    return false;
                }
                if (this.dialog.changeNodesWithArcs.isSelected()) {
                    if (this.dialog.changeInLibrary.isSelected()) {
                        Iterator it = Library.getCurrent().getCells();
                        while (it.hasNext()) {
                            Cell cell = (Cell)it.next();
                            this.replaceAllArcs(cell, ai, ap, false, true);
                        }
                    } else {
                        this.replaceAllArcs(ai.getParent(), ai, ap, this.dialog.changeConnected.isSelected(), this.dialog.changeInCell.isSelected());
                    }
                    return true;
                }
                Highlight.clear();
                Highlight.finished();
                ArcInst onlyNewAi = ai.replace(ap);
                if (onlyNewAi == null) {
                    System.out.println(ap.describe() + " does not fit in the place of " + oldAType.describe());
                    return false;
                }
                int total = 1;
                if (this.dialog.changeEverywhere.isSelected()) {
                    Iterator it = Library.getLibraries();
                    while (it.hasNext()) {
                        Library lib = (Library)it.next();
                        Iterator cIt = lib.getCells();
                        while (cIt.hasNext()) {
                            Cell cell = (Cell)cIt.next();
                            boolean found = true;
                            block16: while (found) {
                                found = false;
                                Iterator nIt = cell.getArcs();
                                while (nIt.hasNext()) {
                                    ArcInst newAi;
                                    ArcInst lAi = (ArcInst)nIt.next();
                                    if (lAi.getProto() != oldAType || CircuitChanges.cantEdit(cell, null, true) || (newAi = lAi.replace(ap)) == null) continue;
                                    ++total;
                                    found = true;
                                    continue block16;
                                }
                            }
                        }
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs in the library replaced with " + ap.describe());
                } else if (this.dialog.changeInLibrary.isSelected()) {
                    Library lib = Library.getCurrent();
                    Iterator cIt = lib.getCells();
                    while (cIt.hasNext()) {
                        Cell cell = (Cell)cIt.next();
                        boolean found = true;
                        block19: while (found) {
                            found = false;
                            Iterator nIt = cell.getArcs();
                            while (nIt.hasNext()) {
                                ArcInst newAi;
                                ArcInst lAi = (ArcInst)nIt.next();
                                if (lAi.getProto() != oldAType || CircuitChanges.cantEdit(cell, null, true) || (newAi = lAi.replace(ap)) == null) continue;
                                ++total;
                                found = true;
                                continue block19;
                            }
                        }
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs in library " + lib.getName() + " replaced with " + ap.describe());
                } else if (this.dialog.changeInCell.isSelected()) {
                    Cell cell = WindowFrame.getCurrentCell();
                    boolean found = true;
                    block21: while (found) {
                        found = false;
                        Iterator nIt = cell.getArcs();
                        while (nIt.hasNext()) {
                            ArcInst newAi;
                            ArcInst lAi = (ArcInst)nIt.next();
                            if (lAi.getProto() != oldAType || CircuitChanges.cantEdit(cell, null, true) || (newAi = lAi.replace(ap)) == null) continue;
                            ++total;
                            found = true;
                            continue block21;
                        }
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs in cell " + cell.describe() + " replaced with " + ap.describe());
                } else if (this.dialog.changeConnected.isSelected()) {
                    ArcInst lAi;
                    ArrayList<ArcInst> others = new ArrayList<ArcInst>();
                    Cell cell = WindowFrame.getCurrentCell();
                    Netlist netlist = cell.getUserNetlist();
                    Iterator it = cell.getArcs();
                    while (it.hasNext()) {
                        lAi = (ArcInst)it.next();
                        if (lAi == onlyNewAi || !netlist.sameNetwork(onlyNewAi, lAi)) continue;
                        others.add(lAi);
                    }
                    it = others.iterator();
                    while (it.hasNext()) {
                        lAi = (ArcInst)it.next();
                        ArcInst newAi = lAi.replace(ap);
                        if (newAi == null) continue;
                        ++total;
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs connected to this replaced with " + ap.describe());
                } else {
                    System.out.println("Arc " + oldAType.describe() + " replaced with " + ap.describe());
                }
            }
            return true;
        }

        private void replaceAllArcs(Cell cell, ArcInst oldAi, ArcProto ap, boolean connected, boolean thiscell) {
            NodeInst ni;
            ArcInst ai;
            ArcInst ai2;
            NodeInst ni2;
            ArcInst ai3;
            ArcInst ai4;
            NodeInst ni3;
            List highs = Highlight.getHighlighted(true, true);
            FlagSet marked = Geometric.getFlagSet(1);
            Iterator it = cell.getNodes();
            while (it.hasNext()) {
                ni3 = (NodeInst)it.next();
                ni3.clearBit(marked);
                ni3.setTempObj(null);
            }
            it = cell.getArcs();
            while (it.hasNext()) {
                ai4 = (ArcInst)it.next();
                ai4.clearBit(marked);
            }
            it = highs.iterator();
            while (it.hasNext()) {
                Geometric geom = (Geometric)it.next();
                if (!(geom instanceof ArcInst) || (ai3 = (ArcInst)geom).getProto() != oldAi.getProto()) continue;
                ai3.setBit(marked);
            }
            if (connected) {
                Netlist netlist = cell.getUserNetlist();
                Iterator it2 = cell.getArcs();
                while (it2.hasNext()) {
                    ai3 = (ArcInst)it2.next();
                    if (ai3.getProto() != oldAi.getProto() || !netlist.sameNetwork(ai3, oldAi)) continue;
                    ai3.setBit(marked);
                }
            }
            if (thiscell) {
                it = cell.getArcs();
                while (it.hasNext()) {
                    ai4 = (ArcInst)it.next();
                    if (ai4.getProto() != oldAi.getProto()) continue;
                    ai4.setBit(marked);
                }
            }
            it = cell.getNodes();
            while (it.hasNext()) {
                ni3 = (NodeInst)it.next();
                if (ni3.getProto() instanceof Cell || ni3.getNumExports() != 0 || ni3.getFunction() != NodeProto.Function.PIN) continue;
                boolean allArcs = true;
                Iterator cIt = ni3.getConnections();
                while (cIt.hasNext()) {
                    Connection con = (Connection)cIt.next();
                    if (con.getArc().isBit(marked)) continue;
                    allArcs = false;
                    break;
                }
                if (!allArcs) continue;
                ni3.setBit(marked);
            }
            PrimitiveNode pin = ((PrimitiveArc)ap).findOverridablePinProto();
            double xS = pin.getDefWidth();
            double yS = pin.getDefHeight();
            ArrayList<NodeInst> dupPins = new ArrayList<NodeInst>();
            Iterator it3 = cell.getNodes();
            while (it3.hasNext()) {
                ni2 = (NodeInst)it3.next();
                if (!ni2.isBit(marked)) continue;
                dupPins.add(ni2);
            }
            it3 = dupPins.iterator();
            while (it3.hasNext()) {
                ni2 = (NodeInst)it3.next();
                NodeInst newNi = NodeInst.makeInstance(pin, ni2.getAnchorCenter(), xS, yS, 0, cell, null);
                if (newNi == null) {
                    return;
                }
                newNi.clearBit(marked);
                ni2.setTempObj(newNi);
            }
            ArrayList<ArcInst> dupArcs = new ArrayList<ArcInst>();
            Iterator it4 = cell.getArcs();
            while (it4.hasNext()) {
                ai2 = (ArcInst)it4.next();
                if (!ai2.isBit(marked)) continue;
                dupArcs.add(ai2);
            }
            it4 = dupArcs.iterator();
            while (it4.hasNext()) {
                ArcInst newAi;
                ai2 = (ArcInst)it4.next();
                NodeInst ni0 = ai2.getHead().getPortInst().getNodeInst();
                PortInst pi0 = null;
                if (ni0.getTempObj() != null) {
                    ni0 = (NodeInst)ni0.getTempObj();
                    pi0 = ni0.getOnlyPortInst();
                } else {
                    pi0 = this.makeContactStack(ai2, 0, ap);
                    if (pi0 == null) {
                        return;
                    }
                }
                NodeInst ni1 = ai2.getTail().getPortInst().getNodeInst();
                PortInst pi1 = null;
                if (ni1.getTempObj() != null) {
                    ni1 = (NodeInst)ni1.getTempObj();
                    pi1 = ni1.getOnlyPortInst();
                } else {
                    pi1 = this.makeContactStack(ai2, 1, ap);
                    if (pi1 == null) {
                        return;
                    }
                }
                double wid = ap.getDefaultWidth();
                if (ai2.getWidth() > wid) {
                    wid = ai2.getWidth();
                }
                if ((newAi = ArcInst.makeInstance(ap, wid, pi0, ai2.getHead().getLocation(), pi1, ai2.getTail().getLocation(), null)) == null) {
                    return;
                }
                ai2.copyVars(newAi);
                newAi.clearBit(marked);
            }
            ArrayList<ArcInst> killArcs = new ArrayList<ArcInst>();
            Iterator it5 = cell.getArcs();
            while (it5.hasNext()) {
                ai = (ArcInst)it5.next();
                if (!ai.isBit(marked)) continue;
                killArcs.add(ai);
            }
            it5 = killArcs.iterator();
            while (it5.hasNext()) {
                ai = (ArcInst)it5.next();
                ai.kill();
            }
            ArrayList<NodeInst> killNodes = new ArrayList<NodeInst>();
            Iterator it6 = cell.getNodes();
            while (it6.hasNext()) {
                ni = (NodeInst)it6.next();
                if (!ni.isBit(marked)) continue;
                killNodes.add(ni);
            }
            it6 = killNodes.iterator();
            while (it6.hasNext()) {
                ni = (NodeInst)it6.next();
                ni.kill();
            }
            marked.freeFlagSet();
        }

        private PortInst makeContactStack(ArcInst ai, int end, ArcProto ap) {
            NodeInst lastNi = ai.getConnection(end).getPortInst().getNodeInst();
            PortProto lastPp = ai.getConnection(end).getPortInst().getPortProto();
            FlagSet marked = NodeProto.getFlagSet(1);
            Iterator it = ap.getTechnology().getNodes();
            while (it.hasNext()) {
                PrimitiveNode np = (PrimitiveNode)it.next();
                np.clearBit(marked);
            }
            int depth = this.findPathToArc(lastPp, ap, 0, marked);
            if (depth < 0) {
                return null;
            }
            Cell cell = ai.getParent();
            PortInst retPi = lastNi.findPortInstFromProto(lastPp);
            Point2D center = ai.getConnection(end).getLocation();
            for (int i = 0; i < depth; ++i) {
                double yS;
                double xS = this.contactStack[i].getDefWidth();
                NodeInst newNi = NodeInst.makeInstance(this.contactStack[i], center, xS, yS = this.contactStack[i].getDefHeight(), 0, cell, null);
                if (newNi == null) {
                    return null;
                }
                PortInst thisPi = newNi.findPortInstFromProto(this.contactStack[i].getPort(0));
                ArcProto typ = this.contactStackArc[i];
                double wid = typ.getDefaultWidth();
                ArcInst newAi = ArcInst.makeInstance(typ, wid, thisPi, retPi, null);
                retPi = thisPi;
                if (newAi != null) continue;
                return null;
            }
            marked.freeFlagSet();
            return retPi;
        }

        int findPathToArc(PortProto pp, ArcProto ap, int depth, FlagSet marked) {
            if (pp.connectsTo(ap)) {
                return depth;
            }
            NodeProto bestNp = null;
            ArcProto bestAp = null;
            int bestDepth = 0;
            Technology tech = ap.getTechnology();
            Iterator it = tech.getNodes();
            while (it.hasNext()) {
                NodeProto.Function fun;
                PrimitiveNode nextNp = (PrimitiveNode)it.next();
                if (nextNp.isBit(marked) || (fun = nextNp.getFunction()) != NodeProto.Function.CONTACT) continue;
                PortProto nextPp = nextNp.getPort(0);
                ArcProto[] connections = nextPp.getBasePort().getConnections();
                ArcProto found = null;
                for (int i = 0; i < connections.length; ++i) {
                    ArcProto thisAp = connections[i];
                    if (thisAp.getTechnology() != tech || !pp.connectsTo(thisAp)) continue;
                    found = thisAp;
                    break;
                }
                if (found == null) continue;
                this.contactStack[depth] = nextNp;
                nextNp.setBit(marked);
                int newDepth = this.findPathToArc(nextPp, ap, depth + 1, marked);
                nextNp.clearBit(marked);
                if (newDepth < 0 || bestNp != null && newDepth >= bestDepth) continue;
                bestDepth = newDepth;
                bestNp = nextNp;
                bestAp = found;
            }
            if (bestNp != null) {
                this.contactStack[depth] = bestNp;
                this.contactStackArc[depth] = bestAp;
                bestNp.setBit(marked);
                int newDepth = this.findPathToArc(bestNp.getPort(0), ap, depth + 1, marked);
                bestNp.clearBit(marked);
                return newDepth;
            }
            return -1;
        }
    }
}

