/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;

public class ErrorLogger
implements ActionListener {
    private static final int ERRORTYPEGEOM = 1;
    private static final int ERRORTYPEEXPORT = 2;
    private static final int ERRORTYPELINE = 3;
    private static final int ERRORTYPETHICKLINE = 4;
    private static final int ERRORTYPEPOINT = 5;
    private static ErrorLogger currentLogger;
    private static List allLoggers;
    private static boolean alreadyExplained;
    private int trueNumErrors;
    private int errorLimit;
    private List allErrors;
    private int currentErrorNumber;
    private boolean limitExceeded;
    private String errorSystem;
    private boolean terminated;
    private boolean persistent;
    private static String errorNode;

    private ErrorLogger() {
    }

    public static synchronized ErrorLogger newInstance(String system) {
        return ErrorLogger.newInstance(system, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorLogger newInstance(String system, boolean persistent) {
        ErrorLogger logger = new ErrorLogger();
        logger.allErrors = new ArrayList();
        logger.trueNumErrors = 0;
        logger.limitExceeded = false;
        logger.currentErrorNumber = -1;
        logger.errorSystem = system;
        logger.errorLimit = User.getErrorLimit();
        logger.terminated = false;
        logger.persistent = persistent;
        List list = allLoggers;
        synchronized (list) {
            if (currentLogger == null) {
                currentLogger = logger;
            }
            allLoggers.add(logger);
        }
        return logger;
    }

    public synchronized ErrorLog logError(String message, Cell cell, int sortKey) {
        if (this.terminated && !this.persistent) {
            System.out.println("WARNING: " + this.errorSystem + " already terminated, should not log new error");
        }
        ++this.trueNumErrors;
        if (this.errorLimit > 0 && this.numErrors() >= this.errorLimit) {
            if (!this.limitExceeded) {
                System.out.println("WARNING: more than " + this.errorLimit + " errors found, ignoring the rest");
                this.limitExceeded = true;
            }
            return null;
        }
        ErrorLog el = new ErrorLog(message, sortKey);
        el.message = message;
        el.sortKey = sortKey;
        el.logCell = cell;
        el.highlights = new ArrayList();
        this.allErrors.add(el);
        this.currentErrorNumber = this.allErrors.size() - 1;
        if (this.persistent) {
            WindowFrame.wantToRedoErrorTree();
        }
        return el;
    }

    public synchronized void clearAllErrors() {
        this.allErrors.clear();
        this.trueNumErrors = 0;
        this.limitExceeded = false;
        this.currentErrorNumber = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorLogger getCurrent() {
        List list = allLoggers;
        synchronized (list) {
            if (currentLogger == null) {
                return ErrorLogger.newInstance("Unknown");
            }
            return currentLogger;
        }
    }

    public synchronized void clearErrors(Cell cell) {
        ArrayList<ErrorLog> trimmedErrors = new ArrayList<ErrorLog>();
        Iterator it = this.allErrors.iterator();
        while (it.hasNext()) {
            ErrorLog log = (ErrorLog)it.next();
            if (log.logCell == cell) continue;
            trimmedErrors.add(log);
        }
        this.allErrors = trimmedErrors;
        this.trueNumErrors = this.allErrors.size();
        this.currentErrorNumber = this.allErrors.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete() {
        if (this.persistent) {
            this.allErrors.clear();
            this.trueNumErrors = 0;
            this.currentErrorNumber = -1;
            WindowFrame.wantToRedoErrorTree();
            return;
        }
        List list = allLoggers;
        synchronized (list) {
            allLoggers.remove(this);
            if (currentLogger == this) {
                currentLogger = allLoggers.size() > 0 ? (ErrorLogger)allLoggers.get(0) : null;
            }
        }
        WindowFrame.wantToRedoErrorTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String describe() {
        List list = allLoggers;
        synchronized (list) {
            if (currentLogger == this) {
                return this.errorSystem + " [Current]";
            }
        }
        return this.errorSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void termLogging(boolean explain) {
        int errs = 0;
        Iterator it = this.allErrors.iterator();
        while (it.hasNext()) {
            ErrorLog el = (ErrorLog)it.next();
            el.index = ++errs;
        }
        if (errs == 0) {
            this.delete();
            return;
        }
        if (errs > 0 && explain && !alreadyExplained) {
            alreadyExplained = true;
            System.out.println("Type > and < to step through errors, or open the ERRORS view in the explorer");
        }
        WindowFrame.wantToRedoErrorTree();
        List list = allLoggers;
        synchronized (list) {
            currentLogger = this;
        }
        this.terminated = true;
    }

    public synchronized void sortErrors() {
        Collections.sort(this.allErrors, new ErrorLogOrder());
    }

    public synchronized int numErrors() {
        return this.trueNumErrors;
    }

    public static String reportNextError() {
        return ErrorLogger.reportNextError(true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reportNextError(boolean showhigh, Geometric[] gPair) {
        ErrorLogger logger;
        List list = allLoggers;
        synchronized (list) {
            if (currentLogger == null) {
                return "No errors to report";
            }
            logger = currentLogger;
        }
        return logger.reportNextError_(showhigh, gPair);
    }

    private synchronized String reportNextError_(boolean showHigh, Geometric[] gPair) {
        if (this.currentErrorNumber < this.allErrors.size() - 1) {
            ++this.currentErrorNumber;
        } else {
            if (this.allErrors.size() <= 0) {
                return "No " + this.errorSystem + " errors";
            }
            this.currentErrorNumber = 0;
        }
        return this.reportError(this.currentErrorNumber, showHigh, gPair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reportPrevError() {
        ErrorLogger logger;
        List list = allLoggers;
        synchronized (list) {
            if (currentLogger == null) {
                return "No errors to report";
            }
            logger = currentLogger;
        }
        return logger.reportPrevError_();
    }

    private synchronized String reportPrevError_() {
        if (this.currentErrorNumber > 0) {
            --this.currentErrorNumber;
        } else {
            if (this.allErrors.size() <= 0) {
                return "No " + this.errorSystem + " errors";
            }
            this.currentErrorNumber = this.allErrors.size() - 1;
        }
        return this.reportError(this.currentErrorNumber, true, null);
    }

    private synchronized String reportError(int errorNumber, boolean showHigh, Geometric[] gPair) {
        if (errorNumber < 0 || errorNumber >= this.allErrors.size()) {
            return this.errorSystem + ": no such error " + (errorNumber + 1) + ", only " + this.numErrors() + " errors.";
        }
        ErrorLog el = (ErrorLog)this.allErrors.get(errorNumber);
        String message = el.reportError(showHigh, gPair);
        return this.errorSystem + " error " + (errorNumber + 1) + " of " + this.allErrors.size() + ": " + message;
    }

    public synchronized int getNumErrors() {
        return this.allErrors.size();
    }

    public synchronized Iterator getErrors() {
        ArrayList copy = new ArrayList();
        Iterator it = this.allErrors.iterator();
        while (it.hasNext()) {
            copy.add(it.next());
        }
        return copy.iterator();
    }

    public synchronized void deleteError(ErrorLog error) {
        if (!this.allErrors.contains(error)) {
            System.out.println(this.errorSystem + ": Does not contain error to delete");
        }
        this.allErrors.remove(error);
        --this.trueNumErrors;
        if (this.currentErrorNumber >= this.allErrors.size()) {
            this.currentErrorNumber = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultMutableTreeNode getExplorerTree() {
        DefaultMutableTreeNode explorerTree = new DefaultMutableTreeNode(errorNode);
        ArrayList loggersCopy = new ArrayList();
        List list = allLoggers;
        synchronized (list) {
            loggersCopy.addAll(allLoggers);
        }
        Iterator eit = loggersCopy.iterator();
        while (eit.hasNext()) {
            ErrorLogger logger = (ErrorLogger)eit.next();
            if (logger.getNumErrors() == 0) continue;
            DefaultMutableTreeNode loggerNode = new DefaultMutableTreeNode(logger);
            Iterator it = logger.getErrors();
            while (it.hasNext()) {
                ErrorLog el = (ErrorLog)it.next();
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(el);
                loggerNode.add(node);
            }
            explorerTree.add(loggerNode);
        }
        return explorerTree;
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu p = new JPopupMenu();
        JMenuItem m = new JMenuItem("Delete");
        m.addActionListener(this);
        p.add(m);
        m = new JMenuItem("Set Current");
        m.addActionListener(this);
        p.add(m);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem m = (JMenuItem)e.getSource();
            if (m.getText().equals("Delete")) {
                this.delete();
            }
            if (m.getText().equals("Set Current")) {
                List list = allLoggers;
                synchronized (list) {
                    currentLogger = this;
                }
                WindowFrame.wantToRedoErrorTree();
            }
        }
    }

    static {
        allLoggers = new ArrayList();
        alreadyExplained = false;
        errorNode = "ERRORS";
    }

    private static class ErrorLogOrder
    implements Comparator {
        private ErrorLogOrder() {
        }

        public int compare(Object o1, Object o2) {
            ErrorLog el1 = (ErrorLog)o1;
            ErrorLog el2 = (ErrorLog)o2;
            return el1.sortKey - el2.sortKey;
        }
    }

    public static class ErrorLog {
        private String message;
        private int sortKey;
        private int index;
        private Cell logCell;
        private List highlights;

        private ErrorLog(String message, int sortKey) {
            this.message = message;
            this.sortKey = sortKey;
            this.index = 0;
            this.highlights = new ArrayList();
        }

        public void addGeom(Geometric geom, boolean showit, Cell cell, VarContext context) {
            ErrorHighlight eh = new ErrorHighlight();
            eh.type = 1;
            eh.geom = geom;
            eh.showgeom = showit;
            eh.cell = cell;
            eh.context = context;
            this.highlights.add(eh);
        }

        public void addExport(Export pp, boolean showit, Cell cell, VarContext context) {
            ErrorHighlight eh = new ErrorHighlight();
            eh.type = 2;
            eh.pp = pp;
            eh.showgeom = showit;
            eh.cell = cell;
            eh.context = context;
            this.highlights.add(eh);
        }

        public void addLine(double x1, double y1, double x2, double y2, Cell cell) {
            ErrorHighlight eh = new ErrorHighlight();
            eh.type = 3;
            eh.x1 = x1;
            eh.y1 = y1;
            eh.x2 = x2;
            eh.y2 = y2;
            eh.cell = cell;
            eh.context = null;
            this.highlights.add(eh);
        }

        public void addPoly(Poly poly, boolean thick, Cell cell) {
            Point2D[] points = poly.getPoints();
            Point2D.Double center = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
            for (int i = 0; i < points.length; ++i) {
                int prev = i - 1;
                if (i == 0) {
                    prev = points.length - 1;
                }
                ErrorHighlight eh = new ErrorHighlight();
                eh.type = thick ? 4 : 3;
                eh.x1 = points[prev].getX();
                eh.y1 = points[prev].getY();
                eh.x2 = points[i].getX();
                eh.y2 = points[i].getY();
                eh.cX = ((Point2D)center).getX();
                eh.cY = ((Point2D)center).getY();
                eh.cell = cell;
                eh.context = null;
                this.highlights.add(eh);
            }
        }

        public void addPoint(double x, double y, Cell cell) {
            ErrorHighlight eh = new ErrorHighlight();
            eh.type = 5;
            eh.x1 = x;
            eh.y1 = y;
            eh.cell = cell;
            eh.context = null;
            this.highlights.add(eh);
        }

        public int getNumGeoms() {
            int total = 0;
            Iterator it = this.highlights.iterator();
            while (it.hasNext()) {
                ErrorHighlight eh = (ErrorHighlight)it.next();
                if (eh.type != 1) continue;
                ++total;
            }
            return total;
        }

        public ErrorHighlight getErrorGeom(int index) {
            int total = 0;
            Iterator it = this.highlights.iterator();
            while (it.hasNext()) {
                ErrorHighlight eh = (ErrorHighlight)it.next();
                if (eh.type != 1) continue;
                if (total == index) {
                    return eh;
                }
                ++total;
            }
            return null;
        }

        public String describeError() {
            return this.message;
        }

        public String reportError(boolean showhigh, Geometric[] gPair) {
            if (gPair != null) {
                Geometric geom1 = null;
                Geometric geom2 = null;
                Iterator it = this.highlights.iterator();
                while (it.hasNext()) {
                    ErrorHighlight eh = (ErrorHighlight)it.next();
                    if (eh.type != 1) continue;
                    if (geom1 == null) {
                        geom1 = eh.geom;
                        continue;
                    }
                    if (geom2 != null) continue;
                    geom2 = eh.geom;
                }
                if (geom1 != null) {
                    gPair[0] = geom1;
                }
                if (geom2 != null) {
                    gPair[1] = geom2;
                }
            }
            if (showhigh) {
                Highlight.clear();
                Iterator it = this.highlights.iterator();
                while (it.hasNext()) {
                    ErrorHighlight eh = (ErrorHighlight)it.next();
                    Cell cell = eh.cell;
                    if (cell != null) {
                        if (!cell.isLinked()) {
                            return "(cell deleted): " + this.message;
                        }
                        boolean found = false;
                        Iterator it2 = WindowFrame.getWindows();
                        while (it2.hasNext()) {
                            EditWindow wnd;
                            WindowFrame wf = (WindowFrame)it2.next();
                            WindowContent content = wf.getContent();
                            if (!(content instanceof EditWindow) || (wnd = (EditWindow)content).getCell() != cell || (eh.context == null || !eh.context.equals(wnd.getVarContext())) && eh.context != null) continue;
                            wf.getFrame().toFront();
                            found = true;
                            break;
                        }
                        if (!found) {
                            WindowFrame wf = WindowFrame.createEditWindow(cell);
                            EditWindow wnd = (EditWindow)wf.getContent();
                            wnd.setCell(eh.cell, eh.context);
                        }
                    }
                    switch (eh.type) {
                        case 1: {
                            if (!eh.showgeom) break;
                            Highlight.addElectricObject(eh.geom, cell);
                            break;
                        }
                        case 2: {
                            Highlight.addText(eh.pp, cell, null, null);
                            break;
                        }
                        case 3: {
                            Highlight.addLine(new Point2D.Double(eh.x1, eh.y1), new Point2D.Double(eh.x2, eh.y2), cell);
                            break;
                        }
                        case 4: {
                            Highlight.addThickLine(new Point2D.Double(eh.x1, eh.y1), new Point2D.Double(eh.x2, eh.y2), new Point2D.Double(eh.cX, eh.cY), cell);
                            break;
                        }
                        case 5: {
                            double consize = 5.0;
                            Highlight.addLine(new Point2D.Double(eh.x1 - consize, eh.y1 - consize), new Point2D.Double(eh.x1 + consize, eh.y1 + consize), cell);
                            Highlight.addLine(new Point2D.Double(eh.x1 - consize, eh.y1 + consize), new Point2D.Double(eh.x1 + consize, eh.y1 - consize), cell);
                        }
                    }
                }
                Highlight.finished();
            }
            return this.message;
        }
    }

    private static class ErrorHighlight {
        int type;
        Geometric geom;
        PortProto pp;
        boolean showgeom;
        double x1;
        double y1;
        double x2;
        double y2;
        double cX;
        double cY;
        Cell cell;
        VarContext context;

        private ErrorHighlight() {
        }

        public String describe() {
            String msg = this.geom instanceof NodeInst ? "Node " + this.geom.describe() : "Arc " + this.geom.describe();
            msg = msg + " in " + this.context.getInstPath(".");
            return msg;
        }
    }
}

