/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.NCC;
import com.sun.electric.tool.ncc.NccBottomUp;
import com.sun.electric.tool.ncc.NccEngine;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.user.User;
import java.util.List;

public class NccJob
extends Job {
    private final int numWindows;
    private final boolean bottomUpFlat;
    private final boolean hierarchical;

    private CellContext[] getSchemLayFromCurrentWindow() {
        CellContext curCellCtxt = NccUtils.getCurrentCellContext();
        if (curCellCtxt == null) {
            System.out.println("Please open the Cell you wish to NCC");
            return null;
        }
        Cell[] schLay = NccUtils.findSchematicAndLayout(curCellCtxt.cell);
        if (schLay == null) {
            System.out.println("current Cell doesn't have both schematic and layout views");
            return null;
        }
        CellContext[] cc = new CellContext[]{new CellContext(schLay[0], curCellCtxt.context), new CellContext(schLay[1], curCellCtxt.context)};
        return cc;
    }

    private boolean isSchemOrLay(CellContext cc) {
        boolean ok;
        Cell c = cc.cell;
        View v = c.getView();
        boolean bl = ok = v == View.SCHEMATIC || v == View.LAYOUT;
        if (!ok) {
            System.out.println("Cell: " + NccUtils.fullName(c) + " isn't schematic or layout");
        }
        return ok;
    }

    private CellContext[] getTwoCellsFromTwoWindows() {
        List cellCtxts = NccUtils.getCellContextsFromWindows();
        if (cellCtxts.size() < 2) {
            System.out.println("Two Cells aren't open in two windows");
            return null;
        }
        CellContext[] cellContexts = new CellContext[]{(CellContext)cellCtxts.get(0), (CellContext)cellCtxts.get(1)};
        if (!this.isSchemOrLay(cellContexts[0]) || !this.isSchemOrLay(cellContexts[1])) {
            return null;
        }
        return cellContexts;
    }

    private CellContext[] getCellsFromWindows(int numWindows) {
        if (numWindows == 2) {
            return this.getTwoCellsFromTwoWindows();
        }
        return this.getSchemLayFromCurrentWindow();
    }

    private NccOptions getOptionsFromNccConfigDialog() {
        NccOptions options = new NccOptions();
        options.verbose = false;
        options.checkSizes = NCC.getCheckSizes();
        options.relativeSizeTolerance = NCC.getRelativeSizeTolerance();
        options.absoluteSizeTolerance = NCC.getAbsoluteSizeTolerance();
        options.haltAfterFirstMismatch = NCC.getHaltAfterFirstMismatch();
        return options;
    }

    private boolean nccTwoCells(CellContext[] cellCtxts, NccOptions options) {
        Cell cell0 = cellCtxts[0].cell;
        VarContext context0 = cellCtxts[0].context;
        Cell cell1 = cellCtxts[1].cell;
        VarContext context1 = cellCtxts[0].context;
        System.out.println("Comparing: " + NccUtils.fullName(cell0) + " with: " + NccUtils.fullName(cell1));
        return NccEngine.compare(cell0, context0, cell1, context1, null, options);
    }

    public boolean doIt() {
        System.out.println("Ncc starting");
        NccOptions options = this.getOptionsFromNccConfigDialog();
        CellContext[] cellCtxts = this.getCellsFromWindows(this.numWindows);
        boolean ok = cellCtxts == null ? false : (this.bottomUpFlat || this.hierarchical ? NccBottomUp.compare(cellCtxts[0].cell, cellCtxts[1].cell, this.hierarchical, options) : this.nccTwoCells(cellCtxts, options));
        if (ok) {
            System.out.print("Ncc done: no mismatches");
        } else {
            System.out.print("Ncc done: comparison failed");
        }
        return ok;
    }

    public NccJob(int numWindows, boolean bottomUpFlat, boolean hierarchical) {
        super("Run NCC", User.tool, Job.Type.CHANGE, null, null, Job.Priority.ANALYSIS);
        LayoutLib.error(numWindows != 1 && numWindows != 2, "numWindows must be 1 or 2");
        LayoutLib.error(bottomUpFlat && hierarchical, "I can't do bottomUpFlat or hierarchical simultaneously");
        this.numWindows = numWindows;
        this.bottomUpFlat = bottomUpFlat;
        this.hierarchical = hierarchical;
        this.startJob();
    }
}

