/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class LibDirs {
    private static String libDirsFile = "LIBDIRS";
    private static ArrayList dirs = new ArrayList();
    private static ArrayList libDirsFiles = new ArrayList();

    LibDirs() {
    }

    public static Iterator getLibDirs() {
        return dirs.iterator();
    }

    public static boolean readLibDirs() {
        boolean error = false;
        dirs.clear();
        libDirsFiles.clear();
        if (LibDirs.parseFile(libDirsFile)) {
            error = true;
        }
        return error;
    }

    private static boolean parseFile(String fileName) {
        if (fileName == null) {
            return true;
        }
        BufferedReader in = null;
        File file = new File(fileName);
        try {
            FileReader fr = new FileReader(file);
            in = new BufferedReader(fr);
        }
        catch (FileNotFoundException e) {
            return true;
        }
        libDirsFiles.add(file.getAbsolutePath());
        boolean error = false;
        int lineNumber = 0;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if (!LibDirs.parseLine(line)) continue;
                System.out.println("Parse error: " + fileName + ":" + lineNumber);
                error = true;
                ++lineNumber;
            }
        }
        catch (IOException e) {
            System.out.println("IOError " + e.getMessage());
        }
        return error;
    }

    private static boolean parseLine(String line) {
        String[] words = (line = line.trim()).split("\\s+");
        if (words.length <= 0) {
            return false;
        }
        if (words[0].equals("*")) {
            return false;
        }
        if (words[0].equals("include")) {
            if (words.length != 2) {
                return true;
            }
            File f = new File(words[1]);
            if (libDirsFiles.contains(f.getAbsolutePath())) {
                return true;
            }
            return LibDirs.parseFile(words[1]);
        }
        dirs.add(words[0]);
        return false;
    }
}

