/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class Schematic {
    private static FlagSet cellsCheckedBit;
    private static ErrorLogger errorLogger;

    public static void doCheck(Cell cell) {
        cellsCheckedBit = NodeProto.getFlagSet(1);
        cellsCheckedBit.clearOnAllCells();
        errorLogger = ErrorLogger.newInstance("Schematic DRC");
        Schematic.checkSchematicCellRecursively(cell);
        errorLogger.termLogging(true);
        cellsCheckedBit.freeFlagSet();
    }

    private static void checkSchematicCellRecursively(Cell cell) {
        cell.setBit(cellsCheckedBit);
        if (cell.getView() != View.SCHEMATIC && cell.getTechnology() != Schematics.tech) {
            return;
        }
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (!(np instanceof Cell)) continue;
            Cell subCell = (Cell)np;
            Cell contentsCell = subCell.contentsView();
            if (contentsCell == null) {
                contentsCell = subCell;
            }
            if (contentsCell.isBit(cellsCheckedBit) || ni.isIconOfParent()) continue;
            Schematic.checkSchematicCellRecursively(contentsCell);
        }
        System.out.println("Checking schematic cell " + cell.describe());
        Schematic.checkSchematicCell(cell, false);
    }

    private static void checkSchematicCell(Cell cell, boolean justThis) {
        if (justThis) {
            errorLogger = ErrorLogger.newInstance("Schematic DRC");
        }
        int initialErrorCount = errorLogger.numErrors();
        Netlist netlist = Network.getUserNetlist(cell);
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (ni.getProto() instanceof PrimitiveNode && ni.getProto().getTechnology() == Generic.tech) continue;
            Schematic.schematicDoCheck(netlist, ni);
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            Schematic.schematicDoCheck(netlist, ai);
        }
        int errorCount = errorLogger.numErrors();
        int thisErrors = errorCount - initialErrorCount;
        String indent = "   ";
        if (justThis) {
            indent = "";
        }
        if (thisErrors == 0) {
            System.out.println(indent + "No errors found");
        } else {
            System.out.println(indent + thisErrors + " errors found");
        }
        if (justThis) {
            errorLogger.termLogging(true);
        }
    }

    private static void schematicDoCheck(Netlist netlist, Geometric geom) {
        Cell cell = geom.getParent();
        if (geom instanceof NodeInst) {
            Iterator it;
            ErrorLogger.ErrorLog err;
            Iterator it2;
            boolean found;
            NodeInst ni = (NodeInst)geom;
            NodeProto np = ni.getProto();
            if (np == Schematics.tech.busPinNode) {
                Connection con;
                if (ni.getNumExports() == 0) {
                    found = false;
                    it2 = ni.getConnections();
                    while (it2.hasNext()) {
                        con = (Connection)it2.next();
                        if (con.getArc().getProto() != Schematics.tech.bus_arc) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        err = errorLogger.logError("Bus pin does not connect to any bus arcs", cell, 0);
                        err.addGeom(geom, true, cell, null);
                        return;
                    }
                }
                int i = 0;
                it2 = ni.getConnections();
                while (it2.hasNext()) {
                    con = (Connection)it2.next();
                    if (con.getArc().getProto() != Schematics.tech.wire_arc) continue;
                    ++i;
                }
                if (i > 1) {
                    err = errorLogger.logError("Wire arcs cannot connect through a bus pin", cell, 0);
                    err.addGeom(geom, true, cell, null);
                    it = ni.getConnections();
                    while (it.hasNext()) {
                        Connection con2 = (Connection)it.next();
                        if (con2.getArc().getProto() == Schematics.tech.wire_arc) {
                            ++i;
                        }
                        err.addGeom(con2.getArc(), true, cell, null);
                    }
                    return;
                }
            }
            if (np.getFunction() == NodeProto.Function.PIN) {
                if (ni.getNumExports() == 0 && ni.getNumConnections() == 0) {
                    found = false;
                    it2 = ni.getVariables();
                    while (it2.hasNext()) {
                        Variable var = (Variable)it2.next();
                        if (!var.isDisplay()) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        err = errorLogger.logError("Stranded pin (not connected or exported)", cell, 0);
                        err.addGeom(geom, true, cell, null);
                        return;
                    }
                }
                if (ni.isInlinePin()) {
                    ErrorLogger.ErrorLog err2 = errorLogger.logError("Unnecessary pin (between 2 arcs)", cell, 0);
                    err2.addGeom(geom, true, cell, null);
                    return;
                }
                Point2D pinLoc = ni.invisiblePinWithOffsetText(false);
                if (pinLoc != null) {
                    err = errorLogger.logError("Invisible pin has text in different location", cell, 0);
                    err.addGeom(geom, true, cell, null);
                    err.addLine(ni.getAnchorCenterX(), ni.getAnchorCenterY(), pinLoc.getX(), pinLoc.getY(), cell);
                    return;
                }
            }
            if (np instanceof Cell) {
                Cell instCell = (Cell)np;
                Cell contentsCell = instCell.contentsView();
                if (contentsCell == null) {
                    contentsCell = instCell;
                }
                it = ni.getVariables();
                while (it.hasNext()) {
                    ErrorLogger.ErrorLog err3;
                    String trueVarName;
                    Variable var = (Variable)it.next();
                    TextDescriptor td = var.getTextDescriptor();
                    if (!td.isParam()) continue;
                    TextDescriptor foundTD = null;
                    Iterator cIt = contentsCell.getVariables();
                    while (cIt.hasNext()) {
                        Variable fVar = (Variable)cIt.next();
                        TextDescriptor fTd = fVar.getTextDescriptor();
                        if (!fTd.isParam() || var.getKey() != fVar.getKey()) continue;
                        foundTD = fTd;
                        break;
                    }
                    if (foundTD == null) {
                        trueVarName = var.getTrueName();
                        err3 = errorLogger.logError("Parameter '" + trueVarName + "' on node " + ni.describe() + " is invalid", cell, 0);
                        err3.addGeom(geom, true, cell, null);
                        continue;
                    }
                    if (td.getUnit() != foundTD.getUnit()) {
                        trueVarName = var.getTrueName();
                        err3 = errorLogger.logError("Parameter '" + trueVarName + "' on node " + ni.describe() + " had incorrect units (now fixed)", cell, 0);
                        err3.addGeom(geom, true, cell, null);
                        td.setUnit(foundTD.getUnit());
                    }
                    if (foundTD.isInterior()) {
                        if (!var.isDisplay()) continue;
                        trueVarName = var.getTrueName();
                        err3 = errorLogger.logError("Parameter '" + trueVarName + "' on node " + ni.describe() + " should not be visible (now fixed)", cell, 0);
                        err3.addGeom(geom, true, cell, null);
                        var.setDisplay(false);
                        continue;
                    }
                    if (var.isDisplay()) continue;
                    trueVarName = var.getTrueName();
                    err3 = errorLogger.logError("Parameter '" + trueVarName + "' on node " + ni.describe() + " should be visible (now fixed)", cell, 0);
                    err3.addGeom(geom, true, cell, null);
                    var.setDisplay(true);
                }
            }
        } else {
            int signals;
            Name name;
            ArcInst ai = (ArcInst)geom;
            boolean checkDangle = false;
            Name arcName = ai.getNameKey();
            if (arcName == null || arcName.isTempname()) {
                checkDangle = true;
            }
            if (checkDangle && ai.getProto() == Schematics.tech.bus_arc && (name = netlist.getBusName(ai)) != null && !name.isTempname()) {
                checkDangle = false;
            }
            if (checkDangle) {
                for (int i = 0; i < 2; ++i) {
                    Connection con = ai.getConnection(i);
                    NodeInst ni = con.getPortInst().getNodeInst();
                    if (ni.getProto().getFunction() != NodeProto.Function.PIN || ni.getNumExports() != 0 || ni.getNumConnections() != 1) continue;
                    ErrorLogger.ErrorLog err = errorLogger.logError("Arc dangles", cell, 0);
                    err.addGeom(geom, true, cell, null);
                    return;
                }
            }
            if ((signals = netlist.getBusWidth(ai)) < 1) {
                signals = 1;
            }
            for (int i = 0; i < 2; ++i) {
                int nodeSize;
                Connection con = ai.getConnection(i);
                PortInst pi = con.getPortInst();
                NodeInst ni = pi.getNodeInst();
                if (!(ni.getProto() instanceof Cell)) continue;
                Cell subNp = (Cell)ni.getProto();
                PortProto pp = pi.getPortProto();
                Cell np = subNp.contentsView();
                if (np != null && ((pp = pi.getPortProto().getEquivalent()) == null || pp == pi.getPortProto())) {
                    ErrorLogger.ErrorLog err = errorLogger.logError("Arc " + ai.describe() + " connects to port " + pi.getPortProto().getName() + " of node " + ni.describe() + ", but there is no equivalent port in cell " + np.describe(), cell, 0);
                    err.addGeom(geom, true, cell, null);
                    err.addGeom(ni, true, cell, null);
                    continue;
                }
                int portWidth = netlist.getBusWidth((Export)pp);
                if (portWidth < 1) {
                    portWidth = 1;
                }
                if ((nodeSize = ni.getNameKey().busWidth()) <= 0) {
                    nodeSize = 1;
                }
                if (signals == portWidth || signals == portWidth * nodeSize) continue;
                ErrorLogger.ErrorLog err = errorLogger.logError("Arc " + ai.describe() + " (" + signals + " wide) connects to port " + pp.getName() + " of node " + ni.describe() + " (" + portWidth + " wide)", cell, 0);
                err.addGeom(geom, true, cell, null);
                err.addGeom(ni, true, cell, null);
            }
        }
        Schematic.checkObjectVicinity(netlist, geom, geom, DBMath.MATID);
    }

    private static void checkObjectVicinity(Netlist netlist, Geometric topGeom, Geometric geom, AffineTransform trans) {
        block6: {
            block4: {
                AffineTransform localTrans;
                NodeProto np;
                NodeInst ni;
                block5: {
                    if (!(geom instanceof NodeInst)) break block4;
                    ni = (NodeInst)geom;
                    np = ni.getProto();
                    localTrans = ni.rotateOut();
                    localTrans.preConcatenate(trans);
                    if (!(np instanceof Cell)) break block5;
                    if (!ni.isExpanded()) break block6;
                    AffineTransform subRot = ni.translateOut();
                    subRot.preConcatenate(localTrans);
                    Cell subCell = (Cell)np;
                    Iterator it = subCell.getNodes();
                    while (it.hasNext()) {
                        NodeInst subNi = (NodeInst)it.next();
                        Schematic.checkObjectVicinity(netlist, topGeom, subNi, subRot);
                    }
                    it = subCell.getArcs();
                    while (it.hasNext()) {
                        ArcInst subAi = (ArcInst)it.next();
                        Schematic.checkObjectVicinity(netlist, topGeom, subAi, subRot);
                    }
                    break block6;
                }
                Technology tech = np.getTechnology();
                Poly[] polyList = tech.getShapeOfNode(ni);
                int total = polyList.length;
                for (int i = 0; i < total; ++i) {
                    Poly poly = polyList[i];
                    poly.transform(localTrans);
                    Schematic.checkPolygonVicinity(netlist, topGeom, poly);
                }
                break block6;
            }
            ArcInst ai = (ArcInst)geom;
            Technology tech = ai.getProto().getTechnology();
            Poly[] polyList = tech.getShapeOfArc(ai);
            int total = polyList.length;
            for (int i = 0; i < total; ++i) {
                Poly poly = polyList[i];
                poly.transform(trans);
                Schematic.checkPolygonVicinity(netlist, topGeom, poly);
            }
        }
    }

    private static boolean checkPolygonVicinity(Netlist netlist, Geometric geom, Poly poly) {
        Poly.Type style = poly.getStyle();
        if (style.isText()) {
            return false;
        }
        Cell cell = geom.getParent();
        NodeInst ni = null;
        ArcInst ai = null;
        if (geom instanceof NodeInst) {
            ni = (NodeInst)geom;
        } else {
            ai = (ArcInst)geom;
        }
        Rectangle2D bounds = geom.getBounds();
        Iterator sIt = cell.searchIterator(bounds);
        while (sIt.hasNext()) {
            boolean found;
            Geometric oGeom = (Geometric)sIt.next();
            if (geom == oGeom) continue;
            if (oGeom instanceof NodeInst) {
                NodeInst oNi = (NodeInst)oGeom;
                if (oNi.getProto() instanceof PrimitiveNode && oNi.getProto().getTechnology() == Generic.tech) continue;
                if (geom instanceof NodeInst) {
                    found = false;
                    Iterator it = ni.getConnections();
                    while (it.hasNext()) {
                        Connection con = (Connection)it.next();
                        Iterator oIt = oNi.getConnections();
                        while (oIt.hasNext()) {
                            Connection oCon = (Connection)oIt.next();
                            if (!netlist.sameNetwork(con.getArc(), oCon.getArc())) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        break;
                    }
                    if (found) {
                        continue;
                    }
                } else {
                    found = false;
                    Iterator oIt = oNi.getConnections();
                    while (oIt.hasNext()) {
                        Connection oCon = (Connection)oIt.next();
                        if (!netlist.sameNetwork(ai, oCon.getArc())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                if (!Schematic.checkPoly(geom, poly, oGeom, oGeom, DBMath.MATID, false)) continue;
                return true;
            }
            ArcInst oAi = (ArcInst)oGeom;
            if (geom instanceof NodeInst) {
                found = false;
                Iterator it = ni.getConnections();
                while (it.hasNext()) {
                    Connection con = (Connection)it.next();
                    if (!netlist.sameNetwork(oAi, con.getArc())) continue;
                    found = true;
                    break;
                }
                if (found || !Schematic.checkPoly(geom, poly, oGeom, oGeom, DBMath.MATID, false)) continue;
                return true;
            }
            if (Schematic.checkColinear(ai, oAi)) {
                return true;
            }
            boolean connected = false;
            if (netlist.sameNetwork(ai, oAi)) {
                connected = true;
            } else {
                int aiBusWidth = netlist.getBusWidth(ai);
                int oAiBusWidth = netlist.getBusWidth(oAi);
                if (aiBusWidth > 1 && oAiBusWidth <= 1) {
                    for (int i = 0; i < aiBusWidth; ++i) {
                        if (netlist.getNetwork(ai, i) != netlist.getNetwork(oAi, 0)) continue;
                        connected = true;
                        break;
                    }
                } else if (oAiBusWidth > 1 && aiBusWidth <= 1) {
                    for (int i = 0; i < oAiBusWidth; ++i) {
                        if (netlist.getNetwork(oAi, i) != netlist.getNetwork(ai, 0)) continue;
                        connected = true;
                        break;
                    }
                }
            }
            if (connected || !Schematic.checkPoly(geom, poly, oGeom, oGeom, DBMath.MATID, true)) continue;
            return true;
        }
        return true;
    }

    private static boolean checkPoly(Geometric geom, Poly poly, Geometric oTopGeom, Geometric oGeom, AffineTransform oTrans, boolean canCross) {
        if (oGeom instanceof NodeInst) {
            NodeInst ni = (NodeInst)oGeom;
            NodeProto np = ni.getProto();
            AffineTransform thisTrans = ni.rotateOut();
            thisTrans.preConcatenate(oTrans);
            if (np instanceof Cell) {
                AffineTransform subRot = ni.translateOut();
                subRot.preConcatenate(thisTrans);
                Cell subCell = (Cell)np;
                Iterator it = subCell.getNodes();
                while (it.hasNext()) {
                    NodeInst subNi = (NodeInst)it.next();
                    if (!Schematic.checkPoly(geom, poly, oTopGeom, subNi, subRot, canCross)) continue;
                    return true;
                }
                it = subCell.getArcs();
                while (it.hasNext()) {
                    ArcInst subAi = (ArcInst)it.next();
                    if (!Schematic.checkPoly(geom, poly, oTopGeom, subAi, subRot, canCross)) continue;
                    return true;
                }
            } else {
                Technology tech = np.getTechnology();
                Poly[] polyList = tech.getShapeOfNode(ni);
                int total = polyList.length;
                for (int i = 0; i < total; ++i) {
                    Poly nodePoly = polyList[i];
                    nodePoly.transform(thisTrans);
                    if (!Schematic.checkPolyAgainstPoly(geom, poly, oTopGeom, nodePoly, canCross)) continue;
                    return true;
                }
            }
        } else {
            ArcInst ai = (ArcInst)oGeom;
            Technology tech = ai.getProto().getTechnology();
            Poly[] polyList = tech.getShapeOfArc(ai);
            int total = polyList.length;
            for (int i = 0; i < total; ++i) {
                Poly oPoly = polyList[i];
                oPoly.transform(oTrans);
                if (!Schematic.checkPolyAgainstPoly(geom, poly, oTopGeom, oPoly, canCross)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkPolyAgainstPoly(Geometric geom, Poly poly, Geometric oGeom, Poly opoly, boolean canCross) {
        if (canCross) {
            int i;
            Point2D[] pointList = poly.getPoints();
            Rectangle2D.Double pointRect = new Rectangle2D.Double();
            boolean found = false;
            for (i = 0; i < pointList.length; ++i) {
                ((Rectangle2D)pointRect).setRect(pointList[i].getX(), pointList[i].getY(), 0.0, 0.0);
                if (!(opoly.polyDistance(pointRect) <= 0.0)) continue;
                found = true;
                break;
            }
            if (!found) {
                pointList = opoly.getPoints();
                found = false;
                for (i = 0; i < pointList.length; ++i) {
                    ((Rectangle2D)pointRect).setRect(pointList[i].getX(), pointList[i].getY(), 0.0, 0.0);
                    if (!(poly.polyDistance(pointRect) <= 0.0)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
        } else if (!poly.intersects(opoly)) {
            return false;
        }
        ErrorLogger.ErrorLog err = errorLogger.logError("Objects touch", geom.getParent(), 0);
        err.addGeom(geom, true, geom.getParent(), null);
        err.addGeom(oGeom, true, geom.getParent(), null);
        return true;
    }

    private static boolean checkColinear(ArcInst ai, ArcInst oAi) {
        double oHigh;
        double fx = ai.getHead().getLocation().getX();
        double fy = ai.getHead().getLocation().getY();
        double tx = ai.getTail().getLocation().getX();
        double ty = ai.getTail().getLocation().getY();
        double oFx = oAi.getHead().getLocation().getX();
        double oFy = oAi.getHead().getLocation().getY();
        double oTx = oAi.getTail().getLocation().getX();
        double oTy = oAi.getTail().getLocation().getY();
        if (oFx == oTx && oFy == oTy) {
            return false;
        }
        double lowX = Math.min(fx, tx);
        double highX = Math.max(fx, tx);
        double lowY = Math.min(fy, ty);
        double highY = Math.max(fy, ty);
        int ang = 0;
        if (fx == tx) {
            double oLow = Math.min(oFy, oTy);
            oHigh = Math.max(oFy, oTy);
            if (oFx != fx || oTx != fx) {
                return false;
            }
            if (lowY >= oHigh || highY <= oLow) {
                return false;
            }
            ang = 900;
        } else if (fy == ty) {
            double oLow = Math.min(oFx, oTx);
            oHigh = Math.max(oFx, oTx);
            if (oFy != fy || oTy != fy) {
                return false;
            }
            if (lowX >= oHigh || highX <= oLow) {
                return false;
            }
            ang = 0;
        } else {
            int oAng;
            ang = DBMath.figureAngle(new Point2D.Double(fx, fy), new Point2D.Double(tx, ty));
            if (ang != (oAng = DBMath.figureAngle(new Point2D.Double(oFx, oFy), new Point2D.Double(oTx, oTy))) && Math.min(ang, oAng) + 1800 != Math.max(ang, oAng)) {
                return false;
            }
            if ((oFx - fx) * (ty - fy) / (tx - fx) != oFy - fy) {
                return false;
            }
            if ((oTx - fx) * (ty - fy) / (tx - fx) != oTy - fy) {
                return false;
            }
            double oLow = Math.min(oFy, oTy);
            double oHigh2 = Math.max(oFy, oTy);
            if (lowY >= oHigh2 || highY <= oLow) {
                return false;
            }
            oLow = Math.min(oFx, oTx);
            oHigh2 = Math.max(oFx, oTx);
            if (lowX >= oHigh2 || highX <= oLow) {
                return false;
            }
        }
        Cell cell = ai.getParent();
        ErrorLogger.ErrorLog err = errorLogger.logError("Arcs overlap", cell, 0);
        err.addGeom(ai, true, cell, null);
        err.addGeom(oAi, true, cell, null);
        ang = (ang + 900) % 3600;
        double dist = 2.0;
        double gDist = dist / 2.0;
        double ca = Math.cos(ang);
        double sa = Math.sin(ang);
        double frX = fx + dist * ca;
        double frY = fy + dist * sa;
        double toX = tx + dist * ca;
        double toY = ty + dist * sa;
        err.addLine(frX, frY, toX, toY, cell);
        err.addLine(frX, frY, fx += gDist * ca, fy += gDist * sa, cell);
        err.addLine(tx += gDist * ca, ty += gDist * sa, toX, toY, cell);
        frX = oFx - dist * ca;
        frY = oFy - dist * sa;
        toX = oTx - dist * ca;
        toY = oTy - dist * sa;
        err.addLine(frX, frY, toX, toY, cell);
        err.addLine(frX, frY, oFx -= gDist * ca, oFy -= gDist * sa, cell);
        err.addLine(oTx -= gDist * ca, oTy -= gDist * sa, toX, toY, cell);
        return true;
    }
}

