/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.technology.Layer;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PolyMerge {
    private HashMap allLayers = new HashMap();

    public void addPolygon(Layer layer, Poly poly) {
        Rectangle2D bounds;
        Area area = (Area)this.allLayers.get(layer);
        if (area == null) {
            area = new Area();
            this.allLayers.put(layer, area);
        }
        if ((bounds = poly.getBox()) != null) {
            Area additionalArea = new Area(bounds);
            area.add(additionalArea);
        }
    }

    public void subPolygon(Layer layer, Poly poly) {
    }

    public void addMerge(PolyMerge other, AffineTransform trans) {
        Iterator it = other.allLayers.keySet().iterator();
        while (it.hasNext()) {
            Layer subLayer = (Layer)it.next();
            Area subArea = (Area)other.allLayers.get(subLayer);
            Area area = (Area)this.allLayers.get(subLayer);
            if (area == null) {
                area = new Area();
                this.allLayers.put(subLayer, area);
            }
            Area newArea = subArea.createTransformedArea(trans);
            area.add(newArea);
        }
    }

    public Iterator getLayersUsed() {
        return this.allLayers.keySet().iterator();
    }

    public List getMergedPoints(Layer layer) {
        Area area = (Area)this.allLayers.get(layer);
        if (area == null) {
            return null;
        }
        ArrayList<Poly> polyList = new ArrayList<Poly>();
        double[] coords = new double[6];
        ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
        Point2D.Double lastMoveTo = null;
        PathIterator pIt = area.getPathIterator(null);
        while (!pIt.isDone()) {
            int type = pIt.currentSegment(coords);
            if (type == 4) {
                if (lastMoveTo != null) {
                    pointList.add(lastMoveTo);
                }
                Point2D[] points = new Point2D[pointList.size()];
                int i = 0;
                Iterator it = pointList.iterator();
                while (it.hasNext()) {
                    points[i++] = (Point2D)it.next();
                }
                Poly poly = new Poly(points);
                poly.setLayer(layer);
                poly.setStyle(Poly.Type.FILLED);
                polyList.add(poly);
                pointList.clear();
                lastMoveTo = null;
            } else if (type == 0 || type == 1) {
                Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                pointList.add(pt);
                if (type == 0) {
                    lastMoveTo = pt;
                }
            }
            pIt.next();
        }
        return polyList;
    }
}

