/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Poly
implements Shape {
    private Type style;
    private Point2D[] points;
    private Layer layer;
    private Rectangle2D bounds;
    private String string;
    private Name name;
    private TextDescriptor descript;
    private Variable var;
    private PortProto pp;

    public Poly(Point2D[] points) {
        this.initialize(points);
    }

    public Poly(double cX, double cY, double width, double height) {
        double halfWidth = width / 2.0;
        double halfHeight = height / 2.0;
        this.initialize(Poly.makePoints(cX - halfWidth, cX + halfWidth, cY - halfHeight, cY + halfHeight));
    }

    public Poly(Rectangle2D rect) {
        this.initialize(Poly.makePoints(rect));
    }

    public static Point2D[] makePoints(double lX, double hX, double lY, double hY) {
        Point2D[] points = new Point2D.Double[]{new Point2D.Double(lX, lY), new Point2D.Double(hX, lY), new Point2D.Double(hX, hY), new Point2D.Double(lX, hY)};
        return points;
    }

    public static Point2D[] makePoints(Rectangle2D rect) {
        double lX = rect.getMinX();
        double hX = rect.getMaxX();
        double lY = rect.getMinY();
        double hY = rect.getMaxY();
        Point2D[] points = new Point2D.Double[]{new Point2D.Double(lX, lY), new Point2D.Double(hX, lY), new Point2D.Double(hX, hY), new Point2D.Double(lX, hY)};
        return points;
    }

    private void initialize(Point2D[] points) {
        this.style = null;
        this.points = points;
        this.layer = null;
        this.bounds = null;
        this.string = null;
        this.name = null;
        this.descript = null;
        this.var = null;
        this.pp = null;
    }

    public Type getStyle() {
        return this.style;
    }

    public void setStyle(Type style) {
        this.style = style;
    }

    public Point2D[] getPoints() {
        return this.points;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public TextDescriptor getTextDescriptor() {
        return this.descript;
    }

    public void setTextDescriptor(TextDescriptor descript) {
        this.descript = descript;
    }

    public Variable getVariable() {
        return this.var;
    }

    public void setVariable(Variable var) {
        this.var = var;
    }

    public PortProto getPort() {
        return this.pp;
    }

    public void setPort(PortProto pp) {
        this.pp = pp;
    }

    public void transform(AffineTransform af) {
        double det;
        if ((this.style == Type.CIRCLEARC || this.style == Type.THICKCIRCLEARC) && (det = af.getDeterminant()) < 0.0) {
            for (int i = 0; i < this.points.length; i += 3) {
                double x = this.points[i + 1].getX();
                double y = this.points[i + 1].getY();
                this.points[i + 1].setLocation(this.points[i + 2].getX(), this.points[i + 2].getY());
                this.points[i + 2].setLocation(x, y);
            }
        }
        af.transform(this.points, 0, this.points, 0, this.points.length);
        this.bounds = null;
    }

    public Rectangle2D getBox() {
        if (this.points.length == 4) {
            if (this.style != Type.FILLED && this.style != Type.CLOSED && this.style != Type.TEXTBOX) {
                return null;
            }
        } else if (this.points.length == 5) {
            if (this.style != Type.OPENED && this.style != Type.OPENEDT1 && this.style != Type.OPENEDT2 && this.style != Type.OPENEDT3) {
                return null;
            }
            if (this.points[0].getX() != this.points[4].getX() || this.points[0].getY() != this.points[4].getY()) {
                return null;
            }
        } else {
            return null;
        }
        if (this.points[0].getX() == this.points[1].getX() && this.points[2].getX() == this.points[3].getX() && this.points[0].getY() == this.points[3].getY() && this.points[1].getY() == this.points[2].getY()) {
            return this.getBounds2D();
        }
        if (this.points[0].getX() == this.points[3].getX() && this.points[1].getX() == this.points[2].getX() && this.points[0].getY() == this.points[1].getY() && this.points[2].getY() == this.points[3].getY()) {
            return this.getBounds2D();
        }
        return null;
    }

    public double getMinSize() {
        Rectangle2D box = this.getBox();
        if (box == null) {
            return 0.0;
        }
        return Math.min(box.getWidth(), box.getHeight());
    }

    public boolean polySame(Poly polyOther) {
        Point2D[] pointsO;
        Point2D[] points = this.getPoints();
        if (points.length != (pointsO = polyOther.getPoints()).length) {
            return false;
        }
        Rectangle2D box = this.getBox();
        Rectangle2D boxO = polyOther.getBox();
        if (box != null && boxO != null) {
            return box.equals(boxO);
        }
        if (box != null || boxO != null) {
            return false;
        }
        for (int i = 0; i < points.length; ++i) {
            if (points[i].equals(pointsO[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isInside(Point2D pt) {
        if (this.style == Type.FILLED || this.style == Type.CLOSED || this.style == Type.CROSSED || this.style.isText()) {
            Rectangle2D bounds = this.getBox();
            if (bounds != null) {
                if (DBMath.pointInRect(pt, bounds)) {
                    return true;
                }
                return bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0 && DBMath.doublesClose(pt.getX(), bounds.getX()) && DBMath.doublesClose(pt.getY(), bounds.getY());
            }
            double ang = 0.0;
            Point2D lastPoint = this.points[this.points.length - 1];
            if (DBMath.pointsClose(pt, lastPoint)) {
                return true;
            }
            int lastp = DBMath.figureAngle(pt, lastPoint);
            for (int i = 0; i < this.points.length; ++i) {
                Point2D thisPoint = this.points[i];
                if (DBMath.pointsClose(pt, lastPoint)) {
                    return true;
                }
                int thisp = DBMath.figureAngle(pt, thisPoint);
                int tang = lastp - thisp;
                if (tang < -1800) {
                    tang += 3600;
                }
                if (tang > 1800) {
                    tang -= 3600;
                }
                ang += (double)tang;
                lastp = thisp;
            }
            return !(Math.abs(ang) <= (double)this.points.length);
        }
        if (this.style == Type.CROSS || this.style == Type.BIGCROSS) {
            return DBMath.doublesClose(this.getCenterX(), pt.getX()) && DBMath.doublesClose(this.getCenterY(), pt.getY());
        }
        if (this.style == Type.OPENED || this.style == Type.OPENEDT1 || this.style == Type.OPENEDT2 || this.style == Type.OPENEDT3 || this.style == Type.VECTORS) {
            int i;
            for (i = 0; i < this.points.length; ++i) {
                if (!DBMath.pointsClose(pt, this.points[i])) continue;
                return true;
            }
            if (this.style == Type.VECTORS) {
                for (i = 0; i < this.points.length; i += 2) {
                    if (!DBMath.isOnLine(this.points[i], this.points[i + 1], pt)) continue;
                    return true;
                }
            } else {
                for (i = 1; i < this.points.length; ++i) {
                    if (!DBMath.isOnLine(this.points[i - 1], this.points[i], pt)) continue;
                    return true;
                }
            }
            return false;
        }
        if (this.style == Type.CIRCLE || this.style == Type.THICKCIRCLE || this.style == Type.DISC) {
            double dist = this.points[0].distance(this.points[1]);
            double odist = this.points[0].distance(pt);
            return odist < dist;
        }
        if (this.style == Type.CIRCLEARC || this.style == Type.THICKCIRCLEARC) {
            double wantdist;
            double angrange;
            int startangle;
            int ang = DBMath.figureAngle(this.points[0], pt);
            int endangle = DBMath.figureAngle(this.points[0], this.points[1]);
            if (endangle > (startangle = DBMath.figureAngle(this.points[0], this.points[2]))) {
                if (ang < startangle || ang > endangle) {
                    return false;
                }
                angrange = endangle - startangle;
            } else {
                if (ang < startangle && ang > endangle) {
                    return false;
                }
                angrange = 3600 - startangle + endangle;
            }
            double dist = this.points[0].distance(pt);
            if (ang == startangle || angrange == 0.0) {
                wantdist = this.points[0].distance(this.points[1]);
            } else if (ang == endangle) {
                wantdist = this.points[0].distance(this.points[2]);
            } else {
                double startdist = this.points[0].distance(this.points[1]);
                double enddist = this.points[0].distance(this.points[2]);
                wantdist = enddist == startdist ? startdist : startdist + (double)(ang - startangle) / angrange * (enddist - startdist);
            }
            return DBMath.doublesClose(dist, wantdist);
        }
        return false;
    }

    public boolean isInside(Rectangle2D bounds) {
        if (this.style == Type.CIRCLE || this.style == Type.THICKCIRCLE || this.style == Type.DISC) {
            Point2D ctr = this.points[0];
            double dx = Math.abs(ctr.getX() - this.points[1].getX());
            double dy = Math.abs(ctr.getY() - this.points[1].getY());
            double rad = Math.max(dx, dy);
            if (!DBMath.pointInRect(new Point2D.Double(ctr.getX() + rad, ctr.getY() + rad), bounds)) {
                return false;
            }
            return DBMath.pointInRect(new Point2D.Double(ctr.getX() - rad, ctr.getY() - rad), bounds);
        }
        for (int i = 0; i < this.points.length; ++i) {
            if (DBMath.pointInRect(this.points[i], bounds)) continue;
            return false;
        }
        return true;
    }

    public void reducePortPoly(PortInst pi, double wid, int angle) {
        double swap;
        NodeInst ni = pi.getNodeInst();
        PortProto pp = pi.getPortProto();
        AffineTransform trans = ni.rotateOut();
        while (ni.getProto() instanceof Cell) {
            trans = ni.translateOut(trans);
            ni = ((Export)pp).getOriginalPort().getNodeInst();
            pp = ((Export)pp).getOriginalPort().getPortProto();
            trans = ni.rotateOut(trans);
        }
        if (this.getStyle() != Type.FILLED && this.getStyle() != Type.CROSSED && this.getStyle() != Type.DISC) {
            return;
        }
        if (ni.getTrace() != null) {
            return;
        }
        double realWid = wid / 2.0;
        Rectangle2D portBounds = this.getBox();
        if (portBounds == null) {
            if (this.getStyle() == Type.DISC) {
                double dist = this.points[0].distance(this.points[1]);
                dist = Math.max(0.0, dist - realWid);
                this.points[1].setLocation(this.points[0].getX() + dist, this.points[0].getY());
                return;
            }
            return;
        }
        double bx = portBounds.getMinX();
        double ux = portBounds.getMaxX();
        double by = portBounds.getMinY();
        double uy = portBounds.getMaxY();
        double cx = portBounds.getCenterX();
        double cy = portBounds.getCenterY();
        SizeOffset so = ni.getSizeOffset();
        Rectangle2D nodeBounds = ni.getBounds();
        Point2D.Double lowerLeft = new Point2D.Double(nodeBounds.getMinX() + so.getLowXOffset(), nodeBounds.getMinY() + so.getLowYOffset());
        trans.transform(lowerLeft, lowerLeft);
        Point2D.Double upperRight = new Point2D.Double(nodeBounds.getMaxX() - so.getHighXOffset(), nodeBounds.getMaxY() - so.getHighYOffset());
        trans.transform(upperRight, upperRight);
        double lx = ((Point2D)lowerLeft).getX();
        double hx = ((Point2D)upperRight).getX();
        double ly = ((Point2D)lowerLeft).getY();
        double hy = ((Point2D)upperRight).getY();
        if (lx > hx) {
            swap = lx;
            lx = hx;
            hx = swap;
        }
        if (ly > hy) {
            swap = ly;
            ly = hy;
            hy = swap;
        }
        if (angle != 0 && angle != 1800) {
            lx = Math.max(bx, lx + realWid);
            if ((hx = Math.min(ux, hx - realWid)) < lx) {
                hx = lx = (hx + lx) / 2.0;
            }
            if (ux >= lx && bx <= hx) {
                for (int j = 0; j < this.points.length; ++j) {
                    double x = this.points[j].getX();
                    if (x < lx) {
                        x = lx;
                    }
                    if (x > hx) {
                        x = hx;
                    }
                    this.points[j].setLocation(x, this.points[j].getY());
                }
            }
        }
        if (angle != 900 && angle != 2700) {
            ly = Math.max(by, ly + realWid);
            if ((hy = Math.min(uy, hy - realWid)) < ly) {
                hy = ly = (hy + ly) / 2.0;
            }
            if (uy >= ly && by <= hy) {
                for (int j = 0; j < this.points.length; ++j) {
                    double y = this.points[j].getY();
                    if (y < ly) {
                        y = ly;
                    }
                    if (y > hy) {
                        y = hy;
                    }
                    this.points[j].setLocation(this.points[j].getX(), y);
                }
            }
        }
    }

    public boolean setExactTextBounds(EditWindow wnd, ElectricObject eObj) {
        Font font;
        String theString = this.getString().trim();
        if (theString.length() == 0) {
            return true;
        }
        int numLines = 1;
        if (this.var != null && (numLines = this.var.getLength()) > 1) {
            Object[] objList = (Object[])this.var.getObject();
            for (int i = 0; i < numLines; ++i) {
                String str;
                if (objList[i] == null || (str = objList[i].toString()).length() <= theString.length()) continue;
                theString = str;
            }
        }
        if ((font = wnd.getFont(this.getTextDescriptor())) == null) {
            return true;
        }
        Rectangle2D bounds = this.getBounds2D();
        double lX = bounds.getMinX();
        double hX = bounds.getMaxX();
        double lY = bounds.getMinY();
        double hY = bounds.getMaxY();
        GlyphVector gv = wnd.getGlyphs(theString, font);
        Rectangle2D glyphBounds = gv.getVisualBounds();
        Type style = this.getStyle();
        style = Poly.rotateType(style, eObj);
        Point2D corner = this.getTextCorner(wnd, font, gv, style, lX, hX, lY, hY);
        double cX = corner.getX();
        double cY = corner.getY();
        double textScale = this.getTextScale(wnd, gv, this.getStyle(), lX, hX, lY, hY);
        double width = glyphBounds.getWidth() * textScale;
        double height = (double)font.getSize() * textScale * (double)numLines;
        switch (this.getTextDescriptor().getRotation().getIndex()) {
            case 1: {
                double saveWidth = width;
                width = height;
                height = saveWidth;
                break;
            }
            case 2: {
                width = -width;
                height = -height;
                break;
            }
            case 3: {
                double saveHeight = height;
                height = width;
                width = saveHeight;
            }
        }
        this.points = new Point2D.Double[]{new Point2D.Double(cX, cY), new Point2D.Double(cX + width, cY), new Point2D.Double(cX + width, cY + height), new Point2D.Double(cX, cY + height)};
        this.bounds = null;
        return false;
    }

    public static Type rotateType(Type origType, ElectricObject eObj) {
        NodeInst ni = null;
        if (eObj instanceof NodeInst) {
            ni = (NodeInst)eObj;
        } else if (eObj instanceof Export) {
            Export pp = (Export)eObj;
            ni = pp.getOriginalPort().getNodeInst();
        } else {
            return origType;
        }
        int nodeAngle = ni.getAngle();
        if ((nodeAngle != 0 || ni.isMirroredAboutXAxis() || ni.isMirroredAboutYAxis()) && nodeAngle % 900 == 0 && origType != Type.TEXTCENT && origType != Type.TEXTBOX) {
            int angle = origType.getTextAngle();
            if (ni.isMirroredAboutXAxis() != ni.isMirroredAboutYAxis()) {
                nodeAngle = 3600 - nodeAngle;
            }
            angle = (angle + nodeAngle) % 3600;
            Type style = Type.getTextTypeFromAngle(angle);
            return style;
        }
        return origType;
    }

    private double getTextScale(EditWindow wnd, GlyphVector gv, Type style, double lX, double hX, double lY, double hY) {
        Rectangle2D glyphBounds;
        double textWidth;
        double textScale = 1.0 / wnd.getScale();
        if (style == Type.TEXTBOX && (textWidth = (glyphBounds = gv.getVisualBounds()).getWidth() * textScale) > hX - lX) {
            textScale *= (hX - lX) / textWidth;
        }
        return textScale;
    }

    private Point2D getTextCorner(EditWindow wnd, Font font, GlyphVector gv, Type style, double lX, double hX, double lY, double hY) {
        Rectangle2D glyphBounds = gv.getVisualBounds();
        double textScale = this.getTextScale(wnd, gv, style, lX, hX, lY, hY);
        double textWidth = glyphBounds.getWidth();
        double textHeight = font.getSize();
        double scaledWidth = textWidth * textScale;
        double scaledHeight = textHeight * textScale;
        double offX = 0.0;
        double offY = 0.0;
        if (style == Type.TEXTCENT || style == Type.TEXTBOX) {
            offX = -scaledWidth / 2.0;
            offY = -scaledHeight / 2.0;
        } else if (style == Type.TEXTTOP) {
            offX = -scaledWidth / 2.0;
            offY = -scaledHeight;
        } else if (style == Type.TEXTBOT) {
            offX = -scaledWidth / 2.0;
        } else if (style == Type.TEXTLEFT) {
            offY = -scaledHeight / 2.0;
        } else if (style == Type.TEXTRIGHT) {
            offX = -scaledWidth;
            offY = -scaledHeight / 2.0;
        } else if (style == Type.TEXTTOPLEFT) {
            offY = -scaledHeight;
        } else if (style != Type.TEXTBOTLEFT) {
            if (style == Type.TEXTTOPRIGHT) {
                offX = -scaledWidth;
                offY = -scaledHeight;
            } else if (style == Type.TEXTBOTRIGHT) {
                offX = -scaledWidth;
            }
        }
        int rotation = this.getTextDescriptor().getRotation().getIndex();
        if (rotation != 0) {
            double saveOffX = offX;
            switch (rotation) {
                case 1: {
                    offX = offY;
                    offY = saveOffX;
                    break;
                }
                case 2: {
                    offX = -offX;
                    offY = -offY;
                    break;
                }
                case 3: {
                    offX = offY;
                    offY = saveOffX;
                }
            }
        }
        double cX = (lX + hX) / 2.0;
        double cY = (lY + hY) / 2.0;
        return new Point2D.Double(cX + offX, cY + offY);
    }

    public double polyDistance(Rectangle2D otherBounds) {
        Rectangle2D polyBounds = this.getBounds2D();
        double polyCX = polyBounds.getCenterX();
        double polyCY = polyBounds.getCenterY();
        Point2D.Double polyCenter = new Point2D.Double(polyCX, polyCY);
        Type localStyle = this.style;
        boolean thisIsPoint = polyBounds.getWidth() == 0.0 && polyBounds.getHeight() == 0.0;
        boolean otherIsPoint = otherBounds.getWidth() == 0.0 && otherBounds.getHeight() == 0.0;
        double otherCX = otherBounds.getCenterX();
        double otherCY = otherBounds.getCenterY();
        Point2D.Double otherPt = new Point2D.Double(otherCX, otherCY);
        if (thisIsPoint) {
            if (otherIsPoint ? polyCX == otherCX && polyCY == otherCY : otherBounds.contains(polyCenter)) {
                return Double.MIN_VALUE;
            }
            return otherPt.distance(polyCenter);
        }
        if (localStyle == Type.FILLED || localStyle == Type.CROSSED || localStyle.isText()) {
            if (otherIsPoint) {
                if (this.isInside(otherPt)) {
                    return otherPt.distance(polyCenter) - Double.MAX_VALUE;
                }
                Rectangle2D box = this.getBox();
                if (box != null) {
                    polyCX = otherCX > box.getMaxX() ? otherCX - box.getMaxX() : (otherCX < box.getMinX() ? box.getMinX() - otherCX : 0.0);
                    polyCY = otherCY > box.getMaxY() ? otherCY - box.getMaxY() : (otherCY < box.getMinY() ? box.getMinY() - otherCY : 0.0);
                    if (polyCX == 0.0 || polyCY == 0.0) {
                        return polyCX + polyCY;
                    }
                    ((Point2D)polyCenter).setLocation(polyCX, polyCY);
                    return polyCenter.distance(new Point2D.Double(0.0, 0.0));
                }
                localStyle = Type.CLOSED;
            } else {
                if (otherBounds.intersects(polyBounds)) {
                    return Double.MIN_VALUE;
                }
                return otherPt.distance(polyCenter);
            }
        }
        if (localStyle == Type.CLOSED) {
            if (otherIsPoint) {
                double bestDist = Double.MAX_VALUE;
                Point2D lastPt = this.points[this.points.length - 1];
                for (int i = 0; i < this.points.length; ++i) {
                    Point2D thisPt;
                    double dist;
                    if (i != 0) {
                        lastPt = this.points[i - 1];
                    }
                    if (!((dist = DBMath.distToLine(lastPt, thisPt = this.points[i], otherPt)) < bestDist)) continue;
                    bestDist = dist;
                }
                return bestDist;
            }
            if (otherBounds.intersects(polyBounds)) {
                return Double.MIN_VALUE;
            }
            return otherPt.distance(polyCenter);
        }
        if (localStyle == Type.OPENED || localStyle == Type.OPENEDT1 || localStyle == Type.OPENEDT2 || localStyle == Type.OPENEDT3) {
            if (otherIsPoint) {
                double bestDist = Double.MAX_VALUE;
                for (int i = 1; i < this.points.length; ++i) {
                    Point2D lastPt = this.points[i - 1];
                    Point2D thisPt = this.points[i];
                    double dist = DBMath.distToLine(lastPt, thisPt, otherPt);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                }
                return bestDist;
            }
            if (otherBounds.intersects(polyBounds)) {
                return Double.MIN_VALUE;
            }
            return otherPt.distance(polyCenter);
        }
        if (localStyle == Type.VECTORS) {
            if (otherIsPoint) {
                double bestDist = Double.MAX_VALUE;
                for (int i = 0; i < this.points.length; i += 2) {
                    Point2D lastPt = this.points[i];
                    Point2D thisPt = this.points[i + 1];
                    double dist = DBMath.distToLine(lastPt, thisPt, otherPt);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                }
                return bestDist;
            }
            if (otherBounds.intersects(polyBounds)) {
                return Double.MIN_VALUE;
            }
            return otherPt.distance(polyCenter);
        }
        if ((localStyle == Type.CIRCLE || localStyle == Type.THICKCIRCLE || localStyle == Type.DISC) && otherIsPoint) {
            double odist = this.points[0].distance(this.points[1]);
            double dist = this.points[0].distance(otherPt);
            if (localStyle == Type.DISC && dist < odist) {
                return dist - Double.MAX_VALUE;
            }
            return Math.abs(dist - odist);
        }
        if ((localStyle == Type.CIRCLEARC || localStyle == Type.THICKCIRCLEARC) && otherIsPoint) {
            double sdist = otherPt.distance(this.points[1]);
            double edist = otherPt.distance(this.points[2]);
            double dist = Math.min(sdist, edist);
            int pang = DBMath.figureAngle(this.points[0], otherPt);
            int sang = DBMath.figureAngle(this.points[0], this.points[1]);
            int eang = DBMath.figureAngle(this.points[0], this.points[2]);
            if (eang > sang ? pang < eang && pang > sang : pang < eang || pang > sang) {
                return dist;
            }
            double odist = this.points[0].distance(this.points[1]);
            dist = this.points[0].distance(otherPt);
            return Math.abs(dist - odist);
        }
        return otherPt.distance(polyCenter);
    }

    public double separation(Poly polyOther) {
        double pd;
        Point2D c;
        int i;
        if (this.intersects(polyOther)) {
            return 0.0;
        }
        double minPD = 0.0;
        for (i = 0; i < this.points.length; ++i) {
            c = polyOther.closestPoint(this.points[i]);
            pd = c.distance(this.points[i]);
            if (pd <= 0.0) {
                return 0.0;
            }
            if (i == 0) {
                minPD = pd;
                continue;
            }
            if (!(pd < minPD)) continue;
            minPD = pd;
        }
        for (i = 0; i < polyOther.points.length; ++i) {
            c = this.closestPoint(polyOther.points[i]);
            pd = c.distance(polyOther.points[i]);
            if (pd <= 0.0) {
                return 0.0;
            }
            if (!(pd < minPD)) continue;
            minPD = pd;
        }
        return minPD;
    }

    public Point2D closestPoint(Point2D pt) {
        Rectangle2D bounds;
        Type localStyle = this.style;
        if (localStyle == Type.FILLED || localStyle == Type.CROSSED || localStyle == Type.TEXTCENT || localStyle.isText()) {
            bounds = this.getBox();
            if (bounds != null) {
                double x = pt.getX();
                double y = pt.getY();
                if (x < bounds.getMinX()) {
                    x = bounds.getMinX();
                }
                if (x > bounds.getMaxX()) {
                    x = bounds.getMaxX();
                }
                if (y < bounds.getMinY()) {
                    y = bounds.getMinY();
                }
                if (y > bounds.getMaxY()) {
                    y = bounds.getMaxY();
                }
                return new Point2D.Double(x, y);
            }
            if (localStyle == Type.FILLED && this.isInside(pt)) {
                return pt;
            }
            localStyle = Type.CLOSED;
        }
        if (localStyle == Type.CLOSED) {
            double bestDist = Double.MAX_VALUE;
            Point2D.Double bestPoint = new Point2D.Double();
            for (int i = 0; i < this.points.length; ++i) {
                int lastI = i == 0 ? this.points.length - 1 : i - 1;
                Point2D pc = DBMath.closestPointToSegment(this.points[lastI], this.points[i], pt);
                double dist = pc.distance(pt);
                if (dist > bestDist) continue;
                bestDist = dist;
                bestPoint.setLocation(pc);
            }
            return bestPoint;
        }
        if (localStyle == Type.OPENED || localStyle == Type.OPENEDT1 || localStyle == Type.OPENEDT2 || localStyle == Type.OPENEDT3) {
            double bestDist = Double.MAX_VALUE;
            Point2D.Double bestPoint = new Point2D.Double();
            for (int i = 1; i < this.points.length; ++i) {
                Point2D pc = DBMath.closestPointToSegment(this.points[i - 1], this.points[i], pt);
                double dist = pc.distance(pt);
                if (dist > bestDist) continue;
                bestDist = dist;
                bestPoint.setLocation(pc);
            }
            return bestPoint;
        }
        if (localStyle == Type.VECTORS) {
            double bestDist = Double.MAX_VALUE;
            Point2D.Double bestPoint = new Point2D.Double();
            for (int i = 0; i < this.points.length; i += 2) {
                Point2D pc = DBMath.closestPointToSegment(this.points[i], this.points[i + 1], pt);
                double dist = pc.distance(pt);
                if (dist > bestDist) continue;
                bestDist = dist;
                bestPoint.setLocation(pc);
            }
            return bestPoint;
        }
        bounds = this.getBounds2D();
        return new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
    }

    public boolean contains(double x, double y) {
        return this.isInside(new Point2D.Double(x, y));
    }

    public boolean contains(Point2D p) {
        return this.isInside(new Point2D.Double(p.getX(), p.getY()));
    }

    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersects(double x, double y, double w, double h) {
        return false;
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersects(Poly polyOther) {
        Rectangle2D thisBounds = this.getBounds2D();
        Rectangle2D otherBounds = polyOther.getBounds2D();
        if (thisBounds.getMaxX() < otherBounds.getMinX() || otherBounds.getMaxX() < thisBounds.getMinX() || thisBounds.getMaxY() < otherBounds.getMinY() || otherBounds.getMaxY() < thisBounds.getMinY()) {
            return false;
        }
        int count = this.points.length;
        for (int i = 0; i < count; ++i) {
            Point2D p = null;
            if (i == 0) {
                if (this.style == Type.OPENED || this.style == Type.OPENEDT1 || this.style == Type.OPENEDT2 || this.style == Type.OPENEDT3 || this.style == Type.VECTORS) continue;
                p = this.points[count - 1];
            } else {
                p = this.points[i - 1];
            }
            Point2D t = this.points[i];
            if (this.style == Type.VECTORS && (i & 1) != 0) {
                ++i;
            }
            if (p.getX() == t.getX() && p.getY() == t.getY() || Math.min(p.getX(), t.getX()) > otherBounds.getMaxX() || Math.max(p.getX(), t.getX()) < otherBounds.getMinX() || Math.min(p.getY(), t.getY()) > otherBounds.getMaxY() || Math.max(p.getY(), t.getY()) < otherBounds.getMinY() || !polyOther.lineIntersect(p, t)) continue;
            return true;
        }
        return false;
    }

    private boolean lineIntersect(Point2D p1, Point2D t1) {
        int count = this.points.length;
        for (int i = 0; i < count; ++i) {
            int ang;
            Point2D p2 = null;
            if (i == 0) {
                if (this.style == Type.OPENED || this.style == Type.OPENEDT1 || this.style == Type.OPENEDT2 || this.style == Type.OPENEDT3 || this.style == Type.VECTORS) continue;
                p2 = this.points[count - 1];
            } else {
                p2 = this.points[i - 1];
            }
            Point2D t2 = this.points[i];
            if (this.style == Type.VECTORS && (i & 1) != 0) {
                ++i;
            }
            if (t2.getX() == p1.getX() && t2.getY() == p1.getY()) {
                return true;
            }
            if (t2.getX() == t1.getX() && t2.getY() == t1.getY()) {
                return true;
            }
            if (p2.getX() == t2.getX() && p2.getY() == t2.getY()) continue;
            if (p2.getX() == t2.getX()) {
                if (Math.min(p1.getX(), t1.getX()) > p2.getX() || Math.max(p1.getX(), t1.getX()) < p2.getX()) continue;
                if (p1.getX() == t1.getX()) {
                    if (Math.min(p1.getY(), t1.getY()) > Math.max(p2.getY(), t2.getY()) || Math.max(p1.getY(), t1.getY()) < Math.min(p2.getY(), t2.getY())) continue;
                    return true;
                }
                if (p1.getY() == t1.getY()) {
                    if (Math.min(p2.getY(), t2.getY()) > p1.getY() || Math.max(p2.getY(), t2.getY()) < p1.getY()) continue;
                    return true;
                }
                ang = DBMath.figureAngle(p1, t1);
                Point2D inter = DBMath.intersect(p2, 900, p1, ang);
                if (inter == null || inter.getX() != p2.getX() || inter.getY() < Math.min(p2.getY(), t2.getY()) || inter.getY() > Math.max(p2.getY(), t2.getY())) continue;
                return true;
            }
            if (p2.getY() == t2.getY()) {
                if (Math.min(p1.getY(), t1.getY()) > p2.getY() || Math.max(p1.getY(), t1.getY()) < p2.getY()) continue;
                if (p1.getY() == t1.getY()) {
                    if (Math.min(p1.getX(), t1.getX()) > Math.max(p2.getX(), t2.getX()) || Math.max(p1.getX(), t1.getX()) < Math.min(p2.getX(), t2.getX())) continue;
                    return true;
                }
                if (p1.getX() == t1.getX()) {
                    if (Math.min(p2.getX(), t2.getX()) > p1.getX() || Math.max(p2.getX(), t2.getX()) < p1.getX()) continue;
                    return true;
                }
                ang = DBMath.figureAngle(p1, t1);
                Point2D inter = DBMath.intersect(p2, 0, p1, ang);
                if (inter == null || inter.getY() != p2.getY() || inter.getX() < Math.min(p2.getX(), t2.getX()) || inter.getX() > Math.max(p2.getX(), t2.getX())) continue;
                return true;
            }
            if (Math.min(p1.getX(), t1.getX()) > Math.max(p2.getX(), t2.getX()) || Math.max(p1.getX(), t1.getX()) < Math.min(p2.getX(), t2.getX()) || Math.min(p1.getY(), t1.getY()) > Math.max(p2.getY(), t2.getY()) || Math.max(p1.getY(), t1.getY()) < Math.min(p2.getY(), t2.getY())) continue;
            int ang1 = DBMath.figureAngle(p1, t1);
            int ang2 = DBMath.figureAngle(p2, t2);
            Point2D inter = DBMath.intersect(p2, ang2, p1, ang1);
            if (inter == null || inter.getX() < Math.min(p2.getX(), t2.getX()) || inter.getX() > Math.max(p2.getX(), t2.getX()) || inter.getY() < Math.min(p2.getY(), t2.getY()) || inter.getY() > Math.max(p2.getY(), t2.getY()) || inter.getX() < Math.min(p1.getX(), t1.getX()) || inter.getX() > Math.max(p1.getX(), t1.getX()) || inter.getY() < Math.min(p1.getY(), t1.getY()) || inter.getY() > Math.max(p1.getY(), t1.getY())) continue;
            return true;
        }
        return false;
    }

    public double getPerimeter() {
        double perim = 0.0;
        int start = 0;
        if (this.style == Type.OPENED || this.style == Type.OPENEDT1 || this.style == Type.OPENEDT2 || this.style == Type.OPENEDT3) {
            start = 1;
        }
        for (int i = start; i < this.points.length; ++i) {
            int j = i - 1;
            if (j < 0) {
                j = this.points.length - 1;
            }
            perim += this.points[i].distance(this.points[j]);
        }
        return perim;
    }

    public double getArea() {
        if (this.style == Type.FILLED || this.style == Type.CLOSED || this.style == Type.CROSSED || this.style.isText()) {
            Rectangle2D bounds = this.getBox();
            if (bounds != null) {
                double area = bounds.getWidth() * bounds.getHeight();
                double sign = 0.0;
                sign = this.points[0].getX() == this.points[1].getX() ? (this.points[2].getX() - this.points[1].getX()) * (this.points[1].getY() - this.points[0].getY()) : (this.points[1].getX() - this.points[0].getX()) * (this.points[1].getY() - this.points[2].getY());
                if (sign < 0.0) {
                    area = -area;
                }
                return area;
            }
            return Poly.getAreaOfPoints(this.points);
        }
        return 0.0;
    }

    private static double getAreaOfPoints(Point2D[] points) {
        double area = 0.0;
        double x0 = points[0].getX();
        double y0 = points[0].getY();
        double y1 = 0.0;
        for (int i = 1; i < points.length; ++i) {
            double x1 = points[i].getX();
            y1 = points[i].getY();
            double p1 = x1 - x0;
            double p2 = y0 + y1;
            double partial = p1 * p2;
            area += partial / 2.0;
            x0 = x1;
            y0 = y1;
        }
        double p1 = points[0].getX() - x0;
        double p2 = points[0].getY() + y1;
        double partial = p1 * p2;
        return area += partial / 2.0;
    }

    public double getCenterX() {
        Rectangle2D b = this.getBounds2D();
        return b.getCenterX();
    }

    public double getCenterY() {
        Rectangle2D b = this.getBounds2D();
        return b.getCenterY();
    }

    public Rectangle2D getBounds2D() {
        if (this.bounds == null) {
            this.calcBounds();
        }
        return this.bounds;
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.calcBounds();
        }
        Rectangle2D r = this.getBounds2D();
        return new Rectangle((int)r.getMinX(), (int)r.getMinY(), (int)r.getWidth(), (int)r.getHeight());
    }

    private void calcBounds() {
        this.bounds = new Rectangle2D.Double();
        if (this.points.length > 0) {
            double lY;
            double lX;
            double hX = lX = this.points[0].getX();
            double hY = lY = this.points[0].getY();
            for (int i = 1; i < this.points.length; ++i) {
                double x = this.points[i].getX();
                double y = this.points[i].getY();
                if (x < lX) {
                    lX = x;
                }
                if (x > hX) {
                    hX = x;
                }
                if (y < lY) {
                    lY = y;
                }
                if (!(y > hY)) continue;
                hY = y;
            }
            this.bounds.setRect(lX, lY, hX - lX, hY - lY);
        }
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new PolyPathIterator(this, at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Poly poly = (Poly)obj;
        Layer layer = this.getLayer();
        if (this.getLayer() != poly.getLayer()) {
            return false;
        }
        if (layer.getFunction() != poly.getLayer().getFunction()) {
            return false;
        }
        boolean geometryCheck = this.polySame(poly);
        return geometryCheck;
    }

    private class PolyPathIterator
    implements PathIterator {
        int idx = 0;
        AffineTransform trans;

        public PolyPathIterator(Poly p, AffineTransform at) {
            this.trans = at;
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.idx > Poly.this.points.length;
        }

        public void next() {
            ++this.idx;
        }

        public int currentSegment(float[] coords) {
            if (this.idx >= Poly.this.points.length) {
                return 4;
            }
            coords[0] = (float)Poly.this.points[this.idx].getX();
            coords[1] = (float)Poly.this.points[this.idx].getY();
            if (this.trans != null) {
                this.trans.transform(coords, 0, coords, 0, 1);
            }
            return this.idx == 0 ? 0 : 1;
        }

        public int currentSegment(double[] coords) {
            if (this.idx >= Poly.this.points.length) {
                return 4;
            }
            coords[0] = Poly.this.points[this.idx].getX();
            coords[1] = Poly.this.points[this.idx].getY();
            if (this.trans != null) {
                this.trans.transform(coords, 0, coords, 0, 1);
            }
            return this.idx == 0 ? 0 : 1;
        }
    }

    public static class Type {
        private String name;
        private boolean isText;
        public static final Type FILLED = new Type("filled", false);
        public static final Type CLOSED = new Type("closed", false);
        public static final Type CROSSED = new Type("crossed", false);
        public static final Type OPENED = new Type("opened", false);
        public static final Type OPENEDT1 = new Type("opened-dotted", false);
        public static final Type OPENEDT2 = new Type("opened-dashed", false);
        public static final Type OPENEDT3 = new Type("opened-thick", false);
        public static final Type VECTORS = new Type("vectors", false);
        public static final Type CIRCLE = new Type("circle", false);
        public static final Type THICKCIRCLE = new Type("thick-circle", false);
        public static final Type DISC = new Type("disc", false);
        public static final Type CIRCLEARC = new Type("circle-arc", false);
        public static final Type THICKCIRCLEARC = new Type("thick-circle-arc", false);
        public static final Type TEXTCENT = new Type("text-center", true);
        public static final Type TEXTTOP = new Type("text-top", true);
        public static final Type TEXTBOT = new Type("text-bottom", true);
        public static final Type TEXTLEFT = new Type("text-left", true);
        public static final Type TEXTRIGHT = new Type("text-right", true);
        public static final Type TEXTTOPLEFT = new Type("text-topleft", true);
        public static final Type TEXTBOTLEFT = new Type("text-botleft", true);
        public static final Type TEXTTOPRIGHT = new Type("text-topright", true);
        public static final Type TEXTBOTRIGHT = new Type("text-botright", true);
        public static final Type TEXTBOX = new Type("text-box", true);
        public static final Type CROSS = new Type("cross", false);
        public static final Type BIGCROSS = new Type("big-cross", false);

        private Type(String name, boolean isText) {
            this.name = name;
            this.isText = isText;
        }

        public boolean isText() {
            return this.isText;
        }

        public String toString() {
            return "Poly.Type " + this.name;
        }

        public int getTextAngle() {
            if (this == TEXTLEFT) {
                return 0;
            }
            if (this == TEXTBOTLEFT) {
                return 450;
            }
            if (this == TEXTBOT) {
                return 900;
            }
            if (this == TEXTBOTRIGHT) {
                return 1350;
            }
            if (this == TEXTRIGHT) {
                return 1800;
            }
            if (this == TEXTTOPRIGHT) {
                return 2250;
            }
            if (this == TEXTTOP) {
                return 2700;
            }
            if (this == TEXTTOPLEFT) {
                return 3150;
            }
            return 0;
        }

        public static Type getTextTypeFromAngle(int angle) {
            switch (angle) {
                case 0: {
                    return TEXTLEFT;
                }
                case 450: {
                    return TEXTBOTLEFT;
                }
                case 900: {
                    return TEXTBOT;
                }
                case 1350: {
                    return TEXTBOTRIGHT;
                }
                case 1800: {
                    return TEXTRIGHT;
                }
                case 2250: {
                    return TEXTTOPRIGHT;
                }
                case 2700: {
                    return TEXTTOP;
                }
                case 3150: {
                    return TEXTTOPLEFT;
                }
            }
            return TEXTCENT;
        }
    }
}

