# Copyright (c) 2008, 2009 David Sugar, Tycho Softworks.
# This file is free software; as a special exception the author gives
# unlimited permission to copy and/or distribute it, with or without
# modifications, as long as this notice is preserved.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

Name: ucommon
Summary: Portable C++ runtime for threads and sockets
Version: 5.3.0
Release: 0%{?dist}
License: LGPLv3+
URL: http://www.gnu.org/software/commoncpp
Source0: http://www.gnutelephony.org/dist/tarballs/ucommon-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: doxygen graphviz-gd openssl-devel
Group: System Environment/Libraries
Summary: Runtime library for portable C++ threading and sockets

%description
GNU uCommon C++ is a lightweight library to facilitate using C++ design
patterns even for very deeply embedded applications, such as for systems using
uClibc along with POSIX threading support. For this reason, uCommon disables
language features that consume memory or introduce runtime overhead. uCommon
introduces some design patterns from Objective-C, such as reference counted
objects, memory pools, and smart pointers.  uCommon introduces some new
concepts for handling of thread locking and synchronization.

%package bin
Requires: %{name} = %{version}-%{release}
Group: Applications/System
Summary: ucommon system and support applications.

%package devel
Requires: %{name} = %{version}-%{release}
Requires: %{name}-bin = %{version}-%{release}
Requires: openssl-devel
Requires: pkgconfig
Group: Development/Libraries
Summary: Headers for building ucommon applications

%package doc
Group: Documentation
Summary: Generated class documentation for ucommon

%description bin
This is a collection of command line tools that use various aspects of the
ucommon library.  Some may be needed to prepare files or for development of
applications.

%description devel
This package provides header and support files needed for building
applications that use the uCommon library and frameworks.

%description doc
Generated class documentation for GNU uCommon library from header files,
html browsable.

%prep
%setup -q
%build

%configure --disable-static
%{__make} %{?_smp_mflags}
%{__rm} -rf doc/html
%{__make} doxy

%install
%{__rm} -rf %{buildroot}
%{__make} DESTDIR=%{buildroot} INSTALL="install -p" install
%{__chmod} 0755 %{buildroot}%{_bindir}/ucommon-config
%{__chmod} 0755 %{buildroot}%{_bindir}/commoncpp-config
%{__rm} %{buildroot}%{_libdir}/*.la

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root,-)
%doc AUTHORS README COPYING COPYING.LESSER COPYRIGHT NEWS SUPPORT ChangeLog
%{_libdir}/libucommon.so.*
%{_libdir}/libusecure.so.*
%{_libdir}/libcommoncpp.so.*

%files bin
%defattr(-,root,root,-)
%{_bindir}/args
%{_bindir}/car
%{_bindir}/pdetach
%{_bindir}/scrub-files
%{_bindir}/mdsum
%{_bindir}/sockaddr
%{_bindir}/zerofill
%{_mandir}/man1/args.*
%{_mandir}/man1/car.*
%{_mandir}/man1/pdetach.*
%{_mandir}/man1/scrub-files.*
%{_mandir}/man1/mdsum.*
%{_mandir}/man1/sockaddr.*
%{_mandir}/man1/zerofill.*

%files devel
%defattr(-,root,root,-)
%{_libdir}/*.so
%{_includedir}/ucommon/
%{_includedir}/commoncpp/
%{_libdir}/pkgconfig/*.pc
%{_bindir}/ucommon-config
%{_bindir}/commoncpp-config
%{_mandir}/man1/ucommon-config.*
%{_mandir}/man1/commoncpp-config.*

%files doc
%defattr(-,root,root,-)
%doc doc/html/*

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%changelog
* Sat Sep 18 2010 - David Sugar <dyfet@gnutelephony.org> - 3.4.0-0
- simplified packaging and better runtime focus.
- ccscript moved to bayonne, ccaudio detached.

* Sun Aug 01 2010 - David Sugar <dyfet@gnutelephony.org> - 3.3.0-0
- internationalization bindings with gnu gettext support.
- reorganized utils into ucommon-bin subpackage.

* Fri Jun 04 2010 - David Sugar <dyfet@gnutelephony.org> - 3.0.0-0
- merged ccscript and ccaudio with ucommon to create single framework.

* Sun Jul 19 2009 - David Sugar <dyfet@gnutelephony.org> - 2.0.6-1
- fixed ucommon-config upstream.

* Tue May 05 2009 - David Sugar <dyfet@gnutelephony.org> - 2.0.5-4
- removed static libraries, fixed other build issues (#498736)

* Sun May 03 2009 - David Sugar <dyfet@gnutelephony.org> - 2.0.5-3
- spec file prepared for redhat/fedora (#498736)

